-- ISComputerPanel_PlayFromMedia.lua
-- Adds a secondary action button under "Play" with per-tab titles and enable rules.
-- Games: "Play from CD" (always disabled)
-- Apps:  "Run from CD" (enabled disabled)
-- Docs:  "Read from CD" (enabled disabled)
-- Audio: "Play from CD" (enabled iff CD inserted)
-- Video: "Play from CD" (enabled iff CD inserted)

ISComputerPanel = ISComputerPanel or ISPanel:derive("ISComputerPanel")

local function _activeTabName(self)
    local idx = self._activeTab or 1
    local title = (self._tabs and self._tabs[idx]) or "Games"
    title = tostring(title):gsub(":%s*$","")
    return title
end

local function _setBtnTitle(self)
    if not self.btnPlayFromMedia or not self.btnPlayFromMedia.setTitle then return end
    local key = _activeTabName(self)
    if key == "Apps" then
        self.btnPlayFromMedia:setTitle("Run from CD")
    elseif key == "Docs" then
        self.btnPlayFromMedia:setTitle("Read from CD")
    else
        self.btnPlayFromMedia:setTitle("Play from CD")
    end
end

-- add button in initialise
local _orig_initialise = ISComputerPanel.initialise
function ISComputerPanel:initialise()
    if _orig_initialise then _orig_initialise(self) end

    -- place directly under Play button, before status/memory bars
    if self.btnPlay and (not self.btnPlayFromMedia) then
        local x = self.btnPlay.x
        local w = self.btnPlay.width
        local h = self.btnPlay.height
        local gap = (self._layout and self._layout.gap) or 12
        local y = self.btnPlay.y + self.btnPlay.height + gap

        self.btnPlayFromMedia = ISButton:new(x, y, w, h, "Play from CD", self, ISComputerPanel.onPlayFromMedia)
        self.btnPlayFromMedia:initialise()
        self:addChild(self.btnPlayFromMedia)

        -- push status/memory bars down to avoid overlap
        if self._ui and self._ui.status then
            local push = h + gap
            self._ui.status.y = (self._ui.status.y or y) + push
        end
        if self._ui and self._ui.memory then
            local push = h + gap
            self._ui.memory.y = (self._ui.memory.y or y) + push
        end
    end

    _setBtnTitle(self)
    if self.updateButtons then self:updateButtons() end
end

-- click handler (stubs for now)
function ISComputerPanel:onPlayFromMedia()
    local key = _activeTabName(self)
    if key == "Games" then
        -- disabled anyway; safeguard
        return
    elseif key == "Apps" then
        print("[Computer] Run from Media (stub)")
    elseif key == "Docs" then
        print("[Computer] Read from Media (stub)")
    elseif key == "Audio" then
        print("[Computer] Play from CD (stub)")
    elseif key == "Video" then
        print("[Computer] Play from CD (stub)")
    end
end

-- keep titles in sync on tab switch
local _orig_setActiveTab = ISComputerPanel.setActiveTab
function ISComputerPanel:setActiveTab(tab)
    if _orig_setActiveTab then _orig_setActiveTab(self, tab) end
    _setBtnTitle(self)
    if self.updateButtons then self:updateButtons() end
end

-- enable/disable logic
local _orig_updateButtons = ISComputerPanel.updateButtons
function ISComputerPanel:updateButtons()
    if _orig_updateButtons then _orig_updateButtons(self) end

    local b = self.btnPlayFromMedia
    if not b or not b.setEnable then return end
    local key = _activeTabName(self)

    if key == "Games" then
        b:setEnable(false)
    elseif key == "Apps" or key == "Docs" then
        -- require  inserted
        b:setEnable(false)
    elseif key == "Audio" or key == "Video" then
        -- require CD inserted
        b:setEnable(false)
    else
        b:setEnable(false)
    end

    _setBtnTitle(self)
end
