function ISComputerPanel:emitSound(name)
  if not name then return end
  local obj = self.worldObj
  if obj and obj.playSound then
    obj:playSound(name)
  elseif self.playerObj and self.playerObj.playSound then
    self.playerObj:playSound(name)
  end
end

-- small helper to queue proximity activation and run a callback when adjacent

function ISComputerPanel:_syncCdFromMd()
  if not self.worldObj or not self.worldObj.getModData then return false end
  local md = self.worldObj:getModData()
  md.computerData = md.computerData or {}
  local t = md.computerData.cdDiskType
  local n = md.computerData.cdDiskName
  local open = md.computerData.cdOpen and true or false
  local changed = false
  if self.insertedDiskType ~= t then self.insertedDiskType = t; changed = true end
  if self.insertedDiskName ~= n then self.insertedDiskName = n; changed = true end
  if self.cdOpen ~= open then self.cdOpen = open; changed = true end
  local hasDisk = (self.insertedDiskType ~= nil)
  if (self.diskInserted and (not hasDisk)) or ((not self.diskInserted) and hasDisk) then
    self.diskInserted = hasDisk; changed = true
  end
  return changed
end

-- Persist CD panel fields back to modData

function ISComputerPanel:persistCd()
  if not self.worldObj or not self.worldObj.getModData then return end
  local md = self.worldObj:getModData()
  md.computerData = md.computerData or {}
  md.computerData.cdOpen = self.cdOpen and true or false
  md.computerData.cdDiskType = self.insertedDiskType
  md.computerData.cdDiskName = self.insertedDiskName
  if self.worldObj.transmitModData then self.worldObj:transmitModData() end
end


function ISComputerPanel:_doToggleCD()
  if not (self.isOn and self:hasPower()) then return end
  local job = ComputerJobs.getJob(self.worldObj)
  if job then return end
  local desired = self.cdOpen and "close" or "open"
  if desired == "open" then self:emitSound("cd_tray_open") else self:emitSound("cd_tray_close") end
  ComputerJobs.startTray(self.worldObj, desired, 2.0)
  self:updateButtons()
  ComputerLight.refresh(self.worldObj)
end


function ISComputerPanel:_doInsertDisk()
  if not (self.isOn and self.cdOpen and self:hasPower() and (not self.diskInserted)) then return end
  if self.insertDlgOpen then return end
  local dlg = ISComputerInsertDialog:new(self.x + 30, self.y + 60, 360, 300, self)
  dlg:initialise()
  dlg:addToUIManager()
  self.insertDlgOpen = true
  self._insertDlgRef = dlg
  self:updateButtons()
end


function ISComputerPanel:_doRemoveSelected()
  local id, sel = nil, nil
  if self.list and self.list.selected ~= nil and self.list.selected ~= -1 and self.list.items then
    sel = self.list.items[self.list.selected]
    if sel and sel.item and sel.item.id then id = sel.item.id end
  end
  if not id then return end
  -- Store pending uninstall name so completion can target correct record
  do
    local md = self.worldObj and self.worldObj.getModData and self.worldObj:getModData() or nil
    if md then
      md.computerData = md.computerData or {}
      md.computerData.pendingUninstallName = (sel and sel.item and sel.item.name) or nil
      if self.worldObj.transmitModData then self.worldObj:transmitModData() end
    end
  end
  ComputerJobs.startUninstall(self.worldObj, id, 4.0)
  self:updateButtons()
end

-- Public button handlers now queue proximity activation


function ISComputerPanel:onToggleCD()
  self:queueActivate(function(p) p:_doToggleCD() end)
end


function ISComputerPanel:onInsertDisk()
  self:queueActivate(function(p) p:_doInsertDisk() end)
end


function ISComputerPanel:onEjectDisk()
  self:emitSound("cd_eject")
  self:queueActivate(function(p) p:_doEjectDisk() end)
end


function ISComputerPanel:onCancelInstall()
  self:queueActivate(function(p) p:_doCancelInstall() end)
end


function ISComputerPanel:onInstallFromDisk()
  self:queueActivate(function(p) p:_doInstallFromDisk() end)
end

function ISComputerPanel:_onInsertDialogClosed()
  self.insertDlgOpen = false
  self._insertDlgRef = nil
  self:updateButtons()
end
