function ISComputerPanel:queueActivate(fn)
  if not (self.worldObj and self.worldObj.getSquare) then return end
  local sq = self.worldObj:getSquare()
  if not sq then return end
  if luautils and luautils.walkAdj then luautils.walkAdj(self.playerObj, sq) end
  local action = ISComputerActivateAction:new(self.playerObj, self, self.worldObj, fn)
  ISTimedActionQueue.add(action)
end

-- Sync CD fields from modData into panel fields; returns true if anything changed


function ISComputerPanel:_isGamesTabActive()
  return self._activeTab == 1
end


function ISComputerPanel:setActiveTab(idx)
  if not idx or idx < 1 or idx > #self._tabs then return end
  self._activeTab = idx
  self.rightTitle = self._tabs[idx]
  -- toggle buttons
  for i, b in ipairs(self.tabButtons) do
    if b and b.setEnable then b:setEnable(i ~= idx) end
  end
  -- populate list
  local key = self._tabKeys[idx]
  if key == "games" then
    ComputerData.populateListUI(self.worldObj, self.list)
  else
    ComputerData.populateListUIByKey(self.worldObj, self.list, key)
  end
  self:updateButtons()
end

function ISComputerPanel:onCancelPlay()
  if self.activeActionType ~= "play" or not self.activeAction then return end
  if self.activeAction.forceStop then self.activeAction:forceStop() else self.activeAction:stop() end
end


function ISComputerPanel:onPlay()
  local job = ComputerJobs.getJob(self.worldObj)
  if job then return end
  if not (self.worldObj and self.worldObj.getSquare) then return end
  -- require selection
  local id = nil
  if self.list and self.list.selected ~= nil and self.list.selected ~= -1 and self.list.items then
    local sel = self.list.items[self.list.selected]
    if sel and sel.item and sel.item.id then id = sel.item.id end
  end
  if not id then return end
  -- walk adjacent then start TA
  local sq = self.worldObj:getSquare(); if not sq then return end
  if luautils and luautils.walkAdj then luautils.walkAdj(self.playerObj, sq) end
  local action = ISComputerPlayAction:new(self.playerObj, self, self.worldObj, self.playerIndex, id)
  ISTimedActionQueue.add(action)
  self:updateButtons()
end

-- TA lifecycle for Play
