function ISComputerPanel:_doTogglePower()
  if not self:hasPower() then return end
  local wasOn = self.isOn and true or false
  self.isOn = not self.isOn
  if ComputerMod and ComputerMod.setComputerOn then
    ComputerMod.setComputerOn(self.worldObj, self.isOn)
  else
    local md = self.worldObj and self.worldObj:getModData() or nil
    if md then
      md.Computer_On = self.isOn
      if self.worldObj.transmitModData then self.worldObj:transmitModData() end
    end
  end
  self:emitSound("pc_power_button_click")
  if self.isOn then
    self:emitSound("pc_power_on")
    self:emitSound("computeron")
  else
    self:emitSound("computeroff")
  end
  ComputerLight.refresh(self.worldObj)
  self:updateButtons()
end


function ISComputerPanel:_doEjectDisk()
  if not (self.cdOpen and self.diskInserted) then return end
  local p = self.playerObj
  if p and self.insertedDiskType then
    local inv = p:getInventory()
    if inv then
      local newItem = inv:AddItem(self.insertedDiskType)
      if newItem and self.insertedDiskName then
        pcall(function() if newItem.setName then newItem:setName(self.insertedDiskName) end end)
        pcall(function() if newItem.setCustomName then newItem:setCustomName(true) end end)
      end
    end
  end
  self.diskInserted = false
  self.insertedDiskType = nil
  self.insertedDiskName = nil
  self:persistCd()
  self:updateButtons()
end


function ISComputerPanel:_doCancelInstall()
  ComputerJobs.cancel(self.worldObj)
  self:updateButtons()
end


function ISComputerPanel:_doInstallFromDisk()
  local capMax = (ComputerData and ComputerData.MAX_GAMES) and ComputerData.MAX_GAMES or 20
  local capCnt = 0
  if ComputerData and ComputerData.countInstalled then
    capCnt = ComputerData.countInstalled(self.worldObj) or 0
  elseif self.list and self.list.items then
    capCnt = #self.list.items
  end
  if capCnt >= capMax then
    self:updateButtons()
    return
  end
  if not (self.isOn and self:hasPower() and (not self.cdOpen) and self.diskInserted and self.insertedDiskType) then return end
  if self:isInstalled(self.insertedDiskType, self.insertedDiskName) then return end
  self:emitSound("install_start")
  ComputerJobs.startInstall(self.worldObj, self.insertedDiskType, 6.0, self.insertedDiskName)
  self:updateButtons()
end

function ISComputerPanel:onTogglePower()
  self:queueActivate(function(p) p:_doTogglePower() end)
end


function ISComputerPanel:onRemoveSelected()
  self:queueActivate(function(p) p:_doRemoveSelected() end)
end

-- Play TA handlers

function ISComputerPanel:onActionStarted(kind, actionRef)
  self.activeActionType = kind
  self.activeAction = actionRef
  self:updateButtons()
end


function ISComputerPanel:onActionStopped(kind, completed)
  if self.activeActionType ~= kind then return end
  self.activeActionType = nil
  self.activeAction = nil
  self:updateButtons()
end

-- Insert dialog lifecycle from dialog
