local function checkForAddition(square)
    local x, y, z = square:getX(), square:getY(), square:getZ()

    local isoBarrel = WPIso.GetBarrel(square)
    if isoBarrel then
        local w, wmax = WPIso.GetWaterStatus(isoBarrel)
        local bid
        local building = square:getBuilding()
        if building then
            local def = building:getDef()
            bid = def:getIDString()
        end
        WPVirtual.BarrelAdd(x, y, z, wmax * 100, bid)
        return
    end

    local isoPump = WPIso.GetPump(square)
    if isoPump then
        local spriteName = isoPump:getSprite():getName()
        local sprite = getSprite(spriteName)
        local object = IsoClothingDryer.new(square:getCell(), square, sprite)
        object:setActivated(false)
        object:setMovedThumpable(true)
        object:createContainersFromSpriteProperties()

        object:transmitCompleteItemToServer()
        square:AddSpecialObject(object)

        square:transmitRemoveItemFromSquare(isoPump)

        WPVirtual.PumpAdd(x, y, z)
        return
    end

    local isoSprinkler = WPIso.GetSprinkler(square)
    if isoSprinkler then
        WPVirtual.SprinklerAdd(x, y, z, 200)
        return
    end

    local isoPipe = WPIso.GetPipe(square)
    if isoPipe then
        local pipeSpriteName = isoPipe:getSprite():getName()
        local sprite = getSprite(pipeSpriteName)
        local object = IsoObject.new(square:getCell(), square, sprite)
        square:transmitRemoveItemFromSquare(isoPipe)
        square:AddSpecialObject(object)
        object:transmitCompleteItemToServer()
        WPIso.BuildPipe(square)

        local isoValve = WPIso.GetValve(square)
        if isoValve then
            local valveSpriteName
            if pipeSpriteName == WPIso.pipeSprites.ns then
                valveSpriteName = WPIso.valveSprites.ns
            elseif pipeSpriteName == WPIso.pipeSprites.we then
                valveSpriteName = WPIso.valveSprites.we
            end

            square:transmitRemoveItemFromSquare(isoValve)

            if valveSpriteName then
                local sprite = getSprite(valveSpriteName)
                local object = IsoObject.new(square:getCell(), square, sprite)
                square:AddSpecialObject(object)
                object:transmitCompleteItemToServer()
                WPVirtual.ValveAdd(x, y, z, 200)
            end
        end

        local isoFlowmeter = WPIso.GetFlowmeter(square)
        if isoFlowmeter then
            local flowmeterSpriteName
            if pipeSpriteName == WPIso.pipeSprites.ns then
                flowmeterSpriteName = WPIso.flowmeterSprites.ns
            elseif pipeSpriteName == WPIso.pipeSprites.we then
                flowmeterSpriteName = WPIso.flowmeterSprites.we
            end

            square:transmitRemoveItemFromSquare(isoFlowmeter)

            if flowmeterSpriteName then
                local sprite = getSprite(flowmeterSpriteName)
                local object = IsoObject.new(square:getCell(), square, sprite)
                square:AddSpecialObject(object)
                object:transmitCompleteItemToServer()
                WPVirtual.FlowmeterAdd(x, y, z)
            end
        end
    end
end

local function checkForRemoval(square)
    local x, y, z = square:getX(), square:getY(), square:getZ()

    local isoBarrel = WPIso.GetBarrel(square)
    if not isoBarrel then
        WPVirtual.BarrelRemove(x, y, z)
    end

    local isoPump = WPIso.GetPump(square)
    if not isoPump then
        WPVirtual.PumpRemove(x, y, z)
    end

    local isoSprinkler = WPIso.GetSprinkler(square)
    if not isoSprinkler then
        WPVirtual.SprinklerRemove(x, y, z)
    end

    local isoPipe = WPIso.GetPipe(square)
    if not isoPipe then
        WPVirtual.PipeRemove(x, y, z)
    end

    local isoValve = WPIso.GetValve(square)
    if not isoValve then
        WPVirtual.ValveRemove(x, y, z)
    end

    local isoFlowmeter = WPIso.GetFlowmeter(square)
    if not isoFlowmeter then
        WPVirtual.FlowmeterRemove(x, y, z)
    end
end

local function onObjectAboutToBeRemoved(object)
    local square = object:getSquare()
    local x = square:getX()
    local y = square:getY()
    local z = square:getZ()
    if WPIso.IsPump(object) then
        WPVirtual.PumpRemove(x, y, z)
    elseif WPIso.IsPipe(object) then
        WPVirtual.PipeRemove(x, y, z)
    elseif WPIso.IsValve(object) then
        WPVirtual.ValveRemove(x, y, z)
    elseif WPIso.IsFlowmeter(object) then
        WPVirtual.FlowmeterRemove(x, y, z)
    elseif WPIso.IsBarrel(object) then
        WPVirtual.BarrelRemove(x, y, z)
    elseif WPIso.IsSprinkler(object) then
        WPVirtual.SprinklerRemove(x, y, z)
    end
end


LuaEventManager.AddEvent("OnBuildActionPerform")

local function onObjectBuild(data)
    local square = data.square
    if not square then return end

    checkForAddition(square)
end

LuaEventManager.AddEvent("OnMoveablesActionComplete")

local function onObjectMove(data)
    local square = data.square
    if not square then return end

    local mode = data.mode
    if not mode then return end

    if mode == "place" then
        checkForAddition(square)
    elseif mode == "pickup" then
        checkForRemoval(square)
    end
end

Events.OnBuildActionPerform.Remove(onObjectBuild)
Events.OnBuildActionPerform.Add(onObjectBuild)

Events.OnMoveablesActionComplete.Remove(onObjectMove)
Events.OnMoveablesActionComplete.Add(onObjectMove)

Events.OnObjectAboutToBeRemoved.Remove(onObjectAboutToBeRemoved)
Events.OnObjectAboutToBeRemoved.Add(onObjectAboutToBeRemoved)
