local xpMultiplierSandbox = SandboxVars.MultiplierConfig or {}
local ToughnessSandbox = SandboxVars.Toughness or {}

local currentPanic = 0
local currentPain = 0

local zombieKilled = false

function CheckPlayers()
    for i = 0, getNumActivePlayers() - 1 do
        local player = getSpecificPlayer(i)
        SetStats(player)
    end
end

Events.OnPlayerUpdate.Add(CheckPlayers)

function SetStats(player)
    local level = player:getPerkLevel(Perks["Toughness"])

    local stats = player:getStats()

    local panic = stats:getPanic()
    local pain = stats:getPain()

    local panicModifier = 1 - level * 0.1 * ToughnessSandbox.PanicReductionMultiplier
    local painModifier = 1 - level * 0.05 * ToughnessSandbox.PainReductionMultiplier

    if panic > currentPanic then
        currentPanic = panic
    elseif panic ~= currentPanic * panicModifier then
        currentPanic = panic / panicModifier
        if currentPanic > 100 then
            currentPanic = 100
        end
    end

    if pain > currentPain then
        currentPain = pain
    elseif pain ~= currentPain * painModifier then
        currentPain = pain / painModifier
        if currentPain > 100 then
            currentPain = 100
        end
    end

    if ToughnessSandbox.AffectsPanic then stats:setPanic(currentPanic * panicModifier) end
    if ToughnessSandbox.AffectsPain then stats:setPain(currentPain * painModifier) end
end

local function GrantAttackXP(player, weapon, target, damage)
    if player and zombieKilled and __classmetatables[IsoPlayer.class].__index.isLocalPlayer then
        player:getXp():AddXP(Perks.Toughness, 4 * GetXPMultiplier())
        zombieKilled = false
    end
end

function GetXPMultiplier()
    return xpMultiplierSandbox.Toughness or 1.0
end

local function ZombieKilled(zombie, var1, var2, var)
    zombieKilled = true
end

Events.OnWeaponHitXp.Add(GrantAttackXP)
Events.OnZombieDead.Add(ZombieKilled)