local xpMultiplierSandbox = SandboxVars.MultiplierConfig or {}
local ToughnessSandbox = SandboxVars.Toughness or {}

local currentPanic = 0
local currentPain = 0
local currentDiscomfort = 0

local zombieKilled = false

function CheckPlayers()
    for i = 0, getNumActivePlayers() - 1 do
        local player = getSpecificPlayer(i)
        SetStats(player)
    end
end

Events.OnPlayerUpdate.Add(CheckPlayers)

function SetStats(player)
    local level = player:getPerkLevel(Perks["Toughness"])

    local stats = player:getStats()

    local panic = stats:getPanic()
    local pain = stats:getPain()
    local discomfort = player:getBodyDamage():getDiscomfortLevel()

    local panicModifier = 1 - level * 0.1 * ToughnessSandbox.PanicReductionMultiplier
    local painModifier = 1 - level * 0.05 * ToughnessSandbox.PainReductionMultiplier
    local discomfortModifier = 1 - level * 0.05 * ToughnessSandbox.DiscomfortReductionMultiplier

    if panic > currentPanic then
        currentPanic = panic
    elseif panic ~= currentPanic * panicModifier then
        currentPanic = panic / panicModifier
        if currentPanic > 100 then
            currentPanic = 100
        end
    end

    if pain > currentPain then
        currentPain = pain
    elseif pain ~= currentPain * painModifier then
        currentPain = pain / painModifier
        if currentPain > 100 then
            currentPain = 100
        end
    end

    if GetDiscomfort(player) < level * 0.1 * ToughnessSandbox.DiscomfortFlatReductionMultiplier then
        if ToughnessSandbox.AffectsDiscomfort then
             player:getBodyDamage():setDiscomfortLevel(0)
        end
    else
        if discomfort > currentDiscomfort then
            currentDiscomfort = discomfort
        elseif discomfort ~= currentDiscomfort * discomfortModifier then
            currentDiscomfort = discomfort / discomfortModifier
            if currentDiscomfort > 100 then
                currentDiscomfort = 100
            end
        end

        if ToughnessSandbox.AffectsDiscomfort then player:getBodyDamage():setDiscomfortLevel(currentDiscomfort * discomfortModifier) end
    end

    if ToughnessSandbox.AffectsPanic then stats:setPanic(currentPanic * panicModifier) end
    if ToughnessSandbox.AffectsPain then stats:setPain(currentPain * painModifier) end
end

function GetDiscomfort(player)
    local discomfort = 0
    local wornItems = getPlayer():getWornItems();

    -- Total discomfort percentage of all worn clothes
    for i = 1, wornItems:size() do
        local wornItem = wornItems:get(i - 1):getItem()   
        discomfort = discomfort + wornItem:getDiscomfortModifier()
    end

    -- These moodles each add 10% extra discomfort for each level of their severity
    discomfort = discomfort + player:getMoodles():getMoodleLevel(MoodleType.Hypothermia) / 10
    discomfort = discomfort + player:getMoodles():getMoodleLevel(MoodleType.Hyperthermia) / 10
    discomfort = discomfort + player:getMoodles():getMoodleLevel(MoodleType.Wet) / 10

    return discomfort
end

local function GrantAttackXP(player, weapon, target, damage)
    if player and zombieKilled and __classmetatables[IsoPlayer.class].__index.isLocalPlayer then
        player:getXp():AddXP(Perks.Toughness, 4 * GetXPMultiplier())
        zombieKilled = false
    end
end

function GetXPMultiplier()
    return xpMultiplierSandbox.Toughness or 1.0
end

local function ZombieKilled(zombie, var1, var2, var)
    zombieKilled = true
end

Events.OnWeaponHitXp.Add(GrantAttackXP)
Events.OnZombieDead.Add(ZombieKilled)