if isServer() or isClient() then return end
local RV = require("RVVehicleTypes")
local VehicleTypes = RV.VehicleTypes
local function splitByComma(str)
    local t = {}
    if not str or str == "" then return t end
    for entry in string.gmatch(str, "([^,]+)") do
        table.insert(t, entry:match("^%s*(.-)%s*$"))
    end
    return t
end
local function removeValue(tbl, val)
    if not tbl or not val then return end
    for i = #tbl, 1, -1 do
        if tbl[i] == val then
            table.remove(tbl, i)
        end
    end
end
local function removeFromAllLists(vehicleName)
    for _, data in pairs(VehicleTypes) do
        if data and data.scripts then
            removeValue(data.scripts, vehicleName)
        end
    end
end
local function insertUnique(typeKey, vehicleName)
    if not typeKey or not vehicleName or vehicleName == "" then return end
    local data = VehicleTypes[typeKey]
    if not data or not data.scripts then return end
    removeFromAllLists(vehicleName)
    table.insert(data.scripts, vehicleName)
end
local function RVAddon_LoadCustomVehicles()
    if not SandboxVars or not SandboxVars.RVAddon then return end
    local opts = SandboxVars.RVAddon
    local map = {
        { key = "CustomNormalVehicles", type = "normal" },
        { key = "CustomBusVehicles", type = "bus" },
        { key = "CustomSmallVehicles", type = "small" },
        { key = "Custom3x2Caravan", type = "3x2caravan" },
        { key = "Custom3x6Caravan", type = "3x6caravan" },
        { key = "Custom3x7Empty", type = "3x7empty" },
        { key = "Custom4x12colossal", type = "4x12colossal" },
    }
    for _, entry in ipairs(map) do
        local list = splitByComma(opts[entry.key])
        for _, v in ipairs(list) do
            insertUnique(entry.type, v)
        end
    end
end
Events.OnGameStart.Add(RVAddon_LoadCustomVehicles)
