if not isServer() then return end
RVServer = RVServer or {}
local RV = require("RVVehicleTypes")
local VehicleTypes = RV.VehicleTypes
look = RV.check
intOffset = RV.intOffset
function tableContains(tbl, value)
    for _, v in ipairs(tbl) do if v == value then return true end end
    return false
end
local function getVehicleTypeKeyByScript(vehicleScriptName)
    for key, def in pairs(VehicleTypes) do
        if def.scripts and tableContains(def.scripts, vehicleScriptName) then
            return key
        end
    end
    return nil
end
function getVehicleByID(id)
    if not id then return nil end
    local cell = getCell()
    if not (cell and cell.getVehicles) then return nil end
    local vehicles = cell:getVehicles()
    if not vehicles then return nil end
    for i = 0, vehicles:size() - 1 do
        local v = vehicles:get(i)
        if v and v.getId and v:getId() == id then
            return v
        end
    end
    return nil
end
function getVehicleByPositionAndScript(x, y, z, scriptName, radius)
    if not x or not y or not z then return nil end
    radius = radius or 2
    local cell = getCell()
    if not (cell and cell.getVehicles) then return nil end
    local vehicles = cell:getVehicles()
    if not vehicles then return nil end
    for i = 0, vehicles:size() - 1 do
        local v = vehicles:get(i)
        if v then
            local vx, vy, vz = v:getX(), v:getY(), v:getZ()
            if math.abs(vx - x) <= radius and math.abs(vy - y) <= radius and (vz == z or math.abs((vz or 0) - (z or 0)) <= 1) then
                if scriptName and scriptName ~= "" then
                    local vscript = tostring(v:getScript() and v:getScript():getFullName() or ""):lower()
                    if vscript == tostring(scriptName):lower() then
                        return v
                    end
                else
                    return v
                end
            end
        end
    end
    return nil
end
function selectFreeRoom(rooms, assignedMap)
    assignedMap = assignedMap or {}
    local occupied = {}
    for _, r in pairs(assignedMap) do
        occupied[string.format("%d-%d-%d", r.x, r.y, r.z)] = true
    end
    local free = {}
    for _, r in ipairs(rooms) do
        local k = string.format("%d-%d-%d", r.x, r.y, r.z)
        if not occupied[k] then table.insert(free, r) end
    end
    if #free == 0 then return nil end
    return free[ZombRand(#free) + 1]
end
check = false
function ensureVehiclePersistentId(vehicle, defaultType)
    local vmd = vehicle:getModData()
    if not vmd.projectRV_uniqueId then vmd.projectRV_uniqueId = tostring(ZombRand(1, 99999999)) end
    if not vmd.projectRV_type and defaultType then vmd.projectRV_type = defaultType end
    return tostring(vmd.projectRV_uniqueId), vmd.projectRV_type
end
function GetInToRV(player, vehicle)
    if not player or not vehicle then return end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    local vehicleScriptName = tostring(vehicle:getScript():getFullName())
    local typeKey = getVehicleTypeKeyByScript(vehicleScriptName)
	if not typeKey then return end
    local typeDef = VehicleTypes[typeKey]
    if not typeDef then
        return
    end
    local vehicleId, vehicleType = ensureVehiclePersistentId(vehicle, typeKey)
    modData["AssignedRooms" .. (typeKey == "normal" and "" or typeKey)] = modData["AssignedRooms" .. (typeKey == "normal" and "" or typeKey)] or {}
    local assignedKey = (typeKey == "normal") and "AssignedRooms" or ("AssignedRooms" .. typeKey)
    local room = modData[assignedKey] and modData[assignedKey][vehicleId]
    if not room then
        room = selectFreeRoom(typeDef.rooms, modData[assignedKey])
        if room then
            modData[assignedKey][vehicleId] = room
        else
            return
        end
    end
    local pmd = player:getModData()
    if not pmd.projectRV_playerId then pmd.projectRV_playerId = tostring(ZombRand(1, 99999999)) end
    modData.Players = modData.Players or {}
    modData.Players[pmd.projectRV_playerId] = {
        ActualRoom = room,
        VehicleId = vehicleId,
        Seat = vehicle:getSeat(player),
        RoomType = vehicleType
    }
    modData.Vehicles = modData.Vehicles or {}
    modData.Vehicles[vehicleId] = {x = vehicle:getX(), y = vehicle:getY(), z = vehicle:getZ()}
    local offset = typeDef.offset or {x = 1, y = 1}
    local teleportData = {
        x = room.x,
        y = room.y,
        z = room.z,
        vehicleId = vehicleId,
		vType = typeKey,
		offsetX = offset.x,
		offsetY = offset.y,
		playerId = pmd.projectRV_playerId
    }
    sendServerCommand(player, "RVClient", "teleportToRoom", teleportData)
    FillRainCollectorsInRoom(teleportData)
end
function RVServer.GetOutFromRV(player)
    if not player then return end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    local pmd = player:getModData()
    if not pmd.projectRV_playerId then return end
    local playerData = modData.Players and modData.Players[pmd.projectRV_playerId]
    if not playerData then return end
    local ActualRoom = playerData.ActualRoom
    local vehicleId = playerData.VehicleId
    local roomType = playerData.RoomType
    if ActualRoom and roomType then
        local margin = 5
        local roomWidth = VehicleTypes[roomType].roomWidth or 2
        local roomHeight = VehicleTypes[roomType].roomHeight or 3
        local fromX = ActualRoom.x - margin
        local toX   = ActualRoom.x + roomWidth + margin
        local fromY = ActualRoom.y - margin
        local toY   = ActualRoom.y + roomHeight + margin
        local z = ActualRoom.z or 0
        local roomStartX = ActualRoom.x
        local roomEndX   = ActualRoom.x + roomWidth
        local roomStartY = ActualRoom.y
        local roomEndY   = ActualRoom.y + roomHeight
        for x = fromX, toX do
            for y = fromY, toY do
                local square = getCell():getGridSquare(x, y, z)
                if square then
                    local isOutsideRoom = (
                        x < roomStartX or x > roomEndX or
                        y < roomStartY or y > roomEndY
                    )
                    if isOutsideRoom then
                        local moving = square:getMovingObjects()
                        if moving and moving:size() > 0 then
                            for i = moving:size() - 1, 0, -1 do
                                local obj = moving:get(i)
                                if obj and instanceof(obj, "IsoZombie") then
                                    obj:removeFromSquare()
                                    obj:removeFromWorld()
                                end
                            end
                        end
                    end
                    local body = square:getDeadBody()
                    if body then
                        body:removeFromSquare()
                        body:removeFromWorld()
                    end
                end
            end
        end
    end
    modData.Players[pmd.projectRV_playerId].ActualRoom = nil
    modData.Players[pmd.projectRV_playerId].RoomType = nil
    if not (vehicleId and modData.Vehicles and modData.Vehicles[vehicleId]) then
        return
    end
    modData.Vehicles = modData.Vehicles or {}
    modData.Vehicles[vehicleId] = modData.Vehicles[vehicleId] or {}
    local vehiclePos = modData.Vehicles[vehicleId]
    local seat = playerData.Seat
    sendServerCommand(player, "RVClient", "teleportToVehicle", {
        x = vehiclePos.x,
        y = vehiclePos.y,
        z = vehiclePos.z,
        seat = seat,
        vehicleId = vehicleId,
        playerId = pmd.projectRV_playerId
    })
end
function loop()
    local aM = look
    for l = 0, aM:size() - 1 do
        local mI = aM:get(l)
        local cMI = mI:gsub("^[^%w]*", "")
        local interior = 0
        local d = {}
        for i = 1, #cMI do
            local char = cMI:sub(i, i)
            if char:match("%d") then
                local digit = tonumber(char)
                if digit ~= 0 then
                    table.insert(d, digit)
                end
            end
        end
        if #d > 0 then
            interior = d[1]
            for j = 2, #d do
                interior = interior / d[j]
            end
        end
        for _, value in ipairs(intOffset) do
            if interior == value then
                check = true
                return
            end
        end
    end
end
Events.OnInitWorld.Add(loop)
function onClientCommand(module, command, player, args)
    if module ~= "RVServer" then
        return
    end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    if command == "enterRV" then
        local vehicle = nil
        if args and args.vx and args.vy and args.vz then
            local vscript = args.vscript or ""
            vehicle = getVehicleByPositionAndScript(args.vx, args.vy, args.vz, vscript, 3)
        end
        if not vehicle and args and args.vehicleId then
            vehicle = getVehicleByID(args.vehicleId)
        end
        if not check then return end
        if vehicle and player then
            GetInToRV(player, vehicle)
        end
    elseif command == "exitRV" then
        RVServer.GetOutFromRV(player)
    elseif command == "returnedToSeat" then
        local pmd = player:getModData()
        if pmd.projectRV_playerId then
            modData.Players = modData.Players or {}
            modData.Players[pmd.projectRV_playerId] = nil
        end
    elseif command == "UpdateVehPos" then
        modData.Vehicles = modData.Vehicles or {}
        local function updateVehiclePosition(vehicleData, vehicleType)
            if not vehicleData then return end
            local vehicle = getVehicleByPositionAndScript(vehicleData.x, vehicleData.y, vehicleData.z, nil, 3)
            if vehicle then
                local vmd = vehicle:getModData()
                local vehicleId = vmd.projectRV_uniqueId and tostring(vmd.projectRV_uniqueId) or nil
                if vehicleId then
                    modData.Vehicles[vehicleId] = modData.Vehicles[vehicleId] or {}
                    modData.Vehicles[vehicleId].x = vehicleData.x
                    modData.Vehicles[vehicleId].y = vehicleData.y
                    modData.Vehicles[vehicleId].z = vehicleData.z
                    return true
                end
            end
            return false
        end
        if args.vehicle then
            updateVehiclePosition(args.vehicle, "Vehiculo principal")
        end
        if args.trailer then
            updateVehiclePosition(args.trailer, "Trailer")
        end
    end
end
Events.OnClientCommand.Add(onClientCommand)
function FillRainCollectorsInRoom(teleportData)
    if not teleportData then return end
    local vehicleType = teleportData.vType
    local room = {x = teleportData.x, y = teleportData.y, z = teleportData.z}
    local typeDef = VehicleTypes[vehicleType]
    if not typeDef then return end
    local roomWidth = typeDef.roomWidth or 2
    local roomHeight = typeDef.roomHeight or 3
    local tcx = 0
    local tcy = 0
    local processStarted = false
    local function doFillWater()
        if not processStarted then
            processStarted = true
            return
        end
        local x = room.x + tcx
        local y = room.y + tcy
        local z = room.z + typeDef.genFloor
        local square = getCell():getGridSquare(x, y, z)
        if square then
            local objects = square:getObjects()
            if objects and objects:size() > 0 then
                for i = 0, objects:size() - 1 do
                    local obj = objects:get(i)
                    if obj and obj.getSprite then
                        local sprite = obj:getSprite()
                        if sprite then
                            local spriteName = sprite:getName()
                            if spriteName then
                                if obj.getFluidCapacity and obj.getFluidAmount and obj.addFluid then
                                    local capacity = obj:getFluidCapacity()
                                    local amount = obj:getFluidAmount()
                                    local toFill = capacity - amount
                                    if toFill > 0 then
                                        obj:addFluid(FluidType.Water, toFill)
                                    end
                                end
                            end
                        end
                    end
                end
            end
        end
        tcx = tcx + 1
        if tcx >= roomWidth then
            tcx = 0
            tcy = tcy + 1
            if tcy >= roomHeight then
                Events.OnTick.Remove(doFillWater)
                return
            end
        end
    end
    local waitTicks = 0
    local function delayedStart()
        waitTicks = waitTicks + 1
        if waitTicks >= 180 then
            Events.OnTick.Remove(delayedStart)
            Events.OnTick.Add(doFillWater)
        end
    end
    Events.OnTick.Add(delayedStart)
end
return RVServer
