if isServer() or isClient() then return end
local RVFunction = RVFunction or {}
local RV_showRadialMenu = ISVehicleMenu.showRadialMenu
local RV = require("RVVehicleTypes")
local VehicleTypes = RV.VehicleTypes
look = RV.check
intOffset = RV.intOffset
local function tableContains(tbl, value)
    for _, v in ipairs(tbl) do if v == value then return true end end
    return false
end
local function getVehicleTypeKeyByScript(vehicleScriptName)
    for key, def in pairs(VehicleTypes) do
        if def.scripts and tableContains(def.scripts, vehicleScriptName) then
            return key
        end
    end
    return nil
end
local function selectFreeRoom(rooms, assignedMap)
    assignedMap = assignedMap or {}
    local occupied = {}
    for _, r in pairs(assignedMap) do
        occupied[string.format("%d-%d-%d", r.x, r.y, r.z)] = true
    end
    local free = {}
    for _, r in ipairs(rooms) do
        local k = string.format("%d-%d-%d", r.x, r.y, r.z)
        if not occupied[k] then table.insert(free, r) end
    end
    if #free == 0 then return nil end
    return free[ZombRand(#free) + 1]
end
local function isTrunkAccessibleForPart(vehicle, part, trunkParts)
    if not part then return false end
	if vehicle:isTrunkLocked() then return false
	else return true end
end
local function ensureVehiclePersistentId(vehicle, defaultType)
    local vmd = vehicle:getModData()
    if not vmd.projectRV_uniqueId then vmd.projectRV_uniqueId = ZombRand(1, 99999999) end
    if not vmd.projectRV_type and defaultType then vmd.projectRV_type = defaultType end
    return tostring(vmd.projectRV_uniqueId), vmd.projectRV_type
end
local function teleportPlayerToRoom(player, room, offset, vehicle)
    if not room then return end
	vehicle:exit(player)
    player:setX(room.x + (offset and offset.x or 1))
    player:setLastX(room.x + (offset and offset.x or 1))
    player:setY(room.y + (offset and offset.y or 1))
    player:setLastY(room.y + (offset and offset.y or 1))
    player:setZ(room.z or 0)
    player:setLastZ(room.z or 0)
	func_Initt(player)
end
local function GetInToRV(player)
    local vehicle = ISVehicleMenu.getVehicleToInteractWith(player)
    if not vehicle then return end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    local vehicleScriptName = tostring(vehicle:getScript():getFullName())
    local typeKey = getVehicleTypeKeyByScript(vehicleScriptName) or vehicle:getModData().projectRV_type or "normal"
    local typeDef = VehicleTypes[typeKey]
    if not typeDef then return end
    local vehicleId, vehicleType = ensureVehiclePersistentId(vehicle, typeKey)
    modData["AssignedRooms" .. (typeKey == "normal" and "" or typeKey)] = modData["AssignedRooms" .. (typeKey == "normal" and "" or typeKey)] or {}
    local assignedKey = (typeKey == "normal") and "AssignedRooms" or ("AssignedRooms" .. typeKey)
    local room = modData[assignedKey] and modData[assignedKey][vehicleId]
    if not room then
        room = selectFreeRoom(typeDef.rooms, modData[assignedKey])
        if room then
            modData[assignedKey][vehicleId] = room
        else
            return
        end
    end
    RVFunction.UpdateBattery(player)
    local pmd = player:getModData()
    if not pmd.projectRV_playerId then pmd.projectRV_playerId = tostring(ZombRand(1, 99999999)) end
    modData.Players = modData.Players or {}
    modData.Players[pmd.projectRV_playerId] = {
        ActualRoom = room,
        VehicleId = vehicleId,
        Seat = vehicle:getSeat(player),
        RoomType = vehicleType
    }
    modData.Vehicles = modData.Vehicles or {}
    modData.Vehicles[vehicleId] = {x = vehicle:getX(), y = vehicle:getY(), z = vehicle:getZ()}
    teleportPlayerToRoom(player, room, typeDef.offset, vehicle)
	RVFunction.RestoreGenerator(vehicleId, room, vehicleType)
end
function ISVehicleMenu.showRadialMenu(player, ...)
    RV_showRadialMenu(player, ...)
    local vehicle = ISVehicleMenu.getVehicleToInteractWith(player)
    if not vehicle then return end

    local vehicleScriptName = tostring(vehicle:getScript():getFullName())
    local typeKey = getVehicleTypeKeyByScript(vehicleScriptName)
    if not typeKey then return end
    local typeDef = VehicleTypes[typeKey]
    if not typeDef or not check then
        return
    end
    local canShow = false
    local part = vehicle:getUseablePart(player)
    if typeDef.requiresSeat and not player:isSeatedInVehicle() then
        canShow = false
    elseif typeDef.requiresTrunk then
        canShow = isTrunkAccessibleForPart(vehicle, part, typeDef.trunkParts) or player:isSeatedInVehicle()
    else
        canShow = true
    end
    if not canShow then return end
    local vmd = vehicle:getModData()
    if not vmd.projectRV_uniqueId then vmd.projectRV_uniqueId = ZombRand(1, 99999999) end
    if not vmd.projectRV_type then vmd.projectRV_type = typeKey end
    local vehicleId = tostring(vmd.projectRV_uniqueId)
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    local assignedKey = (typeKey == "normal") and "AssignedRooms" or ("AssignedRooms" .. typeKey)
    modData[assignedKey] = modData[assignedKey] or {}
    local room = modData[assignedKey][vehicleId]
    local roomsUsed = 0
    for _, _ in pairs(modData[assignedKey]) do roomsUsed = roomsUsed + 1 end
    if room or roomsUsed < #typeDef.rooms then
        local menu = getPlayerRadialMenu(player:getPlayerNum())
        menu:addSlice(getText("ContextMenu_GetInToRV"), getTexture("media/textures/rvInteriorEnter.png"), GetInToRV, player)
    end
end
check = false
function RVFunction.GetOutFromRV(player)
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    local pmd = player:getModData()
    if not pmd.projectRV_playerId then return end
    local playerData = modData.Players and modData.Players[pmd.projectRV_playerId]
    if not playerData then return end
    local ActualRoom = playerData.ActualRoom
    local vehicleId = playerData.VehicleId
    local roomType = playerData.RoomType
    if ActualRoom and roomType then
        local margin = 5
        local roomWidth = VehicleTypes[roomType].roomWidth or 2
        local roomHeight = VehicleTypes[roomType].roomHeight or 3
        local fromX = ActualRoom.x - margin
        local toX   = ActualRoom.x + roomWidth + margin
        local fromY = ActualRoom.y - margin
        local toY   = ActualRoom.y + roomHeight + margin
        local z = ActualRoom.z or 0
        local roomStartX = ActualRoom.x
        local roomEndX   = ActualRoom.x + roomWidth
        local roomStartY = ActualRoom.y
        local roomEndY   = ActualRoom.y + roomHeight
        for x = fromX, toX do
            for y = fromY, toY do
                local square = getCell():getGridSquare(x, y, z)
                if square then
                    local isOutsideRoom = (
                        x < roomStartX or x > roomEndX or
                        y < roomStartY or y > roomEndY
                    )
                    if isOutsideRoom then
                        local moving = square:getMovingObjects()
                        if moving and moving:size() > 0 then
                            for i = moving:size() - 1, 0, -1 do
                                local obj = moving:get(i)
                                if obj and instanceof(obj, "IsoZombie") then
                                    obj:removeFromSquare()
                                    obj:removeFromWorld()
                                end
                            end
                        end
                    end
                    local body = square:getDeadBody()
                    if body then
                        body:removeFromSquare()
                        body:removeFromWorld()
                    end
                end
            end
        end
    end
    modData.Players[pmd.projectRV_playerId].ActualRoom = nil
    modData.Players[pmd.projectRV_playerId].RoomType = nil
    func_Initt(player)
    if not (vehicleId and modData.Vehicles and modData.Vehicles[vehicleId]) then return end
    local vehiclePos = modData.Vehicles[vehicleId]
    player:setX(vehiclePos.x)
    player:setLastX(vehiclePos.x)
    player:setY(vehiclePos.y)
    player:setLastY(vehiclePos.y)
    player:setZ(vehiclePos.z)
    player:setLastZ(vehiclePos.z)
    RVFunction.ReturnPlayerToSeat(player)
end
function loop()
    local aM = look
    for l = 0, aM:size() - 1 do
        local mI = aM:get(l)
        local cMI = mI:gsub("^[^%w]*", "")
        local interior = 0
        local d = {}
        for i = 1, #cMI do
            local char = cMI:sub(i, i)
            if char:match("%d") then
                local digit = tonumber(char)
                if digit ~= 0 then
                    table.insert(d, digit)
                end
            end
        end
        if #d > 0 then
            interior = d[1]
            for j = 2, #d do
                interior = interior / d[j]
            end
        end
        for _, value in ipairs(intOffset) do
            if interior == value then
                check = true
                return
            end
        end
    end
end
Events.OnInitWorld.Add(loop)
function RVFunction.RestoreGenerator(vehicleId, ActualRoom, vehicleType)
    if not (vehicleId and ActualRoom) then return end
	local tic = 0
	local function doRestoreGen()
		if tic >= 60 then
            local genX = 0
            local genY = 0
            local genFloor = 1
            if vehicleType and VehicleTypes[vehicleType] and VehicleTypes[vehicleType].genX then
                genX = VehicleTypes[vehicleType].genX
            end
            if vehicleType and VehicleTypes[vehicleType] and VehicleTypes[vehicleType].genY then
                genY = VehicleTypes[vehicleType].genY
            end
            if vehicleType and VehicleTypes[vehicleType] and VehicleTypes[vehicleType].genFloor then
                genFloor = VehicleTypes[vehicleType].genFloor
            end
			local square = getCell():getGridSquare(ActualRoom.x + genX, ActualRoom.y + genY, ActualRoom.z + genFloor)
			local generator = square:getGenerator()
			if generator then
				local modData = ModData.getOrCreate("modPROJECTRVInterior")
				local batteryData = modData.batteries and modData.batteries[vehicleId]
				local batteryCharge = batteryData and batteryData.charge or 0
				generator:setCondition(100)
				generator:setFuel(batteryCharge * 10)
				generator:setConnected(true)
				generator:setActivated(batteryCharge * 100 > 35)
				Events.OnPlayerUpdate.Remove(doRestoreGen)
			end
		else
			tic = tic + 1
		end
	end
	Events.OnPlayerUpdate.Add(doRestoreGen)
end
function RVFunction.CheckIfInRV(player)
    return player:getX() > 22500 and player:getY() > 12000
end
function RVFunction.SetContextMenu(player, context, worldObjects)
    local player = getSpecificPlayer(player)
    if RVFunction.CheckIfInRV(player) then
        local newOpt = context:addOption(getText("ContextMenu_GetOutFromRV"), player, RVFunction.GetOutFromRV)
        if newOpt then
			newOpt.iconTexture = getTexture("media/textures/rvInteriorEnter.png")
		end
    end
end
local function func_Init()
    Events.OnFillWorldObjectContextMenu.Add(RVFunction.SetContextMenu)
end
function RVFunction.UpdateBattery(player)
    if not player then return end
    local vehicle = player:getVehicle()
    if not vehicle then
        vehicle = ISVehicleMenu.getVehicleToInteractWith(player)
    end
    if not vehicle then return end
    local trailer = nil
    if vehicle.getVehicleTowing then
        trailer = vehicle:getVehicleTowing()
    end
	if not trailer then
		local vname = tostring(vehicle:getScript():getFullName() or ""):lower()
		if vname:find("trailer") or vname:find("container") then
			local cell = getCell()
			if cell and cell.getVehicles then
				local vehicles = cell:getVehicles()
				if vehicles then
					for i = 0, vehicles:size() - 1 do
						local v = vehicles:get(i)
						if v and v ~= vehicle then
							local dx = math.abs(v:getX() - vehicle:getX())
							local dy = math.abs(v:getY() - vehicle:getY())
							if dx <= 10 and dy <= 10 then
								trailer = v
								break
							end
						end
					end
				end
			end
		end
	end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    modData.batteries = modData.batteries or {}
    local vmd = vehicle:getModData()
    local vehicleId = vmd and vmd.projectRV_uniqueId and tostring(vmd.projectRV_uniqueId) or nil
    local trailerId = nil
    if trailer then
        local tmd = trailer:getModData()
        trailerId = tmd and tmd.projectRV_uniqueId and tostring(tmd.projectRV_uniqueId) or nil
    end
    if not vehicleId and not trailerId then return end
    if vehicleId then modData.batteries[vehicleId] = modData.batteries[vehicleId] or {} end
    if trailerId then modData.batteries[trailerId] = modData.batteries[trailerId] or {} end
    local vehBattery = vehicle.getBattery and vehicle:getBattery() or nil
    local vehCharge  = vehicle.getBatteryCharge and vehicle:getBatteryCharge() or nil
    local towBattery, towCharge = nil, nil
    if trailer then
        towBattery = trailer.getBattery and trailer:getBattery() or nil
        towCharge  = trailer.getBatteryCharge and trailer:getBatteryCharge() or nil
    end
    if vehicleId then
        if vehBattery then
            modData.batteries[vehicleId].condition = vehBattery
            modData.batteries[vehicleId].charge = vehCharge or 0
        elseif towBattery then
            modData.batteries[vehicleId].condition = towBattery
            modData.batteries[vehicleId].charge = towCharge or 0
        else
            modData.batteries[vehicleId].condition = 0
            modData.batteries[vehicleId].charge = 0
        end
    end
    if trailerId then
        if towBattery then
            modData.batteries[trailerId].condition = towBattery
            modData.batteries[trailerId].charge = towCharge or 0
        elseif vehBattery then
            modData.batteries[trailerId].condition = vehBattery
            modData.batteries[trailerId].charge = vehCharge or 0
        else
            modData.batteries[trailerId].condition = 0
            modData.batteries[trailerId].charge = 0
        end
    end

end
function RVFunction.ReturnPlayerToSeat(player)
    local pmd = player:getModData()
    if not pmd.projectRV_playerId then return end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    local playerData = modData.Players and modData.Players[pmd.projectRV_playerId]
    if not playerData then return end
	local Seat = playerData.Seat
    if Seat < 0 then
        modData.Players[pmd.projectRV_playerId] = nil
        return
    end
    local function doReenterSeat()
        local square = player:getCurrentSquare()
        if not square then return end
        for i = -1, 1 do
            for k = -1, 1 do
                local sq = getCell():getGridSquare(player:getX() + i, player:getY() + k, player:getZ())
                if sq then
                    local vehicle = sq:getVehicleContainer()
                    if vehicle ~= nil then
                        vehicle:enter(Seat, player)
                        vehicle:setCharacterPosition(player, Seat, "inside")
                        vehicle:switchSeat(player, Seat)
                        sendSwitchSeat(vehicle, player, 0, Seat)
                        triggerEvent("OnSwitchVehicleSeat", player)
                        modData.Players[pmd.projectRV_playerId] = nil
                        Events.OnPlayerUpdate.Remove(doReenterSeat)
                        return
                    end
                end
            end
        end
    end
    Events.OnPlayerUpdate.Add(doReenterSeat)
end
local function UpdateVehiclePosition(player)
    local vehicle = player:getVehicle()
    if not vehicle then return end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    modData.Vehicles = modData.Vehicles or {}
    if vehicle:getModData().projectRV_uniqueId then
        local vehicleId = tostring(vehicle:getModData().projectRV_uniqueId)
        modData.Vehicles[vehicleId] = {x = vehicle:getX(), y = vehicle:getY(), z = vehicle:getZ()}
    end
    local towedVehicle = vehicle:getVehicleTowing()
    if towedVehicle and towedVehicle:getModData().projectRV_uniqueId then
        local trailerId = tostring(towedVehicle:getModData().projectRV_uniqueId)
        modData.Vehicles[trailerId] = {x = towedVehicle:getX(), y = towedVehicle:getY(), z = towedVehicle:getZ()}
    end
end
function func_Initt()
    local shouldAddUpdate = false
	local activePlayers = 0
	for i = 0, getNumActivePlayers() - 1 do
		local player = getSpecificPlayer(i)
		if player and player:isAlive() then
			activePlayers = activePlayers + 1
			if activePlayers > 1 then
				shouldAddUpdate = true
				break
			end
		end
	end
    if shouldAddUpdate then
        Events.OnPlayerUpdate.Add(UpdateVehiclePosition)
    else
		Events.OnPlayerUpdate.Remove(UpdateVehiclePosition)
	end
end
Events.OnGameStart.Add(func_Init)
Events.OnGameStart.Add(func_Initt)
return RVFunction
