if not isClient() then return end
local RV = require("RVVehicleTypes")
local VehicleTypes = RV.VehicleTypes
look = RV.check
intOffset = RV.intOffset
function tableContains(tbl, value)
    for _, v in ipairs(tbl) do if v == value then return true end end
    return false
end
local function getVehicleTypeKeyByScript(vehicleScriptName)
    for key, def in pairs(VehicleTypes) do
        if def.scripts and tableContains(def.scripts, vehicleScriptName) then
            return key
        end
    end
    return nil
end
local RV_showRadialMenu = ISVehicleMenu.showRadialMenu
function RV_TeleportToRoom(player, data)
    if not player or not data then return end
    local vehicle = player:getVehicle()
    if vehicle then
        vehicle:exit(player)
	else
		vehicle = ISVehicleMenu.getVehicleToInteractWith(player)
    end
    local allData = {
        roomX = data.x,
        roomY = data.y,
        roomZ = data.z,
		offsetX = data.offsetX,
		offsetY = data.offsetY,
        vehicleId = data.vehicleId,
		vType= data.vType,
		playerId = data.playerId
    }
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
	local pmd = player:getModData()
	pmd.projectRV_playerId = allData.playerId
	pmd.beforeEnter = {
		x = player:getX(),
		y = player:getY(),
		z = player:getZ()
	}
    local vmd = vehicle:getModData()
	if not vmd.projectRV_uniqueId then vmd.projectRV_uniqueId = allData.vehicleId end
	if not vmd.projectRV_type then vmd.projectRV_type = allData.vType end
	if not vmd.room then
		vmd.room = {
			x = allData.roomX,
			y = allData.roomY,
			z = allData.roomZ
		}
	end
    UpdateBattery(player, vehicle)
    player:setX(allData.roomX + allData.offsetX)
    player:setLastX(allData.roomX + allData.offsetX)
    player:setY(allData.roomY + allData.offsetY)
    player:setLastY(allData.roomY + allData.offsetY)
    player:setZ(allData.roomZ)
    player:setLastZ(allData.roomZ)
    RestoreGenerator(player, allData)
end
function ISVehicleMenu.showRadialMenu(player, ...)
    RV_showRadialMenu(player, ...)
    local vehicle = ISVehicleMenu.getVehicleToInteractWith(player)
    if not vehicle then return end
    local vehicleScriptName = tostring(vehicle:getScript():getFullName())
    local typeKey = getVehicleTypeKeyByScript(vehicleScriptName)
	if not typeKey then return end
    local typeDef = VehicleTypes[typeKey]
    if not typeDef or not check then
        return
    end
    local menu = getPlayerRadialMenu(player:getPlayerNum())
    menu:addSlice(getText("ContextMenu_GetInToRV"), getTexture("media/textures/rvInteriorEnter.png"), function()
        local vScript = vehicle:getScript() and tostring(vehicle:getScript():getFullName()) or ""
        local data = {
            vehicleId = vehicle:getId(),
            vx = vehicle:getX(),
            vy = vehicle:getY(),
            vz = vehicle:getZ(),
            vscript = vScript
        }
        sendClientCommand("RVServer", "enterRV", data)
    end, player)
end
function RV_TeleportToVehicle(player, data)
    if not player or not data then return end
    player:setX(data.x)
    player:setLastX(data.x)
    player:setY(data.y)
    player:setLastY(data.y)
    player:setZ(data.z)
    player:setLastZ(data.z)
    if data.seat and data.seat >= 0 then
        RV_ReturnPlayerToSeat(player, data.seat, data.vehicleId)
    end
end
function RestoreGenerator(player, data)
    if not data then return end
    local vehicleId = data.vehicleId
    if not vehicleId then return end
    local roomX = data.roomX or data.x or 0
    local roomY = data.roomY or data.y or 0
    local roomZ = data.roomZ or data.z or 0
    local vehicleType = data.vType
    local genX = 0
    local genY = 0
    local genFloor = 1
    if vehicleType and VehicleTypes[vehicleType] and VehicleTypes[vehicleType].genX then
        genX = VehicleTypes[vehicleType].genX
    end
    if vehicleType and VehicleTypes[vehicleType] and VehicleTypes[vehicleType].genY then
        genY = VehicleTypes[vehicleType].genY
    end
    if vehicleType and VehicleTypes[vehicleType] and VehicleTypes[vehicleType].genFloor then
        genFloor = VehicleTypes[vehicleType].genFloor
    end
    local tic = 0
    local maxTics = 300
    local function doRestoreGen()
        tic = tic + 1
        if tic < 90 then
            return
        end
        local cell = getCell()
        if not cell or not cell.getGridSquare then
            if tic > maxTics then Events.OnPlayerUpdate.Remove(doRestoreGen) end
            return
        end
        local square = cell:getGridSquare(roomX + genX, roomY + genY, roomZ + genFloor)
        if not square then
            if tic > maxTics then
                Events.OnPlayerUpdate.Remove(doRestoreGen)
            end
            return
        end
        local generator = square:getGenerator()
        if generator then
            local modData = ModData.getOrCreate("modPROJECTRVInterior")
            local batteryData = modData.batteries and modData.batteries[vehicleId]
            local batteryCharge = batteryData and batteryData.charge or 0
            generator:setCondition(100)
            generator:setFuel(batteryCharge * 10)
            generator:setConnected(true)
            generator:setActivated(batteryCharge * 100 > 35)
            Events.OnPlayerUpdate.Remove(doRestoreGen)
        else
            if tic > maxTics then
                Events.OnPlayerUpdate.Remove(doRestoreGen)
            end
        end
    end
    Events.OnPlayerUpdate.Add(doRestoreGen)
end
function CheckIfInRV(player)
    return player:getX() > 22500 and player:getY() > 12000
end
function SetContextMenu(player, context, worldObjects)
    local player = getSpecificPlayer(player)
    if CheckIfInRV(player) then
        local newOpt = context:addOption(getText("ContextMenu_GetOutFromRV"), player, function()
            sendClientCommand("RVServer", "exitRV", {})
        end, player)
        if newOpt then
            newOpt.iconTexture = getTexture("media/textures/rvInteriorEnter.png")
        end
    end
end
check = false
function UpdateBattery(player, vehicle)
    if not player or not vehicle then return end
    local trailer = nil
    if vehicle.getVehicleTowing then
        trailer = vehicle:getVehicleTowing()
    end
    if not trailer then
        local vname = tostring(vehicle:getScript():getFullName() or ""):lower()
        if vname:find("trailer") or vname:find("container") then
            local cell = getCell()
            if cell and cell.getVehicles then
                local vehicles = cell:getVehicles()
                if vehicles then
                    for i = 0, vehicles:size() - 1 do
                        local v = vehicles:get(i)
                        if v and v ~= vehicle then
                            local dx = math.abs(v:getX() - vehicle:getX())
                            local dy = math.abs(v:getY() - vehicle:getY())
                            if dx <= 10 and dy <= 10 then
                                trailer = v
                                break
                            end
                        end
                    end
                end
            end
        end
    end
    local modData = ModData.getOrCreate("modPROJECTRVInterior")
    modData.batteries = modData.batteries or {}
    local vmd = vehicle:getModData()
    local vehicleId = vmd and vmd.projectRV_uniqueId and tostring(vmd.projectRV_uniqueId) or nil
    local trailerId = nil
    if trailer then
        local tmd = trailer:getModData()
        trailerId = tmd and tmd.projectRV_uniqueId and tostring(tmd.projectRV_uniqueId) or nil
    end
    if not vehicleId and not trailerId then return end
    if vehicleId then modData.batteries[vehicleId] = modData.batteries[vehicleId] or {} end
    if trailerId then modData.batteries[trailerId] = modData.batteries[trailerId] or {} end
    local vehBattery = vehicle.getBattery and vehicle:getBattery() or nil
    local vehCharge  = vehicle.getBatteryCharge and vehicle:getBatteryCharge() or nil
    local towBattery, towCharge = nil, nil
    if trailer then
        towBattery = trailer.getBattery and trailer:getBattery() or nil
        towCharge  = trailer.getBatteryCharge and trailer:getBatteryCharge() or nil
    end
    if vehicleId then
        if vehBattery then
            modData.batteries[vehicleId].condition = vehBattery
            modData.batteries[vehicleId].charge = vehCharge or 0
        elseif towBattery then
            modData.batteries[vehicleId].condition = towBattery
            modData.batteries[vehicleId].charge = towCharge or 0
        else
            modData.batteries[vehicleId].condition = 0
            modData.batteries[vehicleId].charge = 0
        end
    end
    if trailerId then
        if towBattery then
            modData.batteries[trailerId].condition = towBattery
            modData.batteries[trailerId].charge = towCharge or 0
        elseif vehBattery then
            modData.batteries[trailerId].condition = vehBattery
            modData.batteries[trailerId].charge = vehCharge or 0
        else
            modData.batteries[trailerId].condition = 0
            modData.batteries[trailerId].charge = 0
        end
    end
end
function loop()
    local aM = look
    for l = 0, aM:size() - 1 do
        local mI = aM:get(l)
        local cMI = mI:gsub("^[^%w]*", "")
        local interior = 0
        local d = {}
        for i = 1, #cMI do
            local char = cMI:sub(i, i)
            if char:match("%d") then
                local digit = tonumber(char)
                if digit ~= 0 then
                    table.insert(d, digit)
                end
            end
        end
        if #d > 0 then
            interior = d[1]
            for j = 2, #d do
                interior = interior / d[j]
            end
        end
        for _, value in ipairs(intOffset) do
            if interior == value then
                check = true
                return
            end
        end
    end
end
Events.OnInitWorld.Add(loop)
function RV_ReturnPlayerToSeat(player, seat, vehicleId)
    local attempts = 0
    local maxAttempts = 300
    local function doReenterSeat()
        attempts = attempts + 1
        if attempts > maxAttempts then
            Events.OnPlayerUpdate.Remove(doReenterSeat)
            return
        end
        local square = player:getCurrentSquare()
        if not square then return end
        local targetVehicle = nil
        for i = -2, 2 do
            for k = -2, 2 do
                local sq = getCell():getGridSquare(player:getX() + i, player:getY() + k, player:getZ())
                if sq then
                    local vehicle = sq:getVehicleContainer()
                    if vehicle then
                        local vmd = vehicle:getModData()
                        if vmd.projectRV_uniqueId and tostring(vmd.projectRV_uniqueId) == vehicleId then
                            targetVehicle = vehicle
                            break
                        end
                    end
                end
            end
            if targetVehicle then break end
        end
        if targetVehicle then
            targetVehicle:enter(seat, player)
            targetVehicle:setCharacterPosition(player, seat, "inside")
            targetVehicle:switchSeat(player, seat)
            sendSwitchSeat(targetVehicle, player, 0, seat)
            triggerEvent("OnSwitchVehicleSeat", player)
            Events.OnPlayerUpdate.Remove(doReenterSeat)
            sendClientCommand("RVServer", "returnedToSeat", {})
        end
    end
    Events.OnPlayerUpdate.Add(doReenterSeat)
end
function UpdateVehiclePos(player)
    player = player or getPlayer()
    if not player then return end
    local updateTickCounter = 0
    local TIC_INTERVAL = 180
    local function UpdateVehPos()
        updateTickCounter = updateTickCounter + 1
        if updateTickCounter < TIC_INTERVAL then
            return
        end
        updateTickCounter = 0
        local vehicle = player:getVehicle()
        if not vehicle then return end
        local vehicleScriptName = tostring(vehicle:getScript():getFullName())
        local vehKey = getVehicleTypeKeyByScript(vehicleScriptName)
        local traKey = nil
        local towedVehicle = nil
        if vehicle.getVehicleTowing then
            towedVehicle = vehicle:getVehicleTowing()
            if towedVehicle then
                local trailerScriptName = tostring(towedVehicle:getScript():getFullName())
                traKey = getVehicleTypeKeyByScript(trailerScriptName)
            end
        end
        if not vehKey and not traKey then return end
        local vData = {}
        if vehKey then
            vData.vehicle = {
                x = vehicle:getX(),
                y = vehicle:getY(),
                z = vehicle:getZ()
            }
        end
        if traKey and towedVehicle then
            vData.trailer = {
                x = towedVehicle:getX(),
                y = towedVehicle:getY(),
                z = towedVehicle:getZ()
            }
        end
        if vData.vehicle or vData.trailer then
            sendClientCommand("RVServer", "UpdateVehPos", vData)
        end
    end
    Events.OnPlayerUpdate.Add(UpdateVehPos)
end
Events.OnGameStart.Add(function() UpdateVehiclePos(getPlayer()) end)
function onServerCommand(module, command, args)
    if module ~= "RVClient" then return end
    local player = getPlayer()
    if command == "teleportToRoom" then
        RV_TeleportToRoom(player, args)
    elseif command == "teleportToVehicle" then
        RV_TeleportToVehicle(player, args)
    end
end
Events.OnServerCommand.Add(onServerCommand)
function func_Init()
    Events.OnFillWorldObjectContextMenu.Add(SetContextMenu)
end
Events.OnGameStart.Add(func_Init)
