
-- ITEM UPDATER --

local function MuleItemParam(item, newparam)
	local x = ScriptManager.instance:getItem(item)
	if x then
		x:DoParam(newparam)
		print("PackMule: item updated: "..item.." "..newparam)
	else
		print("PackMule: unable to find item "..item)
	end	
end

-- SANDBOX OPTIONS --

-- Give all Hunting Vests Capacity, adds sounds, tags, and max item size restrictions --
local function MuleHuntingVests()
    if SandboxVars.B42PackMuleVests.HuntingVests then

		-- Foreman Vest
		MuleItemParam("Vest_Foreman","Type = Container")
		MuleItemParam("Vest_Foreman","DisplayCategory = Bag")
		MuleItemParam("Vest_Foreman","Capacity = 4")
		MuleItemParam("Vest_Foreman","MaxItemSize = 1.3")
		MuleItemParam("Vest_Foreman","WeightReduction = 65")
		MuleItemParam("Vest_Foreman","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Foreman","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Foreman","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Foreman","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Grey
		MuleItemParam("Vest_Hunting_Grey","Type = Container")
		MuleItemParam("Vest_Hunting_Grey","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_Grey","Capacity = 4")
		MuleItemParam("Vest_Hunting_Grey","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_Grey","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_Grey","EquipSound= EquipAliceBelt")
		MuleItemParam("Vest_Hunting_Grey","OpenSound= OpenCargoVest")
		MuleItemParam("Vest_Hunting_Grey","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_Grey","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Orange
		MuleItemParam("Vest_Hunting_Orange","Type = Container")
		MuleItemParam("Vest_Hunting_Orange","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_Orange","Capacity = 4")
		MuleItemParam("Vest_Hunting_Orange","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_Orange","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_Orange","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_Orange","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_Orange","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_Orange","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Camo
		MuleItemParam("Vest_Hunting_Camo","Type = Container")
		MuleItemParam("Vest_Hunting_Camo","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_Camo","Capacity = 4")
		MuleItemParam("Vest_Hunting_Camo","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_Camo","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_Camo","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_Camo","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_Camo","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_Camo","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Green
		MuleItemParam("Vest_Hunting_CamoGreen","Type = Container")
		MuleItemParam("Vest_Hunting_CamoGreen","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_CamoGreen","Capacity = 4")
		MuleItemParam("Vest_Hunting_CamoGreen","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_CamoGreen","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_CamoGreen","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_CamoGreen","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_CamoGreen","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_CamoGreen","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Khaki
		MuleItemParam("Vest_Hunting_Khaki","Type = Container")
		MuleItemParam("Vest_Hunting_Khaki","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_Khaki","Capacity = 4")
		MuleItemParam("Vest_Hunting_Khaki","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_Khaki","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_Khaki","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_Khaki","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_Khaki","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_Khaki","CanBeEquipped = TorsoExtraVestBullet")

		-- Trucker Vest
		MuleItemParam("Vest_Trucker","Type = Container")
		MuleItemParam("Vest_Trucker","DisplayCategory = Bag")
		MuleItemParam("Vest_Trucker","Capacity = 4")
		MuleItemParam("Vest_Trucker","MaxItemSize = 1.3")
		MuleItemParam("Vest_Trucker","WeightReduction = 65")
		MuleItemParam("Vest_Trucker","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Trucker","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Trucker","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Trucker","CanBeEquipped = TorsoExtraVestBullet")

	
		-- Spongie's Open Jackets Compatibility --
	
		-- Foreman Vest OPEN
		MuleItemParam("Vest_ForemanOPEN","Type = Container")
		MuleItemParam("Vest_ForemanOPEN","DisplayCategory = Bag")
		MuleItemParam("Vest_ForemanOPEN","Capacity = 4")
		MuleItemParam("Vest_ForemanOPEN","MaxItemSize = 1.3")
		MuleItemParam("Vest_ForemanOPEN","WeightReduction = 65")
		MuleItemParam("Vest_ForemanOPEN","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_ForemanOPEN","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_ForemanOPEN","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_ForemanOPEN","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Grey OPEN
		MuleItemParam("Vest_Hunting_GreyOPEN","Type = Container")
		MuleItemParam("Vest_Hunting_GreyOPEN","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_GreyOPEN","Capacity = 4")
		MuleItemParam("Vest_Hunting_GreyOPEN","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_GreyOPEN","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_GreyOPEN","EquipSound= EquipAliceBelt")
		MuleItemParam("Vest_Hunting_GreyOPEN","OpenSound= OpenCargoVest")
		MuleItemParam("Vest_Hunting_GreyOPEN","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_GreyOPEN","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Orange OPEN
		MuleItemParam("Vest_Hunting_OrangeOPEN","Type = Container")
		MuleItemParam("Vest_Hunting_OrangeOPEN","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_OrangeOPEN","Capacity = 4")
		MuleItemParam("Vest_Hunting_OrangeOPEN","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_OrangeOPEN","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_OrangeOPEN","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_OrangeOPEN","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_OrangeOPEN","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_OrangeOPEN","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Camo OPEN
		MuleItemParam("Vest_Hunting_CamoOPEN","Type = Container")
		MuleItemParam("Vest_Hunting_CamoOPEN","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_CamoOPEN","Capacity = 4")
		MuleItemParam("Vest_Hunting_CamoOPEN","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_CamoOPEN","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_CamoOPEN","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_CamoOPEN","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_CamoOPEN","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_CamoOPEN","CanBeEquipped = TorsoExtraVestBullet")

		-- Hunting Vest Green OPEN
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","Type = Container")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","DisplayCategory = Bag")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","Capacity = 4")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","MaxItemSize = 1.3")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","WeightReduction = 65")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","EquipSound = EquipAliceBelt")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","OpenSound = OpenCargoVest")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","PutInSound = StoreItemCargoVest")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","CanBeEquipped = TorsoExtraVestBullet")
    end
end

-- Prevents Holes from accumulating on Hunting Vests, best used with Capacity Vests as 'Container' items cannot be repaired normally --
local function MuleVestProtection()
    if SandboxVars.B42PackMuleVests.VestProtection then
		
		--Vests can't have holes
		MuleItemParam("Vest_Foreman","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_Grey","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_Orange","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_Camo","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_CamoGreen","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_Khaki","CanHaveHoles = false")
		MuleItemParam("Vest_Trucker","CanHaveHoles = false")
		MuleItemParam("Vest_ForemanOPEN","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_GreyOPEN","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_OrangeOPEN","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_CamoOPEN","CanHaveHoles = false")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","CanHaveHoles = false")
    end
end


-- Give all Vest types 2 new Attachments Slots, also gives new items the ability to be attached to said Slots --
local function MuleVestAttachments()
    if SandboxVars.B42PackMuleVests.VestAttachments then

		--Vest Attachment Slots
		MuleItemParam("Vest_Foreman","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_Grey","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_Orange","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_Camo","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_CamoGreen","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_Khaki","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Trucker","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Leather","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Leather_BarrelDogs","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Leather_IronRodents","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Leather_WildRaccoons","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Leather_Veteran","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Leather_Biker","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_SheepSkin","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_ForemanOPEN","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_GreyOPEN","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_OrangeOPEN","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_CamoOPEN","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","AttachmentsProvided = HuntingVestLeft;HuntingVestRight")

		--CD Player
		MuleItemParam("CDplayer","AttachmentType = SmallElectronics")

		--Firearm Magazines
		MuleItemParam("44Clip","AttachmentType = AmmoClip")
		MuleItemParam("M14Clip","AttachmentType = AmmoClip")
		MuleItemParam("556Clip","AttachmentType = AmmoClip")
		MuleItemParam("45Clip","AttachmentType = AmmoClip")
		MuleItemParam("9mmClip","AttachmentType = AmmoClip")
    end
end

Events.OnInitGlobalModData.Add(MuleHuntingVests)
Events.OnInitGlobalModData.Add(MuleVestProtection)
Events.OnInitGlobalModData.Add(MuleVestAttachments)
