
-- ITEM UPDATER --

local function MuleItemParam(item, newparam)
	local x = ScriptManager.instance:getItem(item)
	if x then
		x:DoParam(newparam)
		print("PackMule: item updated: "..item.." "..newparam)
	else
		print("PackMule: unable to find item "..item)
	end	
end

-- SANDBOX OPTIONS --

-- Wear Golf Bags with Backpacks, mutually exclusive with Duffel Bags if both are TRUE
local function MuleGolfBags()
    if SandboxVars.B42PackMuleBags.GolfBags then
	
		--Golf Bags
		MuleItemParam("Bag_GolfBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_GolfBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_GolfBag_Melee","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_GolfBag_Melee","CanBeEquipped = BackExtraBag")
    end
end

--Wear Duffel Bags with Backpacks, mutually exclusive with Golf Bags if both are TRUE
local function MuleDuffelBags()
    if SandboxVars.B42PackMuleBags.DuffelBags then
	
		--Duffel Bags
		MuleItemParam("Bag_WeaponBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_WeaponBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_InmateEscapedBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_InmateEscapedBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_MoneyBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_MoneyBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_WorkerBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_WorkerBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_DuffelBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_DuffelBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_BreakdownBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_BreakdownBag","CanBeEquipped= BackExtraBag")
		MuleItemParam("Bag_DuffelBagTINT","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_DuffelBagTINT","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_ShotgunBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_ShotgunBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_ShotgunSawnoffBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_ShotgunSawnoffBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_ShotgunDblBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_ShotgunDblBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_ShotgunDblSawnoffBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_ShotgunDblSawnoffBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_BurglarBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_BurglarBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_Police","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_Police","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_Sheriff","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_Sheriff","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_SWAT","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_SWAT","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_BaseballBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_BaseballBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_TennisBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_TennisBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_FoodCanned","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_FoodCanned","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_FoodSnacks","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_FoodSnacks","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_MedicalBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_MedicalBag","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_Military","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_Military","CanBeEquipped = BackExtraBag")
		MuleItemParam("Bag_ToolBag","BodyLocation = BackExtraBag")
		MuleItemParam("Bag_ToolBag","CanBeEquipped = BackExtraBag")
    end
end

--
local function MuleRifleCases()
    if SandboxVars.B42PackMuleBags.RifleCases then
		
		-- Rifle Cases
		MuleItemParam("Bag_RifleCaseCloth","BodyLocation = RifleBag")
		MuleItemParam("Bag_RifleCaseCloth","CanBeEquipped= RifleBag")
		MuleItemParam("Bag_RifleCaseCloth2","BodyLocation = RifleBag")
		MuleItemParam("Bag_RifleCaseCloth2","CanBeEquipped = RifleBag")
		MuleItemParam("Bag_ShotgunCaseCloth","BodyLocation = RifleBag")
		MuleItemParam("Bag_ShotgunCaseCloth","CanBeEquipped = RifleBag")
		MuleItemParam("Bag_ShotgunCaseCloth2","BodyLocation = RifleBag")
		MuleItemParam("Bag_ShotgunCaseCloth2","CanBeEquipped = RifleBag")
		MuleItemParam("Bag_RifleCaseClothCamo","BodyLocation = RifleBag")
		MuleItemParam("Bag_RifleCaseClothCamo","CanBeEquipped = RifleBag")
    end
end

local function MuleMilitaryWebbing()
    if SandboxVars.B42PackMuleBags.MilitaryWebbing then

		--Military Backpacks
		MuleItemParam("Bag_SurvivorBag","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottomALICE")
		MuleItemParam("Bag_ALICEpack_DesertCamo","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottomALICE")
		MuleItemParam("Bag_ALICEpack_Army","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottomALICE")
		MuleItemParam("Bag_ALICEpack","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottomALICE")
    end
end

local function MuleHikingWebbing()
    if SandboxVars.B42PackMuleBags.HikingWebbing then

		--Hiking Backpacks
		MuleItemParam("Bag_BigHikingBag","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottomBig")
		MuleItemParam("Bag_BigHikingBag_Travel","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottomBig")
		MuleItemParam("Bag_NormalHikingBag","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
		MuleItemParam("Bag_HikingBag_Travel","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
    end
end

local function MuleSchoolWebbing()
    if SandboxVars.B42PackMuleBags.SchoolWebbing then

		--School Backpacks
		MuleItemParam("Bag_Schoolbag","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_Schoolbag_Kids","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_Schoolbag_Patches","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_Schoolbag_Travel","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_Schoolbag_Medical","AttachmentsProvided = WebbingLeft;WebbingRight")
    end
end

local function MuleSmallCraftedWebbing()
    if SandboxVars.B42PackMuleBags.SmallCraftedWebbing then

		--Small Crafted Backpacks
		MuleItemParam("Bag_CrudeLeatherBag","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_CrudeTarpBag","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_CraftedFramepack_Small","AttachmentsProvided = WebbingLeft;WebbingRight")
		MuleItemParam("Bag_TarpFramepack_Small","AttachmentsProvided = WebbingLeft;WebbingRight")
    end
end

local function MuleLargeCraftedWebbing()
    if SandboxVars.B42PackMuleBags.LargeCraftedWebbing then

		--Large Crafted Backpacks
		MuleItemParam("Bag_CraftedFramepack_Large","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
		MuleItemParam("Bag_CraftedFramepack_Large2","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
		MuleItemParam("Bag_CraftedFramepack_Large3","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
		MuleItemParam("Bag_CraftedFrame_Large2","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
		MuleItemParam("Bag_CraftedFrame_Large3","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
		MuleItemParam("Bag_TarpFramepack_Large","AttachmentsProvided = WebbingLeft;WebbingRight;BedrollBottom")
    end
end

Events.OnInitGlobalModData.Add(MuleGolfBags)
Events.OnInitGlobalModData.Add(MuleDuffelBags)
Events.OnInitGlobalModData.Add(MuleRifleCases)
Events.OnInitGlobalModData.Add(MuleMilitaryWebbing)
Events.OnInitGlobalModData.Add(MuleHikingWebbing)
Events.OnInitGlobalModData.Add(MuleSchoolWebbing)
Events.OnInitGlobalModData.Add(MuleSmallCraftedWebbing)
Events.OnInitGlobalModData.Add(MuleLargeCraftedWebbing)