
-- ITEM UPDATER --

local function MuleItemParam(item, newparam)
	local x = ScriptManager.instance:getItem(item)
	if x then
		x:DoParam(newparam)
		print("PackMule: item updated: "..item.." "..newparam)
	else
		print("PackMule: unable to find item "..item)
	end	
end

-- SANDBOX OPTIONS --

-- Wear Slings and Satchels with Backpacks --
local function MuleSlingsAndSatchels()
	if SandboxVars.B42PackMulev2.SlingsAndSatchels then	

		--Slings
		MuleItemParam("Bag_SheetSlingBag","BodyLocation = LowerBag")
		MuleItemParam("Bag_SheetSlingBag","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_HideSlingBag","BodyLocation = LowerBag")
		MuleItemParam("Bag_HideSlingBag","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_TarpSlingBag","BodyLocation = LowerBag")
		MuleItemParam("Bag_TarpSlingBag","CanBeEquipped = LowerBag")

		--Satchels
		MuleItemParam("Bag_ClothSatchel_Burlap","BodyLocation = LowerBag")
		MuleItemParam("Bag_ClothSatchel_Burlap","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_ClothSatchel_Cotton","BodyLocation = LowerBag")
		MuleItemParam("Bag_ClothSatchel_Cotton","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_ClothSatchel_Denim","BodyLocation = LowerBag")
		MuleItemParam("Bag_ClothSatchel_Denim","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_ClothSatchel_DenimBlack","BodyLocation = LowerBag")
		MuleItemParam("Bag_ClothSatchel_DenimBlack","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_ClothSatchel_DenimLight","BodyLocation = LowerBag")
		MuleItemParam("Bag_ClothSatchel_DenimLight","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_Satchel","BodyLocation = LowerBag")
		MuleItemParam("Bag_Satchel","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_Satchel_Medical","BodyLocation = LowerBag")
		MuleItemParam("Bag_Satchel_Medical","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_Satchel_Military","BodyLocation = LowerBag")
		MuleItemParam("Bag_Satchel_Military","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_SatchelPhoto","BodyLocation = LowerBag")
		MuleItemParam("Bag_SatchelPhoto","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_FishingBasket","BodyLocation = LowerBag")
		MuleItemParam("Bag_FishingBasket","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_Satchel_Mail","BodyLocation = LowerBag")
		MuleItemParam("Bag_Satchel_Mail","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_Satchel_Leather","BodyLocation = LowerBag")
		MuleItemParam("Bag_Satchel_Leather","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_HideSatchel","BodyLocation = LowerBag")
		MuleItemParam("Bag_HideSatchel","CanBeEquipped = LowerBag")
		MuleItemParam("Bag_Satchel_Fishing","BodyLocation = LowerBag")
		MuleItemParam("Bag_Satchel_Fishing","CanBeEquipped = LowerBag")	

		--[B42] Hemp & Tobacco Compatibility
		MuleItemParam("Bag_BurlapTote","BodyLocation = LowerBag")
		MuleItemParam("Bag_BurlapTote","CanBeEquipped = LowerBag")
	end
end

-- Allows Wallets and Pouches to be Equipped --
local function MuleWalletsAndPouches()
    if SandboxVars.B42PackMulev2.WalletsAndPouches then

		--Wallets
		MuleItemParam("Wallet","BodyLocation = Pocket")
		MuleItemParam("Wallet","CanBeEquipped  = Pocket")
		MuleItemParam("Wallet","WeightReduction  = 50")
		MuleItemParam("Wallet_Female","BodyLocation = Pocket")
		MuleItemParam("Wallet_Female","CanBeEquipped  = Pocket")
		MuleItemParam("Wallet_Female","WeightReduction  = 50")
		MuleItemParam("Wallet_Male","BodyLocation = Pocket")
		MuleItemParam("Wallet_Male","CanBeEquipped  = Pocket")
		MuleItemParam("Wallet_Male","WeightReduction  = 50")
		MuleItemParam("Wallet_Hide","BodyLocation = Pocket")
		MuleItemParam("Wallet_Hide","CanBeEquipped = Pocket")
		MuleItemParam("Wallet_Hide","WeightReduction  = 50")

		--Pouches
		MuleItemParam("GemBag","BodyLocation = Pocket")
		MuleItemParam("GemBag","CanBeEquipped = Pocket")
		MuleItemParam("SeedBag","BodyLocation = Pocket")
		MuleItemParam("SeedBag","CanBeEquipped = Pocket")
		MuleItemParam("SeedBag_Farming","BodyLocation = Pocket")
		MuleItemParam("SeedBag_Farming","CanBeEquipped = Pocket")
    end
end

-- Wear Canteens with Bandoliers --
local function MuleCanteen()
    if SandboxVars.B42PackMulev2.Canteen then

		--Canteen
		MuleItemParam("Bag_LeatherWaterBag","BodyLocation = ExtraStrap")
		MuleItemParam("Bag_LeatherWaterBag","CanBeEquipped = ExtraStrap")
		MuleItemParam("CanteenCowboy","BodyLocation = ExtraStrap")
		MuleItemParam("CanteenCowboy","CanBeEquipped = ExtraStrap")
    end
end	

-- Wear Watches with Bracelets and Forearm Armor --
local function MuleWatch()
    if SandboxVars.B42PackMulev2.Watch then

		--Watches
		MuleItemParam("WristWatch_Right_ClassicBlack","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_ClassicBlack","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_ClassicBlack","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_ClassicBlack","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_ClassicBrown","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_ClassicBrown","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_ClassicBrown","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_ClassicBrown","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_ClassicMilitary","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_ClassicMilitary","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_ClassicMilitary","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_ClassicMilitary","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_ClassicGold","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_ClassicGold","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_ClassicGold","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_ClassicGold","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_DigitalBlack","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_DigitalBlack","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_DigitalBlack","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_DigitalBlack","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_DigitalRed","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_DigitalRed","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_DigitalRed","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_DigitalRed","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_DigitalDress","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_DigitalDress","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_DigitalDress","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_DigitalDress","CanBeEquipped = LeftAccessory")
		MuleItemParam("WristWatch_Right_Expensive","BodyLocation = RightAccessory")
		MuleItemParam("WristWatch_Right_Expensive","CanBeEquipped = RightAccessory")
		MuleItemParam("WristWatch_Left_Expensive","BodyLocation = LeftAccessory")
		MuleItemParam("WristWatch_Left_Expensive","CanBeEquipped = LeftAccessory")
    end
end

-- Wear Bracelets with Watches and Forearm Armor --
local function MuleBracelet()
    if SandboxVars.B42PackMulev2.Bracelet then

		--Bracelets
		MuleItemParam("Bracelet_BangleRightGold","BodyLocation = RightAccessorySmall")
		MuleItemParam("Bracelet_BangleRightGold","CanBeEquipped = RightAccessorySmall")
		MuleItemParam("Bracelet_BangleLeftGold","BodyLocation = LeftAccessorySmall")
		MuleItemParam("Bracelet_BangleLeftGold","CanBeEquipped = LeftAccessorySmall")
		MuleItemParam("Bracelet_ChainRightGold","BodyLocation = RightAccessorySmall")
		MuleItemParam("Bracelet_ChainRightGold","CanBeEquipped = RightAccessorySmall")
		MuleItemParam("Bracelet_ChainLeftGold","BodyLocation = LeftAccessorySmall")
		MuleItemParam("Bracelet_ChainLeftGold","CanBeEquipped = LeftAccessorySmall")
		MuleItemParam("Bracelet_BangleRightSilver","BodyLocation = RightAccessorySmall")
		MuleItemParam("Bracelet_BangleRightSilver","CanBeEquipped = RightAccessorySmall")
		MuleItemParam("Bracelet_BangleLeftSilver","BodyLocation = LeftAccessorySmall")
		MuleItemParam("Bracelet_BangleLeftSilver","CanBeEquipped = LeftAccessorySmall")
		MuleItemParam("Bracelet_ChainRightSilver","BodyLocation = RightAccessorySmall")
		MuleItemParam("Bracelet_ChainRightSilver","CanBeEquipped = RightAccessorySmall")
		MuleItemParam("Bracelet_ChainLeftSilver","BodyLocation = LeftAccessorySmall")
		MuleItemParam("Bracelet_ChainLeftSilver","CanBeEquipped = LeftAccessorySmall")
		MuleItemParam("Bracelet_RightFriendshipTINT","BodyLocation = RightAccessorySmall")
		MuleItemParam("Bracelet_RightFriendshipTINT","CanBeEquipped = RightAccessorySmall")
		MuleItemParam("Bracelet_LeftFriendshipTINT","BodyLocation = LeftAccessorySmall")
		MuleItemParam("Bracelet_LeftFriendshipTINT","CanBeEquipped = LeftAccessorySmall")
    end
end

-- Wear Ear Protectors with Hats --
local function MuleEarProtectors()
    if SandboxVars.B42PackMulev2.EarProtectors then

		--Ear Protectors
		MuleItemParam("Hat_EarMuffs","BodyLocation = EarProtector")
		MuleItemParam("Hat_EarMuffs","CanBeEquipped = EarProtector")
		MuleItemParam("Hat_EarMuff_Protectors","BodyLocation = EarProtector")
		MuleItemParam("Hat_EarMuff_Protectors","CanBeEquipped = EarProtector")
    end
end

-- Allows Hunting Vests to Repaired --
local function MuleRepairVest()
    if SandboxVars.B42PackMulev2.RepairVest then

		--Cloth Vests
		MuleItemParam("Vest_Foreman","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_Grey","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_Orange","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_Camo","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_CamoGreen","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_Khaki","FabricType = Cotton")
		MuleItemParam("Vest_Trucker","FabricType = Cotton")
		
    end
end

-- Wear Boiler Suits with Jackets --
local function MuleBoilerSuits()
    if SandboxVars.B42PackMulev2.BoilerSuits then

		--Boiler Suits
		MuleItemParam("Boilersuit","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_BlueRed","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_BlueRed","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_Flying","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_Flying","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_Prisoner","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_Prisoner","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_PrisonerKhaki","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_PrisonerKhaki","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_SWAT","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_SWAT","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_Yellow","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_Yellow","CanBeEquipped = PantsExtra")

		--Spongie's Open Jackets Compatibility
		MuleItemParam("Vest_ForemanOPEN","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_GreyOPEN","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_OrangeOPEN","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_CamoOPEN","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_CamoGreenOPEN","FabricType = Cotton")
		MuleItemParam("Vest_Hunting_KhakiOPEN","FabricType = Cotton")
		MuleItemParam("BoilersuitOPEN","BodyLocation = PantsExtra")
		MuleItemParam("BoilersuitOPEN","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_BlueRedOPEN","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_BlueRedOPEN","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_FlyingOPEN","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_FlyingOPEN","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_PrisonerOPEN","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_PrisonerOPEN","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_PrisonerKhakiOPEN","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_PrisonerKhakiOPEN","CanBeEquipped = PantsExtra")
		MuleItemParam("Boilersuit_YellowOPEN","BodyLocation = PantsExtra")
		MuleItemParam("Boilersuit_YellowOPEN","CanBeEquipped = PantsExtra")		
    end
end

-- Wear Lanterns on Belts --
local function MuleLantern()
    if SandboxVars.B42PackMulev2.Lantern then

		--Lanterns
		MuleItemParam("Lantern_Hurricane","AttachmentType = Wrench")
		MuleItemParam("Lantern_Hurricane_Forged","AttachmentType = Wrench")
		MuleItemParam("Lantern_Hurricane_Copper","AttachmentType = Wrench")
		MuleItemParam("Lantern_Hurricane_Gold","AttachmentType = Wrench")
		MuleItemParam("Lantern_Hurricane_Silver","AttachmentType = Wrench")
		MuleItemParam("Lantern_CraftedElectric","AttachmentType = Wrench")
		MuleItemParam("Lantern_Propane","AttachmentType = Wrench")		
    end
end

-- Wear Penlights on Webbing --
local function MulePenlight()
    if SandboxVars.B42PackMulev2.Penlight then

		--Penlight
		MuleItemParam("PenLight","AttachmentType = Webbing")		
    end
end

-- Equip BlowTorch to Back --
local function MuleBlowTorch()
    if SandboxVars.B42PackMulev2.BlowTorch then

		--Welding Torch
		MuleItemParam("BlowTorch","AttachmentType = Shovel")		
    end
end

-- Allows Magazine Limb Armor recipes to be learned from Crossword and Wordsearch Magazines --
local function MuleMagazineArmor()
    if SandboxVars.B42PackMulev2.MagazineArmor then

		--Magazine Limb Armor
		MuleItemParam("MagazineCrossword","ResearchableRecipes = MakeForearmMagazineArmor")
		MuleItemParam("MagazineWordsearch","ResearchableRecipes = MakeForearmMagazineArmor")		
    end
end

Events.OnInitGlobalModData.Add(MuleSlingsAndSatchels)
Events.OnInitGlobalModData.Add(MuleWalletsAndPouches)
Events.OnInitGlobalModData.Add(MuleCanteen)
Events.OnInitGlobalModData.Add(MuleWatch)
Events.OnInitGlobalModData.Add(MuleBracelet)
Events.OnInitGlobalModData.Add(MuleEarProtectors)
Events.OnInitGlobalModData.Add(MuleRepairVest)
Events.OnInitGlobalModData.Add(MuleBoilerSuits)
Events.OnInitGlobalModData.Add(MuleLantern)
Events.OnInitGlobalModData.Add(MulePenlight)
Events.OnInitGlobalModData.Add(MuleBlowTorch)
Events.OnInitGlobalModData.Add(MuleMagazineArmor)