-- media/lua/client/XP_NB_BuildSets.lua
-- This module returns a table (M) and also assigns global XP_NC_SETS to support both require styles.
-- Shared build sets XP_NC_SETS for compatibility.

-- Expose both a return table and a global, so both patterns work.
local M = {}

M.XP_NC_VANILLA_BUILD_SET = {
    ["Advanced_Forge"] = true,
    ["Amphora"] = true,
    ["BarbedWireFence"] = true,
    ["BarrelOven"] = true,
    ["BarricadeMetalBar"] = true,
    ["BarricadeMetalSheet"] = true,
    ["BarricadePlanks"] = true,
    ["Blast_Furnace"] = true,
    ["BrickDoorFrameLvl1"] = true,
    ["BrickDoorFrameLvl2"] = true,
    ["BrickFenceLvl2"] = true,
    ["BrickFloorLvl1"] = true,
    ["BrickWallLvl1"] = true,
    ["BrickWallLvl2"] = true,
    ["BrickWindowFrameLvl1"] = true,
    ["BrickWindowFrameLvl2"] = true,
    ["ButcherHook"] = true,
    ["Campfire"] = true,
    ["Charcoal_Burner_DarkGreenBarrel"] = true,
    ["Charcoal_Burner_LightGreenBarrel"] = true,
    ["Charcoal_Burner_MetalDrum"] = true,
    ["Charcoal_Burner_OrangeBarrel"] = true,
    ["Charcoal_Pit"] = true,
    ["ChickenHutch"] = true,
    ["ChickenHutch2"] = true,
    ["Chopping_Block"] = true,
    ["ChurnBucket"] = true,
    ["Coffin"] = true,
    ["Composter"] = true,
    ["ComposterShoddy"] = true,
    ["Cooking_Pit"] = true,
    ["DirtFloor"] = true,
    ["Dome_Kiln"] = true,
    ["DoubleDoor"] = true,
    ["DoubleFenceGate"] = true,
    ["DoubleWireGate"] = true,
    ["DryingRackLarge"] = true,
    ["DryingRackMedium"] = true,
    ["DryingRackSmall"] = true,
    ["Drying_Rack"] = true,
    ["FeedingTroughDouble"] = true,
    ["FeedingTroughDoubleMetal"] = true,
    ["FeedingTroughSimple"] = true,
    ["Forge"] = true,
    ["Forge_Primitive_Forge"] = true,
    ["GravelFloor"] = true,
    ["Grindstone"] = true,
    ["Hand_Press"] = true,
    ["HeckleComb"] = true,
    ["Herb_Drying_Rack"] = true,
    ["Kiln_Large"] = true,
    ["Kiln_Small"] = true,
    ["LeanTo_Shelter"] = true,
    ["Leather_Shelter"] = true,
    ["LogDoorFrameLvl1"] = true,
    ["LogFence"] = true,
    ["LogGate"] = true,
    ["LogWall"] = true,
    ["LogWindowFrameLvl1"] = true,
    ["Log_Bench"] = true,
    ["Log_Stairs"] = true,
    ["Log_Stool"] = true,
    ["Log_Table"] = true,
    ["MetalBigMetalFence"] = true,
    ["MetalBigWireFence"] = true,
    ["MetalDoorFrameLvl1"] = true,
    ["MetalDoorFrameLvl2"] = true,
    ["MetalDoorLvl1"] = true,
    ["MetalDoorLvl2"] = true,
    ["MetalFenceLvl1"] = true,
    ["MetalFenceLvl2"] = true,
    ["MetalFloorLvl1"] = true,
    ["MetalPoleFenceGate"] = true,
    ["MetalPoleFenceGateSmall"] = true,
    ["MetalSmallPoleFence"] = true,
    ["MetalSmallWireFence"] = true,
    ["MetalWallFrame"] = true,
    ["MetalWallLvl1"] = true,
    ["MetalWallLvl2"] = true,
    ["MetalWindowFrameLvl1"] = true,
    ["MetalWindowFrameLvl2"] = true,
    ["MetalWireFenceGate"] = true,
    ["MetalWireFenceGateSmall"] = true,
    ["Metal_CounterCorner_Lvl1"] = true,
    ["Metal_CounterCorner_Lvl2"] = true,
    ["Metal_Counter_Lvl1"] = true,
    ["Metal_Counter_Lvl2"] = true,
    ["Metal_Crate_Lvl1"] = true,
    ["Metal_Crate_Lvl2"] = true,
    ["Metal_LockerBig_Lvl1"] = true,
    ["Metal_LockerBig_Lvl2"] = true,
    ["Metal_LockerSmall_Lvl1"] = true,
    ["Metal_LockerSmall_Lvl2"] = true,
    ["Metal_Shelves_Lvl1"] = true,
    ["Metal_Shelves_Lvl2"] = true,
    ["Metal_Stairs"] = true,
    ["Other_Log_Stool"] = true,
    ["Piano"] = true,
    ["Pottery_Bench"] = true,
    ["Pottery_Wheel"] = true,
    ["Primitive_Furnace"] = true,
    ["RainCollector"] = true,
    ["RainCollectorRound"] = true,
    ["RainCollectorRound_Tarp"] = true,
    ["RainCollector_Tarp"] = true,
    ["RippleComb"] = true,
    ["RuggedCross"] = true,
    ["Rugged_Stool"] = true,
    ["Rugged_Table"] = true,
    ["SandFloor"] = true,
    ["SandbagWall"] = true,
    ["ScutchingBoard"] = true,
    ["SimpleLoom"] = true,
    ["Simple_Cooking_Pit"] = true,
    ["Simple_Drying_Rack"] = true,
    ["Simple_Herb_Drying_Rack"] = true,
    ["SkullPoleAntlers"] = true,
    ["SkullPoleBull"] = true,
    ["SkullPoleCow"] = true,
    ["SkullPoleDeer"] = true,
    ["SkullPoleDeerDoe"] = true,
    ["SkullPolePig"] = true,
    ["SkullPoleSheep"] = true,
    ["Smelting_Furnace"] = true,
    ["SofteningBeam"] = true,
    ["Spinning_Wheel"] = true,
    ["StickFence"] = true,
    ["Stick_Bookcase"] = true,
    ["Stick_BookcaseSmall_Lvl1"] = true,
    ["StoneCairn"] = true,
    ["StoneDoorFrame"] = true,
    ["StoneWall"] = true,
    ["StoneWindowFrame"] = true,
    ["Stone_Cabinet"] = true,
    ["Stone_Mill"] = true,
    ["Stone_Quern"] = true,
    ["TanninBarrel"] = true,
    ["Tarp_Shelter"] = true,
    ["WoodCross"] = true,
    ["WoodDoorFrameLvl1"] = true,
    ["WoodDoorFrameLvl2"] = true,
    ["WoodDoorFrameLvl3"] = true,
    ["WoodFenceGate"] = true,
    ["WoodFenceLvl1"] = true,
    ["WoodFenceLvl2"] = true,
    ["WoodFenceLvl3"] = true,
    ["WoodFloorLvl1"] = true,
    ["WoodFloorLvl2"] = true,
    ["WoodFloorLvl3"] = true,
    ["WoodLampPillar"] = true,
    ["WoodPicket"] = true,
    ["WoodSign"] = true,
    ["WoodStake"] = true,
    ["Wood_BarElementCorner_Lvl1"] = true,
    ["Wood_BarElementCorner_Lvl2"] = true,
    ["Wood_BarElementCorner_Lvl3"] = true,
    ["Wood_BarElement_Lvl1"] = true,
    ["Wood_BarElement_Lvl2"] = true,
    ["Wood_BarElement_Lvl3"] = true,
    ["Wood_Bed"] = true,
    ["Wood_BookcaseSmall_Lvl1"] = true,
    ["Wood_BookcaseSmall_Lvl2"] = true,
    ["Wood_Bookcase_Lvl1"] = true,
    ["Wood_Bookcase_Lvl2"] = true,
    ["Wood_Chair_Lvl1"] = true,
    ["Wood_Chair_Lvl2"] = true,
    ["Wood_Chair_Lvl3"] = true,
    ["Wood_Crate_Lvl1"] = true,
    ["Wood_Crate_Lvl2"] = true,
    ["Wood_ShelvesDouble_Lvl1"] = true,
    ["Wood_Shelves_Lvl1"] = true,
    ["Wood_Shelves_Lvl2"] = true,
    ["Wood_Stairs"] = true,
    ["Wood_TableDrawerLvl1"] = true,
    ["Wood_TableDrawerLvl2"] = true,
    ["Wood_TableDrawerLvl3"] = true,
    ["Wood_TableLvl1"] = true,
    ["Wood_TableLvl2"] = true,
    ["Wood_TableLvl3"] = true,
    ["Wood_TableSmall_Lvl1"] = true,
    ["Wood_TableSmall_Lvl2"] = true,
    ["Wood_TableSmall_Lvl3"] = true,
    ["WoodenDoorLvl1"] = true,
    ["WoodenDoorLvl2"] = true,
    ["WoodenDoorLvl3"] = true,
    ["WoodenPole"] = true,
    ["WoodenWallFrame"] = true,
    ["WoodenWallLvl1"] = true,
    ["WoodenWallLvl2"] = true,
    ["WoodenWallLvl3"] = true,
    ["WoodenWindowFrameLvl1"] = true,
    ["WoodenWindowFrameLvl2"] = true,
    ["WoodenWindowFrameLvl3"] = true,
    ["Wooden_Windows"] = true,
}

M.XP_NC_NEAT_BUILD_SET = {
    ["Commercial_BlackDoorFrame"] = true,
    ["Commercial_FullGlassBlackWall"] = true,
    ["Commercial_FullGlassRedWall"] = true,
    ["Commercial_GlassBlackDoorFrame"] = true,
    ["Commercial_GlassRedDoorFrame"] = true,
    ["Commercial_GridGlassBlackWall"] = true,
    ["Commercial_GridGlassRedWall"] = true,
    ["Commercial_HalfGlassBlackWall"] = true,
    ["Commercial_HalfGlassRedWall"] = true,
    ["Commercial_RedDoorFrame"] = true,
    ["Doors_WoodenBarnDark"] = true,
    ["Doors_WoodenBarnLight"] = true,
    ["Fences_BlackConcreteRailing"] = true,
    ["Fences_ConstructionBrick"] = true,
    ["Fences_ConstructionDirt"] = true,
    ["Fences_ConstructionGravel"] = true,
    ["Fences_ConstructionSand"] = true,
    ["Fences_FancyPlasterRailing"] = true,
    ["Fences_GlassConcreteRailing"] = true,
    ["Fences_Log"] = true,
    ["Fences_LogCorner"] = true,
    ["Fences_MetalFarmGate"] = true,
    ["Fences_RawConcreteRailing"] = true,
    ["Fences_WhiteConcreteRailing"] = true,
    ["Floor_Concrete"] = true,
    ["Floor_ConcreteCorner"] = true,
    ["Floor_DirtCorner"] = true,
    ["Floor_DirtEdge"] = true,
    ["Floor_FallGrass"] = true,
    ["Floor_FallGrassCorner"] = true,
    ["Floor_FallGrassEdge"] = true,
    ["Floor_GravelCorner"] = true,
    ["Floor_GravelEdge"] = true,
    ["Floor_Hay"] = true,
    ["Floor_HayEdge"] = true,
    ["Floor_RailroadDark"] = true,
    ["Floor_RailroadLight"] = true,
    ["Floor_SandCorner"] = true,
    ["Floor_SandEdge"] = true,
    ["Floor_SpringGrass"] = true,
    ["Floor_SpringGrassCorner"] = true,
    ["Floor_SpringGrassEdge"] = true,
    ["Floor_SummerGrass"] = true,
    ["Floor_SummerGrassCorner"] = true,
    ["Floor_SummerGrassEdge"] = true,
    ["Furniture_SmallWoodenCase"] = true,
    ["Industry_RailroadBrownDoorFrame"] = true,
    ["Industry_RailroadBrownWall"] = true,
    ["Industry_RailroadBrownWindowFrame"] = true,
    ["Industry_RailroadRedDoorFrame"] = true,
    ["Industry_RailroadRedWall"] = true,
    ["Industry_RailroadRedWindowFrame"] = true,
    ["Industry_TruckDoorFrame"] = true,
    ["Industry_TruckWall"] = true,
    ["Industry_TruckWindowFrame"] = true,
    ["Metal_Welding_MilitaryLockerBig"] = true,
    ["Pottery_BrownTileDoorFrame"] = true,
    ["Pottery_BrownTileWall"] = true,
    ["Pottery_BrownTileWindowFrame"] = true,
    ["Pottery_DarkTileDoorFrame"] = true,
    ["Pottery_DarkTileWall"] = true,
    ["Pottery_DarkTileWindowFrame"] = true,
    ["Pottery_GreyTileDoorFrame"] = true,
    ["Pottery_GreyTileWall"] = true,
    ["Pottery_GreyTileWindowFrame"] = true,
    ["Pottery_WhiteTileDoorFrame"] = true,
    ["Pottery_WhiteTileWall"] = true,
    ["Pottery_WhiteTileWindowFrame"] = true,
    ["Pottery_YellowTileDoorFrame"] = true,
    ["Pottery_YellowTileWall"] = true,
    ["Pottery_YellowTileWindowFrame"] = true,
    ["Welding_BlackRailingFence"] = true,
    ["Welding_ConciseStairs"] = true,
    ["Welding_GardenBlackFence"] = true,
    ["Welding_GreenFrameSingleBed"] = true,
    ["Welding_IndustryMeshFloor"] = true,
    ["Welding_IndustryPerforatedFloor"] = true,
    ["Welding_IndustryStairs"] = true,
    ["Welding_IronBandBarzier"] = true,
    ["Welding_MixRailingFence"] = true,
    ["Welding_OfficeBlackDoor"] = true,
    ["Welding_OfficeYellowDoor"] = true,
    ["Welding_RailroadRailingFence"] = true,
    ["Welding_SchoolBlueLocker"] = true,
    ["Welding_SchoolYellowLocker"] = true,
    ["Welding_SewerFloor"] = true,
    ["Welding_ShopClothingDoubleRack"] = true,
    ["Welding_ShopClothingSingleRack"] = true,
    ["Welding_ShopClothingStandRack"] = true,
    ["Welding_SmallMilitaryCase"] = true,
    ["Welding_WhiteDoor"] = true,
    ["Welding_WhiteRailingFence"] = true,
    ["Welding_YellowDoor"] = true,
    ["Wood_BlueInteriorDoor"] = true,
    ["Wood_BluePanelDoorFrame"] = true,
    ["Wood_BluePanelWall"] = true,
    ["Wood_BluePanelWindowFrame"] = true,
    ["Wood_BlueSheetSingleBed"] = true,
    ["Wood_BrownExteriorDoor"] = true,
    ["Wood_BrownInteriorDoor"] = true,
    ["Wood_BrownPanelDoorFrame"] = true,
    ["Wood_BrownPanelWall"] = true,
    ["Wood_BrownPanelWindowFrame"] = true,
    ["Wood_ConciseStairs"] = true,
    ["Wood_DarkGarageDoorFrame"] = true,
    ["Wood_DarkGarageWall"] = true,
    ["Wood_DarkGarageWindowFrame"] = true,
    ["Wood_DogHouse"] = true,
    ["Wood_DoubleDoorDark"] = true,
    ["Wood_FancyBookCase"] = true,
    ["Wood_FancyBrownRailingFence"] = true,
    ["Wood_FancyCornerBookCase"] = true,
    ["Wood_FancyWhiteRailingFence"] = true,
    ["Wood_GardenWhiteFence"] = true,
    ["Wood_GreenPanelDoorFrame"] = true,
    ["Wood_GreenPanelWall"] = true,
    ["Wood_GreenPanelWindowFrame"] = true,
    ["Wood_LightGarageDoorFrame"] = true,
    ["Wood_LightGarageWall"] = true,
    ["Wood_LightGarageWindowFrame"] = true,
    ["Wood_LightLogDoor"] = true,
    ["Wood_LineGarageDoorFrame"] = true,
    ["Wood_LineGarageWall"] = true,
    ["Wood_LineGarageWindowFrame"] = true,
    ["Wood_ModernDarkStairs"] = true,
    ["Wood_ModernHostipalStair"] = true,
    ["Wood_ModernHotelStaris"] = true,
    ["Wood_ModernLightStaris"] = true,
    ["Wood_ModernOrangeStairs"] = true,
    ["Wood_ModernRedStairs"] = true,
    ["Wood_ModernSingleBed"] = true,
    ["Wood_RawRailingFence"] = true,
    ["Wood_RedInteriorDoor"] = true,
    ["Wood_RedPanelDoorFrame"] = true,
    ["Wood_RedPanelWall"] = true,
    ["Wood_RedPanelWindowFrame"] = true,
    ["Wood_SimpleFarmFence"] = true,
    ["Wood_SimpleSingleBed"] = true,
    ["Wood_StandCoffin"] = true,
    ["Wood_WhiteBookcase"] = true,
    ["Wood_WhiteExteriorDoor"] = true,
    ["Wood_WhiteInteriorDoor"] = true,
    ["Wood_WhitePanelDoorFrame"] = true,
    ["Wood_WhitePanelWall"] = true,
    ["Wood_WhitePanelWindowFrame"] = true,
    ["Wood_WhiteRailingFence"] = true,
    ["Wood_YellowPanelDoorFrame"] = true,
    ["Wood_YellowPanelWall"] = true,
    ["Wood_YellowPanelWindowFrame"] = true,
    ["WoodenDarkWallLvl1"] = true,
    ["WoodenDarkWallLvl2"] = true,
    ["WoodenDarkWallLvl3"] = true,
    ["WoodenDarkWindowFrameLvl1"] = true,
    ["WoodenDarkWindowFrameLvl2"] = true,
    ["WoodenDarkWindowFrameLvl3"] = true,
}

M.XP_NC_SHELTERHOLD_SET = {
	["Hold_Hive"] = true,
	["Hold_HoneyExtractor"] = true,
}

-- Explicit per-recipe label overrides (forces the exact Mod name shown)
-- Keys are internal recipe names (same string you use in your sets).
M.XP_NB_MOD_NAME_BY_RECIPE = {
    -- ["Hold_Hive"]           = "ShelterHold:Beehive",   -- explicit label override
    -- ["Hold_HoneyExtractor"] = "ShelterHold:Beehive",
}
-- Make it available globally and as a module return.
XP_NC_SETS = M
return M
