local tennisNetSprites = {
    ["recreational_sports_01_49"] = true,
    ["recreational_sports_01_51"] = true,
    ["recreational_sports_01_52"] = true,
    ["recreational_sports_01_53"] = true,
    ["recreational_sports_01_54"] = true
}

local tennisFloorSprites = {
    ["recreational_sports_01_22"] = true,
    ["recreational_sports_01_23"] = true
}

local function onLoadGridSquare(square)
    local hasTennisNet = false
    local netSquareKey = nil
    local netSpriteName = nil
    local objects = square:getObjects()
    for i = 0, objects:size() - 1 do
        local obj = objects:get(i)
        local sprite = obj:getSprite()
        if sprite and tennisNetSprites[sprite:getName()] then
            hasTennisNet = true
            netSpriteName = sprite:getName()
            netSquareKey = square:getX() .. "," .. square:getY() .. "," .. square:getZ()
            break
        end
    end

    if hasTennisNet and netSquareKey then
        local modData = ModData.getOrCreate("TennisSpawns")
        if not modData[netSquareKey] then
            local hasFloor = false
            for dx = -1, 1 do
                for dy = -1, 1 do
                    local nsq = getCell():getGridSquare(square:getX() + dx, square:getY() + dy, square:getZ())
                    if nsq then
                        local floor = nsq:getFloor()
                        if floor then
                            local floorSprite = floor:getSprite()
                            if floorSprite and tennisFloorSprites[floorSprite:getName()] then
                                hasFloor = true
                                break
                            end
                        end
                    end
                end
                if hasFloor then break end
            end

            if hasFloor and (netSpriteName == "recreational_sports_01_52" or netSpriteName == "recreational_sports_01_49") then
                -- Spawn tennis balls
                local ballCount = ZombRand(1, 7)  -- 1 to 6
                for i = 1, ballCount do
                    local dx = ZombRand(-5, 6)
                    local dy = ZombRand(-5, 6)
                    local nsq = getCell():getGridSquare(square:getX() + dx, square:getY() + dy, square:getZ())
                    if nsq then
                        local xoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                        local yoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                        local floor = nsq:getFloor()
                        if floor and floor:getSprite() and tennisFloorSprites[floor:getSprite():getName()] then
                            nsq:AddWorldInventoryItem("Base.TennisBall", xoff, yoff, 0)
                        end
                    end
                end

                -- Spawn tennis rackets
                local racketCount = ZombRand(3)
                for i = 1, racketCount do
                    local attempts = 0
                    local maxAttempts = 6
                    local spawned = false
                    while attempts < maxAttempts and not spawned do
                        local dx = ZombRand(-5, 6)
                        local dy = ZombRand(-5, 6)
                        local nsq = getCell():getGridSquare(square:getX() + dx, square:getY() + dy, square:getZ())
                        if nsq then
                            local floor = nsq:getFloor()
                            if floor and floor:getSprite() and tennisFloorSprites[floor:getSprite():getName()] then
                                local xoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                                local yoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                                local rotation = ZombRand(0, 360)
                                local item = nsq:AddWorldInventoryItem("Base.TennisRacket", xoff, yoff, 0)
                                if item then
                                    item:setWorldZRotation(rotation)
                                    spawned = true
                                end
                            end
                        end
                        attempts = attempts + 1
                    end
                    if not spawned then
                        print("Failed to spawn tennis racket after " .. maxAttempts .. " attempts for net at " .. netSquareKey)
                    end
                end

                modData[netSquareKey] = true
            end
        end
    end
end

local function onGameStart()
    ModData.getOrCreate("TennisSpawns")
end

Events.OnGameStart.Add(onGameStart)
Events.LoadGridsquare.Add(onLoadGridSquare)