local dumbbellSprites = {
    ["recreational_sports_01_34"] = true,
    ["recreational_sports_01_35"] = true
}

local barbellSprites = {
    ["recreational_sports_01_40"] = true,
    ["recreational_sports_01_41"] = true,
    ["recreational_sports_01_42"] = true,
    ["recreational_sports_01_43"] = true,
    ["recreational_sports_01_44"] = true,
    ["recreational_sports_01_45"] = true,
    ["recreational_sports_01_46"] = true,
    ["recreational_sports_01_47"] = true
}

local spriteOrientations = {
    ["recreational_sports_01_40"] = "South",
    ["recreational_sports_01_41"] = "South",
    ["recreational_sports_01_42"] = "East",
    ["recreational_sports_01_43"] = "East",
    ["recreational_sports_01_44"] = "North",
    ["recreational_sports_01_45"] = "North",
    ["recreational_sports_01_46"] = "West",
    ["recreational_sports_01_47"] = "West"
}

local processedSquares
local dumbbellCountPerBench

local function initModData()
    local modData = ModData.getOrCreate("GymSpawner")
    modData.processedSquares = modData.processedSquares or {}
    modData.dumbbellCountPerBench = modData.dumbbellCountPerBench or {}
    processedSquares = modData.processedSquares
    dumbbellCountPerBench = modData.dumbbellCountPerBench
end

local function onLoadGridSquare(square)
    local squareKey = square:getX() .. "," .. square:getY() .. "," .. square:getZ()
    if processedSquares[squareKey] then return end

    local hasDumbMat = false
    local hasBarbMat = false
    local benchSpriteName = nil
    local objects = square:getObjects()
    for i = 0, objects:size() - 1 do
        local obj = objects:get(i)
        local sprite = obj:getSprite()
        if sprite then
            local name = sprite:getName()
            if dumbbellSprites[name] then
                hasDumbMat = true
            end
            if barbellSprites[name] then
                local spriteNum = tonumber(name:sub(-2))
                if spriteNum % 2 == 1 then
                    hasBarbMat = true
                    benchSpriteName = name
                end
            end
        end
    end
    if hasDumbMat then
        local benchNearby = false
        local nearestBenchKey = nil
        for dx = -5, 5 do
            for dy = -5, 5 do
                local nsq = getCell():getGridSquare(square:getX() + dx, square:getY() + dy, square:getZ())
                if nsq then
                    local nObjects = nsq:getObjects()
                    for i = 0, nObjects:size() - 1 do
                        local obj = nObjects:get(i)
                        local sprite = obj:getSprite()
                        if sprite and barbellSprites[sprite:getName()] then
                            local spriteNum = tonumber(sprite:getName():sub(-2))
                            if spriteNum % 2 == 1 then
                                benchNearby = true
                                nearestBenchKey = nsq:getX() .. "," .. nsq:getY() .. "," .. nsq:getZ() .. ":" .. sprite:getName()
                                break
                            end
                        end
                    end
                    if benchNearby then break end
                end
            end
            if benchNearby then break end
        end
        if benchNearby and nearestBenchKey then
            dumbbellCountPerBench[nearestBenchKey] = dumbbellCountPerBench[nearestBenchKey] or 0
            if dumbbellCountPerBench[nearestBenchKey] < 2 and ZombRand(100) < 20 then
                local dumbbellExists = false
                local items = square:getWorldObjects()
                for i = 0, items:size() - 1 do
                    local item = items:get(i):getItem()
                    if item and item:getFullType() == "Base.DumbBell" then
                        dumbbellExists = true
                        break
                    end
                end
                if not dumbbellExists then
                    local xoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                    local yoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                    square:AddWorldInventoryItem("Base.DumbBell", xoff, yoff, 0)
                    dumbbellCountPerBench[nearestBenchKey] = dumbbellCountPerBench[nearestBenchKey] + 1
                end
            end
        end
    end
    if hasBarbMat and benchSpriteName and (spriteOrientations[benchSpriteName] == "North" or spriteOrientations[benchSpriteName] == "East" or spriteOrientations[benchSpriteName] == "South" or spriteOrientations[benchSpriteName] == "West") then
        local items = square:getWorldObjects()
        local barbellExists = false
        for i = 0, items:size() - 1 do
            local item = items:get(i):getItem()
            if item and item:getFullType() == "Base.BarBell" then
                barbellExists = true
                break
            end
        end
        if not barbellExists and ZombRand(100) < 95 then
            local xoff = ZombRand(2) == 0 and ZombRand(0, 20) / 100.0 or -ZombRand(0, 20) / 100.0
            local yoff = ZombRand(2) == 0 and ZombRand(0, 20) / 100.0 or -ZombRand(0, 20) / 100.0
            local rotation = ZombRand(-20, 21)
            if spriteOrientations[benchSpriteName] == "South" then
                if ZombRand(4) == 0 then
                    yoff = ZombRand(210, 231) / 100.0 -- 2.1 to 2.3 tiles south
                else
                    yoff = -ZombRand(20, 41) / 100.0 -- 0.2 to 0.4 tiles north
                end
            elseif spriteOrientations[benchSpriteName] == "North" then
                if ZombRand(5) == 0 then
                    yoff = -ZombRand(40, 61) / 100.0 -- 0.4 to 0.6 tiles north
                else
                    yoff = ZombRand(230, 251) / 100.0 -- 2.3 to 2.5 tiles south
                end
            elseif spriteOrientations[benchSpriteName] == "East" then
                if ZombRand(4) == 0 then
                    xoff = ZombRand(70, 91) / 100.0 -- 0.7 to 0.9 tiles east
                else
                    xoff = -ZombRand(70, 91) / 100.0 -- 0.7 to 0.9 tiles west
                end
                rotation = rotation + 90 -- Rotate 90 degrees for East
            else -- West
                if ZombRand(5) == 0 then
                    xoff = -ZombRand(110, 131) / 100.0 -- 1.1 to 1.3 tiles west
                else
                    xoff = ZombRand(70, 91) / 100.0 -- 0.7 to 0.9 tiles east
                end
                rotation = rotation + 90 -- Rotate 90 degrees for West
            end
            local item = square:AddWorldInventoryItem("Base.BarBell", xoff, yoff, 0)
            if item then
                item:setWorldZRotation(rotation)
            end
        end
    end
    if hasDumbMat or hasBarbMat then
        processedSquares[squareKey] = true
    end
end

Events.OnInitGlobalModData.Add(initModData)
Events.LoadGridsquare.Add(onLoadGridSquare)