local basketballHoopSprites = {
	["recreational_sports_01_24"] = true, -- South facing hoop
    ["recreational_sports_01_25"] = true, -- East facing hoop
	["recreational_sports_01_26"] = true, -- North facing hoop
    ["recreational_sports_01_27"] = true  -- West facing hoop
}

local function onLoadGridSquare(square)
    local hoopX, hoopY, hoopZ = nil, nil, nil
    local hoopSpriteName = nil
    local objects = square:getObjects()
    
    for i = 0, objects:size() - 1 do
        local obj = objects:get(i)
        local sprite = obj:getSprite()
        if sprite then
            local spriteName = sprite:getName()
            if basketballHoopSprites[spriteName] then
                hoopX = square:getX()
                hoopY = square:getY()
                hoopZ = square:getZ()
                hoopSpriteName = spriteName
                break
            end
        end
    end

    if hoopX ~= nil then
        local hoopSquareKey = hoopX .. "," .. hoopY .. "," .. hoopZ
        local modData = ModData.getOrCreate("BasketballSpawns")
        if not modData[hoopSquareKey] then
            if ZombRand(100) < 20 then
                local attempts = 0
                local maxAttempts = 10
                local spawned = false
                while attempts < maxAttempts and not spawned do
                    local dx, dy
					if hoopSpriteName == "recreational_sports_01_24" then -- South facing
						dx = ZombRand(-6, 7) -- Up to 6 tiles west or east
						dy = ZombRand(0, 9) -- Random 0 to 8 tiles south
                    elseif hoopSpriteName == "recreational_sports_01_25" then -- East facing
                        dx = ZombRand(0, 9) -- Random 0 to +8 tiles east
                        dy = ZombRand(-6, 7) -- Up to 6 tiles south or north
					elseif hoopSpriteName == "recreational_sports_01_26" then -- North facing
						dx = ZombRand(-6, 7) -- Up to 6 tiles west or east
						dy = ZombRand(-8, 0) -- Random 0 to 8 tiles north
                    elseif hoopSpriteName == "recreational_sports_01_27" then -- West facing
                        dx = ZombRand(-8, 0) -- Random -8 to 0 tiles west
                        dy = ZombRand(-6, 7) -- Up to 6 tiles south or north
					else
						dx = 0
						dy = 0
                    end
                    local nsq = getCell():getGridSquare(hoopX + dx, hoopY + dy, hoopZ - 1) -- Spawn at z = hoopZ - 1
                    if nsq then
                        local xoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                        local yoff = ZombRand(2) == 0 and ZombRand(0, 50) / 100.0 or -ZombRand(0, 50) / 100.0
                        nsq:AddWorldInventoryItem("Base.Basketball", xoff, yoff, 0)
                        modData[hoopSquareKey] = true
                        spawned = true
                    end
                    attempts = attempts + 1
                end
                if not spawned then
                    print("Failed to spawn basketball after " .. maxAttempts .. " attempts for hoop at " .. hoopSquareKey)
                end
            end
        end
    end
end

local function onGameStart()
    ModData.getOrCreate("BasketballSpawns")
end

Events.OnGameStart.Add(onGameStart)
Events.LoadGridsquare.Add(onLoadGridSquare)