require "ISUI/ISPanel"

NB_BuildingInfoPanel = ISTableLayout:derive("NB_BuildingInfoPanel")

local FONT_HGT_SMALL = getTextManager():getFontHeight(UIFont.Small)
local FONT_HGT_MEDIUM = getTextManager():getFontHeight(UIFont.Medium)

-- ----------------------------------------------------------------------------------------------------- --
-- Update Position
-- ----------------------------------------------------------------------------------------------------- --
function NB_BuildingInfoPanel:updatePosition()
    if not self.BuildingPanel then return end
    
    local ScreenPadding = 2
    local newX = self.BuildingPanel:getAbsoluteX() + self.BuildingPanel:getWidth() + ScreenPadding
    local buildPanelCenterY = self.BuildingPanel:getAbsoluteY() + self.BuildingPanel:getHeight() / 2
    local newY = buildPanelCenterY - self.height / 2

    local buildPanelBottom = self.BuildingPanel:getAbsoluteY() + self.BuildingPanel:getHeight()
    if newY + self.height > buildPanelBottom then
        newY = buildPanelBottom - self.height
    end
    
    self:setX(newX)
    self:setY(newY)
end

-- ----------------------------------------------------------------------------------------------------- --
-- initialise
-- ----------------------------------------------------------------------------------------------------- --
function NB_BuildingInfoPanel:initialise()
    ISTableLayout.initialise(self)
    self:updatePosition()
end

function NB_BuildingInfoPanel:new(x, y, width, height, BuildingPanel)
    local o = ISTableLayout:new(x, y, width, height)
    setmetatable(o, self)
    self.__index = self
    
    o.BuildingPanel = BuildingPanel
    o.logic = BuildingPanel.logic
    o.player = BuildingPanel.player

    o.padding = BuildingPanel.padding
    o.iconSize = math.floor(FONT_HGT_SMALL * 4/16)*16

    o.lvlRecipePanelminH = o.iconSize + FONT_HGT_MEDIUM + o.padding * 4

    o.iunputItemHeight = FONT_HGT_SMALL + o.padding + FONT_HGT_MEDIUM

    o.minimumWidth = (o.iunputItemHeight * 3 ) * 2 + o.padding*3
    
    return o
end

-- ----------------------------------------------------------------------------------------------------- --
-- createChildren
-- ----------------------------------------------------------------------------------------------------- --
function NB_BuildingInfoPanel:createChildren()
    self.mainColumn = self:addColumn(nil)
    self.mainColumn.minimumWidth = self.minimumWidth

    self.lvlRecipeRow = self:addRow(nil)
    self.lvlRecipeRow.minimumHeight = self.lvlRecipePanelminH

    self.detailRow = self:addRow(nil)
    self.detailRow.minimumHeight = 0

    self.inputRow = self:addRow(nil)
    local inputRowMax = 3
    self.inputRow.minimumHeight = (inputRowMax +1) * self.padding + self.iunputItemHeight * inputRowMax

    self:createLvlRecipePanel()
    self:createDetailPanel()
    self:createInputPanel()
end

function NB_BuildingInfoPanel:createLvlRecipePanel()
    self.lvlRecipePanel = NB_LevelRecipePanel:new(0, 0, 10, 10, self)
    self.lvlRecipePanel:initialise()
    self:setElement(self.mainColumn:index(), self.lvlRecipeRow:index(), self.lvlRecipePanel)
end

function NB_BuildingInfoPanel:createDetailPanel()
    self.detailPanel = NB_BuildingInfoDetailPanel:new(0, 0, 10, 10, self)
    self.detailPanel:initialise()
    self:setElement(self.mainColumn:index(), self.detailRow:index(), self.detailPanel)
end

function NB_BuildingInfoPanel:createInputPanel()
    self.inputPanel = NB_BuildingInput_Panel:new(0, 0, 10, 10, self)
    self.inputPanel:initialise()
    self:setElement(self.mainColumn:index(), self.inputRow:index(), self.inputPanel)
end
-- ----------------------------------------------------------------------------------------------------- --
-- Update
-- ----------------------------------------------------------------------------------------------------- --
function NB_BuildingInfoPanel:update()
    ISTableLayout.update(self)
end

function NB_BuildingInfoPanel:onRecipeChanged()
    if self.lvlRecipePanel and self.lvlRecipePanel.onRecipeChanged then
        self.lvlRecipePanel:onRecipeChanged()
    end

    if self.inputPanel and self.inputPanel.onRecipeChanged then
        self.inputPanel:onRecipeChanged()
    end

    self:calculateLayout()
end

function NB_BuildingInfoPanel:close()
    self:setVisible(false)
    self:removeFromUIManager()
end

-- ----------------------------------------------------------------------------------------------------- --
-- Render
-- ----------------------------------------------------------------------------------------------------- --
function NB_BuildingInfoPanel:prerender()
    self:updatePosition()

    if not self.BuildingPanel or not self.BuildingPanel:isReallyVisible() then
        self:setVisible(false)
    end
    local panelBG = NinePatchTexture.getSharedTexture("media/ui/Neat_Building/Panel/MainPanelBG_RoundTop.png")
    if panelBG then
        panelBG:render(self:getAbsoluteX(), self:getAbsoluteY(), self.width, self.height, 0.1, 0.1, 0.1, 0.7)
    end
end


return NB_BuildingInfoPanel