-- media/lua/client/GunshotTrait.lua

-- Register the trait



TraitFactory.addTrait("GunshotSurvivor", "Headshot Survivor", -8, "You awaken with a dreadfully sore head, pure agony burns as your rub your bandaged forehead, then you remember. you got shot in the head, but survived. that bullet is going to need to come out sooner or later....", false)



TraitFactory.addTrait("FreshHeadshot", "A Real Kick In The Head.", -10, "Agony. Pure Agony. Is my blood? something hit me. a gunshot. muzzle flash. then darkness. thats right. I was shot at, my head reels in pure pain. but Death did not claim me...yet. This floor is comfortable. I'm not sure I want it to be my final resting place. I better stop this bleeding... and Quick. we can worry about the bullet later...", false)


 local GunshotSurvivor = "media/textures/GunshotSurvivor.png"
 local FreshHeadshot = "media/textures/FreshHeadshot.png"

 local GunshotSurvivor = "media\textures\GunshotSurvivor.PNG"
 local FreshHeadshot = "media\textures\FreshHeadshot.PNG"


-- Make traits mutually exclusive
local GunshotSurvivor = TraitFactory.getTrait("GunshotSurvivor")
local FreshHeadshot = TraitFactory.getTrait("FreshHeadshot")
TraitFactory.setMutualExclusive("GunshotSurvivor", "FreshHeadshot") -- Can't have both




-- Function to apply the gunshot wound
local function applyGunshotWound(player, square)
    if player:HasTrait("GunshotSurvivor") then
        local bodyDamage = player:getBodyDamage()
        local head = bodyDamage:getBodyPart(BodyPartType.Head)
        
        -- Apply a deep wound with a lodged bullet
        head:setHaveBullet(true, 0) -- Bullet lodged, 0 depth (surface wound for survivability)
        head:AddDamage(20) -- Simulate gunshot damage
        head:setBleeding(true) -- Active bleeding
        head:setBleedingTime(15) -- Moderate bleeding duration
        head:setDeepWounded(true) -- Mark as a deep wound
        head:setDeepWoundTime(100) -- Severe deep wound requiring treatment
        head:setBandaged(true, 50) -- Bandaged, but dirty (0 health, needs replacement)
		
        -- Apply pain and health reduction
        bodyDamage:setOverallBodyHealth(bodyDamage:getOverallBodyHealth() - 30) -- Significant health loss


		player:getInventory():AddItem("Base.Bandage")
		
		 elseif player:HasTrait("FreshHeadshot") then
        -- Unbandaged, more dangerous headshot wound
		
		        local bodyDamage = player:getBodyDamage()
        local head = bodyDamage:getBodyPart(BodyPartType.Head)
		
		
		
		head:setHaveBullet(true, 0) -- Bullet lodged, 0 depth (surface wound for survivability)
        head:AddDamage(20) -- Simulate gunshot damage
        head:setBleeding(true) -- Active bleeding
        head:setBleedingTime(15) -- Moderate bleeding duration
        head:setDeepWounded(true) -- Mark as a deep wound
        head:setDeepWoundTime(100) -- Severe deep wound requiring treatment
        head:setBandaged(false, 0) -- Bandaged, but dirty (0 health, needs replacement)
		
        -- Apply pain and health reduction
        bodyDamage:setOverallBodyHealth(bodyDamage:getOverallBodyHealth() - 30) -- Significant health loss
        
		
		
		
    end
end

-- Hook into the OnNewGame event
Events.OnNewGame.Add(applyGunshotWound)