local function getAlarmItem()
    local player = getPlayer()
    if not player then
        return
    end

    local leftItem = player:getWornItem("LeftWrist")
    local rightItem = player:getWornItem("RightWrist")

    local function isDigitalWatch(item)
        return item
            and item.isAlarmSet
            and item.isDigital
            and item:isDigital()
    end

    if isDigitalWatch(leftItem) then
        return leftItem
    elseif isDigitalWatch(rightItem) then
        return rightItem
    end

    return nil
end

local RightClickWatchToSetAlarmPanel = ISPanel:derive("RightClickWatchToSetAlarmPanel")

function RightClickWatchToSetAlarmPanel:new()
    local o = {}
    o = ISPanel:new(0, 0, 0, 0)
    o.background = false
    setmetatable(o, self)
    self.__index = self
    return o
end

function RightClickWatchToSetAlarmPanel:initialise()
    ISPanel.initialise(self)
    self:setSizeAndPosition()
    self:bringToTop()
    self:setVisible(false)
    self:addToUIManager()
    self:updateVisibility()
end

function RightClickWatchToSetAlarmPanel:updateVisibility()
    if getAlarmItem() then
        self:setVisible(true)
    else
        self:setVisible(false)
    end
end

function RightClickWatchToSetAlarmPanel:setSizeAndPosition()
    local clockSize = getCore():getOptionClockSize()
    local screenWidth = getCore():getScreenWidth()
    local padding = 10
    local widthLarge = 156
    local widthSmall = 81
    local heightLarge = 62
    local heightSmall =  32

	if clockSize == 2 then
        self:setWidth(widthLarge)
        self:setHeight(heightLarge)
        self:setX(screenWidth - widthLarge - padding)
	elseif clockSize == 1 then
        self:setWidth(widthSmall)
        self:setHeight(heightSmall)
        self:setX(screenWidth - widthSmall - padding)
	end

    self:setY(padding)
end

function RightClickWatchToSetAlarmPanel:onMouseUp(x, y)
    local alarm = getAlarmItem()
    if not alarm then
        return
    end
    alarm:setAlarmSet(not alarm:isAlarmSet())
end

function RightClickWatchToSetAlarmPanel:onRightMouseUp(x, y)
    local alarm = getAlarmItem()
    if not alarm then
        return
    end

    local width, height, padding = 230, 160, 10
    local modal = ISAlarmClockDialog:new(
        getCore():getScreenWidth() - width - padding,
        padding, width, height, 0, alarm)
    modal:initialise()
    modal:addToUIManager()
end

local panel = nil
Events.OnGameStart.Add(function()
    panel = RightClickWatchToSetAlarmPanel:new()
    panel:initialise()
end)

Events.OnClothingUpdated.Add(function()
    if panel then
       panel:updateVisibility()
    end
end)