require "TimedActions/ISBaseTimedAction"

Fol_Take_A_Bath_TUB_Action = ISBaseTimedAction:derive("Fol_Take_A_Bath_TUB_Action");
local tub_part = ""
local tub
local posit_correct = 0.1
local Consume_water
local Object_water
local Object_water2
local square
local square2
local WaterSprites
local WaterSprites2
local player_X
local player_Y
local old_player_X
local old_player_Y
function Fol_Take_A_Bath_TUB_Action:isValid()
    return true;
end

local i = 0
local number_Sprite = 0

local function setPlayerXY(player, _x, _y)
    player:setX(_x)
    player:setY(_y)
    player_X = player:getX()
    player_Y = player:getY()
end
local function setSprite(_speed, loop_start, loop_end, SpriteName1, SpriteName2)
    if i < _speed then
        i = i + 1
    elseif i >= _speed then
        i = 0
        number_Sprite = number_Sprite + 1
        if number_Sprite > loop_end then
            number_Sprite = loop_start
        end
    end
    Object_water:setSprite(SpriteName1 .. tostring(number_Sprite))
    Object_water2:setSprite(SpriteName2 .. tostring(number_Sprite))
end
function Fol_Take_A_Bath_TUB_Action:update()
    local tub_X = tub:getSquare():getX()
    local tub_Y = tub:getSquare():getY()
    if self.character:getBodyDamage():getColdStrength() > 0 then
        self.character:getBodyDamage():setColdStrength(self.character:getBodyDamage():getColdStrength() - 0.06);
    end


    if tub_part == "Part1" then
        if player_Y - posit_correct ~= tub_Y or player_X - posit_correct ~= tub_X then
            setPlayerXY(self.character, tub_X + posit_correct, tub_Y + posit_correct)
        end
        setSprite(4, 31, 44, "fol_tub_A_1_", "fol_tub_A_2_")
    elseif tub_part == "Part2" then
        if player_Y + 1 - posit_correct ~= tub_Y or player_X - posit_correct ~= tub_X then
            setPlayerXY(self.character, tub_X + posit_correct, tub_Y - 1 + posit_correct)
        end
        setSprite(4, 31, 44, "fol_tub_A_1_", "fol_tub_A_2_")
    elseif tub_part == "Part3" then
        if player_Y - posit_correct ~= tub_Y or player_X - posit_correct ~= tub_X then
            setPlayerXY(self.character, tub_X + posit_correct, tub_Y + posit_correct)
        end
        setSprite(4, 31, 44, "fol_tub_B_1_", "fol_tub_B_2_")
    elseif tub_part == "Part4" then
        if player_Y - posit_correct ~= tub_Y or player_X + 1 - posit_correct ~= tub_X then
            setPlayerXY(self.character, tub_X - 1 + posit_correct, tub_Y + posit_correct)
        end
        setSprite(4, 31, 44, "fol_tub_B_1_", "fol_tub_B_2_")
    end

    self.character:getBodyDamage():setBoredomLevel(self.character:getBodyDamage():getBoredomLevel() - 0.02);
    self.character:getBodyDamage():setUnhappynessLevel(self.character:getBodyDamage():getUnhappynessLevel() - 0.02);
end

function Fol_Take_A_Bath_TUB_Action:waitToStart()
    local player_X, player_Y = self.character:getX(), self.character:getY()
    local tub_X, tub_Y = tub:getSquare():getX(), tub:getSquare():getY()

    old_player_X = player_X
    old_player_Y = player_Y
    if player_X - tub_X <= 1 or player_X - tub_X >= -1 then
        if player_Y - tub_Y <= 1 or player_Y - tub_Y >= -1 then
            if tub_part == "Part1" then
                self.character:faceLocationF(self.character:getX(), self.character:getY() + 0.5)
            elseif tub_part == "Part2" then
                self.character:faceLocationF(self.character:getX(), self.character:getY() + 0.5)
            elseif tub_part == "Part3" then
                self.character:faceLocationF(self.character:getX() + 0.5, self.character:getY())
            elseif tub_part == "Part4" then
                self.character:faceLocationF(self.character:getX() + 0.5, self.character:getY())
            end
        end
    end
    return self.character:shouldBeTurning()
end

function Fol_Take_A_Bath_TUB_Action:start()
    self.character:setPrimaryHandItem(nil)
    self:setOverrideHandModels(nil, nil)
    local tub_X = tub:getSquare():getX()
    local tub_Y = tub:getSquare():getY()
    local tub_Z = tub:getSquare():getZ()
    local player_Z = self.character:getZ()
    if tub_part == "Part1" then
        setPlayerXY(self.character, tub_X + posit_correct, tub_Y + posit_correct)
        square = getCell():getGridSquare(player_X, player_Y, player_Z)
        WaterSprites = "fol_tub_A_1_0"
        square2 = getCell():getGridSquare(player_X, player_Y + 1, player_Z)
        self:setActionAnim("fol_bath_1")
    elseif tub_part == "Part2" then
        setPlayerXY(self.character, tub_X + posit_correct, tub_Y - 1 + posit_correct)
        square = getCell():getGridSquare(player_X, player_Y, player_Z)
        WaterSprites = "fol_tub_A_1_0"
        square2 = getCell():getGridSquare(player_X, player_Y + 1, player_Z)
        WaterSprites2 = "fol_tub_A_2_0"
        self:setActionAnim("fol_bath_1")


        if square ~= nil and WaterSprites ~= nil then
            Object_water = IsoObject.new(square, WaterSprites)
            Object_water:setCustomColor(1, 1, 1, 1)
            square:AddTileObject(Object_water)
        end
        if square2 ~= nil and WaterSprites2 ~= nil then
            Object_water2 = IsoObject.new(square2, WaterSprites2)
            Object_water2:setCustomColor(1, 1, 1, 1)
            square2:AddTileObject(Object_water2)
        end
    elseif tub_part == "Part3" then
        setPlayerXY(self.character, tub_X + posit_correct, tub_Y + posit_correct)
        square = getCell():getGridSquare(player_X, player_Y, player_Z)
        WaterSprites = "fol_tub_B_1_0"
        square2 = getCell():getGridSquare(player_X + 1, player_Y, player_Z)
        WaterSprites2 = "fol_tub_B_2_0"
        self:setActionAnim("fol_bath_1")

        if square ~= nil and WaterSprites ~= nil then
            Object_water = IsoObject.new(square, WaterSprites)
            Object_water:setCustomColor(1, 1, 1, 1)
            square:AddTileObject(Object_water)
        end
        if square2 ~= nil and WaterSprites2 ~= nil then
            Object_water2 = IsoObject.new(square2, WaterSprites2)
            Object_water2:setCustomColor(1, 1, 1, 1)
            square2:AddTileObject(Object_water2)
        end
    elseif tub_part == "Part4" then
        setPlayerXY(self.character, tub_X - 1 + posit_correct, tub_Y + posit_correct)
        square = getCell():getGridSquare(player_X, player_Y, player_Z)
        WaterSprites = "fol_tub_B_1_0"
        square2 = getCell():getGridSquare(player_X + 1, player_Y, player_Z)
        WaterSprites2 = "fol_tub_B_2_0"
        self:setActionAnim("fol_bath_1")

        if square ~= nil and WaterSprites ~= nil then
            Object_water = IsoObject.new(square, WaterSprites)
            Object_water:setCustomColor(1, 1, 1, 1)
            square:AddTileObject(Object_water)
        end
        if square2 ~= nil and WaterSprites2 ~= nil then
            Object_water2 = IsoObject.new(square2, WaterSprites2)
            Object_water2:setCustomColor(1, 1, 1, 1)
            square2:AddTileObject(Object_water2)
        end
    end

    Object_water = IsoObject.new(square, WaterSprites)
    Object_water:setCustomColor(1, 1, 1, 1)
    square:AddTileObject(Object_water)
    Object_water2 = IsoObject.new(square2, WaterSprites2)
    Object_water2:setCustomColor(1, 1, 1, 1)
    square2:AddTileObject(Object_water2)
    self.character:getBodyDamage():setWetness(100);
end

function Fol_Take_A_Bath_TUB_Action:stop()
    number_Sprite = 0
    Object_water:setCustomColor(1, 1, 1, 0)
    square:RemoveTileObject(Object_water);
    square = nil
    Object_water2:setCustomColor(1, 1, 1, 0)
    square2:RemoveTileObject(Object_water2);
    square2 = nil
    --end
    setPlayerXY(self.character, old_player_X, old_player_Y)
    ISBaseTimedAction.stop(self);
end

function Fol_Take_A_Bath_TUB_Action:perform()
    if self.character:getBodyDamage():getColdStrength() < 1 then
        self.character:getBodyDamage():setHasACold(false);
    end

    local visual = self.character:getHumanVisual()
    for i = 1, BloodBodyPartType.MAX:index() do
        local part = BloodBodyPartType.FromIndex(i - 1)
        local Blood_Value
        visual:getBlood(part)
        local Dirt_Value = visual:getDirt(part)

        visual:setBlood(part, 0)
        visual:setDirt(part, 0)
        setPlayerXY(self.character, old_player_X, old_player_Y)
        if i >= BloodBodyPartType.MAX:index() then
            break
        end
    end

    local pick_consume_water = { 0, 20, 40, 60, 80, 100 }

    if SandboxVars.TakeABath.consume_water ~= nil then
        Consume_water = pick_consume_water[tonumber(SandboxVars.TakeABath.consume_water)]
    else
        Consume_water = 0
    end

    if tub:hasWater() then
    local waterAvailable = tub:getFluidAmount()
    tub:useFluid(Consume_water)
    end

    self.character:getBodyDamage():decreaseBodyWetness(self.character:getBodyDamage():getWetness() / ZombRand(0, 20));
    self.character:getBodyDamage():setBoredomLevel(self.character:getBodyDamage():getBoredomLevel() - 0.1);
    self.character:getBodyDamage():setUnhappynessLevel(self.character:getBodyDamage():getUnhappynessLevel() - 0.1);
    self.character:getStats():setEndurance(self.character:getStats():getEndurance() +
    self.character:getStats():getEndurance() / ZombRand(0, 5)) --恢復耐力
    self.character:resetModelNextFrame();
    number_Sprite = 0
    if square ~= nil and WaterSprites ~= nil then
        Object_water:setCustomColor(1, 1, 1, 0)
        square:RemoveTileObject(Object_water);
        square = nil
        Object_water2:setCustomColor(1, 1, 1, 0)
        square2:RemoveTileObject(Object_water2);
        square2 = nil
    end

    ISBaseTimedAction.perform(self);
end

function Fol_Take_A_Bath_TUB_Action:new(character, _Object, _Part, consume_water)
    Consume_water = consume_water
    tub_part = _Part
    tub = _Object
    local o = {};
    setmetatable(o, self);
    self.__index = self;
    o.character = character;
    o.maxTime = 500;
    if o.character:isTimedActionInstant() then o.maxTime = 1; end
    return o;
end
