require "TimedActions/ISBaseTimedAction"
local CLs
local isEquipped_Cloth
Fol_ISDryMyself = ISBaseTimedAction:derive("Fol_ISDryMyself");
function Fol_ISDryMyself:isValid()
	return self.character:getInventory():contains(self.item) and self.character:getBodyDamage():getWetness() > 0 and
		self.item:getCurrentUsesFloat() > 0;
end

function Fol_ISDryMyself:update()
end

function Fol_ISDryMyself:start()
	self:setActionAnim("Fol_DrySelf")
	self:setOverrideHandModels("Fol_DishCloth", nil);
end

function Fol_ISDryMyself:stop()
	ISBaseTimedAction.stop(self);
end

function Fol_ISDryMyself:perform()
	self.character:getBodyDamage():decreaseBodyWetness(self.item:getCurrentUsesFloat() * 100);
	self.character:getInventory():Remove(self.item)
	local itemType = self.item:getType()
	if itemType == "BathTowel" then
		self.character:getInventory():AddItem("Base.BathTowelWet")
	elseif itemType == "DishCloth" then
		self.character:getInventory():AddItem("Base.DishClothWet")
	else
		-- Fallback por si acaso
		self.character:getInventory():AddItem("Base.DishClothWet")
	end
	if #CLs > 0 then
		for i = 1, #CLs do
			isEquipped_Cloth = CLs[i]
			ISTimedActionQueue.add(ISWearClothing:new(self.character, isEquipped_Cloth, 50))
			if i >= #CLs then
				CLs = {}
				break
			end
		end
	end
	ISBaseTimedAction.perform(self);
end

function Fol_ISDryMyself:new(character, item, time, Cloths_Put_On)
	CLs = Cloths_Put_On
	local o = {}
	setmetatable(o, self)
	self.__index = self
	o.character = character;
	o.item = item;
	o.stopOnWalk = true;
	o.stopOnRun = true;
	o.maxTime = 180;
	if o.character:isTimedActionInstant() then o.maxTime = 1; end
	return o;
end
