Events.OnPlayerUpdate.Add(function(player)
    if not player or not instanceof(player, "IsoPlayer") then return end
    if player:isDead() then return end

    local data = player:getModData()
    if not data then return end

    local body = player:getBodyDamage()
    local stats = player:getStats()

    if data.IsGod and body and stats then
        body:RestoreToFullHealth()
        stats:setFatigue(0.0)
        stats:setHunger(0.0)
        stats:setThirst(0.0)
        stats:setEndurance(1.0)
        print("[CheatHealth] God Mode active: Player fully healed.")
    end

    if data.IsImmortal and body then
        local health = body:getHealth()
        if health > 0 and health < 0.9 then
            body:setHealth(1.0)
            print("[CheatHealth] Prevent Death override: Restored to full before danger.")
        end
    end
end)