require("MainCreationMethods");
require('NPCs/MainCreationMethods');

local SpawnItems = {};

Items = {
    ["base:fireofficer"] = {"Base.Axe", "Base.Hat_Fireman", "Base.Jacket_Fireman"},
    ["base:policeofficer"] = {"Base.Shotgun", "Base.ShotgunShellsBox", "Base.Nightstick"},
    ["base:parkranger"] = {"Base.HuntingRifle", "Base.308Box", "Base.HandAxe"},
    ["base:constructionworker"] = {"Base.Hammer", "Base.MasonsTrowel", "Base.Hat_HardHat"},
    ["base:securityguard"] = {"Base.Revolver", "Base.Bullets45Box", "Base.Nightstick", "Base.HandTorch"},
    ["base:carpenter"] = {"Base.Hammer", "Base.Screwdriver", "Base.GardenSaw"},
    ["base:burglar"] = {"Base.Crowbar", "Base.Bag_WeaponBag"},
    ["base:chef"] = {"Base.MeatCleaver", "Base.LargeKnife", "Base.KnifeSushi", "Base.TinOpener", "Base.Pot"},
    ["base:repairman"] = {"Base.Hammer", "Base.Screwdriver", "Base.ScrewsBox"},
    ["base:rancher"] = {"Base.DoubleBarrelShotgun", "Base.ShotgunShellsBox", "Base.SheepElectricShears", "Base.GardenFork", "Base.Hat_Cowboy"},
    ["base:farmer"] = {"Base.GardenHoe", "Base.WateredCan", "Base.CabbageBagSeed2", "Base.CarrotBagSeed2", "Base.RedRadishBagSeed2"},
    ["base:fisherman"] = {"Base.FishingRod", "Base.FishingNet", "Base.Hat_BucketHatFishing", "Base.Worm", "Base.Worm", "Base.Worm", "Base.Worm", "Base.Worm"},
    ["base:doctor"] = {"Base.FirstAidKit", "Base.SutureNeedle", "Base.SutureNeedle", "Base.SutureNeedleHolder", "Base.Tweezers", "Base.Scalpel", "Base.AlcoholWipes", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholBandage"},
    ["base:veteran"] = {"Base.AssaultRifle2", "Base.M14Clip", "Base.M14Clip", "Base.308Box"},
    ["base:nurse"] = {"Base.FirstAidKit", "Base.Pills", "Base.PillsBeta", "Base.Antibiotics", "Base.Antibiotics", "Base.AlcoholWipes", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholBandage"},
    ["base:lumberjack"] = {"Base.WoodAxe", "Base.HandAxe", "Base.Whetstone"},
    ["base:fitnessInstructor"] = {"Base.DumbBell", "Base.BarBell", "Base.Sportsbottle"},
    ["base:burgerflipper"] = {"Base.KitchenKnife", "Base.TinOpener", "Base.Spatula", "Base.Spiffo", "Base.PaperBag", "Base.PopBottle", "Base.Burger", "Base.Fries", "Base.FriedOnionRings"},
    ["base:electrician"] = {"Base.Screwdriver", "Base.Pliers", "Base.Lantern_CraftedElectric",},
    ["base:engineer"] = {"Base.PipeBomb", "Base.PipeBomb", "Base.FlameTrap", "Base.SmokeBomb"},
    ["base:metalworker"] = {"Base.BlowTorch", "Base.WeldingMask", "Base.SheetMetal"},
    ["base:smither"] = {"Base.SmithingHammer", "Base.MetalworkingPliers", "Base.MetalworkingChisel", "Base.MetalworkingPunch"},
    ["base:mechanics"] = {"Base.Wrench", "Base.LugWrench", "Base.Jack"},
    ["base:tailor"] = {"Base.SewingKit", "Base.Needle", "Base.Scissors", "Base.KnittingNeedles", "Base.Yarn", "Base.Thread", "Base.Thread", "Base.Thread"},

    -- Mar Vanilla-Like Occupations
    ["mar_federalofficer"] = {"Base.AssaultRifle", "Base.556Clip", "Base.556Clip", "Base.556Box"},
    ["mar_cleaner"] = {"Base.Bleach", "Base.Mop", "Base.Broom", "Base.DishCloth", "Base.Bucket", "Base.CleaningLiquid2"},
    ["mar_athlete"] = {"Base.DumbBell", "Base.BarBell", "Base.Sportsbottle"},
    ["mar_miner"] = {"Base.PickAxe", "Base.Shovel", "Base.Hat_HardHat_Miner"},
    ["mar_demolitionworker"] = {"Base.Sledgehammer", "Base.Hat_HardHat", "Base.Glasses_SafetyGoggles"},
    ["mar_privateinvestigator"] = {"Base.PenMultiColor", "Base.Pencil", "Base.Notebook", "Base.CameraExpensive", "Base.Bag_Satchel"},
    ["mar_mason"] = {"Base.MasonsChisel", "Base.ClubHammer", "Base.MasonsTrowel"},
    ["mar_waiter"] = {"Base.SteakKnife", "Base.KitchenKnife", "Base.PotOfSoup", "farming.Salad", "Base.Pancakes"},
    ["mar_butcher"] = {"Base.MeatCleaver", "Base.LargeKnife", "Base.KnifeFillet"},
    ["mar_deliverydriver"] = {},
    ["mar_mortician"] = {"Base.Shovel", "Base.Tweezers", "Base.Needle", "Base.Scalpel", "Base.SutureNeedleHolder"},

    -- Simple Overhaul: Traits and Occupations
    ["deliverymanocc"] = {},  
    ["loaderocc"] = {"Base.Crowbar", "Base.Gloves_LeatherGloves", "Base.ElbowPad_Right", "Base.ElbowPad_Left"},  
    ["truckerocc"] = {"Base.Wrench", "Base.HandTorch"},   
    ["soldierocc"] = {"Base.AssaultRifle", "Base.556Clip", "Base.556Clip", "Base.556Box"},
    ["botanistocc"] = {"Base.HandShovel", "Base.HandFork", "Base.BookForaging2", "Base.Acorn", "Base.Violets", "Base.MushroomGeneric6"},
    ["gravemanocc"] = {"Base.Shovel", "Base.EntrenchingTool"},
    ["dancerocc"] = {"Base.RadioRed", "Base.Bag_FannyPackFront"},
    ["priestocc"] = {"Base.Book_Bible", "Base.Candle", "Base.Candle", "Base.Candle", "Base.Matches"},
    ["heavyathinstructorocc"] = {"Base.DumbBell", "Base.BarBell", "Base.Sportsbottle"},
    ["detectiveocc"] = {"Base.Revolver_Short", "Base.Bullets38Box", "Base.MagnifyingGlass", "Base.Pen", "Base.Notebook"},
    ["teacherocc"] = {"Base.Apple", "Base.BookCarpentry1", "Base.BookMaintenance1", "Base.BookTailoring1"},  
    ["cleanermanocc"] = {"Base.Bleach", "Base.Mop", "Base.Broom", "Base.DishCloth", "Base.Bucket", "Base.CleaningLiquid2"},  
    ["stuntmanocc"] = {"Base.Hat_CrashHelmet" ,"Base.ElbowPad_Right", "Base.ElbowPad_Left", "Base.Kneepad_Right", "Base.Kneepad_Left"},
    ["gasstationoperatorocc"] = {"Base.PetrolCan", "Base.RubberHose"},
    ["campcounsocc"] = {"Base.KnifePocket", "Base.Lighter", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.Needle", "Base.Thread", "Base.FishingHook"},
    ["dragracerocc"] = {"Base.Hat_CrashHelmet"},  
    ["junkyardworkerocc"] = {"Base.BlowTorch", "Base.Wrench", "Base.TireIron"},
    ["lifeguardocc"] = {"Base.Whistle", "Base.Bullhorn", "Base.Sportsbottle", "Base.Bag_Satchel_Medical", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholWipes"}, 
    ["demoworkerocc"] = {"Base.Sledgehammer", "Base.Hat_HardHat", "Base.Glasses_SafetyGoggles"},
    ["butcherocc"] = {"Base.MeatCleaver", "Base.LargeKnife", "Base.KnifeFillet"},
    ["paparazziocc"] = {"Base.CameraExpensive", "Base.CameraFilm", "Base.Bag_Satchel"},
    ["minerocc"] = {"Base.PickAxe", "Base.Shovel", "Base.Hat_HardHat_Miner"},
    ["cashierocc"] = {"Base.GroceryBag1"},
    ["criminalocc"] = {"Base.Pistol", "Base.Bullets9mmBox", "Base.KnifeButterfly", "Base.Hat_Bandana"},
    ["animalcontrolofficerocc"] = {"Base.TrapCage", "Base.TrapBox", "Base.TrapStick"},
    ["hunterocc"] = {"Base.HuntingRifle", "Base.308Box", "Base.HuntingKnife", "Base.TrapSnare"},
    ["veterinarianocc"] = {"Base.Leash", "Base.CatTreats", "Base.Dogfood", "Base.FirstAidKit", "Base.SutureNeedle", "Base.AlcoholWipes", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholBandage", "Base.AlcoholBandage"}, 
}

function SpawnItems.OnNewGame(playerObj, square)
    if isClient() then
		return
	end

    local profession = playerObj:getDescriptor():getCharacterProfession()

    if Items[tostring(profession)] ~= nil
    then
        local container = nil;
        for i, item in ipairs(Items[tostring(profession)]) do

            local newItem = nil;

            if container ~= nil then
                newItem = container:getItemContainer():AddItem(item);
            else
                newItem = playerObj:getInventory():AddItem(item);
                if newItem:IsInventoryContainer() then
                    container = newItem;
                end
            end

            if newItem:getMaxAmmo() > 0 
            then
                newItem:setCurrentAmmoCount(newItem:getMaxAmmo())
                if item ~= "Base.M14Clip" and item ~= "Base.556Clip"
                then
                    newItem:setRoundChambered(true);
                    newItem:setContainsClip(true);
                end
            end
        end
    end
    
    BurglarStolenValuables(profession, playerObj)
    DeliveryDriverRandomPackages(profession, playerObj)
    TruckerRandomMap(profession, playerObj)
    StoreEmployeeRandomItems(profession, playerObj)
end

function BurglarStolenValuables(profession, playerObj)
    --Burglar stolen valuables
    if tostring(profession) == "base:burglar" then
        local inventory = playerObj:getInventory();
        bag = inventory:getItemFromType("Base.Bag_WeaponBag");
        if bag ~= nil then
            bag:getItemContainer():AddItem("Base.MoneyBundle");
            bag:getItemContainer():AddItem("Base.MoneyBundle");
            for i = 1, ZombRand(5, 20), 1 do
                bag:getItemContainer():AddItem("Base.Money");
            end

            ran = ZombRand(0, 3);
            if ran == 0 then
                bag:getItemContainer():AddItem("Base.Diamond");
            end
            if ran == 1 then
                bag:getItemContainer():AddItem("Base.Emerald");
            end
            if ran == 2 then
                bag:getItemContainer():AddItem("Base.Ruby");
            end
            if ran == 3 then
                bag:getItemContainer():AddItem("Base.Sapphire");
            end

            ran = ZombRand(0, 4);
            if ran == 0 then
                bag:getItemContainer():AddItem("Base.Ring_Right_RingFinger_Gold");
            end
            if ran == 1 then
                bag:getItemContainer():AddItem("Base.Ring_Right_RingFinger_Silver");
            end
            if ran == 2 then
                bag:getItemContainer():AddItem("Base.Ring_Right_RingFinger_SilverDiamond");
            end
            if ran == 3 then
                bag:getItemContainer():AddItem("Base.Ring_Right_RingFinger_GoldRuby");
            end
            if ran == 4 then
                bag:getItemContainer():AddItem("Base.Ring_Left_RingFinger_GoldDiamond");
            end
        end
        playerObj:setClothingItem_Back(bag);
    end
end

function TruckerRandomMap(profession, playerObj)
    if tostring(profession) == "truckerocc" then
        ran = ZombRand(0, 4);
        if ran == 0 then
            playerObj:getInventory():AddItem("Base.MuldraughMap");
        end
        if ran == 1 then
            playerObj:getInventory():AddItem("Base.WestpointMap");
        end
        if ran == 2 then
            playerObj:getInventory():AddItem("Base.RiversideMap");
        end
        if ran == 3 then
            playerObj:getInventory():AddItem("Base.RosewoodMap");
        end
    end
end

function StoreEmployeeRandomItems(profession, playerObj)

    function GiveRandomItem(profession, playerObj, bag)
        ran = ZombRand(0, 19);
        if ran == 0 then
            bag:getItemContainer():AddItem("Base.TinnedBeans");
        end
        if ran == 1 then
            bag:getItemContainer():AddItem("Base.TunaTin");
        end
        if ran == 2 then
            bag:getItemContainer():AddItem("Base.CannedChili");
        end
        if ran == 3 then
            bag:getItemContainer():AddItem("Base.Pop2");
        end
        if ran == 4 then
            bag:getItemContainer():AddItem("Base.BeerCan");
        end
        if ran == 5 then
            bag:getItemContainer():AddItem("Base.Milk");
        end
        if ran == 6 then
            bag:getItemContainer():AddItem("Base.GranolaBar");
        end
        if ran == 7 then
            bag:getItemContainer():AddItem("Base.Cheese");
        end
        if ran == 8 then
            bag:getItemContainer():AddItem("Base.CakeSlice");
        end
        if ran == 9 then
            bag:getItemContainer():AddItem("Base.Crisps");
        end
        if ran == 10 then
            bag:getItemContainer():AddItem("Base.Chocolate");
        end
        if ran == 11 then
            bag:getItemContainer():AddItem("Base.Bread");
        end
        if ran == 12 then
            bag:getItemContainer():AddItem("Base.Cereal");
        end
        if ran == 13 then
            bag:getItemContainer():AddItem("Base.EggCarton");
        end
        if ran == 14 then
            bag:getItemContainer():AddItem("Base.Lettuce");
        end
        if ran == 15 then
            bag:getItemContainer():AddItem("Base.Eggplant");
        end
        if ran == 16 then
            bag:getItemContainer():AddItem("Base.Corn");
        end
        if ran == 17 then
            bag:getItemContainer():AddItem("Base.Zucchini");
        end
        if ran == 18 then
            bag:getItemContainer():AddItem("Base.Onion");
        end
    end

    if tostring(profession) == "cashierocc" then

        bag = playerObj:getInventory():getItemFromType("Base.GroceryBag1");

        GiveRandomItem(profession, playerObj, bag);
        GiveRandomItem(profession, playerObj, bag);
        GiveRandomItem(profession, playerObj, bag);
        GiveRandomItem(profession, playerObj, bag);
        GiveRandomItem(profession, playerObj, bag);
    end
end

-- Give delivery driver 3 packages with random loot as their starting items
function DeliveryDriverRandomPackages(profession, playerObj)

    function GiveRandomPackage(profession, playerObj)
        package = playerObj:getInventory():AddItem("Base.Parcel_Medium");
        ran = ZombRand(0, 10);
        if ran == 0 then
            package:getItemContainer():AddItem("Base.NailsBox");
        end
        if ran == 1 then
            package:getItemContainer():AddItem("Base.ScrewsBox");
        end
        if ran == 2 then
            package:getItemContainer():AddItem("Base.BandageBox");
        end
        if ran == 3 then
            package:getItemContainer():AddItem("Base.BatteryBox");
        end
        if ran == 4 then
            package:getItemContainer():AddItem("Base.DuctTapeBox");
        end
        if ran == 5 then
            package:getItemContainer():AddItem("Base.AdhesiveTapeBox");
        end
        if ran == 6 then
            package:getItemContainer():AddItem("Base.AntibioticsBox");
        end
        if ran == 7 then
            package:getItemContainer():AddItem("Base.Garbagebag_box");
        end
        if ran == 8 then
            package:getItemContainer():AddItem("Base.Base.Cereal");
            package:getItemContainer():AddItem("Base.Base.Cereal");
        end
        if ran == 9 then
            package:getItemContainer():AddItem("Base.CandyPackage");
            package:getItemContainer():AddItem("Base.CandyPackage");
            package:getItemContainer():AddItem("Base.CandyPackage");
            package:getItemContainer():AddItem("Base.CandyPackage");
        end
        if ran == 10 then
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
            package:getItemContainer():AddItem("Base.Pop2");
        end
    end

    if tostring(profession) == "mar_deliverydriver" or tostring(profession) == "deliverymanocc" then
        GiveRandomPackage(profession, playerObj)
        GiveRandomPackage(profession, playerObj)
    end
end

function AlterProfessionDescription()
    local profList = ProfessionFactory.getCharacterProfessions()
    for i=1,profList:size() do
		local prof = profList:get(i-1)
        if Items[prof:getType()] ~= nil
        then
            local desc = prof:getDescription()
            desc = desc .. "\n\nStarting Items:"
            local itemName = "";
            local multiplier = 1;
            for i, item in ipairs(Items[prof:getType()]) do
                local it = getItem(item)

                if itemName == it:getDisplayName() then
                    multiplier = multiplier + 1;
                else
                    if multiplier > 1 then
                        desc = desc .. " x" .. tostring(multiplier);
                    end

                    desc = desc .. "\n- " .. it:getDisplayName();

                    multiplier = 1;
                end

                itemName = it:getDisplayName();
            end

            if multiplier > 1 then
                desc = desc .. " x" .. tostring(multiplier);
            end

            prof:setDescription(desc);
        end
	end
end

--Events.OnGameBoot.Add(AlterProfessionDescription);
Events.OnNewGame.Add(SpawnItems.OnNewGame);
Events.OnGameStart.Add(SpawnItems.onNewGame);

