BeyondOneWeek = {
    id = "BeyondOneWeek",
    name = "Bandits Week One And Beyond",
    config = {
        -- Tweaks --
        disableNukeQuest = true,
        variedRaids = true, --adjusts intensity of group raids (BWOEventsPlace)
        policeRoll = "65",
        swatRoll = "75",
        hazmatRoll = "75",
        minimumQuickCooldown = "1",
        maximumQuickCooldown = "5",
        meleeRebalance = true, --nerf the npcs melee 
        hitChance = "90",
        itemDmgMulti = "3",
        scratchChance = "75",
        deepWoundChance = "15",
        cutChance = "45",
        bleedingChance = "20",
        --chances for damage rolls

    },
}

-- -------------------------------------------------------------------------- --
--                                   Options                                  --
-- -------------------------------------------------------------------------- --

function BeyondOneWeek:buildOptions()
    local options = PZAPI.ModOptions:create(BeyondOneWeek.id, BeyondOneWeek.name)
    options:addDescription("!!!Please restart to see changes!!!")
    options:addTitle("LEGACY")
    BeyondOneWeek.config.disableNukeQuest = options:addTickBox("disableNukeQuest", "Disable Nuke Quest", true, "Nullifies functions related to nukes")
    options:addTitle("INTRUSTIVE CHANGES")
    options:addDescription("Below are changes that directly tamper with Week One's functions/code! Should the dev update a toggled mechanic they may cause issues or be outdated in comparison.")
    options:addDescription("--Varied Raids-- Varies the events for Police, Swat & Hazmats")
    BeyondOneWeek.config.variedRaids = options:addTickBox("variedRaids", "Varied Raids", true, "Varies stats, spawns & timings of raids")
    BeyondOneWeek.config.policeRoll = options:addTextEntry("policeRoll","Cop Report Chance","65","Percent a report will actually be made when a crime is committed (Default: 65)")
    BeyondOneWeek.config.swatRoll = options:addTextEntry("swatRoll","Swat Report Chance","75","Percent a report will actually be made to the swat team (Default: 75)")
    BeyondOneWeek.config.hazmatRoll = options:addTextEntry("hazmatRoll","Hazmat Squad Chance","75","Percent a squad will actually come when requested (Default: 75)")
    BeyondOneWeek.config.minimumQuickCooldown = options:addTextEntry("minimumQuickCooldown","Minimum Non-Player Cooldown (m)","1","How long the OVERALL cooldown will be if the player does not trigger the incident directly (Default: 1)")
    BeyondOneWeek.config.maximumQuickCooldown = options:addTextEntry("maximumQuickCooldown","Maximum Non-Player Cooldown (m)","5","How long the OVERALL cooldown will be if the player does not trigger the incident directly (Default: 5)")
    options:addDescription("--Melee Rebalance-- Make CQC less punishing")
    BeyondOneWeek.config.meleeRebalance = options:addTickBox("meleeRebalance", "NPC Melee Rebalance", true, "NPC hits are way less punishing up-close")
    BeyondOneWeek.config.hitChance = options:addTextEntry("hitChance","Hit Chance Percentage","90","Percent hits will connect and not miss (Default: 90)")
    BeyondOneWeek.config.itemDmgMulti = options:addTextEntry("itemDmgMulti","Item Damage Multiplier","3","Multiplier for melee weapons (not fists) in damage calculation (Default: 3)")
    options:addDescription("On hit there is a 1 in 4 chance to get afflicted with a health debuff when a slashing weapon is used, here are the percentages when this chance occurs.")
    BeyondOneWeek.config.scratchChance = options:addTextEntry("scratchChance","Scratch","75","Multiplier for melee weapons (not fists) in damage calculation (Default: 75)")
    BeyondOneWeek.config.deepWoundChance = options:addTextEntry("deepWoundChance","Deep Wound","15","Multiplier for melee weapons (not fists) in damage calculation (Default: 15)")
    BeyondOneWeek.config.cutChance = options:addTextEntry("cutChance","Cut","45","Multiplier for melee weapons (not fists) in damage calculation (Default: 45)")
    BeyondOneWeek.config.bleedingChance = options:addTextEntry("bleedingChance","Bleed","20","Multiplier for melee weapons (not fists) in damage calculation (Default: 20)")


    --self.config.tilesPerTick = options:addSlider("tilesPerTick", "Tiles per tick", 1, 64, 1, 8)
    --options:addDescription("How many tiles to clean per tick. Increasing this will affect performance!\nDefault: 8")
end

function BeyondOneWeek:syncOptions()
    local options = PZAPI.ModOptions:getOptions(BeyondOneWeek.id)
    BeyondOneWeek.config.disableNukeQuest = options:getOption("disableNukeQuest"):getValue()

    BeyondOneWeek.config.variedRaids = options:getOption("variedRaids"):getValue()
    BeyondOneWeek.config.meleeRebalance = options:getOption("meleeRebalance"):getValue()
    BeyondOneWeek.config.minimumQuickCooldown = options:getOption("minimumQuickCooldown"):getValue()
    BeyondOneWeek.config.maximumQuickCooldown = options:getOption("maximumQuickCooldown"):getValue()
    BeyondOneWeek.config.meleeRebalance = options:getOption("meleeRebalance"):getValue()
    BeyondOneWeek.config.itemDmgMulti = options:getOption("itemDmgMulti"):getValue()

    BeyondOneWeek.config.scratchChance = options:getOption("scratchChance"):getValue()
    BeyondOneWeek.config.deepWoundChance = options:getOption("deepWoundChance"):getValue()
    BeyondOneWeek.config.cutChance = options:getOption("cutChance"):getValue()
    BeyondOneWeek.config.bleedingChance = options:getOption("bleedingChance"):getValue()
end

-- -------------------------------------------------------------------------- --
--                                   Utils                                    --
-- -------------------------------------------------------------------------- --

-- -------------------------------------------------------------------------- --
--                                  Handlers                                  --
-- -------------------------------------------------------------------------- --
function BeyondOneWeek:onGameBoot()
    BeyondOneWeek:buildOptions()
    BeyondOneWeek:syncOptions()
end

-- -------------------------------------------------------------------------- --
--                                   Hooks                                    --
-- -------------------------------------------------------------------------- --

Events.OnGameBoot.Add(function() BeyondOneWeek:onGameBoot() end)
