local function debugPrint(message)
    if getDebug() then
        print("[ExtendedBatteryLife] " .. tostring(message))
    end
end

local function ModifyBatteryDrainRate()
    local multiplier = SandboxVars.ExtendedBatteryLife.BatteryMultiplier or 0.5
    debugPrint("Initializing Extended Battery Life with multiplier: " .. tostring(multiplier))
    
    local scriptManager = getScriptManager()
    local allRecipes = scriptManager:getAllCraftRecipes()
    local batteryItems = {}

    debugPrint("Scanning for items that accept batteries...")
    for i = 0, allRecipes:size() - 1 do
        local recipe = allRecipes:get(i)
        local recipeName = recipe:getName() or "unknown"
        
        if recipeName:contains("InsertBattery") then
            local inputsScripts = recipe:getInputs()
            
            for j = 0, inputsScripts:size() - 1 do
                local inputScript = inputsScripts:get(j)
                local inputItems = inputScript:getPossibleInputItems()

                for k = 0, inputItems:size() - 1 do
                    local item = inputItems:get(k)
                    batteryItems[item:getFullName()] = true
                end
            end
        end
    end

    for name, _ in pairs(batteryItems) do
        debugPrint("Battery item found: " .. name)
    end

    for name, _ in pairs(batteryItems) do
        local item = scriptManager:getItem(name)
        if item then
            debugPrint("Setting drain rate of " .. name .. " to " .. tostring(item:getUseDelta() * multiplier))
            item:setUseDelta(item:getUseDelta() * multiplier)
        end
    end
end

Events.OnGameStart.Add(ModifyBatteryDrainRate)