require "OptionScreens/CharacterCreationProfession"
local function addOrUpdateEfficiencySkill(self, levels)
    local efficiencyBaseLevel = 2
    local efficiencyLevel = (levels[Perks.Efficiency] or 0) + efficiencyBaseLevel
    if efficiencyLevel < 0 then efficiencyLevel = 0 end
    if efficiencyLevel > 10 then efficiencyLevel = 10 end
    local found = false
    for i = 1, #self.listboxXpBoost.items do
        local item = self.listboxXpBoost.items[i]
        if item.item.perk == Perks.Efficiency then
            item.item.level = efficiencyLevel
            found = true
            break
        end
    end
    if not found then
        self.listboxXpBoost:addItem(PerkFactory.getPerkName(Perks.Efficiency), { perk = Perks.Efficiency, level = efficiencyLevel })
    end
    self.listboxXpBoost:sort()
end

local originalCheckXPBoost = CharacterCreationProfession.checkXPBoost
CharacterCreationProfession.checkXPBoost = function(self, ...)
    originalCheckXPBoost(self, ...)
    local levels = {}
    if self.listboxTraitSelected and self.listboxTraitSelected.items then
        for _, v in pairs(self.listboxTraitSelected.items) do
            if v.item:getXPBoostMap() then
                local table = transformIntoKahluaTable(v.item:getXPBoostMap())
                for perk, level in pairs(table) do
                    levels[perk] = (levels[perk] or 0) + level:intValue()
                end
            end
        end
    end
    if self.profession and self.profession:getXPBoostMap() then
        local table = transformIntoKahluaTable(self.profession:getXPBoostMap())
        for perk, level in pairs(table) do
            levels[perk] = (levels[perk] or 0) + level:intValue()
        end
    end
    addOrUpdateEfficiencySkill(self, levels)
end

efficiencyDefaultXP = function()
    local player = getPlayer()
    if not player then return end

    local efficiency = player:getPerkLevel(Perks.Efficiency)
    local isUneff = player:HasTrait("unefficient")
    local isEff = player:HasTrait("efficient")
    local isYW = player:getDescriptor():getProfession() == "youthworker"

    if not isUneff and ((efficiency < 2) or 
        (isEff and efficiency == 3) or 
        (isYW and efficiency == 3) or 
        (isYW and isEff and efficiency == 6)) then
        player:LevelPerk(Perks.Efficiency)
        player:LevelPerk(Perks.Efficiency)
        luautils.updatePerksXp(Perks.Efficiency, player)
    end
end

Events.OnCreatePlayer.Add(efficiencyDefaultXP)