require 'Items/SuburbsDistributions'
require 'Items/ProceduralDistributions'

local bookData = {
    {name = "Efficiency.BookEfficiency1", weights = {10, 8, 2, 2, 2, 2, 2}},
    {name = "Efficiency.BookEfficiency2", weights = {8, 6, 1, 1, 1, 1, 1}},
    {name = "Efficiency.BookEfficiency3", weights = {6, 4, 0.5, 0.5, 0.5, 0.5, 0.5}},
    {name = "Efficiency.BookEfficiency4", weights = {4, 2, 0.1, 0.1, 0.1, 0.1, 0.1}},
    {name = "Efficiency.BookEfficiency5", weights = {2, 1, 0.01, 0.01, 0.01, 0.01, 0.01}},
}

local targets = {
    "BookstoreBooks",
    "LibraryBooks",
    "LivingRoomShelf",
    "ClassroomMisc",
    "ClassroomShelves",
    "KitchenBook",
    "LivingRoomShelfNoTapes"
}

for i, distribution in ipairs(targets) do
    local items = ProceduralDistributions["list"][distribution].items
    for _, book in ipairs(bookData) do
        table.insert(items, book.name)
        table.insert(items, book.weights[i])
    end
end
