require "TimedActions/ISBaseTimedAction"

local originalAddTimedAction = ISTimedActionQueue.add

local lastActionType = nil
local actionRepetitionCount = 0
local function getActionName(action)
    if action and action.Type then return action.Type end
    return tostring(action)
end

local MultiplierConfig = SandboxVars.MultiplierConfig or {}
function ISTimedActionQueue.add(action)
    local originalPerform = action.perform
    function action:perform()
        if self.maxTime == -1 then
            print("Skipping XP for instant action: " .. tostring(getActionName(action)))
            originalPerform(self)
            return
        end
        originalPerform(self)
        local isGlobal = MultiplierConfig.XPMultiplierGlobalToggle or true
        local xpMultiplier = 1.0
        if isGlobal then
            xpMultiplier = MultiplierConfig.XPMultiplierGlobal or 1.0
        else
            xpMultiplier = MultiplierConfig.Efficiency or 1.0
        end
        local enableGrindLimit = SandboxVars.Efficiency.EnableGrindLimit or false
        local grindLimitIndex = SandboxVars.Efficiency.GrindLimitIndex or 0.9
        local grindLimitThreshold = SandboxVars.Efficiency.GrindLimitThreshold or 10

        local actionName = getActionName(action)
        if actionName == lastActionType then
            actionRepetitionCount = actionRepetitionCount + 1
        else
            actionRepetitionCount = 1
            lastActionType = actionName
        end

        local xpAmount
        if enableGrindLimit and actionRepetitionCount > grindLimitThreshold then
            local decreaseFactor = grindLimitIndex ^ (actionRepetitionCount - grindLimitThreshold)
            xpAmount = math.max(0.001, xpMultiplier * decreaseFactor)
        else
            xpAmount = xpMultiplier
        end

        local player = self.character
        if player then
            player:getXp():AddXP(Perks.Efficiency, xpAmount) 
        end
    end
    originalAddTimedAction(action)
end
