require("TimedActions/ISBaseTimedAction")

defaultMaxTime = 0
TmaxTime = 0
local originalAdjustMaxTime = ISBaseTimedAction.adjustMaxTime or function(self, maxTime)
	return maxTime
end
local effBool = true
function toggleEffBool()
    effBool = not effBool
    print("effBool is now: " .. tostring(effBool))
end
function ISBaseTimedAction:adjustMaxTime(maxTime)
	if effBool then
		maxTime = originalAdjustMaxTime(self, maxTime or 50)
		defaultMaxTime = maxTime
		if maxTime ~= -1 and defaultMaxTime >= SandboxVars.Efficiency.DefaultTimeLimit then
			local efficiency = self.character:getPerkLevel(Perks.Efficiency)
			local efficiencyMultipliers = {
				SandboxVars.Efficiency.Level0,
				SandboxVars.Efficiency.Level1,
				SandboxVars.Efficiency.Level2,
				SandboxVars.Efficiency.Level3,
				SandboxVars.Efficiency.Level4,
				SandboxVars.Efficiency.Level5,
				SandboxVars.Efficiency.Level6,
				SandboxVars.Efficiency.Level7,
				SandboxVars.Efficiency.Level8,
				SandboxVars.Efficiency.Level9,
				SandboxVars.Efficiency.Level10,
			}

			if efficiency >= 0 and efficiency <= 10 then
				if self.recipe and self.recipe:getOriginalname() == "Transcribe Journal" then
					print("Avoiding Efficiency multiplier for Journal")
				else
					maxTime = maxTime * efficiencyMultipliers[efficiency + 1]
					if maxTime <= 5 and defaultMaxTime >= 10 then
						print("Fallback maxTime")
						maxTime = 3
					end
					if maxTime < 2 and defaultMaxTime >= 8 then
						print("Fallback maxTime")
						maxTime = 1
					end
				end
			end
		end
		TmaxTime = maxTime
		return maxTime
	else
		TmaxTime = maxTime
		return maxTime
	end
end
function ISTimedActionQueue:addToQueue(action)
	action.maxTime = action:adjustMaxTime(action.maxTime)
	table.insert(self.queue, action)
	if #self.queue == 1 then
		self.current = action
		action:begin()
	end
end

function getEfficiencyValues()
	return {defaultMaxTime, TmaxTime, effBool}
end