local MaskEfficiency = 0
local prevSicknessLevel = -1

local MaskEfficiencyTable = {
    -- Juego Base --
    ["Base.Hat_DustMask"] = 0.5,                            
    ["Base.Hat_GasMask"] = 1.0,                             
    ["Base.Hat_NBCmask"] = 1.0,                             
    ["Base.Hat_SurgicalMask_Blue"] = 0.5,                   
    ["Base.Hat_SurgicalMask_Green"] = 0.5,                  
    ["Base.Hat_BandanaMaskTINT"] = 0.25,                    
    ["Base.Hat_BandanaMask"] = 0.25,                        
    ["Base.HazmatSuit"] = 1.0,
    ["Base.Hat_Bandana"] = 0.25,
	["Base.Ghillie_Top"] = 0.25,
	["Base.Hat_HockeyMask"] = 0.25,
	["Base.Hat_BalaclavaFull"] = 0.25,
    -- Authentic Z --
    ["AuthenticZClothing.Hat_BandanaMaskDesert"] = 0.25,    
    ["AuthenticZClothing.Hat_BandanaMaskRed"] = 0.25,       
    ["AuthenticZClothing.Hat_GasMask"] = 1.0,               
    ["AuthenticZClothing.CEDAHazmatSuit"] = 1.0,           
    ["AuthenticZClothing.CEDAHazmatSuitBlack"] = 1.0,       
    ["AuthenticZClothing.CEDAHazmatSuitBlue"] = 1.0,        
    ["AuthenticZClothing.CEDAHazmatSuitRed"] = 1.0,         
    ["AuthenticZClothing.HazmatSuit2"] = 1.0,               
    ["AuthenticZBackpacks+.Hat_GasMask"] = 1.0,             
    -- Shark and Peach's Military Uniform Improvements --
    ["SMUIClothing.Hat_M17"] = 1.0,                         
    ["SMUIClothing.Hat_M40"] = 1.0,                        
    ["SMUIClothing.Hat_Shemagh"] = 0.25,                   
    ["SMUIClothing.Hat_ShemaghWoodland"] = 0.25,            
    ["SMUIClothing.Hat_ShemaghDesert"] = 0.25,              
    ["SMUIClothing.Hat_M17Doff"] = 1.0,                    
    ["SMUIClothing.Hat_M40Doff"] = 1.0,                     
    ["SMUIClothing.Hat_MarkIV"] = 1.0,                      
    ["SMUIClothing.Hat_M9"] = 1.0,                          
    ["SMUIClothing.Mask_ExtremeColdWeather"] = 0.25,        
    -- Shark's Law Enforcement Overhaul --
    ["SLEOClothing.Hat_PoliceBalaclava"] = 0.25,            
    ["SLEOClothing.Hat_PoliceM17"] = 1.0,                   
    -- Britas Armor --
    ["Base.Hat_MCU_GasMask"] = 1.0,                         
    ["Base.Hat_M45_GasMask"] = 1.0,                         
    ["Base.Hat_M50"] = 1.0,                                 
    ["Base.Hat_FM53"] = 1.0,                                
    ["Base.Hat_MSA_Gas_Mask"] = 1.0,                        
    ["Base.Hat_MSA_Gas_Mask_AMP"] = 1.0,                    
    ["Base.Bag_Shemagh_Half"] = 0.25,                       
    ["Base.K1_Gasmask"] = 1.0,
    ["Base.K1_Half"] = 1.0,
    ["Base.K1_Hood"] = 1.0,
    ["Base.PMK1_Gasmask"] = 1.0,
    ["Base.PMK1_Half"] = 1.0,
    ["Base.PMK2_Gasmask"] = 1.0,
    ["Base.PMK2_Half"] = 1.0,
    ["Base.S10_Gasmask"] = 1.0,
    ["Base.S10_Gasmask_Set"] = 1.0,
    ["Base.GP4U_Gasmask"] = 1.0,
    ["Base.MM1_Gasmask"] = 1.0,
    ["Base.SHMS_Gasmask"] = 1.0,
    ["Base.SHMS_Gasmask_Set"] = 1.0,
    ["Base.GP5M_Gasmask"] = 1.0,
    ["Base.PMG_Gasmask"] = 1.0,
    ["Base.GM15_Gasmask"] = 1.0,
    ["Base.GM17_Gasmask"] = 1.0,
    ["Base.Metro_Gasmask"] = 1.0,
    ["Base.Metro_Gasmask_Set"] = 1.0,
    ["Base.Bandana_Mask"] = 0.25,
    ["Base.Bandana_Mask_Half"] = 0.25,
    ["Base.Bandana_Mask_Camo"] = 0.25,
    ["Base.Bandana_Mask_Half_Camo"] = 0.25,
    ["Base.Bandana_Mask_Other"] = 0.25,
    ["Base.Bandana_Mask_Half_Other"] = 0.25,
    ["Base.Balaclava_Mask_1"] = 0.25,
    ["Base.Balaclava_Mask_2"] = 0.25,
    ["Base.Balaclava_Mask_3"] = 0.25,
    ["Base.Balaclava_Mask_4"] = 0.25,
    ["Base.Balaclava_Mask_5"] = 0.25,
    ["Base.Balaclava_Mask_6"] = 0.25,
    ["Base.Scarf_Mask"] = 0.25,
    ["Base.Scarf_Mask_ON"] = 0.25,
    ["Base.Scarf_Mask_Camo"] = 0.25,
    ["Base.Scarf_Mask_Camo_ON"] = 0.25,
    ["Base.Scarf_Mask_Hunting"] = 0.25,
    ["Base.Scarf_Mask_Hunting_ON"] = 0.25,
    ["Base.Scarf_Mask_Casual"] = 0.25,
    ["Base.Scarf_Mask_Casual_ON"] = 0.25,
    ["Base.Scarf_Mask_Ashe"] = 0.25,
    ["Base.Scarf_Mask_Ashe_ON"] = 0.25,
    ["Base.Hunter_Mask"] = 0.25,
    ["Base.Hunter_Mask_ON"] = 0.25,
    ["Base.Chain_Mask"] = 0.25,
    -- Swatpack --
    ["Base.Hat_SwatGasMask"] = 1.0,                         
    ["Base.Hat_Balaclava_Swat"] = 0.25,                     
    -- ADVANCED GEAR --
    ["Base.SniperVeil"] = 0.25,                            
    -- Paw Low Loot --
    ["Base.HECU Gas Mask"] = 1.0,                          
    ["Base.BalaTight"] = 0.25,                              
    ["Base.BalaTight2"] = 0.25,                             
    ["Base.RogueMask"] = 1.0,                               
    -- Undead Survivor --
    ["UndeadSurvivor.StalkerMask"] = 1.0,                   
    ["UndeadSurvivor.PrepperMask"] = 1.0,                   
    ["UndeadSurvivor.NomadMask"] = 0.25,                    
    ["UndeadSurvivor.OminousNomadMask"] = 0.25,             
    ["UndeadSurvivor.HeadhunterGasmask"] = 1.0,            
    ["UndeadSurvivor.DeadlyHeadhunterGasmask"] = 1.0,             
    -- Scrap Armor --
    ["Base.Hat_Rebreather"] = 1.0,                         
    -- They Knew --
    ["TheyKnew.MysteriousHazmat"] = 1.0,                   
    -- Toxic Fog --
    ["Base.Hat_GasMask_Improvised"] = 1.0,                  
    -- Stalker Armor Pack
    ["Base.GP5GasMask"] = 1.0,
    ["Base.M40GasMask"] = 1.0,
    ["Base.PPM88"] = 1.0,
    ["Base.GP10Z"] = 1.0,
    ["Base.SovietPMG"] = 1.0,
    ["Base.CS2aGasMask"] = 1.0,
    ["Base.PBF1"] = 1.0,
    ["Base.PBF1CS"] = 1.0,
    ["Base.PBF1Duty"] = 1.0,
    ["Base.PBF1Freedom"] = 1.0,
    ["Base.PBF2"] = 1.0,
    ["Base.PBF2CS"] = 1.0,
    ["Base.PBF2Duty"] = 1.0,
    ["Base.PBF2Freedom"] = 1.0,
    ["Base.RespiratorGold"] = 1.0,
    ["Base.RespiratorSilver"] = 1.0,
    ["Base.RespiratorCS"] = 1.0,
    ["Base.RespiratorFreedom"] = 1.0,
    ["Base.RespiratorDuty"] = 1.0,
    ["Base.RespiratorMonolith"] = 1.0,
    -- Asura Chi --
    ["AsuraChi.chiGasMask"] = 1.0,
    -- slyy's Spicy Attire
    ["slyyAttire.slyyHat_PlagueDocMask"] = 0.25,
    -- Insurgent - Black Ops Profession --
    ["Insurgent.Hat_GasMaskInsurgent"] = 1.0,
	-- Snake Pack --
    ["Base.NumarkHazmatSuit"] = 1.0,
    ["Base.Hat_BeekeepingHat"] = 0.25,
    ["Base.Hat_Batman"] = 0.25,
    ["Base.Hat_SAWMask"] = 0.25,
    ["Base.Hat_JoeMask"] = 0.25,
    ["Base.Hat_BossMask"] = 0.25,
    ["Base.Hat_MascaraCalavera"] = 0.25,
    ["Base.Hat_KakuHelmet"] = 0.5,
	-- Cerberus Pack --
	["Base.Mask_Balaclava_Cerberus"] = 0.25,
	["Base.MaskFull_BallisticMask_Cerberus_NoBelts"] = 0.5,
	["Base.MaskFull_BallisticMask_Cerberus"] = 0.5,
	["Base.Mask_BandanaMask_Cerberus"] = 0.25,
	["Base.Helmet_Mandible_Cerberus"] = 0.5,
	-- Lynx Pack --
	["Base.Helmet_RysT_Lynx_DOWN-Black"] = 0.5,
	["Base.Helmet_RysT_Lynx_DOWN-Green"] = 0.5,
	["Base.Mask_Balaclava_Lynx"] = 0.25,
	["Base.Mask_BandanaMask_Lynx"] = 0.25,
	-- KATTAJ1 Military Pack --
	["Base.Military_MaskHelmet_GasMask-M80"] = 1.0,
	["Base.Military_Mask_Balaclava1-Black"] = 0.25,
	["Base.Military_Mask_Balaclava1-Desert"] = 0.25,
	["Base.Military_Mask_Balaclava1-Green"] = 0.25,
	["Base.Military_Mask_Balaclava1-White"] = 0.25,
	["Base.Military_Mask_Balaclava2-Black"] = 0.25,
	["Base.Military_Mask_Balaclava2-Desert"] = 0.25,
	["Base.Military_Mask_Balaclava2-Green"] = 0.25,
	["Base.Military_Mask_Balaclava2-White"] = 0.25,
	["Base.Military_Mask_BandanaMask-Black"] = 0.25,
	["Base.Military_Mask_BandanaMask-Desert"] = 0.25,
	["Base.Military_Mask_BandanaMask-Green"] = 0.25,
	["Base.Military_Mask_BandanaMask-White"] = 0.25,
	["Base.Military_FullHelmet_Vanguard-Black"] = 0.5,
	["Base.Military_FullHelmet_Vanguard-Desert"] = 0.5,
	["Base.Military_FullHelmet_Vanguard-Green"] = 0.5,
	["Base.Military_FullHelmet_Vanguard-White"] = 0.5,
	-- KP Armor Pack --
	["Base.FullHelmet_01-White"] = 0.5,
	["Base.FullHelmet_01-Green"] = 0.5,
	["Base.FullHelmet_01-Desert"] = 0.5,
	["Base.FullHelmet_01-Black"] = 0.5,
	-- [J&G] Black Multicam Uniform --
	["Base.Black_Camo_GasMask-M80"] = 1.0,
	["Base.Black_Camo_Balaclava"] = 0.25,
	-- [J&G] Forest Multicam Uniform --
	["Base.Forest_Camo_GasMask-M80"] = 1.0,
	["Base.Forest_Camo_Balaclava"] = 0.25,
	-- [J&G] Alpine Multicam Uniform --
	["Base.Alpine_Camo_GasMask-M80"] = 1.0,
	["Base.Alpine_Camo_Balaclava"] = 0.25,
	-- [J&G] Desert Multicam Uniform --
	["Base.Desert_Camo_GasMask-M80"] = 1.0,
	["Base.Desert_Camo_Balaclava"] = 0.25,
	-- [J&G] XKU Uniform --
	["Base.Desert_Camo_GasMask-M80"] = 1.0,
	["Base.Desert_Camo_Balaclava"] = 0.25,
	-- Anthro Accessories --
	["AnthroAccessories.Tactical_Anthro_Mask_Ballistic"] = 1.0,
	["AnthroAccessories.Tactical_Anthro_Mask_Balaclava"] = 0.25,
	["AnthroAccessories.Tactical_Human_Mask_Ballistic"] = 1.0,
	-- zRe Vaccine 2.0 ReMod by kERHUS --
	["Base.zReV2_1ECO_fullhelmet1"] = 1.0,
	["Base.zReV2_1ECO_fullhelmet1A"] = 1.0,
	["Base.zReV2_1ECO_fullhelmet2"] = 1.0,
	["Base.zReV2_1ECO_fullhelmet2A"] = 1.0,
	-- OCP Gear --
	["Base.OCP-GasMask"] = 1.0,
	-- Better Masks --
    ["NMBM.Hat_DisposableMask_White"] = 0.5,                         
    ["NMBM.Hat_DisposableMask_Black"] = 0.5,                         
    ["NMBM.Hat_SpiffoMask_Black"] = 0.5,                         
    ["NMBM.Hat_SpiffoMask_White"] = 0.5,                       
    ["NMBM.Hat_SpiffoMask_Yellow"] = 0.5,                         
    ["NMBM.Hat_XMaskWhite"] = 0.5,                         
    ["NMBM.Hat_XMaskBlack"] = 0.5,                         
    ["NMBM.Hat_XMaskBlack_Red"] = 0.5,                        
    ["NMBM.Hat_SmileMaskYellow"] = 0.5,                         
    ["NMBM.Hat_SmileMaskBlack"] = 0.5,                         
    ["NMBM.Hat_HalloweenMask1"] = 0.5,                         
    ["NMBM.Hat_FaceMaskBlack"] = 0.5,                         
    ["NMBM.Hat_FaceMaskYellow"] = 0.5,                       
    ["NMBM.Hat_FaceMaskNavy"] = 0.5,                         
    ["NMBM.Hat_FaceMaskWhite"] = 0.5,                       
    ["NMBM.Hat_AdidasFaceMask_Black"] = 0.5,                       
    ["NMBM.Hat_AdidasFaceMask_White"] = 0.5,                         
    ["NMBM.Hat_WoodlandFaceMask"] = 0.5,                         
    ["NMBM.Hat_FaceMaskRed"] = 0.5,                         
    ["NMBM.Hat_FaceMaskLeopardPrint"] = 0.5,                         
    ["NMBM.Hat_FaceMaskLeopardPrint2"] = 0.5,                        
    ["NMBM.Hat_FaceMaskJollyRoger"] = 0.5,                         
    ["NMBM.Hat_FaceMaskCatWhiskersBlack"] = 0.5,                         
    ["NMBM.Hat_FaceMaskCatWhiskersWhite"] = 0.5,                         
    ["NMBM.Hat_FaceMaskCatWhiskersPink"] = 0.5,                         
    ["NMBM.Hat_HalfMaskRespirator_Black"] = 1.0,                         
    ["NMBM.Hat_HalfMaskRespirator_White"] = 1.0,                        
    ["NMBM.Hat_TR2TacticalRespirator"] = 1.0,                         
    ["NMBM.Hat_HalfMaskRespiratorII_Black"] = 1.0,                        
    ["NMBM.Hat_HalfMaskRespiratorII_White"] = 1.0,
	-- zRe SWAT ARMOR --
    ["Base.zReSWAT_Hat_GasMask"] = 1.0,                         
    ["Base.zReSWAT_Hat_GasMask_NoBelts"] = 1.0,                        
    ["Base.zReSWAT_BalaclavaFace"] = 0.25,  
    -- zRe ARMOR PACK by kERHUS --	
	["Base.zRe_Hat_BalaclavaFace"] = 0.25,                         
    ["Base.zRe_Respirator"] = 1.0,                        
    ["Base.zRe_Tractor_Hat_GasMask"] = 1.0,                        
    ["Base.zRe_Hat_Altyn_Green"] = 0.5,  
    ["Base.zRe_Hat_Altyn_Olive"] = 0.5,  
    ["Base.zRe_Hat_Altyn_Black"] = 0.5, 
    -- Gangs+ --
	["Base.AC_AcidMask01"] = 0.25,
	["Base.Hat_CrashHelmetFULL"] = 0.5,
	["Base.Hat_CrashHelmet_Police"] = 0.5,
	["Base.Hat_RiotHelmet"] = 0.5,
	["Base.Hat_SkullBalaclavaFull"] = 0.25,
	["Base.AC_SkullMask01"] = 0.25,
	["Base.AC_SkullMask02"] = 0.25,
	["Base.Hat_TacticalBalaclavaFull"] = 0.25,
	-- Scrap Armor --
	["Base.Hat_Rebreather"] = 1.0,
	["Base.Hat_MotorcycleHelmet2"] = 0.5,
	["Base.Hat_MotorcycleHelmet2open"] = 0.25,
	["Base.Hat_ScrapHelmet"] = 0.5,
	["Base.Hat_ScrapHelmetopen"] = 0.25,
	["Base.Hat_ScrapKettleHelmet"] = 0.25,
	["Base.Hat_WelderMask2"] = 0.5,
	-- The Jin_Roh --
	["Base.Jin_Roh_Mask"] = 0.5,
	-- Taller de Forja --
	["Forja.CascoMedieval"] = 0.5,
	-- Insurgent Profession --
	["Insurgent.DeployedParachute"] = 1.0,
	-- CRM_FactionPack --
	["CRM.CRM_GasMask"] = 1.0,
	["CRM.CRM_helmet_MK1_closed"] = 0.5,
	["CRM.CRM_helmet_MK1_closed_front"] = 0.5,
	["CRM.CRM_helmet_MK2_closed"] = 0.5,
	["CRM.CRM_helmet_MK2_closed_front"] = 0.5,
	["CRM.CRMFaceShield"] = 0.5,
	-- Authentic Z - Lite --
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLRacing"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalBobaFett"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalSimple"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalEvelKnievel"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalGreenDragon"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalShark"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalKiss"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalOptimus"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalPowerRangerRed"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalSnowLeopard"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLDecalVenom"] = 0.5,
	["AuthenticZLite.Hat_AuthenticCrashHelmetFULLTINT"] = 0.5,
	["AuthenticZLite.Hat_StormtrooperHelmetAZ"] = 0.5,
	["AuthenticZLite.CEDAHazmatSuitBlack"] = 1.0,
	["AuthenticZLite.CEDAHazmatSuitRed"] = 1.0,
	["AuthenticZLite.CEDAHazmatSuitBlue"] = 1.0,
	["AuthenticZLite.CEDAHazmatSuit"] = 1.0,
	["AuthenticZLite.HazmatSuit2"] = 1.0,
	["AuthenticZLite.NBHHazmatSuitNoShoes"] = 1.0,
	["AuthenticZLite.CEDAHazmatSuitBlackNoShoes"] = 1.0,
	["AuthenticZLite.CEDAHazmatSuitBlueNoShoes"] = 1.0,
	["AuthenticZLite.CEDAHazmatSuitRedNoShoes"] = 1.0,
	["AuthenticZLite.HazmatSuit2NoShoes"] = 1.0,
	["AuthenticZLite.NBHHazmatSuit"] = 1.0,
	["AuthenticZLite.RaveMask"] = 0.25,
	["AuthenticZLite.CultistMask"] = 0.25,
	["AuthenticZLite.Hat_ChickenHeadJacket"] = 0.25,
	["AuthenticZLite.Hat_DeathMask"] = 0.25,
	["AuthenticZLite.Hat_DRLegoHead"] = 0.25,
	["AuthenticZLite.Hat_GasMask"] = 1.0,
	["AuthenticZLite.Hat_GhostFace"] = 0.25,
	["AuthenticZLite.Hat_HockeyMaskJason"] = 0.25,
	["AuthenticZLite.Hat_LeatherFace"] = 0.25,
	["AuthenticZLite.Hat_MichaelMyers"] = 0.25,
	["AuthenticZLite.Hat_TagillaMask"] = 0.5,
	["AuthenticZLite.Hat_TagillaMask2"] = 0.5,
	["AuthenticZLite.Hat_TrueEyeCult"] = 0.25,
	["AuthenticZLite.Hat_WrinklesMask"] = 0.25,
	["AuthenticZLite.Mask_Oni"] = 0.25,
	["AuthenticZLite.Mask_Samurai"] = 0.25,
	-- TLOUClothingSeraphites --
	["TLOU.Hat_FedraGasMask"] = 1.0,
	-- Realistic Army Zombies --
	["RAZ.Hat_GasMaskArmy"] = 1.0,
	["RAZ.Hat_GasMaskArmy_nofilter"] = 1.0,
}


local function setEfficiencyForItem(maskItem)
    local type = maskItem:getFullType()
    local maskEfficiencyRaw = 0
    if MaskEfficiencyTable[type] ~= nil  then
        MaskEfficiency = MaskEfficiencyTable[type] * maskItem:getCondition() / maskItem:getConditionMax()
    else
--[[        local tags = ScriptManager.instance:getItem(type):getTags()
        for i=0,tags:size() do
            local tag = tags:get(i)
            if tag == "GasMask" or tag == "HazmatSuit" then
                MaskEfficiency = 1
                return
            end
        end]]
        MaskEfficiency = 0
    end
end

local function UpdateMaskEfficiency(player)
    local wornItems = player:getWornItems()
    local maskItem = wornItems:getItem("Mask")
    if maskItem then
        setEfficiencyForItem(maskItem)
    else
        maskItem = wornItems:getItem("MaskEyes")
        if maskItem then
            setEfficiencyForItem(maskItem)
        else
            maskItem = wornItems:getItem("MaskFull")
            if maskItem then
                setEfficiencyForItem(maskItem)
            else
			maskItem = wornItems:getItem("FullSuitHeadNumark")
        if maskItem then
            setEfficiencyForItem(maskItem)
        else
		maskItem = wornItems:getItem("KATTAJ1Balaclava")
            if maskItem then
                setEfficiencyForItem(maskItem)
            else
			maskItem = wornItems:getItem("Balaclava")
            if maskItem then
                setEfficiencyForItem(maskItem)
            else
		maskItem = wornItems:getItem("Mandible")
        if maskItem then
            setEfficiencyForItem(maskItem)
        else
			maskItem = wornItems:getItem("Hat")
            if maskItem then
                setEfficiencyForItem(maskItem)
            else
			maskItem = wornItems:getItem("FullTop")
            if maskItem then
                setEfficiencyForItem(maskItem)
            else
                maskItem = wornItems:getItem("FullHat")
                if maskItem then
                    setEfficiencyForItem(maskItem)
                else
                    maskItem = wornItems:getItem("FullSuitHead")
                    if maskItem then
                        setEfficiencyForItem(maskItem)
                    else
                        maskItem = wornItems:getItem("Scarf")
                        if maskItem then
                            setEfficiencyForItem(maskItem)
                        else
                            MaskEfficiency = 0
                        end
                    end
                end
			end
            end
			end
			end
			end
			end
			end
			end
			end
			end

local function ApplyMaskEfficiency(player)
    local bodyDamage = player:getBodyDamage()
	if prevSicknessLevel < 0.0 then --get initial value
		prevSicknessLevel = bodyDamage:getFoodSicknessLevel()
	end
    local currentSickness = bodyDamage:getFoodSicknessLevel()
    if MaskEfficiency > 0.0 and currentSickness > 0.0 then
        local newSickness = currentSickness
        local gameTimeMultiplier = GameTime.getInstance():getMultiplier()
        local deltaSicknessLevel = currentSickness - prevSicknessLevel
        local poisonLevel = bodyDamage:getPoisonLevel()
        if deltaSicknessLevel > 0 then
            -- we cannot get the number of corpses, because that value is not exposed in lua, so we calculate it backwards ourselves
            local sicknessFromCorpses
            if poisonLevel > 0.0 then --use different formula if poisoned
                --original formula for 41.65
                sicknessFromCorpses = deltaSicknessLevel - ((bodyDamage:getInfectionGrowthRate() * (2 + Math.round(bodyDamage:getPoisonLevel() / 10.0))) * gameTimeMultiplier)
            else
                sicknessFromCorpses = deltaSicknessLevel
            end
            local sicknessFromCorpseRate = BodyDamage.getSicknessFromCorpsesRate(6) -- Damage is calculated for any corpse above 5
            local estimatedCorpses = sicknessFromCorpses / sicknessFromCorpseRate / gameTimeMultiplier
            local sicknessFromCorpsesAdjusted = Math.min(Math.ceil(estimatedCorpses), 20) * sicknessFromCorpseRate * gameTimeMultiplier-- capped at 20 corpses
            if sicknessFromCorpses > 0 then
                newSickness = newSickness - (sicknessFromCorpsesAdjusted * MaskEfficiency)
            end
        end
        if newSickness < 0 then
            newSickness = 0
        end
        bodyDamage:setFoodSicknessLevel(newSickness);
        prevSicknessLevel = newSickness
    else
        prevSicknessLevel = currentSickness
    end
end

local function OnCreatePlayer(playerIndex, player)
    if (playerIndex == 0) then
        UpdateMaskEfficiency(player)
    end
end

Events.OnClothingUpdated.Add(UpdateMaskEfficiency)
Events.OnPlayerUpdate.Add(ApplyMaskEfficiency)
Events.OnCreatePlayer.Add(OnCreatePlayer)