local ShowLocatorsButton = ISButton:derive("ShowLocatorsButton")
local ISWorldMap_renderOrig = nil
local showLocators = false

function ShowLocatorsButton:initialise()
    ISButton.initialise(self)
end

function ShowLocatorsButton:update()
    if ISWorldMap_instance then
        if ISWorldMap_instance:isVisible() then self:setVisible(true)
        else self:setVisible(false) end
    end
    if showLocators then self:setTitle(SWS_GetModText("HideGroupMembers"))
    else self:setTitle(SWS_GetModText("ShowGroupMembers")) end
end

function ShowLocatorsButton:new(x, y, width, height, title, clicktarget, onclick)
    local o = {}
    o = ISButton:new(x, y, width, height, title, clicktarget, onclick)
    setmetatable(o, self)
    self.__index = self
    return o
end

local function CreateShowLocatorsButton()
    local buttonShowLocators = ShowLocatorsButton:new(
            math.floor(getCore():getScreenWidth()/2),
            getCore():getScreenHeight()-50,
            150, 25,
            SWS_GetModText("ShowGroupMembers"),
            nil,
            function()
                if showLocators then showLocators = false
                else showLocators = true end
            end
    )
    buttonShowLocators:addToUIManager()
    buttonShowLocators:setVisible(false)
    buttonShowLocators:setAlwaysOnTop(true)
end

local function ISWorldMap_renderNew(self)
    ISWorldMap_renderOrig(self)
	local playerQuests = SSQM:GetActiveQuests()

	for i=1, #playerQuests do
		local playerQuest = playerQuests[i]
		if playerQuest then
			local x, y, ss
			local itemsReq = -1
			local targetTitle = false
			if playerQuest.Target then
				if playerQuest.Target.Count then
					itemsReq = playerQuest.Target.Count
					if playerQuest.Target.Found then
						itemsReq = itemsReq - playerQuest.Target.Found
					end
				end
				if itemsReq ~= 0 and playerQuest.Target.X ~= nil then
					x = playerQuest.Target.X
					y = playerQuest.Target.Y
					if playerQuest.Target.MapTitle then
						targetTitle = playerQuest.Target.MapTitle
					else
						targetTitle = SWS_GetModText("UnknownTarget")
					end
				end
				if not targetTitle then
					if playerQuest.Target.NPCID ~= nil then
						ss = SSM:Get(playerQuest.Target.NPCID)
					elseif playerQuest.Target.Name and playerQuest.Target.MarkNPC then
						ss = SSM:GetSurvivorByName(playerQuest.Target.Name)
					elseif playerQuest.Giver then
						ss = SSM:Get(playerQuest.Giver)
					end
					if ss then
						x = ss:getX()
						y = ss:getY()
						targetTitle = ss:getName()
					elseif playerQuest.Target.AltX ~= nil then
						x = playerQuest.Target.AltX
						y = playerQuest.Target.AltY
						targetTitle = playerQuest.Target.AltMapTitle
					end
				end
			elseif playerQuest.Giver then
				ss = SSM:Get(playerQuest.Giver)
				if ss then
					x = ss:getX()
					y = ss:getY()
					targetTitle = ss:getName()
				end
			end
			if targetTitle then
				local mapX = self.mapAPI:worldToUIX(x, y) - 3
				local mapY = self.mapAPI:worldToUIY(x, y) - 3
				local name_size = getTextManager():MeasureStringX(UIFont.NewSmall, targetTitle)
				self:drawRect(mapX, mapY, 6, 6, 1, 0, 0, 1)
				self:drawRect(mapX-1, mapY+8, name_size+1, 15, 0.5, 0, 0, 0)
				self:drawText(targetTitle, mapX, mapY+9, 1, 1, 1, 1, UIFont.NewSmall)
			end
		end
    end
	
    if showLocators then
        local group_members = get_group():getMembers()
        for i=2, #group_members do
            local member = group_members[i]
			if member ~= nil and type(member) ~= "number" and member.player then
				--TODO: show npc locations even if they get unloaded
				local x = self.mapAPI:worldToUIX(member:getX(), member:getY())-3
				local y = self.mapAPI:worldToUIY(member:getX(), member:getY())-3
				self:drawRect(x, y, 6, 6, 1, 0, 0, 1)
				local member_name = member:getName()
				local name_size = getTextManager():MeasureStringX(UIFont.NewSmall, member_name)
				self:drawRect(x-1, y+8, name_size+1, 15, 0.5, 0, 0, 0)
				self:drawText(member_name, x, y+9, 1, 1, 1, 1, UIFont.NewSmall)
			end
        end
    end
end

Events.OnGameBoot.Add(function()
	ISWorldMap_renderOrig = ISWorldMap.render
	ISWorldMap.render = ISWorldMap_renderNew
end)
	
Events.OnGameStart.Remove(create_button_show_locators)
Events.OnGameStart.Add(CreateShowLocatorsButton)