local TalkToSurvivorOrig = nil
local AskToJoinOrig = nil
local InviteToPartyOrig = nil
local QuestManagerInitOrig = nil
local SSM_LoadSurvivorOrig = nil
local SSM_spawnSurvivorOrig = nil
local SSM_OnDeathOrig = nil
local SSQM_CheckTriggerOrig = nil
local SSQM_PerformTriggerActionsOrig = nil
local FarmingTask_getAPlantThatNeedsOrig = nil
local SuperSurvivor_NPC_ManageLockedDoorsOrig = nil
local SuperSurvivor_OnDeathOrig = nil
local saveSurvivorMapOrig = nil

local customFuncRefs = {}
local npcsThatWantToTalk = {}
local activeQuests = {}
local failedQuests = {}
local completeQuests = {}
local miscMessages = {}
local actionQueue = {}
local questData = {}
local lastDialogueActions = {nil,nil}
local lastQuestID = 0
local lastZombiePlayerHit = nil
local preventTalkToNPC = false

local survivorsInCell = {}
local spawnCellKeys = {}
SWS_NPC_CELL_SPAWN_MAX = 2

myQuestInfoWindow = nil

SSQM_ActiveQuestsChanged = false
SSQM_FailedQuestsChanged = false
SSQM_CompleteQuestsChanged = false
SSQM_MiscMessagesChanged = false
SSQM_ActionQueueChanged = false
SSQM_QuestDataChanged = false
SSQM_NPCCellKeysChanged = false
SSQM_NPCCellCountsChanged = false
SSQM_NPCTWTTChanged = false

SWS_FruitFoods = {
	"Apple", "Banana", "BerryBlack", "BerryBlue", "Cherry",
	"Grapefruit", "Grapes", "Mango", "Orange", "Peach", "Pear"
}

SS_Jobs = {
	Leader = "Leader", Companion = "Companion", Dustman = "Dustman",
	Guard = "Guard", Sheriff = "Sheriff", Junkman = "Junkman",
	Farmer = "Farmer", Timberjack = "Timberjack", Hauler = "Hauler",
	Worker = "Worker", Partner = "Partner", Doctor = "Doctor",
	Trader = "Trader", Chef = "Chef"
}

function SWS_CellSpawnCount(square)
	local cellX = math.floor(square:getX() / 300.0)
	local cellY = math.floor(square:getY() / 300.0)
	local cellKey = "x"..cellX.."y"..cellY
	
	if survivorsInCell[cellKey] ~= nil then
		return survivorsInCell[cellKey]
	else
		return 0
	end
end

function GetAdjSquareNew(square, dir)
	if not square then return nil end
	if dir == 'N' then
		return getCell():getGridSquare(square:getX(),square:getY() - 1,square:getZ());
	elseif dir == 'E' then
		return getCell():getGridSquare(square:getX() + 1,square:getY(),square:getZ());
	elseif dir == 'S' then
		return getCell():getGridSquare(square:getX(),square:getY() + 1,square:getZ());
	else
		return getCell():getGridSquare(square:getX() - 1,square:getY(),square:getZ());
	end
end

function DoctorNeedsBandage(bp)
	return (bp:bandaged() == false and (bp:bleeding() or bp:isDeepWounded() or bp:isCut() or bp:stitched()))
end

function DoctorNeedsSplint(bp)
	if bp:HasInjury() and bp:getFractureTime() > 0 and not bp:isSplint() then
		local bpt = bp:getType():toString()
		if bpt == "UpperArm_L" or bpt == "UpperArm_R" or bpt == "ForeArm_L" or bpt == "ForeArm_R" or
		bpt == "UpperLeg_L" or bpt == "UpperLeg_R" or bpt == "LowerLeg_L" or bpt == "LowerLeg_R" then
			return true
		else
			return false
		end
	else
		return false
	end
end

function DoctorNeedsWoundDisinfect(bp)
	return (bp:HasInjury() and bp:isInfectedWound() and (bp:bandaged() == false or bp:getAlcoholLevel() == 0.0 or DoctorNeedsCleanBandage(bp)))
end

function DoctorNeedsAntibiotics(bp, player)
	return (bp:HasInjury() and bp:isInfectedWound() and player:getReduceInfectionPower() == 0.0)
end

function DoctorDetermineTreatement(bp)
	
	if not instanceof(bp,"BodyPart") then 
		print("error non body part given to DoctorDetermineTreatement")
		return "?" 
	end

	if (DoctorNeedsSplint(bp)) then return "Splint"
	elseif (DoctorNeedsGlassRemoval(bp)) and (bp:bandaged()) then return "Bandage Removal"
	elseif (DoctorNeedsGlassRemoval(bp)) and (not bp:bandaged()) then return "Remove Glass"
	elseif (DoctorNeedsBulletRemoval(bp)) and (bp:bandaged()) then return "Bandage Removal"
	elseif (DoctorNeedsBulletRemoval(bp)) and (not bp:bandaged()) then return "Remove Bullet"
	elseif (DoctorNeedsStiches(bp)) and (bp:bandaged()) then return "Bandage Removal"
	elseif (DoctorNeedsStiches(bp)) and (not bp:bandaged()) then return "Stich"
	elseif (DoctorNeedsWoundDisinfect(bp)) and (bp:bandaged()) then return "Bandage Removal"
	elseif (DoctorNeedsWoundDisinfect(bp)) and (not bp:bandaged()) then return "Bandage"
	elseif (DoctorNeedsBandage(bp)) then return "Bandage"
	elseif (DoctorNeedsCleanBandage(bp)) then return "Bandage Removal"
	else return "None" end
end

function DoctorTask:FindPatient()
	local player = self.parent.player
	local groupID = self.parent:getGroupID()
	local patient = nil
	local range = 10
	local Square, closestsoFarSquare;
	local minx = math.floor(player:getX() - range)
	local maxx = math.floor(player:getX() + range)
	local miny = math.floor(player:getY() - range)
	local maxy = math.floor(player:getY() + range)
	local closestsoFar = range
	
	for x=minx, maxx do
		for y=miny, maxy do
			Square = getCell():getGridSquare(x,y,player:getZ())
			if Square ~= nil then
				local distance = getDistanceBetween(Square,player)
				local closeobjects = Square:getMovingObjects()
				for i=0, closeobjects:size()-1 do
					local obj = closeobjects:get(i)
					if obj ~= nil then 
						if instanceof(obj,"IsoPlayer") and self.parent.player:CanSee(obj) and obj:getModData().isHostile ~= true and not obj:isDead() then
							if RequiresTreatment(obj) and distance < closestsoFar and obj:getModData().Group == groupID then
								closestsoFar = distance
								patient = obj
							end
						end
					end
				end
			end
		end
	end
	
	return patient
end

function DoctorTask:setPatient(patient)
	self.Patient = patient
end

function AttemptEntryIntoBuildingTask:isValid()
	if not self.parent or not self.parent.TargetBuilding then return false end
	
	if self.parent:isTargetBuildingClaimed(self.parent.TargetBuilding) then
		self:giveUpOnBuilding()
		return false
	end
	
	return true
end

function SuperSurvivorManager:forMax()
	return self.SurvivorCount+1
end

function SuperSurvivor:isRecruitable()
	local group = self:getGroup()
	return ((not group) or group:getMemberCount() <= 1)
end

function AskToJoinNew(test, player)
	local SS = SSM:Get(player:getModData().ID)
	local mySS = SSM:Get(0)
	if SS and mySS then
		if mySS:isRecruitable() then
			if player:getModData().NoParty or SS:isHostile() then
				mySS:Get():Say(getActionText("CanIJoin"))
				SS:Speak(getSpeech("No"))
				print("SWS: group cannot accept main player")
			else
				AskToJoinOrig(test, player)
			end
		else
			mySS:Get():Say(getActionText("CanIJoin"))
			SS:Speak(SWS_GetModText("HaveOwnGroup"))
		end
	end
end

function InviteToPartyNew(test, player)
	local SS = SSM:Get(player:getModData().ID)
	if SS:isRecruitable() then
		InviteToPartyOrig(test, player)
	else
		SS:Speak(SWS_GetModText("AlreadyInGroup"))
	end
end

function SuperSurvivor:isHostile()
	return self:Get():getModData().isHostile
end

function SuperSurvivor:NPC_IFOD_BarricadedInsideOwnBase()

	local door = self:inFrontOfDoor()
			
	if door ~= nil and door:isBarricaded() and not self.player:isOutside()  then
		local building = self:getBaseBuilding()
		if building ~= nil and building == self:getBuilding() then
			print("SWS: NPC is barricaded inside their own base!")
			local barricade = door:getBarricadeOnSameSquare()
			if not barricade then
				barricade = door:getBarricadeOppositeCharacter(self.player)
			end
			if barricade then
				return barricade
			else
				return false
			end
		end
	end
	
	return false
end

function SuperSurvivor:inFrontOfBlockedDoorAndOutside()

	local door = self:inFrontOfDoor()

	if (door ~= nil) and (door:isLocked() or door:isLockedByKey() or door:isBarricaded()) and (self.player:isOutside()) then
		return door
	else 
		return false
	end
end

function SuperSurvivor:NPC_IFOD_LockedOutsidePlayerBuilding()

	local door = self:inFrontOfBlockedDoorAndOutside()
	local building = nil
	
	if door then
		local sq = door:getOtherSideOfDoor(self.player)
		if sq then
			building = sq:getBuilding()
		end
	end
			
	if building and building == getSpecificPlayer(0):getBuilding() then
		print("SWS: NPC is locked outside of the building the player is in")
		return true
	end
	
	return false
end

function SuperSurvivor_NPC_ManageLockedDoorsNew(self)
	SuperSurvivor_NPC_ManageLockedDoorsOrig(self)
	local barricade = self:NPC_IFOD_BarricadedInsideOwnBase()
	if barricade then
		if barricade:isMetal() then
			print("SWS: removing metal barricade blocking NPC")
			barricade:removeMetal(self.player)
			self.StuckDoorTicks = 0
		elseif barricade:isMetalBar() then
			print("SWS: removing metal bar barricade blocking NPC")
			barricade:removeMetalBar(self.player)
			self.StuckDoorTicks = 0
		elseif barricade:getNumPlanks() > 0 then
			print("SWS: removing plank barricade blocking NPC")
			barricade:removePlank(self.player)
			self.StuckDoorTicks = 0
		end
	end
end

function SuperSurvivor:setRelationshipWP(thisAmount)
	self.player:getModData().RWP = thisAmount
end

function SuperSurvivor:recruitSurvivor()
	if self:isDead() then return end
	
	local group = nil
	if SSM:Get(0):getGroupID() == nil then
		group = SSGM:newGroup()
		group:addMember(SSM:Get(0), SS_Jobs.Leader)
	else
		group = SSM:Get(0):getGroup()
	end
	
	if group and not group:isMember(self) then
		group:addMember(self, SS_Jobs.Companion)
	else
		print("SWS: recruitSurvivor() could not find or create group")
	end

	self:getTaskManager():clear()
	self:PlusRelationshipWP(1.0)
	self:setAIMode("Follow")
	self:setGroupRole("Companion")
	self:getTaskManager():AddToTop(FollowTask:new(self,getSpecificPlayer(0)))
	
	print("SWS: Survivor was recruited")
end

function SuperSurvivor:rejectSurvivor()
	self:getTaskManager():clear()
	self:PlusRelationshipWP(-1.0)
	self:setAIMode("Random Solo")

	print("SWS: Survivor was rejected")
end

function SuperSurvivor:wearSuit(suitTable)
	self.player:clearWornItems()
	self.player:setWornItem("Jacket", nil)
	for i=1, #suitTable do
		if suitTable[i] ~= nil then
			self:WearThis(suitTable[i])
		end
	end
end

function SuperSurvivor:giveRandomWeapon(hoursSurvived)
	if ZombRand(100) < (ChanceToSpawnWithGun + math.floor(hoursSurvived/48)) then 
		self:giveWeapon(getWeapon(RangeWeapons[ZombRand(#RangeWeapons)+1]),true)
		SWS_IncreaseSkillLevel(self:Get(), "Aiming", ZombRand(1,4), 9)
		SWS_IncreaseSkillLevel(self:Get(), "Reloading", ZombRand(1,4), 9)
	elseif ZombRand(100) < (ChanceToSpawnWithWep + math.floor(hoursSurvived/48)) then 
		self:giveWeapon(MeleWeapons[ZombRand(#MeleWeapons)+1],true) 
	end
end

function SuperSurvivor:giveRandomFood()
	local bag = self:getBag()
	local count = ZombRand(0,3)
	
	for i=1, count do
		bag:AddItem("Base."..tostring(CannedFoods[ZombRand(#CannedFoods)+1]))
	end
	
	count = ZombRand(0,3)
	for i=1, count do
		bag:AddItem("Base."..tostring(SWS_FruitFoods[ZombRand(#SWS_FruitFoods)+1]))
	end
end

function SuperSurvivor:Teleport(x, y, z)
    self.player:setX(x)
    self.player:setY(y)
    self.player:setZ(z)
    
    self.player:setLx(self.player:getX())
    self.player:setLy(self.player:getY())
    self.player:setLz(self.player:getZ())
	
	self.TargetSquare = nil
	self.LastSquare = nil
	
	self:SaveSurvivorOnMap()
end

function QuestManager:SaveToFile()
	if SSQM_QuestTriggersChanged then
		local ssqmData = {LastQuest=lastQuestID, TriggerCount=SSQM.QuestCount, Triggers=SSQM.Quests}
		SWS_SaveTable(ssqmData, "SWS_QuestTriggers.txt")
		SSQM_QuestTriggersChanged = false
	end
	if SSQM_QuestDataChanged then
		SWS_SaveTable(questData, "SWS_QuestData.txt")
		SSQM_QuestDataChanged = false
	end
	if SSQM_ActionQueueChanged then
		SWS_SaveTable(actionQueue, "SWS_ActionQueue.txt")
		SSQM_ActionQueueChanged = false
	end
	if SSQM_FailedQuestsChanged then
		SWS_SaveTable(failedQuests, "SWS_FailedQuests.txt")
		SSQM_FailedQuestsChanged = false
	end
	if SSQM_CompleteQuestsChanged then
		SWS_SaveTable(completeQuests, "SWS_CompleteQuests.txt")
		SSQM_CompleteQuestsChanged = false
	end
	if SSQM_ActiveQuestsChanged then
		SWS_SaveTable(activeQuests, "SWS_ActiveQuests.txt")
		SSQM_ActiveQuestsChanged = false
	end
	if SSQM_MiscMessagesChanged then
		SWS_SaveTable(miscMessages, "SWS_MiscMessages.txt")
		SSQM_MiscMessagesChanged = false
	end
	if SSQM_NPCCellCountsChanged then
		SWS_SaveTable(survivorsInCell, "SWS_NPCCellCounts.txt")
		SSQM_NPCCellCountsChanged = false
	end
	if SSQM_NPCCellKeysChanged then
		SWS_SaveTable(spawnCellKeys, "SWS_NPCCellKeys.txt")
		SSQM_NPCCellKeysChanged = false
	end
	if SSQM_NPCTWTTChanged then
		SWS_SaveTable(npcsThatWantToTalk, "SWS_WantToTalkNPCs.txt")
		SSQM_NPCTWTTChanged = false
	end
end

function QuestManager:LoadFromFile()
	if SWS_DoesFileExist("SWS_QuestTriggers.txt") then
		local ssqmData = SWS_LoadTable("SWS_QuestTriggers.txt")
		SSQM.QuestCount = ssqmData.TriggerCount
		SSQM.Quests = ssqmData.Triggers
		lastQuestID = ssqmData.LastQuest
	end
	if SWS_DoesFileExist("SWS_QuestData.txt") then
		questData = SWS_LoadTable("SWS_QuestData.txt")
	end
	if SWS_DoesFileExist("SWS_WantToTalkNPCs.txt") then
		npcsThatWantToTalk = SWS_LoadTable("SWS_WantToTalkNPCs.txt")
	end
	if SWS_DoesFileExist("SWS_ActionQueue.txt") then
		actionQueue = SWS_LoadTable("SWS_ActionQueue.txt")
	end
	if SWS_DoesFileExist("SWS_FailedQuests.txt") then
		failedQuests = SWS_LoadTable("SWS_FailedQuests.txt")
	end
	if SWS_DoesFileExist("SWS_CompleteQuests.txt") then
		completeQuests = SWS_LoadTable("SWS_CompleteQuests.txt")
	end
	if SWS_DoesFileExist("SWS_ActiveQuests.txt") then
		activeQuests = SWS_LoadTable("SWS_ActiveQuests.txt")
	end
	if SWS_DoesFileExist("SWS_MiscMessages.txt") then
		miscMessages = SWS_LoadTable("SWS_MiscMessages.txt")
	end
	if SWS_DoesFileExist("SWS_NPCCellCounts.txt") then
		survivorsInCell = SWS_LoadTable("SWS_NPCCellCounts.txt")
	end
	if SWS_DoesFileExist("SWS_NPCCellKeys.txt") then
		spawnCellKeys = SWS_LoadTable("SWS_NPCCellKeys.txt")
	end
end

function QuestManager:KilledZombie()
	local zombieName = SWS_GetModText("Zombie")
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Target then
			if activeQuests[i].Target.Method == "kill" and activeQuests[i].Target.Name == zombieName then
				activeQuests[i].Target.Count = activeQuests[i].Target.Count - 1
				if activeQuests[i].Target.Count == 0 then
					activeQuests[i].Target.Count = -1
					self:update("GotTargetCount", activeQuests[i].QuestID)
				end
			end
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:KilledNPC(npcName, ID)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Target and activeQuests[i].Target.Method == "kill" then
			if activeQuests[i].Target.NPCID or activeQuests[i].Target.Name == npcName then
				if (not activeQuests[i].Target.NPCID) or activeQuests[i].Target.NPCID == ID then
					activeQuests[i].Target.Count = activeQuests[i].Target.Count - 1
					if activeQuests[i].Target.Count == 0 then
						activeQuests[i].Target.Count = -1
						self:update("GotTargetCount", activeQuests[i].QuestID)
					end
				end
			end
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:UpdateObjectsBuilt(objName, x, y)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Target and activeQuests[i].Target.X then
			if activeQuests[i].Target.Method == "build" and activeQuests[i].Target.ObjectName == objName then
				local targDist = getDistanceBetweenPoints(activeQuests[i].Target.X, activeQuests[i].Target.Y, x, y)
				if targDist <= activeQuests[i].Target.Range then
					activeQuests[i].Target.Count = activeQuests[i].Target.Count - 1
					if activeQuests[i].Target.Count == 0 then
						activeQuests[i].Target.Count = -1
						self:update("GotTargetCount", activeQuests[i].QuestID)
					end
				end
			end
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:UpdateItemsFound(itemID, foundNum)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Target then
			if activeQuests[i].Target.Method == "find" and activeQuests[i].Target.BaseID == itemID then
				if activeQuests[i].Target.Uses and activeQuests[i].Target.Uses > 1 then
					activeQuests[i].Target.Found = math.floor(foundNum/activeQuests[i].Target.Uses)
				else
					activeQuests[i].Target.Found = foundNum
				end
				if activeQuests[i].Target.Found >= activeQuests[i].Target.Count then
					activeQuests[i].Target.Count = -1
					self:update("GotTargetCount", activeQuests[i].QuestID)
				end
			end
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:GetRequiredObjects()
	local result = {}
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Target then
			if activeQuests[i].Target.Method == "build" then
				table.insert(result, activeQuests[i].Target.ObjectName)
			end
		end
	end
	return result
end

function QuestManager:GetRequiredItems()
	local result = {}
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Target then
			if activeQuests[i].Target.Method == "find" then
				table.insert(result, activeQuests[i].Target.BaseID)
			end
		end
	end
	return result
end

function QuestManager:GetQuestTitle(questID)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			return activeQuests[i].Title
		end
	end
	return false
end

function QuestManager:GetQuestDesc(questID)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			return activeQuests[i].Desc
		end
	end
	return false
end

function QuestManager:GetQuestTarget(questID)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			return activeQuests[i].Target
		end
	end
	return false
end

function QuestManager:GetTargetName(questTarget, remaining)
	if questTarget.Plural and remaining > 1 then
		return questTarget.Plural
	else
		return questTarget.Name
	end
end

function QuestManager:SetTargetCoords(questID, pos, txt, altPos, altTxt)
	if not pos then pos = {nil,nil} end
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			if activeQuests[i].Target then
				activeQuests[i].Target.X = pos[1]
				activeQuests[i].Target.Y = pos[2]
				activeQuests[i].Target.MapTitle = txt
			else
				activeQuests[i].Target = { X=pos[1], Y=pos[2], MapTitle=txt }
			end
			if altPos then
				activeQuests[i].Target.AltX = altPos[1]
				activeQuests[i].Target.AltY = altPos[2]
				activeQuests[i].Target.AltMapTitle = altTxt
			end
			SSQM_ActiveQuestsChanged = true
			break
		end
	end
end

function QuestManager:SetTargetNPC(questID, name, id, markMap)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			if activeQuests[i].Target then
				activeQuests[i].Target.Name = name
				activeQuests[i].Target.NPCID = id
				activeQuests[i].Target.MarkNPC = markMap
			else
				activeQuests[i].Target = { Name=name, NPCID=id, MarkNPC=markMap }
			end
			SSQM_ActiveQuestsChanged = true
			break
		end
	end
end

function QuestManager:CreateNPCPreset(npcPreset)
	local pX = 0
	local pY = 0
	local locZ = 0
	local groupID = nil
	local npcGreet = nil
	local npcPerks = nil
	local npcWeapon = nil
	local npcOrders = "Explore"
	local npcRole = "Worker"
	local npcSuit = "Preset_Survivalist"
	local npcName = SWS_GetModText("Survivor")
	local npcFemale = false
	local npcHostile = false
	local patrolling = false
	local noParty = false
	
	if npcPreset.PatrolX then pX = npcPreset.PatrolX end
	if npcPreset.PatrolY then pY = npcPreset.PatrolY end
	if npcPreset.GroupID then groupID = npcPreset.GroupID end
	if npcPreset.Greeting then npcGreet = npcPreset.Greeting end
	if npcPreset.Orders then npcOrders = npcPreset.Orders end
	if npcPreset.Suit then npcSuit = npcPreset.Suit end
	if npcPreset.Name then npcName = npcPreset.Name end
	if npcPreset.Role then npcRole = npcPreset.Role end
	if npcPreset.IsFemale then npcFemale = npcPreset.IsFemale end
	if npcPreset.NoParty then noParty = npcPreset.NoParty end
	if npcPreset.Z ~= nil then locZ = npcPreset.Z end
	if npcOrders == "Patrol" then patrolling = true end
	
	if npcPreset.Hostile ~= nil then
		npcHostile = npcPreset.Hostile
	end
	
	if npcPreset.Weapon then
		npcWeapon = getWeapon(npcPreset.Weapon)
	elseif npcPreset.Weapons then
		npcWeapon = SWS_RandomWeapon(npcPreset.Weapons)
	end
	
	if npcPreset.Perk1Name then npcPerks = {{ Name=npcPreset.Perk1Name, Level=npcPreset.Perk1Level }} end
	if npcPreset.Perk2Name then table.insert(npcPerks, { Name=npcPreset.Perk2Name, Level=npcPreset.Perk2Level }) end
	if npcPreset.Perk3Name then table.insert(npcPerks, { Name=npcPreset.Perk3Name, Level=npcPreset.Perk3Level }) end
	if npcPreset.Perk4Name then table.insert(npcPerks, { Name=npcPreset.Perk4Name, Level=npcPreset.Perk4Level }) end
	
	return {
		Suit = npcSuit, Name = npcName, Orders = npcOrders, Role = npcRole, GroupID = groupID,
		Greeting = npcGreet, X = npcPreset.X, Y = npcPreset.Y, Z = locZ,
		NoParty = noParty, isHostile = npcHostile, Weapon = npcWeapon, isFemale = npcFemale,
		Perks = npcPerks, Patrolling = patrolling, PX = pX, PY = pY
	}
end

function QuestManager:CreateGroupPresets(groupPreset)
	local pX = 0
	local pY = 0
	local locZ = 0
	local leaderGreet = nil
	local leaderPerks = nil
	local leaderWeap = nil
	local guardWeaps = nil
	local leaderRole = "Leader"
	local leaderOrders = "Standing Ground"
	local guardOrders = "Guard"
	local leaderSuit = "Preset_Leader"
	local guardSuit = "Preset_Guard"
	local leaderFemale = false
	local leaderHostile = false
	local guardsHostile = false
	local patrolling = false
	local noParty = false
	local hasBase = false
	local baseX = 0
	local baseY = 0
	
	if groupPreset.PatrolX then pX = groupPreset.PatrolX end
	if groupPreset.PatrolY then pY = groupPreset.PatrolY end
	if groupPreset.Greeting then leaderGreet = groupPreset.Greeting end
	if groupPreset.Orders then leaderOrders = groupPreset.Orders end
	if groupPreset.Suit then leaderSuit = groupPreset.Suit end
	if groupPreset.Role then leaderRole = groupPreset.Role end
	if groupPreset.IsFemale then leaderFemale = groupPreset.IsFemale end
	if groupPreset.GuardSuit then guardSuit = groupPreset.GuardSuit end
	if groupPreset.GuardsHostile then guardsHostile = groupPreset.GuardsHostile end
	if groupPreset.GuardWeapons then guardWeaps = groupPreset.GuardWeapons end
	if groupPreset.GuardOrders then guardOrders = groupPreset.GuardOrders end
	if groupPreset.NoParty then noParty = groupPreset.NoParty end
	if groupPreset.Z ~= nil then locZ = groupPreset.Z end
	if leaderOrders == "Patrol" then patrolling = true end
	
	if groupPreset.Weapons then
		leaderWeap = SWS_RandomWeapon(groupPreset.Weapons)
		if not guardWeaps then guardWeaps = groupPreset.Weapons end
	end
	
	if groupPreset.BaseX ~= nil then
		baseX = groupPreset.BaseX
		baseY = groupPreset.BaseY
		hasBase = true
	end
	
	if groupPreset.Hostile ~= nil then
		leaderHostile = groupPreset.Hostile
		if leaderHostile then
			guardsHostile = true; noParty = true
		end
	end
	if groupPreset.GuardsHostile ~= nil then guardsHostile = groupPreset.GuardsHostile end
	
	if groupPreset.Perk1Name then leaderPerks = {{ Name=groupPreset.Perk1Name, Level=groupPreset.Perk1Level }} end
	if groupPreset.Perk2Name then table.insert(leaderPerks, { Name=groupPreset.Perk2Name, Level=groupPreset.Perk2Level }) end
	if groupPreset.Perk3Name then table.insert(leaderPerks, { Name=groupPreset.Perk3Name, Level=groupPreset.Perk3Level }) end
	if groupPreset.Perk4Name then table.insert(leaderPerks, { Name=groupPreset.Perk4Name, Level=groupPreset.Perk4Level }) end
	
	local groupPresets = {{
		Suit = leaderSuit, Name = groupPreset.Name, Orders = leaderOrders, Role = leaderRole,
		Greeting = leaderGreet, X = groupPreset.X, Y = groupPreset.Y, Z = locZ, NoParty = noParty,
		isHostile = leaderHostile, Weapon = leaderWeap, isFemale = leaderFemale, Perks = leaderPerks,
		Patrolling = patrolling, PX = pX, PY = pY, BX = baseX, BY = baseY, HasBase = hasBase
	}}
	
	if groupPreset.Guards and groupPreset.Guards > 0 then
		guardOrders = SWS_SplitString(guardOrders, ",")
		for i=1, groupPreset.Guards do
			local guardWeap = nil
			local guardOrder = guardOrders[1]
			local guardPosX = groupPreset.X
			local guardPosY = groupPreset.Y
			if ZombRand(2) == 0 then
				guardPosX = guardPosX + ZombRand(4)+1
			else
				guardPosX = guardPosX - (ZombRand(4)+1)
			end
			if ZombRand(2) == 0 then
				guardPosY = guardPosY + ZombRand(4)+1
			else
				guardPosY = guardPosY - (ZombRand(4)+1)
			end
			if guardWeaps then
				guardWeap = SWS_RandomWeapon(guardWeaps)
			end
			if i <= #guardOrders then guardOrder = guardOrders[i] end
			local groupMemberPreset = {
				Suit = guardSuit, Name = groupPreset.GuardName, Orders = guardOrder, Role = "Guard",
				X = guardPosX, Y = guardPosY, Z = locZ, NoParty = noParty, isHostile = guardsHostile, Weapon = guardWeap
			}
			table.insert(groupPresets, groupMemberPreset)
		end
	end
	
	return groupPresets
end

local function QuestInfoWindowCreateNew()
	print("SWS: creating QuestInfoWindow")
	local FONT_HGT_SMALL = getTextManager():getFontHeight(UIFont.Small)
	myQuestInfoWindow = QuestInfoWindow:new(400, 270, FONT_HGT_SMALL * 6 + 250, FONT_HGT_SMALL * 10 + 300)
	myQuestInfoWindow:addToUIManager()
	myQuestInfoWindow:setVisible(false)
	myQuestInfoWindow.pin = true
	myQuestInfoWindow.resizable = false
end

local function QuestManagerKeyDownHandleNew(keyNum)

	if getSpecificPlayer(0) then
		--print("keyNum: " .. tostring(keyNum))
	
		if keyNum == getCore():getKey("Open Quest Info Window") then -- i key (23)
		
			if not myQuestInfoWindow then QuestInfoWindowCreateNew() end
			
			myQuestInfoWindow:setVisible(not myQuestInfoWindow:getIsVisible())
			
		elseif keyNum == 57 then -- space key
				
			if SSQM and SSQM.BannerMSG then
				SSQM.BannerMSG:removeFromUIManager()
				SSQM.BannerMSG = nil
				SSQM.ShownBannerMSGCount = 0
			end
			
			myDialogueWindow:skip()
		
		elseif keyNum == 199 then -- home key
		
			local mainPlayer = getSpecificPlayer(0)
			mainPlayer:Say(SWS_GetModText("MyCoordsAre")..math.floor(mainPlayer:getX()) .. ", " .. math.floor(mainPlayer:getY()))
			
		end	
	end
end

function QuestManager:UpdateQuestInfoWindow()
	local questTitle = ""
	local infoText = ""
	local doneText = ""
	local failText = ""
	local miscText = ""
	
	SSQM_ActiveQuestsChanged = true
	
	if #activeQuests > 0 then
		for i=#activeQuests, 1, -1 do
			if activeQuests[i] then
			
				questTitle = string.upper(activeQuests[i].Title)
				infoText = infoText .. questTitle .. "\n\n" .. activeQuests[i].Desc .. "\n\n"
				
				if activeQuests[i].Target then
				
					local itemsReq = 0
					if activeQuests[i].Target.Count then
						itemsReq = activeQuests[i].Target.Count
						if activeQuests[i].Target.Found then
							itemsReq = itemsReq - activeQuests[i].Target.Found
						end
					end
					
					if itemsReq > 0 then
						if activeQuests[i].Target.Method == "kill" then
							if activeQuests[i].Target.Plural then
								local targetName = self:GetTargetName(activeQuests[i].Target, itemsReq)
								infoText = infoText .. SWS_GetModText("GoalKill") .. tostring(itemsReq) .. SWS_GetModText("More") .. targetName .. "\n\n"
							else
								infoText = infoText .. SWS_GetModText("GoalKill") .. activeQuests[i].Target.Name .. "\n\n"
							end
						elseif activeQuests[i].Target.Method == "find" then
							if activeQuests[i].Target.Plural then
								local targetName = self:GetTargetName(activeQuests[i].Target, itemsReq)
								infoText = infoText .. SWS_GetModText("GoalFind") .. tostring(itemsReq) .. SWS_GetModText("More") .. targetName .. "\n\n"
							else
								infoText = infoText .. SWS_GetModText("GoalFind") .."1 ".. activeQuests[i].Target.Name .. "\n\n"
							end
						elseif activeQuests[i].Target.Method == "build" then
							local targDist = getDistanceBetweenPoints(getSpecificPlayer(0):getX(), getSpecificPlayer(0):getY(), activeQuests[i].Target.X, activeQuests[i].Target.Y)
							if targDist > activeQuests[i].Target.Range then
								infoText = infoText .. SWS_GetModText("GoalGoTo") .. " \n\n"
							else
								if activeQuests[i].Target.Plural then
									local targetName = self:GetTargetName(activeQuests[i].Target, itemsReq)
									infoText = infoText .. SWS_GetModText("GoalBuild") .. tostring(itemsReq) .. SWS_GetModText("More") .. targetName .. "\n\n"
								else
									infoText = infoText .. SWS_GetModText("GoalBuild") .. activeQuests[i].Target.Name .. "\n\n"
								end
							end
						end
					end
				end
				
				if activeQuests[i].Reward then
					infoText = infoText .. SWS_GetModText("RewardColon") .. tostring(activeQuests[i].Reward.Amount) .. SWS_GetModText("TimesSymbol") .. activeQuests[i].Reward.Name .. "\n\n"
				end
			end
		end
	end
	
	if #completeQuests > 0 then
		for i=#completeQuests, 1, -1 do
			doneText = doneText .. string.upper(completeQuests[i].Title) .. "\n\n" .. completeQuests[i].Desc .. "\n\n"
		end
	end
	
	if #failedQuests > 0 then
		for i=#failedQuests, 1, -1 do
			failText = failText .. string.upper(failedQuests[i].Title) .. "\n\n" .. failedQuests[i].Desc .. "\n\n"
		end
	end
	
	if #miscMessages > 0 then
		for i=#miscMessages, 1, -1 do
			miscText = miscText .. "- " .. miscMessages[i] .. "\n\n"
		end
	end
	
	if infoText == "" then infoText = SWS_GetModText("NoActiveQuests") end
	if doneText == "" then doneText = SWS_GetModText("NoCompQuests") end
	if failText == "" then failText = SWS_GetModText("NoFailedQuests") end
	if miscText == "" then miscText = SWS_GetModText("NoMsgHistory") end
	
	if myQuestInfoWindow then
		myQuestInfoWindow:setText(infoText, "Active")
		myQuestInfoWindow:setText(doneText, "Completed")
		myQuestInfoWindow:setText(failText, "Failed")
		myQuestInfoWindow:setText(miscText, "Misc")
	end
end

function QuestManager:ShowMessage(message, saveMisc)
	self:SetBannerMSG(message)
	if saveMisc then
		table.insert(miscMessages, message)
		SSQM_MiscMessagesChanged = true
		self:UpdateQuestInfoWindow()
	end
end

function QuestManager:RunTriggerActions(thisName)
	for i=1, self.QuestCount do
		if self.Quests[i] ~= nil then 
			local trigger = self.Quests[i]
			if trigger and trigger.TriggerName == thisName then 
				self:PerformTriggerActions(trigger.ResultActions,trigger.TriggerName)
				return
			end
		end
	end
end

function QuestManager:RemoveTriggersWithName(thisName)
	for i=1, self.QuestCount do
		if self.Quests[i] and self.Quests[i].Name == thisName then 
			--if self.Quests[i].OnComplete then self.Quests[i]:OnComplete() end
			self.Quests[i] = nil
			for t=i, self.QuestCount do
				if self.Quests[t+1] then
					self.Quests[t] = self.Quests[t+1]
					self.Quests[t+1] = nil
				end
			end
			self.QuestCount = self.QuestCount - 1
			SSQM_QuestTriggersChanged = true
		end
	end
end

function QuestManager:RemoveTrigger(thisName)
	for i=1, self.QuestCount do
		if self.Quests[i] and self.Quests[i].TriggerName == thisName then 
			--if self.Quests[i].OnComplete then self.Quests[i]:OnComplete() end
			self.Quests[i] = nil
			for t=i, self.QuestCount do
				if self.Quests[t+1] then
					self.Quests[t] = self.Quests[t+1]
					self.Quests[t+1] = nil
				end
			end
			self.QuestCount = self.QuestCount - 1
			SSQM_QuestTriggersChanged = true
			break
		end
	end
end

function QuestManager:RemoveAllTriggers()
	self.QuestCount = 0
	self.Quests = {}
	SSQM_QuestTriggersChanged = true
end

function QuestManager:SetTriggerEnabled(thisName, newValue)
	for i=1, self.QuestCount do
		if self.Quests[i] and self.Quests[i].TriggerName == thisName then 
			self.Quests[i].Enabled = newValue
			SSQM_QuestTriggersChanged = true
			break
		end
	end
end

function QuestManager:TriggerEnabled(thisName)
	for i=1, self.QuestCount do
		if self.Quests[i] and self.Quests[i].TriggerName == thisName then
			return self.Quests[i].Enabled
		end
	end
	return false
end

function QuestManager:AddTrigger(newTrigger)
	if newTrigger == nil then
		print("SWS: warning nil trigger provided to QuestManager:AddTrigger()")
		return false
	end
	self.QuestCount = self.QuestCount + 1
	self.Quests[self.QuestCount] = newTrigger
	SSQM_QuestTriggersChanged = true
end

function QuestManager:AddTriggers(newTriggers)
	if newTriggers == nil then
		print("SWS: warning no triggers provided to QuestManager:AddTriggers()")
		return false
	end
	for i=1, #newTriggers do
		self:AddTrigger(newTriggers[i])
	end
end

function QuestManager:AddTriggerTop(newTrigger)
	if newTrigger == nil then
		print("SWS: warning nil trigger provided to QuestManager:AddTriggerTop()")
		return false
	end
	
	if self.QuestCount > 0 then
		self.Quests[self.QuestCount+1] = self.Quests[self.QuestCount]
		
		for i=self.QuestCount, 2, -1 do
			self.Quests[i] = self.Quests[i-1]
		end
	end
	
	self.QuestCount = self.QuestCount + 1
	self.Quests[1] = newTrigger
	SSQM_QuestTriggersChanged = true
end

function QuestManager:AddQuestTrigger(questID, trigger)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			print("SWS: adding trigger "..trigger.TriggerName.." to quest "..questID)
			table.insert(activeQuests[i].Triggers, trigger.TriggerName)
			self:AddTrigger(trigger)
			SSQM_ActiveQuestsChanged = true
			return true
		end
	end
	return false
end

function QuestManager:AddQuestTriggers(questID, triggers)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			for t=#triggers, 1, -1 do
				print("SWS: adding trigger "..triggers[t].TriggerName.." to quest "..questID)
				table.insert(activeQuests[i].Triggers, triggers[t].TriggerName)
				self:AddTrigger(triggers[t])
			end
			SSQM_ActiveQuestsChanged = true
			return true
		end
	end
	return false
end

function QuestManager:BeginQuest(questTitle, questDesc, questGiver, questTarget, questReward, triggers)
	self:ShowMessage(SWS_GetModText("StartQuestMsg") .. questTitle .."\n\n".. SWS_GetModText("QuestInfoMsg"))
	getSoundManager():PlaySound("unlock", false, 0.8)
	
	if not triggers then triggers = {} end
	if not questDesc then questDesc = SWS_GetModText("NoQuestInfo") end
	local doneDesc = "- " .. questDesc
	
	if questTarget and questTarget.Method and questTarget.Count then
		local targetName = self:GetTargetName(questTarget, questTarget.Count)
		if questTarget.Count > 1 then
			doneDesc = SWS_GetModText("CompletedGoal") .. questTarget.Method .. " " .. questTarget.Count .. " " .. targetName
		else
			doneDesc = SWS_GetModText("CompletedGoal") .. questTarget.Method .. " "  .. targetName
		end
	end
	
	lastQuestID = lastQuestID + 1
	local doInsert = true
	local questInfo = {
		QuestID=lastQuestID,
		Giver=questGiver,
		Title=questTitle,
		Desc=questDesc,
		DoneDesc=doneDesc,
		Target=questTarget,
		Reward=questReward,
		Triggers={}
	}
	
	for i=1, #activeQuests do
		if activeQuests[i] == nil then
			activeQuests[i] = questInfo
			doInsert = false
			break
		end
	end
	
	if doInsert then
		table.insert(activeQuests, questInfo)
	end
	
	for i=1, #triggers do
		table.insert(questInfo.Triggers, triggers[i].TriggerName)
		self:AddTriggerTop(triggers[i])
	end
	
	self:UpdateQuestInfoWindow()
	SSQM_QuestTriggersChanged = true
	return lastQuestID
end

function QuestManager:EndQuest(questID, failReason)
	local questTitle = self:GetQuestTitle(questID)
	if not questTitle then return false end
	
	if not failReason then
		self:ShowMessage(SWS_GetModText("CompQuestMsg") .. questTitle)
		getSoundManager():PlaySound("unlock", false, 0.8)
	end
	
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			if failReason then
				--if activeQuests[i].FailFunc and customFuncRefs[activeQuests[i].FailFunc] then
				--	local failFunc = customFuncRefs[activeQuests[i].FailFunc]
				--	if activeQuests[i].FailArgs ~= nil then
				--		failFunc(activeQuests[i].FailArgs)
				--	else
				--		failFunc()
				--	end
				--end
				table.insert(failedQuests, { Title=questTitle, Desc=failReason })
				SSQM_FailedQuestsChanged = true
			else
				table.insert(completeQuests, { Title=questTitle, Desc=activeQuests[i].DoneDesc })
				SSQM_CompleteQuestsChanged = true
			end
			local questCount = #activeQuests
			local triggers = activeQuests[i].Triggers
			for t=1, #triggers do
				self:RemoveTrigger(triggers[t])	
			end
			activeQuests[i] = nil
			for ii=i, questCount do
				if activeQuests[ii+1] and activeQuests[ii+1].QuestID > 0 then
					activeQuests[ii] = activeQuests[ii+1]
					activeQuests[ii+1] = nil
				end
			end
			self:UpdateQuestInfoWindow()
			return true
		end
	end
	
	return false
end

function QuestManager:FailQuest(questID, failReason)
	if questID and questID > 0 then
		local questTitle = self:GetQuestTitle(questID)
		if questTitle and self:EndQuest(questID, failReason) then
			self:ShowMessage(SWS_GetModText("FailQuestMsg") .. questTitle .."\n\n".. failReason)
		end
	end
end

--function QuestManager:SetFailFunc(questID, funcName, args)
--	for i=1, #activeQuests do
--		if activeQuests[i] and activeQuests[i].QuestID == questID then
--			activeQuests[i].FailFunc = funcName
--			activeQuests[i].FailArgs = args
--			break
--		end
--	end
--end

function QuestManager:UpdateQuestTitle(questID, newTitle)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			activeQuests[i].Title = newTitle
			break
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:UpdateQuestDesc(questID, newDesc)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			activeQuests[i].Desc = newDesc
			if not (activeQuests[i].Target and activeQuests[i].Target.Method) then
				activeQuests[i].DoneDesc = activeQuests[i].DoneDesc .. "\n\n- " .. newDesc
			end
			break
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:SetQuestGiver(questID, newGiver)
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].QuestID == questID then
			activeQuests[i].Giver = newGiver
			break
		end
	end
	self:UpdateQuestInfoWindow()
end

function QuestManager:SetGlobalData(dataName, dataVal)
	for i=1, #questData do
		if questData[i] and questData[i].Name == dataName then
			questData[i].Value = dataVal
			return
		end
	end
	table.insert(questData, { Name=dataName, Value=dataVal })
	SSQM_QuestDataChanged = true
end

function QuestManager:GetGlobalData(dataName, defaultVal)
	SSQM_QuestDataChanged = true
	for i=1, #questData do
		if questData[i] and questData[i].Name == dataName then
			return questData[i].Value
		end
	end
	if defaultVal ~= nil then
		self:SetGlobalData(dataName, defaultVal)
	end
	return defaultVal
end

function QuestManager:IncGlobalData(dataName, incVal)
	for i=1, #questData do
		if questData[i] and questData[i].Name == dataName then
			questData[i].Value = questData[i].Value + incVal
			SSQM_QuestDataChanged = true
			return
		end
	end
end

function QuestManager:DelayActions(actions, delay)
	for i=1, #actionQueue do
		if actionQueue[i] == nil then
			actionQueue[i] = { Actions=actions, Delay=delay }
			SSQM_ActionQueueChanged = true
			return
		end
	end
	table.insert(actionQueue, { Actions=actions, Delay=delay })
	SSQM_ActionQueueChanged = true
end

function QuestManager:CheckQuestGivers()
	for i=1, #activeQuests do
		if activeQuests[i] and activeQuests[i].Giver then
			local SS = SSM:Get(activeQuests[i].Giver)
			if SS then
				--TODO: create better way of checking if npc is hostile towards player
				--if SS:isEnemy(getSpecificPlayer(0)) then
				--	self:FailQuest(activeQuests[i].QuestID, SWS_GetModText("QuestGiverAgro"))
				--	break
				--end
			end
		end
	end
end

function QuestManager:CheckDeadNPC(name, id)
	for i=1, #activeQuests do
		if activeQuests[i] then
			if activeQuests[i].Giver and activeQuests[i].Giver == id then
				self:FailQuest(activeQuests[i].QuestID, SWS_GetModText("QuestGiverDead"))
			elseif activeQuests[i].Target then
				if ((not activeQuests[i].Target.Method) or activeQuests[i].Target.Method ~= "kill") and 
				((activeQuests[i].Target.NPCID ~=nil and activeQuests[i].Target.NPCID == id) 
				or (activeQuests[i].Target.Name and activeQuests[i].Target.Name == name)) then
					self:FailQuest(activeQuests[i].QuestID, name..SWS_GetModText("HasDied"))
				end
			end
		end
	end
end

function QuestManager:CheckNPCWantsToTalk(npcID)
	local SS = SSM:Get(npcID)
	if not SS then return end
	for i=1, #npcsThatWantToTalk do
		if npcsThatWantToTalk[i] then
			if (npcsThatWantToTalk[i].ID and npcsThatWantToTalk[i].ID == npcID) or	
			(npcsThatWantToTalk[i].Name and npcsThatWantToTalk[i].Name == SS:getName()) then
				SS.HasBikuri = true
				break
			end
		end
	end
end

function QuestManager:SetNPCWantsToTalk(npcID, wantsToTalk)
	if wantsToTalk then
		for i=1, #npcsThatWantToTalk do
			if npcsThatWantToTalk[i] == nil then
				npcsThatWantToTalk[i] = { ID=npcID }
				SSQM_NPCTWTTChanged = true
				return
			end
		end
		table.insert(npcsThatWantToTalk, { ID=npcID })
	else
		for i=1, #npcsThatWantToTalk do
			if npcsThatWantToTalk[i] and npcsThatWantToTalk[i].ID == npcID then
				npcsThatWantToTalk[i] = nil
				SSQM_NPCTWTTChanged = true
			end
		end
	end
end

function QuestManager:SetNPCWantsToTalkByName(npcName, wantsToTalk)
	if wantsToTalk then
		for i=1, #npcsThatWantToTalk do
			if npcsThatWantToTalk[i] == nil then
				npcsThatWantToTalk[i] = { Name=npcName }
				SSQM_NPCTWTTChanged = true
				return
			end
		end
		table.insert(npcsThatWantToTalk, { Name=npcName })
	else
		for i=1, #npcsThatWantToTalk do
			if npcsThatWantToTalk[i] and npcsThatWantToTalk[i].Name == npcName then
				npcsThatWantToTalk[i] = nil
				SSQM_NPCTWTTChanged = true
			end
		end
	end
end

function QuestManager:SetCustomFunc(funcName, funcRef)
	customFuncRefs[funcName] = funcRef
end

function QuestManager:GetCustomFunc(funcName)
	return customFuncRefs[funcName]
end

function QuestManager:AnswerChosen(triggername, resultactions)
	if triggername then
		self:PerformTriggerActions(resultactions, triggername)
	else
		print("SWS: warning nil trigger name provided to QuestManager:AnswerChosen()")
	end
end

function QuestManager:GetActiveQuests()
	return activeQuests
end

function DialogueWindow:setYesBtnTitle(newTitle)
	self.YesButton:setTitle(newTitle)
end

function DialogueWindow:setNoBtnTitle(newTitle)
	self.NoButton:setTitle(newTitle)
end

function DialogueWindow:setContBtnTitle(newTitle)
	self.ContinueButton:setTitle(newTitle)
end

function SuperSurvivorRandomSpawnNew(square, giveStuff)

	print("SWS: spawning random survivor")
	local hoursSurvived = math.floor(getGameTime():getWorldAgeHours())
	local ASuperSurvivor = SSM:spawnSurvivor(nil, square, true)

	local FinalChanceToBeHostile = ChanceToBeHostileNPC + math.floor(hoursSurvived/48)
	if (FinalChanceToBeHostile > MaxChanceToBeHostileNPC) and (ChanceToBeHostileNPC < MaxChanceToBeHostileNPC) then FinalChanceToBeHostile = MaxChanceToBeHostileNPC end
	
	if ASuperSurvivor then
		if(ZombRand(100) < (ChanceToSpawnWithGun + math.floor(hoursSurvived/48))) then 
			ASuperSurvivor:giveWeapon(getWeapon(RangeWeapons[ZombRand(#RangeWeapons)+1]),true)
			SWS_IncreaseSkillLevel(ASuperSurvivor.player, "Firearm", 2+ZombRand(3), 9)
		elseif(ZombRand(100) < (ChanceToSpawnWithWep + math.floor(hoursSurvived/48))) then 
			ASuperSurvivor:giveWeapon(MeleWeapons[ZombRand(#MeleWeapons)+1],true) 
		end
		if ZombRand(100) < FinalChanceToBeHostile then ASuperSurvivor:setHostile(true) end
		
		if giveStuff then
			ASuperSurvivor:giveRandomFood()
			getRandomSurvivorSuit(ASuperSurvivor)
		end
	end

	return ASuperSurvivor
end

local function SuperSurvivorsLoadGridsquareNew(square)

	if square ~= nil then
		local x = square:getX()
		local y = square:getY()
		local z = square:getZ()
		local key = x .. y .. z
		
		if SurvivorMap == nil then
			
			local sc = 1;
			RPresetSpawns = {};
			while PresetSpawns[sc] do
				if PresetSpawns[sc].Z == nil then PresetSpawns[sc].Z = 0 end
				local pindex = PresetSpawns[sc].X .. PresetSpawns[sc].Y .. PresetSpawns[sc].Z
				RPresetSpawns[pindex] = PresetSpawns[sc]
				RPresetSpawns[pindex].ID = sc
				sc = sc + 1;
			end
			
			SSM:init()
			SSGM:Load()
			HillTopGroup:AllSpokeTo()
			BlockadeGroup:AllSpokeTo()
			
			local gameVersion = getCore():getGameVersion()
			IsDamageBroken = (gameVersion:getMajor() >= 41 and gameVersion:getMinor() > 50 and gameVersion:getMinor() < 53)
			IsNpcDamageBroken = (gameVersion:getMajor() >= 41 and gameVersion:getMinor() >= 53)
	
			if IsDamageBroken then
				MaxChanceToBeHostileNPC = 0
			end
			if IsDamageBroken then
				RaidsStartAfterThisManyHours = 9999999
			end
					
			if(doesFileExist("SurvivorLocX")) then 
				SurvivorMap = loadSurvivorMap()
				print("Survivor map loaded")
			else 
				SurvivorMap = {} 
				SurvivorLocX = {}
				SurvivorLocY = {}
				SurvivorLocZ = {}
				print("Survivor map set")
			end
		
		end
		
		if key and (SurvivorMap[key] ~= nil) and (#SurvivorMap[key] > 0) then		
			local i = 1
			while(SurvivorMap[key][i] ~= nil) do								
				SSM:LoadSurvivor(SurvivorMap[key][i], square)
				i = i + 1
			end
			i = 1
			SurvivorMap[key] = {}		
		end
		
		if (square:getModData().SurvivorSquareLoaded == nil) and (square:getZ()==0 or square:isOutside()==false) and (not SuperSurvivorPresetSpawn(square)) then
		
			SurvivorMap[key] = {}
			square:getModData().SurvivorSquareLoaded = true
			local hoursSurvived = math.floor(getGameTime():getWorldAgeHours())
			
			if (SuperSurvivorSpawnRate ~= 0) and (ZombRand(SuperSurvivorSpawnRate + hoursSurvived) == 0) and (square:getZoneType() == "TownZone") and (not square:isSolid()) then
		
				local newSS = SuperSurvivorRandomSpawn(square, true)
				print("SWS: LOAD GRID SQUARE SPAWN AT " .. key)
				
			end
		end
	end
end

local function SuperSurvivorsSurvivorManagerNew()
	local mainPlayer = getSpecificPlayer(0)
	if AlternativeSpawning == 1 or mainPlayer:isAsleep() then
		return false 
	end

	--this needs to run every once in a while
	mainPlayer:getModData().hitByCharacter = false
	mainPlayer:getModData().semiHostile = false
	mainPlayer:getModData().dealBreaker = nil
	
	local square = mainPlayer:getCurrentSquare()
	local cellX = math.floor(square:getX() / 300.0)
	local cellY = math.floor(square:getY() / 300.0)
	local cellKey = "x"..cellX.."y"..cellY
	print("SWS: GROUP SPAWN CELL KEY IS "..cellKey)

	if survivorsInCell[cellKey] and survivorsInCell[cellKey] < SWS_NPC_CELL_SPAWN_MAX then
		SWS_SpawnSurvivorGroup()
	end
end

local function SSM_LoadSurvivorNew(self, ID, square)
	if SSM_LoadSurvivorOrig(self, ID, square) == false then return false end
	SSQM:CheckNPCWantsToTalk(ID)
end

local function SSM_spawnSurvivorNew(self, isFemale, square, skipCheck)
	local cellX = math.floor(square:getX() / 300.0)
	local cellY = math.floor(square:getY() / 300.0)
	local cellKey = "x"..cellX.."y"..cellY
	print("SWS: SURVIVOR SPAWN CELL KEY IS "..cellKey)
	if not survivorsInCell[cellKey] then
		survivorsInCell[cellKey] = 1
		SSQM_NPCCellCountsChanged = true
	elseif skipCheck or survivorsInCell[cellKey] < SWS_NPC_CELL_SPAWN_MAX then
		survivorsInCell[cellKey] = survivorsInCell[cellKey] + 1
		SSQM_NPCCellCountsChanged = true
	else
		print("SWS: survivor limit reached for current cell")
		return
	end
	
	print("SWS: survivor count for current cell is "..survivorsInCell[cellKey])
	local SS = SSM_spawnSurvivorOrig(self, isFemale, square)
	if SS then
		SWS_RemoveZombiesAroundSquare(square)
		spawnCellKeys[SS:getID()] = cellKey
		SSQM_NPCCellKeysChanged = true
		return SS
	else
		print("SWS: SSM_spawnSurvivorOrig returned invalid SS")
		survivorsInCell[cellKey] = survivorsInCell[cellKey] - 1
		SSQM_NPCCellCountsChanged = true
	end
end

local function SSM_OnDeathNew(self, ID)
	SSM_OnDeathOrig(self, ID)
	local cellKey = spawnCellKeys[ID]
	if survivorsInCell[cellKey] then
		if survivorsInCell[cellKey] > 0 then
			survivorsInCell[cellKey] = survivorsInCell[cellKey] - 1
			SSQM_NPCCellCountsChanged = true
		end
		spawnCellKeys[ID] = nil
		SSQM_NPCCellKeysChanged = true
	end
end

local function SuperSurvivor_OnDeathNew(self)
	SuperSurvivor_OnDeathOrig(self)
	local npcName = self:getName()
	local npcID = self:getID()
	SSQM:KilledNPC(npcName, npcID)
	SSQM:CheckDeadNPC(npcName, npcID)
end

local function SuperSurvivorPresetQuestSpawn(PresetSpawn)
	
	local square = getCell():getGridSquare(PresetSpawn.X,PresetSpawn.Y,PresetSpawn.Z)
	
	if not (square and IsSquareFloorAndFree(square)) then
		square = FindFreeAdjacentSquare(PresetSpawn.X,PresetSpawn.Y,PresetSpawn.Z)
	end
	
	if not square then return false end
	if (square:getModData().thisSquareSpawnedPreset == true) then return false end
	
	local isFemale = false
	if PresetSpawn.isFemale ~= nil then isFemale = PresetSpawn.isFemale end
	
	local SuperSurvivor = SSM:spawnSurvivor(isFemale,square,true)
	if (SuperSurvivor == nil) then return false end
	
	if (PresetSpawn.AIMode ~= nil) then SuperSurvivor:setAIMode(PresetSpawn.AIMode) end
				
	SuperSurvivor.player:setZ(PresetSpawn.Z)
	
	if (PresetSpawn.GroupID ~= nil) then	
		local Role = PresetSpawn.Role
		if not Role then Role = "Worker" end
		local tempGroup = SSGM:Get(PresetSpawn.GroupID)
		
		if PresetSpawn.HasBase then
			local baseBounds = {
				PresetSpawn.BX - 30, PresetSpawn.BX + 30,
				PresetSpawn.BY - 30, PresetSpawn.BY + 30, 0
			}
			local forageBounds = {
				baseBounds[1] - 20, baseBounds[2] + 20,
				baseBounds[3] - 20, baseBounds[4] + 20
			}
			
			tempGroup:setBounds(baseBounds)
			tempGroup:setGroupArea("ForageArea", forageBounds[1],forageBounds[2],forageBounds[3],forageBounds[4],0)
			tempGroup:setGroupArea("ChopTreeArea", forageBounds[1],forageBounds[2],forageBounds[3],forageBounds[4],0)
			
			local baseSquare = getCell():getGridSquare(PresetSpawn.BX,PresetSpawn.BY,0)
			if baseSquare and baseSquare:getBuilding() then
				SuperSurvivor:setBaseBuilding(baseSquare:getBuilding())
			end
		end
		
		tempGroup:addMember(SuperSurvivor,Role)
	end
	
	local tempTM = SuperSurvivor:getTaskManager()
	tempTM:clear()
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Guard") then				
		tempTM:AddToTop(GuardTask:new(SuperSurvivor,SuperSurvivor.player:getCurrentSquare()))
		SuperSurvivor:setAIMode("Guard")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Doctor") then				
		tempTM:AddToTop(DoctorTask:new(SuperSurvivor))
		SuperSurvivor:setAIMode("Doctor")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Farming") then				
		tempTM:AddToTop(FarmingTask:new(SuperSurvivor))
		SuperSurvivor:setAIMode("Farmer")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Wander") or (PresetSpawn.Orders == "Explore") then				
		tempTM:AddToTop(WanderTask:new(SuperSurvivor))
		SuperSurvivor:setAIMode("Wander")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "FollowRoute") then	
		local routeID = PresetSpawn.RouteID 
		tempTM:AddToTop(FollowRouteTask:new(SuperSurvivor,routeID))
		SuperSurvivor:setAIMode("FollowRoute")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Standing Ground") then
		SuperSurvivor:setWalkingPermitted(false)
		SuperSurvivor:setAIMode("Stand Ground")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Forage") then
		tempTM:AddToTop(ForageTask:new(SuperSurvivor))
		SuperSurvivor:setAIMode("Forage")
	end
	
	if (PresetSpawn.Orders ~= nil) and (PresetSpawn.Orders == "Chop Wood") then
		SuperSurvivor.player:getInventory():AddItem("Base.WoodAxe")
		tempTM:AddToTop(ChopWoodTask:new(SuperSurvivor))
		SuperSurvivor:setAIMode("Chop Wood")
	end
	
	if PresetSpawn.Patrolling then
		local spawnSquare = SuperSurvivor.player:getCurrentSquare()
		local patrolPoint = { spawnSquare:getX()+PresetSpawn.PX, spawnSquare:getY()+PresetSpawn.PY }
		local patrolSquare = getCell():getGridSquare(patrolPoint[1],patrolPoint[2],PresetSpawn.Z)				
		SuperSurvivor.player:getModData().PX = patrolPoint[1]
		SuperSurvivor.player:getModData().PY = patrolPoint[2]
		SuperSurvivor.player:getModData().PZ = PresetSpawn.Z
		tempTM:AddToTop(PatrolTask:new(SuperSurvivor,spawnSquare,patrolSquare))
		SuperSurvivor:setAIMode("Patrol")		
	end
	
	if (PresetSpawn.NoParty ~= nil) then 
		SuperSurvivor.player:getModData().NoParty = PresetSpawn.NoParty
	end
	
	if (PresetSpawn.isHostile == true) then SuperSurvivor:setHostile(true) end
	SuperSurvivor.player:getModData().seenZombie = true
				
	if (PresetSpawn.Weapon ~= nil) then
		SuperSurvivor:giveWeapon(PresetSpawn.Weapon,true)
	end
	if (PresetSpawn.ShowName ~= nil) then
		SuperSurvivor.player:getModData().ShowName = true
	end
	if (PresetSpawn.Greeting) then
		SuperSurvivor.player:getModData().Greeting = PresetSpawn.Greeting
	end
	if (PresetSpawn.InitGreeting) then
		SuperSurvivor.player:getModData().InitGreeting = PresetSpawn.InitGreeting
	end
	SuperSurvivor:setName(PresetSpawn.Name)
	
	if PresetSpawn.Perks ~= nil then
		for i=1, #PresetSpawn.Perks do
			if PresetSpawn.Perks[i].Name and PresetSpawn.Perks[i].Level then
				local perk = Perks.FromString(PresetSpawn.Perks[i].Name)
				if perk and (tostring(perk) ~= "MAX") then
					local level = PresetSpawn.Perks[i].Level
					local count = 0
					while(count < level) do
						SuperSurvivor.player:LevelPerk(perk)
						count = count + 1
					end
				end
			end
		end
	end
	
	if (PresetSpawn.Suit ~= nil) then
		SuperSurvivor:wearSuit(SWS_GetPresetClothes(PresetSpawn.Suit))
	end
	
	return SuperSurvivor
end

local function SetupDialogueWindow(SS, action)
	SS.ContinueResultActions = action.ContinueResultActions
	SS.NoResultActions = nil
	SS.YesResultActions = nil
	if action.isYesOrNoQuestion or action.ActionType == "SSQuestionDialogueW" then
		--SS.HasQuestion = true
		SS.NoResultActions = action.NoResultActions
		SS.YesResultActions = action.YesResultActions
		if action.YesBtnText then myDialogueWindow:setYesBtnTitle(action.YesBtnText) else myDialogueWindow:setYesBtnTitle(SWS_GetModText("Yes")) end
		if action.NoBtnText then myDialogueWindow:setNoBtnTitle(action.NoBtnText) else myDialogueWindow:setNoBtnTitle(SWS_GetModText("No")) end
	end
	if action.ContinueBtnText then myDialogueWindow:setContBtnTitle(action.ContinueBtnText) else myDialogueWindow:setContBtnTitle(SWS_GetModText("Continue")) end
end

local function SetLastDialogueAction(action)
	if action.DialogueLevel == nil then
		lastDialogueActions[2] = lastDialogueActions[1]
		lastDialogueActions[1] = action
	else
		lastDialogueActions[action.DialogueLevel] = action
	end
end

local function QuestManagerInitNew(newplayerID)
	QuestManagerInitOrig(newplayerID)
	SSQM.QuestCount = 0
	SSQM.Quests = {}
	SSQM.Quests[0] = nil
end

local function GetActionFuncArgs(action)
	local args = {}
	if action.Arg1 ~= nil then
		table.insert(args, action.Arg1)
	end
	if action.Arg2 ~= nil then
		table.insert(args, action.Arg2)
	end
	if action.Arg3 ~= nil then
		table.insert(args, action.Arg3)
	end
	if action.Arg4 ~= nil then
		table.insert(args, action.Arg4)
	end
	if #args == 1 then
		return args[1]
	elseif #args > 0 then
		return args
	else
		return nil
	end
end

local function DynamicActionCheck(action)
	if action.IsDynamic then
		local dataFunc = customFuncRefs[action.DataFunc]
		if dataFunc then
			local vals = dataFunc(GetActionFuncArgs(action))
			action.Value = vals.Dialog
			action.isYesOrNoQuestion = vals.IYONQ
			action.YesResultActions = vals.YesActions
			action.NoResultActions = vals.NoActions
			action.ContinueResultActions = vals.ContinueActions
			if vals.ContinueBtnText ~= nil then
				action.ContinueBtnText = vals.ContinueBtnText
			end
			if vals.YesBtnText ~= nil then
				action.YesBtnText = vals.YesBtnText
			end
			if vals.NoBtnText ~= nil then
				action.NoBtnText = vals.NoBtnText
			end
		else
			action.Value = "ERROR"
		end
	elseif action.DataFunc then
		local dataFunc = customFuncRefs[action.DataFunc]
		if dataFunc then
			action.Value = dataFunc(GetActionFuncArgs(action))
		else
			action.Value = "ERROR"
		end
	end
end

local function SSQM_PerformTriggerActionsNew(self, Actions, TriggerName)
	if SSQM_PerformTriggerActionsOrig(self, Actions, TriggerName) == false then
		SSQM_QuestTriggersChanged = true
		return false
	end
	for i=1, #Actions do
		if not Actions[i] then break end
		DynamicActionCheck(Actions[i])
		local SS = nil
		if Actions[i].ActionType == "SSSpeak" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then
				print("SWS: SSSpeak triggered by " .. TriggerName)
				SS.player:faceThisObject(getSpecificPlayer(0))
				SS:Speak(Actions[i].Value)
			end
		elseif Actions[i].ActionType == "SetSSWantsToTalk" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
				self:SetNPCWantsToTalk(Actions[i].NPCID, Actions[i].Value)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
				self:SetNPCWantsToTalkByName(Actions[i].NPCName, Actions[i].Value)
			end
			if SS then
				print("SWS: SetSSWantsToTalk triggered by " .. TriggerName)
				SS.HasBikuri = Actions[i].Value
			end
		elseif Actions[i].ActionType == "RewardPlayer" then
			print("SWS: RewardPlayer triggered by " .. TriggerName)
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then SS:PlusRelationshipWP(1.0) end
			getSpecificPlayer(0):getInventory():AddItems(Actions[i].ItemType, Actions[i].ItemQuantity)
		elseif Actions[i].ActionType == "SSDialogueW" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then
				print("SWS: SSDialogueW triggered by " .. TriggerName)
				SetLastDialogueAction(Actions[i])
				SetupDialogueWindow(SS, Actions[i])
				if getDistanceBetween(SS,getSpecificPlayer(0)) > 1.8 then
					SS:getTaskManager():AddToTop(DialogueTask:new(SS,getSpecificPlayer(0),Actions[i].Value,false,TriggerName,{},{},Actions[i].ContinueResultActions,true))
					SS:getTaskManager():setTaskUpdateLimit(0)
				else
					SS.TriggerName = TriggerName
					myDialogueWindow:start(SS, Actions[i].Value, Actions[i].isYesOrNoQuestion)
				end
			end
		elseif Actions[i].ActionType == "SSQuestionDialogueW" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then
				print("SWS: SSQuestionDialogueW triggered by " .. TriggerName)
				Actions[i].isYesOrNoQuestion = true
				SetLastDialogueAction(Actions[i])
				SetupDialogueWindow(SS, Actions[i])
				if getDistanceBetween(SS,getSpecificPlayer(0)) > 1.8 then
					local task = DialogueTask:new(SS,getSpecificPlayer(0),Actions[i].Value,true,TriggerName,Actions[i].YesResultActions,Actions[i].NoResultActions,Actions[i].ContinueResultActions,true)
					SS:getTaskManager():AddToTop(task)
					SS:getTaskManager():setTaskUpdateLimit(0)
				else
					SS.TriggerName = TriggerName
					myDialogueWindow:start(SS, Actions[i].Value, true)
				end
			end
		elseif Actions[i].ActionType == "SSNextDialogueW" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then
				print("SWS: SSNextDialogueW triggered by " .. TriggerName)
				SS.TriggerName = TriggerName
				SetLastDialogueAction(Actions[i])
				SetupDialogueWindow(SS, Actions[i])
				myDialogueWindow:start(SS, Actions[i].Value, Actions[i].isYesOrNoQuestion)
			end
		elseif Actions[i].ActionType == "SSPrevDialogueW" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			local lastDialogueAction = nil
			if Actions[i].DialogueLevel == nil then
				lastDialogueAction = lastDialogueActions[2]
				SetLastDialogueAction(lastDialogueAction)
			else
				lastDialogueAction = lastDialogueActions[Actions[i].DialogueLevel]
			end
			if SS and lastDialogueAction then
				print("SWS: SSPrevDialogueW triggered by " .. TriggerName)
				SS.TriggerName = TriggerName
				DynamicActionCheck(lastDialogueAction)
				SetupDialogueWindow(SS, lastDialogueAction)
				myDialogueWindow:start(SS, lastDialogueAction.Value, lastDialogueAction.isYesOrNoQuestion)
			end
		elseif Actions[i].ActionType == "TeleportSS" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then
				print("SWS: TeleportSS triggered by " .. TriggerName)
				SS:Teleport(Actions[i].X, Actions[i].Y, Actions[i].Z)
			end
		elseif Actions[i].ActionType == "RecruitSS" then
			if Actions[i].NPCID ~= nil then
				SS = SSM:Get(Actions[i].NPCID)
			else
				SS = SSM:GetSurvivorByName(Actions[i].NPCName)
			end
			if SS then
				print("SWS: RecruitSS triggered by " .. TriggerName)
				SS:recruitSurvivor()
			end
		elseif Actions[i].ActionType == "SpawnPresetGroup" then
			print("SWS: SpawnPresetGroup triggered by " .. TriggerName)
			if not Actions[i].GroupID then
				Actions[i].GroupID = SSGM:newGroup():getID()
				Actions[i].Spawned = {}
			end
			local doRetry = false
			local groupPresets = self:CreateGroupPresets(Actions[i].Value)
			for p=1, #groupPresets do
				groupPresets[p].GroupID = Actions[i].GroupID
				if not Actions[i].Spawned[p] then
					if SuperSurvivorPresetQuestSpawn(groupPresets[p]) then
						Actions[i].Spawned[p] = true
					else
						print("SWS: SpawnPresetGroup failed to spawn group member preset")
						Actions[i].Value.X = Actions[i].Value.X + (ZombRand(5)-2)
						Actions[i].Value.Y = Actions[i].Value.Y + (ZombRand(5)-2)
						if Actions[i].Retries == nil then Actions[i].Retries = 4 end
						if Actions[i].Retries > 0 then
							Actions[i].Retries = Actions[i].Retries - 1
							doRetry = true
						end
					end
				end
			end
			if doRetry then self:DelayActions({Actions[i]}, 1) end
		elseif Actions[i].ActionType == "SpawnPresetSS" then
			print("SWS: SpawnPresetSS triggered by " .. TriggerName)
			local npcPreset = self:CreateNPCPreset(Actions[i].Value)
			if not SuperSurvivorPresetQuestSpawn(npcPreset) then
				print("SWS: SpawnPresetSS failed to spawn npc preset")
				Actions[i].Value.X = Actions[i].Value.X + (ZombRand(5)-2)
				Actions[i].Value.Y = Actions[i].Value.Y + (ZombRand(5)-2)
				if Actions[i].Retries == nil then Actions[i].Retries = 4 end
				if Actions[i].Retries > 0 then
					Actions[i].Retries = Actions[i].Retries - 1
					self:DelayActions({Actions[i]}, 1)
				end
			end
		elseif Actions[i].ActionType == "SetGroupData" then
			local group = SWS_GetContactedGroup(Actions[i].GroupID)
			if group and Actions[i].Name then
				print("SWS: SetGroupData triggered by " .. TriggerName)
				group[Actions[i].Name] = Actions[i].Value
				SWS_ContGroupsChanged = true
			end
		elseif Actions[i].ActionType == "SetTargetCoords" then
			local mapPos = nil
			local altPos = nil
			if Actions[i].X ~= nil then
				mapPos = { Actions[i].X, Actions[i].Y }
			end
			if Actions[i].AltX ~= nil then
				altPos = { Actions[i].AltX, Actions[i].AltY }
			end
			print("SWS: SetTargetCoords triggered by " .. TriggerName)
			self:SetTargetCoords(Actions[i].QuestID, mapPos, Actions[i].Value, altPos, Actions[i].AltValue)
		elseif Actions[i].ActionType == "SetTargetNPC" then
			print("SWS: SetTargetNPC triggered by " .. TriggerName)
			self:SetTargetNPC(Actions[i].QuestID, Actions[i].Name, Actions[i].NPCID, Actions[i].MarkMap)
		elseif Actions[i].ActionType == "UpdateQuestDesc" then
			print("SWS: UpdateQuestDesc triggered by " .. TriggerName)
			self:UpdateQuestDesc(Actions[i].QuestID, Actions[i].Value)
		elseif Actions[i].ActionType == "IncGlobalData" then
			print("SWS: IncGlobalData triggered by " .. TriggerName)
			self:IncGlobalData(Actions[i].Name, Actions[i].Value)
		elseif Actions[i].ActionType == "SetGlobalData" then
			print("SWS: SetGlobalData triggered by " .. TriggerName)
			self:SetGlobalData(Actions[i].Name, Actions[i].Value)
		elseif Actions[i].ActionType == "DelayActions" then
			print("SWS: DelayActions triggered by " .. TriggerName)
			self:DelayActions(Actions[i].Actions, Actions[i].Value)
		elseif Actions[i].ActionType == "FinishQuest" then
			print("SWS: FinishQuest triggered by " .. TriggerName)
			self:EndQuest(Actions[i].QuestID)
		elseif Actions[i].ActionType == "RunTriggerActions" then
			print("SWS: RunTriggerActions triggered by " .. TriggerName)
			self:RunTriggerActions(Actions[i].Value)
		elseif Actions[i].ActionType == "CustomFunc" then
			local custFunc = customFuncRefs[Actions[i].FuncName]
			if custFunc then
				print("SWS: Custom function triggered by " .. TriggerName)
				custFunc(GetActionFuncArgs(Actions[i]))
			else
				print("SWS: No custom function named "..Actions[i].FuncName)
			end
		end
	end
	SSQM_QuestTriggersChanged = true
end

local function SSQM_CheckTriggerNew(self, Trigger, EventTypeToCheck, Param1)
	if SSQM_CheckTriggerOrig(self, Trigger, EventTypeToCheck, Param1) then
		return true
	else
		if not Trigger.Enabled then return false end
		local SS = nil
		if (Trigger.ConditionType == "DistanceToSS") and (EventTypeToCheck == "DistanceToSS") then
			if Trigger.NPCID ~= nil then
				SS = SSM:Get(Trigger.NPCID)
			else
				SS = SSM:GetSurvivorByName(Trigger.NPCName)
			end
			if not SS then return false end
			local dist = getDistanceBetweenPoints(getSpecificPlayer(0):getX(), getSpecificPlayer(0):getY(), SS.player:getX(), SS.player:getY())
			if dist <= Trigger.Distance then
				print("SWS: DistanceToSS triggered via " .. tostring(Trigger.TriggerName))
				return true 
			end
		elseif (Trigger.ConditionType == "DistanceFromSS") and (EventTypeToCheck == "DistanceFromSS") then
			if Trigger.NPCID ~= nil then
				SS = SSM:Get(Trigger.NPCID)
			else
				SS = SSM:GetSurvivorByName(Trigger.NPCName)
			end
			if not SS then return false end
			local dist = getDistanceBetweenPoints(getSpecificPlayer(0):getX(), getSpecificPlayer(0):getY(), SS.player:getX(), SS.player:getY())
			if dist >= Trigger.Distance then
				print("SWS: DistanceFromSS triggered via " .. tostring(Trigger.TriggerName))
				return true 
			end
		elseif (Trigger.ConditionType == "TalkToSS") and (EventTypeToCheck == "TalkToSS") then
			local doTrigger = false
			if Trigger.NPCID then
				doTrigger = (Param1:getID() == Trigger.NPCID)
			elseif Trigger.NPCName then
				doTrigger = (Param1:getName() == Trigger.NPCName)
			end
			if doTrigger then
				print("SWS: TalkToSS triggered via " .. tostring(Trigger.TriggerName))
				return true
			end
		elseif (Trigger.ConditionType == "BringToSS") and (EventTypeToCheck == "BringToSS") then
			local doTrigger = false
			if Trigger.NPCID then
				doTrigger = (Param1:getID() == Trigger.NPCID)
			elseif Trigger.NPCName then
				doTrigger = (Param1:getName() == Trigger.NPCName)
			end
			if doTrigger then
				if SWS_PlayerItemCount(getSpecificPlayer(0), Trigger.TargetID) >= Trigger.TargetCount then
					print("SWS: BringToSS triggered via " .. tostring(Trigger.TriggerName))
					SWS_PlayerRemoveItems(getSpecificPlayer(0), Trigger.TargetID, Trigger.TargetCount)
					return true
				elseif Trigger.FailActions then
					self:PerformTriggerActions(Trigger.FailActions, tostring(Trigger.TriggerName).."_FailActions")
				end
			end
		elseif (Trigger.ConditionType == "GotTargetCount") and (EventTypeToCheck == "GotTargetCount") and (Param1 == Trigger.QuestID) then
			print("SWS: GotTargetCount triggered via " .. tostring(Trigger.TriggerName))
			return true
		elseif (Trigger.ConditionType == "EnterOrLeaveArea") and (EventTypeToCheck == "EnterOrLeaveArea")  then
			local insideArea = false
			local dist = getDistanceBetweenPoints(getSpecificPlayer(0):getX(), getSpecificPlayer(0):getY(), Trigger.CenterX, Trigger.CenterY)
			if dist <= Trigger.Distance then insideArea = true end
			if Trigger.InsideArea then
				if not insideArea then
					Trigger.InsideArea = false
					SSQM_QuestTriggersChanged = true
					self:UpdateQuestInfoWindow()
					print("SWS: EnterOrLeaveArea triggered via " .. tostring(Trigger.TriggerName))
					return true
				end
			elseif insideArea then
				Trigger.InsideArea = true
				SSQM_QuestTriggersChanged = true
				self:UpdateQuestInfoWindow()
				print("SWS: EnterOrLeaveArea triggered via " .. tostring(Trigger.TriggerName))
				return true
			end
		end
	end
	return false
end

local function OnTalkedToSurvivor(SS)
	SS.HasBikuri = false
	SSQM:SetNPCWantsToTalk(SS:getID(), false)
	SSQM:SetNPCWantsToTalkByName(SS:getName(), false)
	SSQM:update("TalkToSS", SS)
	SSQM:update("BringToSS", SS)
end

local function TalkToSurvivorNew(test, SS)
	TalkToSurvivorOrig(test, SS)
	if preventTalkToNPC then return end
	local mainPlayer = getSpecificPlayer(0)
	if getDistanceBetween(SS, mainPlayer) > 1.8 then
		SS:walkToDirect(mainPlayer:getCurrentSquare())
		preventTalkToNPC = true
		SWS_SetRepeatFunc(8, SS, function(this)
			if (not this.args) or this.args:isDead() then
				preventTalkToNPC = false
				return true
			end
			if getDistanceBetween(this.args, getSpecificPlayer(0)) > 1.8 then
				if this.count == 0 then preventTalkToNPC = false end
				return false
			end
			OnTalkedToSurvivor(this.args)
			preventTalkToNPC = false
			return true
		end)
	else
		OnTalkedToSurvivor(SS)
	end
end

local function onMouseWheelScroll(self, del)
	self.scrollBar:updatePos()
end

local function DialogueEnded(actions)
	if actions then
		for i=1, #actions do
			if actions[i].ActionType == "SSNextDialogueW" or 
			actions[i].ActionType == "SSPrevDialogueW" or
			actions[i].DialogAction then return false end
		end
	end
	return true
end

local function YesButtonPressedNew()
	local SS = SSM:Get(myDialogueWindow.TalkingSSID)
	print("SWS: Answered Yes to question of survivor " .. tostring(SS:getName()))
	if SS then
		if SS.YesResultActions == nil then print("SWS: warning detected nil YesResultActions") end
		local endOfDialogue = DialogueEnded(SS.YesResultActions)
		SSQM:AnswerChosen(SS.TriggerName, SS.YesResultActions)
		if endOfDialogue then
			SS.HasQuestion = false
			SS.NoResultActions = nil
			SS.YesResultActions = nil
			SS.ContinueResultActions = nil
			SS.TriggerName = nil
			setGameSpeed(1)
			myDialogueWindow:setVisible(false)
		end
	else
		print("SWS: error could not get SS for ID " .. tostring(myDialogueWindow.TalkingSSID))	
		setGameSpeed(1)
		myDialogueWindow:setVisible(false)
	end
end

local function NoButtonPressedNew()
	local SS = SSM:Get(myDialogueWindow.TalkingSSID)
	print("SWS: Answered No to question of survivor " .. tostring(SS:getName()))
	if SS then
		if SS.NoResultActions == nil then print("SWS: warning detected nil NoResultActions") end
		local endOfDialogue = DialogueEnded(SS.NoResultActions)
		SSQM:AnswerChosen(SS.TriggerName, SS.NoResultActions)
		if endOfDialogue then
			SS.HasQuestion = false
			SS.NoResultActions = nil
			SS.YesResultActions = nil
			SS.ContinueResultActions = nil
			SS.TriggerName = nil
			setGameSpeed(1)
			myDialogueWindow:setVisible(false)
		end
	else
		print("SWS: error could not get SS for ID " .. tostring(myDialogueWindow.TalkingSSID))	
		setGameSpeed(1)
		myDialogueWindow:setVisible(false)
	end
end

local function ContinueButtonPressedNew()	
	local SS = SSM:Get(myDialogueWindow.TalkingSSID)
	print("SWS: Pressed Continue button in dialog with " .. tostring(SS:getName()))
	if SS then
		local endOfDialogue = DialogueEnded(SS.ContinueResultActions)
		SSQM:AnswerChosen(SS.TriggerName, SS.ContinueResultActions)
		if endOfDialogue then
			SS.HasQuestion = false
			SS.NoResultActions = nil
			SS.YesResultActions = nil
			SS.ContinueResultActions = nil
			SS.TriggerName = nil
			setGameSpeed(1)
			myDialogueWindow:setVisible(false)
		end
	else
		print("SWS: error could not get SS for ID " .. tostring(myDialogueWindow.TalkingSSID))	
		setGameSpeed(1)
		myDialogueWindow:setVisible(false)
	end
end

local function DialogueTask_isCompleteNew(self)
	if self.Current == 99999 then
		self.Current = 99998
		self.parent.ContinueResultActions = self.ContinueResultActions
		self.parent.TriggerName = self.TriggerName
		
		if (self.isYesOrNoQuestion) then
			--self.parent.HasQuestion = true
			self.parent.NoResultActions = self.NoResultActions
			self.parent.YesResultActions = self.YesResultActions
		end
		return true
	elseif self.Current > #self.Dialogue then
		return true
	else return false end	
end

local function DialogueWindow_onUpdateNew(self)
	if self:getIsVisible() then
		local SS = SSM:Get(myDialogueWindow.TalkingSSID)
		if (not SS) or (getGameSpeed() > 0 and getDistanceBetween(SS, getSpecificPlayer(0)) >= 5) then
			self:setVisible(false)
			return
		end
		local cutstring = string.sub(self.text,1,self.currentCharacter)
		if self.strlen >= self.currentCharacter then
			self.speedticks = self.speedticks + 1
			if self.speedticks > self.textspeed then
				self.currentCharacter = self.currentCharacter + 1	
				self:setText(cutstring)
				self.speedticks = 0	
			end	
		elseif self.YesOrNoQuestion and not self.YesButton:getIsVisible() then
			self.YesButton:setVisible(true)
			self.NoButton:setVisible(true)			
		elseif self.YesButton:getIsVisible() and not self.ContinueButton:getIsVisible() then
			if SS.ContinueResultActions then
				self.ContinueButton:setVisible(true)
			end
		end
	end
end

local function DialogueWindow_startNew(self, SS, text, YesOrNoQuestion)

	if is_array(text) then
		if #text == 1 then
			self.text = text[1]
		else
			self.text = "";
			for i=1,#text do
				if text[i] then
					self.text = self.text .. text[i] .. "\n"
				end
			end
		end
	else 
		self.text = text
	end
	
	self.strlen = string.len(self.text)
	self.YesOrNoQuestion = YesOrNoQuestion
	
	self.TalkingSSID = SS:getID()
	self.complete = false
	self:setText("")
	self.currentCharacter = 1
	self:setVisible(true)
	setGameSpeed(0)
	self:setTitle(SS:getName())
	self.YesButton:setVisible(false)
	self.NoButton:setVisible(false)
	
	self.ContinueButton:setVisible(not YesOrNoQuestion)
	
	self.avatarPanel:setCharacter(SS.player)
end

local function DialogueWindow_createChildrenNew(self)

	local FONT_HGT_SMALL = getTextManager():getFontHeight(UIFont.Small)
	local panelHeight = FONT_HGT_SMALL * 10 + 85
	local panelWidth = FONT_HGT_SMALL * 6 + 200
	
	self.HomeWindow = ISRichTextPanel:new(0, 0, panelWidth, panelHeight)
	self.HomeWindow:initialise()
	--self.HomeWindow:instantiate()
	self.HomeWindow:noBackground()
	self.HomeWindow:setMargins(FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL)
	self.HomeWindow.autosetheight = false
	self.HomeWindow.clip = true
	self.HomeWindow:ignoreHeightChange()
	
    self.scrollPanel = ISPanel:new(100, FONT_HGT_SMALL + 1, panelWidth, panelHeight)
    self.scrollPanel:initialise()
    --self.scrollPanel:instantiate()
    self.scrollPanel:setAnchorRight(true)
    self.scrollPanel:setAnchorLeft(true)
    self.scrollPanel:setAnchorTop(true)
    self.scrollPanel:setAnchorBottom(true)
	self.scrollPanel:addChild(self.HomeWindow)
	self:addChild(self.scrollPanel)
	
	self.scrollPanel.scrollBar = ISScrollBar:new(self.HomeWindow, true)
    self.scrollPanel.scrollBar:initialise()
    self.scrollPanel.onMouseWheel = onMouseWheelScroll
	self.HomeWindow:addChild(self.scrollPanel.scrollBar)
	
    self.btnPanel = ISPanel:new(0, panelHeight + FONT_HGT_SMALL, panelWidth + 100, 60)
    self.btnPanel:initialise()
    --self.btnPanel:instantiate()
	self:addChild(self.btnPanel)
	
	self.YesButton = ISButton:new(35, panelHeight + 28, 90, 25, SWS_GetModText("Yes"), self, YesButtonPressedNew);			
	self.YesButton:setEnable(true)
	self.YesButton:initialise()
	--self.YesButton:instantiate()
	--self.YesButton:addToUIManager()
	self:addChild(self.YesButton)
	
	self.NoButton = ISButton:new(255, panelHeight + 28, 90, 25, SWS_GetModText("No"), self, NoButtonPressedNew);			
	self.NoButton:setEnable(true)
	self.NoButton:initialise()
	--self.NoButton:instantiate()
	--self.NoButton:addToUIManager()
	self:addChild(self.NoButton)
	
	self.ContinueButton = ISButton:new(145, panelHeight + 28, 90, 25, SWS_GetModText("Continue"), self, ContinueButtonPressedNew);			
	self.ContinueButton:setEnable(true)
	self.ContinueButton:initialise()
	--self.ContinueButton:instantiate()
	--self.ContinueButton:addToUIManager()
	self:addChild(self.ContinueButton)
	
	self.avatarPanel = ISCharacterScreenAvatar:new(0, 35, 100, 180)
	self.avatarPanel:setVisible(true)
	self:addChild(self.avatarPanel)
	self.avatarPanel:setOutfitName("Foreman", false, false)
	self.avatarPanel:setState("idle")
	self.avatarPanel:setDirection(IsoDirections.S)
	self.avatarPanel:setIsometric(false)
			
	ISCollapsableWindow.createChildren(self);
end

local function DialogueWindowCreateNew()
	local FONT_HGT_SMALL = getTextManager():getFontHeight(UIFont.Small)
	myDialogueWindow = DialogueWindow:new(400, 270, FONT_HGT_SMALL * 6 + 300, FONT_HGT_SMALL * 10 + 152)
	myDialogueWindow:addToUIManager()
	myDialogueWindow:setVisible(false)
	myDialogueWindow.pin = true
	myDialogueWindow.resizable = false
	myDialogueWindow.textspeed = 2
end

local function QuestInfoWindow_newNew(self, x, y, width, height)
	local o = {}
	o = ISCollapsableWindow:new(x, y, width, height)
	setmetatable(o, self)
	self.__index = self
	o.title = SWS_GetModText("QuestInfo")
	o.pin = false
	return o
end

local function QuestInfoWindow_setTextNew(self, newText, tabName)
	if not tabName then tabName = "Active" end
	local tabPanel = self.TabText1
	if tabName == "Completed" then
		tabPanel = self.TabText2
	elseif tabName == "Failed" then
		tabPanel = self.TabText3
	elseif tabName == "Misc" then
		tabPanel = self.TabText4
	end
	tabPanel.text = newText
	tabPanel:paginate()
end

local function QuestInfoWindow_createChildrenNew(self)
	print("SWS: creating children of QuestInfoWindow")
	local FONT_HGT_SMALL = getTextManager():getFontHeight(UIFont.Small)
	local TAB_HEIGHT = FONT_HGT_SMALL + 6
	local panelWidth = FONT_HGT_SMALL * 6 + 250
	local panelHeight = FONT_HGT_SMALL * 10 + (300 - (TAB_HEIGHT + FONT_HGT_SMALL + 2))
	
	self.TabText1 = ISRichTextPanel:new(0, 0, panelWidth, panelHeight)
	self.TabText1:initialise()
    --self.TabText1:instantiate()
	self.TabText1:noBackground()
	self.TabText1:setMargins(FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL)
	self.TabText1.autosetheight = false
	self.TabText1.clip = true
	self.TabText1:ignoreHeightChange()
	
    self.tabPanel1 = ISPanel:new(0, FONT_HGT_SMALL + 2, panelWidth, panelHeight)
    self.tabPanel1:initialise()
    --self.tabPanel1:instantiate()
    self.tabPanel1:setAnchorRight(true)
    self.tabPanel1:setAnchorLeft(true)
    self.tabPanel1:setAnchorTop(true)
    self.tabPanel1:setAnchorBottom(true)
	self.tabPanel1:addChild(self.TabText1)
	
	self.TabText2 = ISRichTextPanel:new(0, 0, panelWidth, panelHeight)
	self.TabText2:initialise()
    --self.TabText2:instantiate()
	self.TabText2:noBackground()
	self.TabText2:setMargins(FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL)
	self.TabText2.autosetheight = false
	self.TabText2.clip = true
	self.TabText2:ignoreHeightChange()
	
    self.tabPanel2 = ISPanel:new(0, FONT_HGT_SMALL + 2, panelWidth, panelHeight)
    self.tabPanel2:initialise()
    --self.tabPanel2:instantiate()
    self.tabPanel2:setAnchorRight(true)
    self.tabPanel2:setAnchorLeft(true)
    self.tabPanel2:setAnchorTop(true)
    self.tabPanel2:setAnchorBottom(true)
	self.tabPanel2:addChild(self.TabText2)
	
	self.TabText3 = ISRichTextPanel:new(0, 0, panelWidth, panelHeight)
	self.TabText3:initialise()
    --self.TabText3:instantiate()
	self.TabText3:noBackground()
	self.TabText3:setMargins(FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL)
	self.TabText3.autosetheight = false
	self.TabText3.clip = true
	self.TabText3:ignoreHeightChange()
	
    self.tabPanel3 = ISPanel:new(0, FONT_HGT_SMALL + 2, panelWidth, panelHeight)
    self.tabPanel3:initialise()
    --self.tabPanel3:instantiate()
    self.tabPanel3:setAnchorRight(true)
    self.tabPanel3:setAnchorLeft(true)
    self.tabPanel3:setAnchorTop(true)
    self.tabPanel3:setAnchorBottom(true)
	self.tabPanel3:addChild(self.TabText3)
	
	self.TabText4 = ISRichTextPanel:new(0, 0, panelWidth, panelHeight)
	self.TabText4:initialise()
    --self.TabText4:instantiate()
	self.TabText4:noBackground()
	self.TabText4:setMargins(FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL, FONT_HGT_SMALL)
	self.TabText4.autosetheight = false
	self.TabText4.clip = true
	self.TabText4:ignoreHeightChange()
	
    self.tabPanel4 = ISPanel:new(0, FONT_HGT_SMALL + 2, panelWidth, panelHeight)
    self.tabPanel4:initialise()
    --self.tabPanel4:instantiate()
    self.tabPanel4:setAnchorRight(true)
    self.tabPanel4:setAnchorLeft(true)
    self.tabPanel4:setAnchorTop(true)
    self.tabPanel4:setAnchorBottom(true)
	self.tabPanel4:addChild(self.TabText4)
	
	self.tabPanel1.scrollBar = ISScrollBar:new(self.TabText1, true)
    self.tabPanel1.scrollBar:initialise()
    self.tabPanel1.onMouseWheel = onMouseWheelScroll
	self.TabText1:addChild(self.tabPanel1.scrollBar)
	
	self.tabPanel2.scrollBar = ISScrollBar:new(self.TabText2, true)
    self.tabPanel2.scrollBar:initialise()
    self.tabPanel2.onMouseWheel = onMouseWheelScroll
	self.TabText2:addChild(self.tabPanel2.scrollBar)
	
	self.tabPanel3.scrollBar = ISScrollBar:new(self.TabText3, true)
    self.tabPanel3.scrollBar:initialise()
    self.tabPanel3.onMouseWheel = onMouseWheelScroll
	self.TabText3:addChild(self.tabPanel3.scrollBar)
	
	self.tabPanel4.scrollBar = ISScrollBar:new(self.TabText4, true)
    self.tabPanel4.scrollBar:initialise()
    self.tabPanel4.onMouseWheel = onMouseWheelScroll
	self.TabText4:addChild(self.tabPanel4.scrollBar)
	
	self.HomeWindow = ISTabPanel:new(0, FONT_HGT_SMALL + 2, panelWidth, FONT_HGT_SMALL * 10 + 300)
	self.HomeWindow:initialise()
    --self.HomeWindow:instantiate()
	self.HomeWindow:addView(SWS_GetModText("Active"), self.tabPanel1)
	self.HomeWindow:addView(SWS_GetModText("Completed"), self.tabPanel2)
	self.HomeWindow:addView(SWS_GetModText("Failed"), self.tabPanel3)
	self.HomeWindow:addView(SWS_GetModText("Misc"), self.tabPanel4)
	self:addChild(self.HomeWindow)
		
	ISCollapsableWindow.createChildren(self)
	SSQM:UpdateQuestInfoWindow()
end

local function FarmingTask_getAPlantThatNeedsNew(self, needs)
	local result = FarmingTask_getAPlantThatNeedsOrig(self, needs)
	if result and needs == "Plowing" then
		if result:isOutside() and not result:HasTree() then return result end
		local area = self.group:getGroupArea("FarmingArea")
		for x=result:getX(), area[2] do
			for y=area[3], area[4] do
				local sq = getCell():getGridSquare(x,y,area[5])
				if sq and sq:isOutside() and not sq:HasTree() then
					local plant = self:getPlant(sq)
					if (not plant) or not plant:isAlive() then
						print("SWS: returning square for plowing containing "..tostring(plant))
						return sq 
					end
				end
			end
		end
		print("SWS: failed to find free square for plowing")
		return nil
	end
	return result
end

local function getContextMenuTextNew(text)
	if text == "TalkOption_Desc" then
		return getText("ContextMenu_SS_TalkDesc")
	else
		return getText("ContextMenu_SS_" .. text)
	end
end

local function getActionTextNew(text)
	if text == "Eat" or text == "Drink" or text == "Disinfect" or text == "Bandage" then
		return SWS_GetModText(text)
	elseif text == "Apply_Bandage" then
		return SWS_GetModText("ApplyBandage")
	elseif text == "Remove_Bandage" then
		return SWS_GetModText("RemoveBandage")
	elseif text == "SD_HoldStill" then
		return getText("IGUI_SS_HoldStill")
	elseif text == "SD_DoctorDone" then
		return getText("IGUI_SS_DoctorDone")
	else
		return getText("IGUI_SS_" .. text)
	end
end

local function saveSurvivorMapNew()
	if SWS_GameLoaded then
		if SSQM then
			saveSurvivorMapOrig()
			SWS_SaveModVars()
			SSQM:SaveToFile()
		else
			SWS_GameLoaded = false
		end
	end
end

Events.EveryOneMinute.Add(function()
	--SSQM:CheckQuestGivers()
	SSQM:update("DistanceToSS")
	SSQM:update("DistanceFromSS")
	SSQM:update("EnterOrLeaveArea")
	
	local mainPlayer = getSpecificPlayer(0)
	local reqQuestItems = SSQM:GetRequiredItems()
	
	if #reqQuestItems > 0 then
		for _, questItem in ipairs(reqQuestItems) do
			SSQM:UpdateItemsFound(questItem, SWS_PlayerItemCount(mainPlayer, questItem))
		end
	end
	
	for i=1, #actionQueue do
		if actionQueue[i] then
			actionQueue[i].Delay = actionQueue[i].Delay - 1
			if actionQueue[i].Delay <= 0 then
				SSQM:PerformTriggerActions(actionQueue[i].Actions, "DelayedActionTrigger")
				actionQueue[i] = nil
			end
			SSQM_ActionQueueChanged = true
		end
	end
end)

Events.OnHitZombie.Add(function(zombie, character, bodyPartType, handWeapon)
	if character == getSpecificPlayer(0) then
		lastZombiePlayerHit = zombie
	end
end)

Events.OnZombieDead.Add(function(zombie)
	if zombie == lastZombiePlayerHit then
		SSQM:KilledZombie()
	end
end)

Events.OnGameBoot.Add(function()
	GetAdjSquare = GetAdjSquareNew
	QuestManagerInitOrig = QuestManagerInit
	QuestManagerInit = QuestManagerInitNew
	QuestInfoWindow.new = QuestInfoWindow_newNew
	QuestInfoWindow.setText = QuestInfoWindow_setTextNew
	QuestInfoWindow.createChildren = QuestInfoWindow_createChildrenNew
	DialogueWindow.start = DialogueWindow_startNew
	DialogueWindow.createChildren = DialogueWindow_createChildrenNew
	DialogueWindow.onUpdate = DialogueWindow_onUpdateNew
	TalkToSurvivorOrig = TalkToSurvivor
	TalkToSurvivor = TalkToSurvivorNew
	AskToJoinOrig = AskToJoin
	AskToJoin = AskToJoinNew
	InviteToPartyOrig = InviteToParty
	InviteToParty = InviteToPartyNew
	SuperSurvivor_OnDeathOrig = SuperSurvivor.OnDeath
	SuperSurvivor.OnDeath = SuperSurvivor_OnDeathNew
	SuperSurvivor_NPC_ManageLockedDoorsOrig = SuperSurvivor.NPC_ManageLockedDoors
	SuperSurvivor.NPC_ManageLockedDoors = SuperSurvivor_NPC_ManageLockedDoorsNew
	SuperSurvivorRandomSpawn = SuperSurvivorRandomSpawnNew
	SuperSurvivorsNewSurvivorManager = SuperSurvivorsSurvivorManagerNew
	SSM_LoadSurvivorOrig = SuperSurvivorManager.LoadSurvivor
	SuperSurvivorManager.LoadSurvivor = SSM_LoadSurvivorNew
	SSM_spawnSurvivorOrig = SuperSurvivorManager.spawnSurvivor
	SuperSurvivorManager.spawnSurvivor = SSM_spawnSurvivorNew
	SSM_OnDeathOrig = SuperSurvivorManager.OnDeath
	SuperSurvivorManager.OnDeath = SSM_OnDeathNew
	SSQM_PerformTriggerActionsOrig = QuestManager.PerformTriggerActions
	QuestManager.PerformTriggerActions = SSQM_PerformTriggerActionsNew
	SSQM_CheckTriggerOrig = QuestManager.CheckTrigger
	QuestManager.CheckTrigger = SSQM_CheckTriggerNew
	QuestManager.EditTriggerEnabled = QuestManager.SetTriggerEnabled
	DialogueTask.isComplete = DialogueTask_isCompleteNew
	FarmingTask_getAPlantThatNeedsOrig = FarmingTask.getAPlantThatNeeds
	FarmingTask.getAPlantThatNeeds = FarmingTask_getAPlantThatNeedsNew
	getContextMenuText = getContextMenuTextNew
	getActionText = getActionTextNew
	saveSurvivorMapOrig = saveSurvivorMap
	saveSurvivorMap = saveSurvivorMapNew
end)
	
Events.LoadGridsquare.Remove(SuperSurvivorsLoadGridsquare)
Events.LoadGridsquare.Add(SuperSurvivorsLoadGridsquareNew)

Events.OnKeyPressed.Remove(QuestManagerKeyDownHandle)
Events.OnKeyPressed.Add(QuestManagerKeyDownHandleNew)

Events.OnGameStart.Remove(QuestInfoWindowCreate)
Events.OnGameStart.Add(QuestInfoWindowCreateNew)

Events.OnGameStart.Remove(DialogueWindowCreate)
Events.OnGameStart.Add(DialogueWindowCreateNew)