local npcWalkieTalkies = { "Radio.WalkieTalkie2", "Radio.WalkieTalkie3", "Radio.WalkieTalkie4", "Radio.WalkieTalkie5" }
local hamRadioNames = { "HamRadio1", "HamRadio2", "HamRadioMakeShift" }
local traderShopCats = { "Clothes", "Equipment", "Food", "Resources", "Tools" }
local sheriffShopCats = { "Guns", "Ammo" }
local tempQuestInfo = { Title = "", Desc =  "", Target = nil, Reward = nil }
local tempDialogInfo = { Dialog = "", IYONQ = true, YesActions = nil, NoActions = nil, ContinueActions = nil }
local contactedGroups = {}
local minuteRepeatFuncs = {}
local survivorShopList = {}

local survivorTargetSquare = nil
local survivorChannelInt = 123400
local survivorLastContacted = 0
local survivorLastZKills = 0
local survivorSearchTimer = 0
local survivorKnockTimer = 0
local survivorRequestTimer = 0
local survivorShopDiscount = 0

local radioLastUsedByPlayer = nil
local radioAttractedRaiders = false
local radioResponseTimer = 0
local radioResponseType = 0
local radioResponseGroupID = 0
local radioResponseSurvivorID = 0
local radioRequestSurvivorID = 0

SWS_GameLoaded = false
SWS_LiteralVarsChanged = false
SWS_ContGroupsChanged = false
SWS_SurvivorShopsChanged = false
SWS_SpawnStatesChanged = false

--NOTE: use SWS_AddGroupSpawnPoint() and SWS_AddGangSpawnPoint()
-- functions to add new group or gang spawn locations

local SpawnMapName = "KnoxCountry"

local GangSpawnStates = {
	KnoxCountry = { 0,0,0,0,0,0,0,0,0,0 }
}

local GroupSpawnStates = {
	KnoxCountry = { 0,0,0,0,0,0,0,0,0,0,0,0 }
}

local GroupSpawnPoints = {
	KnoxCountry = {
		{{13871, 2293}, {13903, 2246}},
		{{13544, 2977}, {13578, 2840}},
		{{12628, 5635}, {12573, 5619}},
		{{12025, 2262}, {12025, 2210}},
		{{11897, 6990}, {12024, 7005}},
		{{10155, 6624}, {10144, 6681}},
		{{10885, 9844}, {10838, 9795}},
		{{9814, 12874}, {9815, 12919}},
		{{8005, 11492}, {8003, 11548}},
		{{7131, 8390}, {7125, 8296}},
		{{6628, 5508}, {6672, 5509}},
		{{5567, 9767}, {5544, 9715}}
	}
}

local FarmSpawnPoints = {
	KnoxCountry = {
		{{13860, 2302}, {13914, 2234}},
		{{13544, 2986}, {13578, 2833}},
		{{12608, 5634}, {12578, 5630}},
		{{12005, 2268}, {12045, 2218}},
		{{11890, 6998}, {12014, 7010}},
		{{10161, 6612}, {10147, 6698}},
		{{10882, 9828}, {10837, 9786}},
		{{9818, 12863}, {9814, 12908}},
		{{7990, 11492}, {7990, 11560}},
		{{7133, 8380}, {7132, 8306}},
		{{6630, 5498}, {6670, 5495}},
		{{5566, 9776}, {5538, 9729}}
	}
}

local GangSpawnPoints = {
	KnoxCountry = {
		{12738, 2179, 12, 0}, {13131, 2145, 12, 0},
		{13680, 2759, 12, 0}, {13340, 3032, 12, 0},
		{12446, 3802, 12, 0}, {11950, 6816, 12, 0},
		{10632, 9890, 10, 0}, {8300, 12212, 12, 0},
		{6560, 8955, 10, 0}, {5585, 5946, 12, 0}
	}
}

SWS_shopItems = {
	Medical = {
		{ ItemID="Base.FirstAidKit", Price=150, MaxStock=2 },
		{ ItemID="Base.Pills", Price=220, MaxStock=3 },
		{ ItemID="Base.PillsVitamins", Price=180, MaxStock=3 },
		{ ItemID="Base.PillsBeta", Price=200, MaxStock=3 },
		{ ItemID="Base.PillsSleepingTablets", Price=210, MaxStock=3 },
		{ ItemID="Base.PillsAntiDep", Price=210, MaxStock=3 },
		{ ItemID="Base.Antibiotics", Price=120, MaxStock=2 },
		{ ItemID="Base.Bandage", Price=40, MaxStock=5 },
		{ ItemID="Base.AlcoholBandage", Price=50, MaxStock=2 },
		{ ItemID="Base.CottonBalls", Price=30, MaxStock=5 },
		{ ItemID="Base.AlcoholWipes", Price=40, MaxStock=3 },
		{ ItemID="Base.Disinfectant", Price=90, MaxStock=2 },
		{ ItemID="Base.SutureNeedle", Price=50, MaxStock=2 },
		{ ItemID="Base.SutureNeedleHolder", Price=50, MaxStock=2 },
		{ ItemID="Base.Tweezers", Price=50, MaxStock=2 },
		{ ItemID="Base.Splint", Price=100, MaxStock=3 }
	},
	Food = {
		{ ItemID="Base.WhiskeyFull", Price=100, MaxStock=1 },
		{ ItemID="Base.Milk", Price=60, MaxStock=2 },
		{ ItemID="Base.PopBottle", Price=50, MaxStock=2 },
		{ ItemID="Base.SugarBrown", Price=40, MaxStock=2 },
		{ ItemID="Base.Sugar", Price=30, MaxStock=2 },
		{ ItemID="Base.Salt", Price=30, MaxStock=2 },
		{ ItemID="Base.OilOlive", Price=60, MaxStock=2 },
		{ ItemID="Base.OilVegetable", Price=60, MaxStock=2 },
		{ ItemID="Base.Lard", Price=60, MaxStock=2 },
		{ ItemID="Base.TinnedBeans", Price=50, MaxStock=2 },
		{ ItemID="Base.CannedCarrots", Price=50, MaxStock=2 },
		{ ItemID="Base.CannedCorn", Price=50, MaxStock=2 },
		{ ItemID="Base.CannedPeas", Price=50, MaxStock=2 },
		{ ItemID="Base.CannedSardines", Price=60, MaxStock=2 },
		{ ItemID="Base.TunaTin", Price=60, MaxStock=2 }
	},
	Resources = {
		{ ItemID="Base.EngineParts", Price=380, MaxStock=2 },
		{ ItemID="Base.PetrolCan", Price=350, MaxStock=2 },
		{ ItemID="Base.NailsBox", Price=120, MaxStock=4 },
		{ ItemID="Base.ScrewsBox", Price=130, MaxStock=4 },
		{ ItemID="Base.Rope", Price=70, MaxStock=5 },
		{ ItemID="Base.Wire", Price=90, MaxStock=5 },
		{ ItemID="Base.Twine", Price=100, MaxStock=5 },
		{ ItemID="Base.Thread", Price=80, MaxStock=5 },
		{ ItemID="Base.SewingKit", Price=140, MaxStock=2 },
		{ ItemID="Base.WeldingRods", Price=250, MaxStock=2 },
		{ ItemID="Base.GunPowder", Price=230, MaxStock=3 },
		{ ItemID="Base.Amplifier", Price=50, MaxStock=4 },
		{ ItemID="Radio.RadioReceiver", Price=50, MaxStock=4 },
		{ ItemID="Radio.RadioTransmitter", Price=90, MaxStock=3 },
		{ ItemID="Base.Glue", Price=140, MaxStock=3 },
		{ ItemID="Base.Woodglue", Price=160, MaxStock=2 },
		{ ItemID="Base.DuctTape", Price=130, MaxStock=4 },
		{ ItemID="Base.CleaningLiquid", Price=90, MaxStock=2 }
	},
	Equipment = {
		{ ItemID="Base.Sling", Price=250, MaxStock=1 },
		{ ItemID="Base.Bag_NormalHikingBag", Price=550, MaxStock=1 },
		{ ItemID="Base.Bag_BigHikingBag", Price=650, MaxStock=1 },
		{ ItemID="Base.Bag_ALICEpack", Price=750, MaxStock=1 },
		{ ItemID="Base.Bag_ALICEpack_Army", Price=850, MaxStock=1 },
		{ ItemID="Base.Torch", Price=120, MaxStock=1 },
		{ ItemID="Base.HandTorch", Price=150, MaxStock=1 },
		{ ItemID="Base.Scissors", Price=50, MaxStock=1 },
		{ ItemID="Base.Lighter", Price=80, MaxStock=2 },
		{ ItemID="Base.Matches", Price=60, MaxStock=3 },
		{ ItemID="Base.CampfireKit", Price=100, MaxStock=2 },
		{ ItemID="Base.CampingTentKit", Price=490, MaxStock=1 },
		{ ItemID="Radio.WalkieTalkie3", Price=220, MaxStock=1 },
		{ ItemID="Radio.WalkieTalkie4", Price=250, MaxStock=1 },
		{ ItemID="Radio.WalkieTalkie5", Price=290, MaxStock=1 }
	},
	Tools = {
		{ ItemID="Base.Saw", Price=290, MaxStock=1 },
		{ ItemID="Base.Axe", Price=350, MaxStock=1 },
		{ ItemID="Base.PickAxe", Price=420, MaxStock=1 },
		{ ItemID="Base.WoodAxe", Price=490, MaxStock=1 },
		{ ItemID="Base.Crowbar", Price=250, MaxStock=1 },
		{ ItemID="Base.Screwdriver", Price=170, MaxStock=1 },
		{ ItemID="Base.BlowTorch", Price=590, MaxStock=1 },
		{ ItemID="Base.FishingRod", Price=550, MaxStock=1 },
		{ ItemID="Base.GardenHoe", Price=220, MaxStock=1 },
		{ ItemID="Base.Shovel", Price=250, MaxStock=1 },
		{ ItemID="farming.HandShovel", Price=150, MaxStock=1 },
		{ ItemID="Base.BaseballBat", Price=320, MaxStock=1 },
		{ ItemID="Base.Sledgehammer", Price=450, MaxStock=1 },
		{ ItemID="Base.Hammer", Price=200, MaxStock=1 },
		{ ItemID="Base.PipeWrench", Price=210, MaxStock=1 },
		{ ItemID="Base.Wrench", Price=190, MaxStock=1 },
		{ ItemID="Base.Machete", Price=520, MaxStock=1 },
		{ ItemID="Base.HandScythe", Price=300, MaxStock=1 },
		{ ItemID="Base.HuntingKnife", Price=390, MaxStock=1 }
	},
	Guns = {
		{ ItemID="Base.Pistol", Price=790, MaxStock=1 },
		{ ItemID="Base.Pistol2", Price=850, MaxStock=1 },
		{ ItemID="Base.Pistol3", Price=990, MaxStock=1 },
		{ ItemID="Base.Revolver_Short", Price=810, MaxStock=1 },
		{ ItemID="Base.Revolver", Price=890, MaxStock=1 },
		{ ItemID="Base.Revolver_Long", Price=1000, MaxStock=1 },
		{ ItemID="Base.Shotgun", Price=1190, MaxStock=1 },
		{ ItemID="Base.ShotgunSawnoff", Price=1150, MaxStock=1 },
		{ ItemID="Base.DoubleBarrelShotgun", Price=1100, MaxStock=1 },
		{ ItemID="Base.DoubleBarrelShotgunSawnoff", Price=1060, MaxStock=1 },
		{ ItemID="Base.VarmintRifle", Price=930, MaxStock=1 },
		{ ItemID="Base.HuntingRifle", Price=1120, MaxStock=1 },
		{ ItemID="Base.AssaultRifle", Price=1250, MaxStock=1 },
		{ ItemID="Base.AssaultRifle2", Price=1290, MaxStock=1 }
	},
	Ammo = {
		{ ItemID="Base.223Box", Price=220, MaxStock=4 },
		{ ItemID="Base.308Box", Price=230, MaxStock=4 },
		{ ItemID="Base.Bullets38Box", Price=250, MaxStock=3 },
		{ ItemID="Base.Bullets44Box", Price=290, MaxStock=2 },
		{ ItemID="Base.Bullets45Box", Price=270, MaxStock=3 },
		{ ItemID="Base.556Box", Price=300, MaxStock=1 },
		{ ItemID="Base.Bullets9mmBox", Price=210, MaxStock=4 },
		{ ItemID="Base.ShotgunShellsBox", Price=240, MaxStock=4 },
		{ ItemID="Base.9mmClip", Price=250, MaxStock=2 },
		{ ItemID="Base.45Clip", Price=260, MaxStock=2 },
		{ ItemID="Base.44Clip", Price=280, MaxStock=2 },
		{ ItemID="Base.223Clip", Price=300, MaxStock=2 },
		{ ItemID="Base.308Clip", Price=320, MaxStock=2 },
		{ ItemID="Base.M14Clip", Price=350, MaxStock=2 },
		{ ItemID="Base.556Clip", Price=390, MaxStock=2 }
	},
	Clothes = {
		{ ItemID="Base.AmmoStrap_Bullets", Price=400, MaxStock=1 },
		{ ItemID="Base.AmmoStrap_Shells", Price=410, MaxStock=1 },
		{ ItemID="Base.HolsterSimple", Price=350, MaxStock=1 },
		{ ItemID="Base.HolsterDouble", Price=390, MaxStock=1 },
		{ ItemID="Base.Shoes_BlackBoots", Price=290, MaxStock=1 },
		{ ItemID="Base.Shoes_ArmyBoots", Price=470, MaxStock=1 },
		{ ItemID="Base.Vest_BulletArmy", Price=1190, MaxStock=1 },
		{ ItemID="Base.Vest_BulletCivilian", Price=890, MaxStock=1 },
		{ ItemID="Base.Vest_Hunting_Camo", Price=300, MaxStock=1 },
		{ ItemID="Base.Vest_Hunting_Grey", Price=310, MaxStock=1 },
		{ ItemID="Base.Hat_GasMask", Price=270, MaxStock=1 },
		{ ItemID="Base.WeldingMask", Price=350, MaxStock=1 },
		{ ItemID="Base.Hat_CrashHelmet", Price=420, MaxStock=1 },
		{ ItemID="Base.Hat_Army", Price=550, MaxStock=1 },
		{ ItemID="Base.Gloves_LeatherGloves", Price=150, MaxStock=1 },
		{ ItemID="Base.HazmatSuit", Price=590, MaxStock=1 }
	}
}

SWS_outfitPresets = {
	Preset_Leader = {
		SurvivorRandomSuits["Preset"]["Preset_Leader"],
		SurvivorRandomSuits["Preset"]["Preset_Army"],
		{
			"Base.Hat_Cowboy",
			"Base.Glasses_Aviators", 
			"Base.Tshirt_Profession_VeterenGreen", 
			"Base.Jacket_Black",
			"Base.Trousers_LeatherBlack", 
			"Base.Socks_Ankle",
			"Base.Shoes_Black"
		}, {
			"Base.Tshirt_SpiffoDECAL",
			"Base.Jacket_Shellsuit_Blue",
			"Base.Trousers_JeanBaggy",
			"Base.Socks_Ankle",
			"Base.Shoes_BlueTrainers",
			"Base.Glasses",
			"Base.Belt2"
		}
	},
	Preset_Doctor = {
		SurvivorRandomSuits["Preset"]["Preset_Doctor"],
		SurvivorRandomSuits["Rare"]["Nurse1"]
	},
	Preset_Police = {
		SurvivorRandomSuits["Preset"]["Preset_Police"],
		SurvivorRandomSuits["Rare"]["Police1"],
		SurvivorRandomSuits["Rare"]["Deputy1"]
	},
	Preset_Worker = {
		SurvivorRandomSuits["Preset"]["Preset_Worker"],
		SurvivorRandomSuits["Normal"]["Worker1"]
	},
	Preset_Trader = {
		SurvivorRandomSuits["Preset"]["Preset_Formal"],
		SurvivorRandomSuits["Preset"]["Preset_Hunter"],
		{
			"Base.Hat_BucketHat",
			"Base.Tshirt_McCoys",
			"Base.Vest_Waistcoat",
			"Base.Shorts_CamoUrbanLong",
			"Base.Socks_Long",
			"Base.Shoes_Brown",
			"Base.Belt2"
		}
	},
	Preset_Farmer = {
		SurvivorRandomSuits["Preset"]["Preset_Farmer"],
		{
			"Base.Shirt_Lumberjack",
			"Base.TrousersMesh_DenimLight",
			"Base.Shoes_Wellies",
			"Base.Belt2"
		}, {
			"Base.Hat_SummerHat",
			"Base.Shirt_Denim",
			"Base.Shorts_ShortDenim",
			"Base.Shoes_FlipFlop",
			"Base.Belt2"
		}
	},
	Preset_Guard = {
		SurvivorRandomSuits["Preset"]["Preset_Guard"],
		SurvivorRandomSuits["Preset"]["Preset_ArmyCamo"],
		SurvivorRandomSuits["Preset"]["Preset_MarinesCamo"]
	},
	Preset_Gangster = {
		SurvivorRandomSuits["Preset"]["Preset_Gangster"],
		SurvivorRandomSuits["Rare"]["Bandit1"],
		SurvivorRandomSuits["Rare"]["Bandit2"],
		SurvivorRandomSuits["Rare"]["Bandit3"],
		SurvivorRandomSuits["Uncommon"]["Biker1"]
	},
	Preset_Survivalist = {
		SurvivorRandomSuits["Preset"]["Preset_Survivalist"],
		SurvivorRandomSuits["Preset"]["Preset_Hunter"],
		SurvivorRandomSuits["Rare"]["Prepper1"]
	},
	Preset_Default = {
		SurvivorRandomSuits["Common"]["Basic1"],
		SurvivorRandomSuits["Normal"]["Athlete1"],
		SurvivorRandomSuits["Normal"]["Student1"],
		SurvivorRandomSuits["Normal"]["Student2"]
	}
}

SWS_raiderTitles = {
	SWS_GetModText("Raider"), SWS_GetModText("Outlaw"),
	SWS_GetModText("Bandit"), SWS_GetModText("Thug"), SWS_GetModText("Gangster")
}

SWS_rewardTexts = {
	SWS_GetModText("RewardDialog1"), SWS_GetModText("RewardDialog2"),
	SWS_GetModText("RewardDialog3"), SWS_GetModText("RewardDialog4")
}

SWS_leaveTexts = {
	SWS_GetModText("LeaveDialog1"), SWS_GetModText("LeaveDialog2"),
	SWS_GetModText("LeaveDialog3"), SWS_GetModText("LeaveDialog4"),
	SWS_GetModText("LeaveDialog5"), SWS_GetModText("LeaveDialog6")
}

SWS_greetTexts = {
	SWS_GetModText("GreetDialog1"), SWS_GetModText("GreetDialog2"),
	SWS_GetModText("GreetDialog3"), SWS_GetModText("GreetDialog4"),
	SWS_GetModText("GreetDialog5"), SWS_GetModText("GreetDialog6"),
	SWS_GetModText("GreetDialog7"), SWS_GetModText("GreetDialog8")
}

SWS_meetTexts = {
	leader = { SWS_GetModText("MeetDialog1"), SWS_GetModText("MeetDialog2") },
	trader = { SWS_GetModText("MeetDialog3"), SWS_GetModText("MeetDialog4") },
	doctor = { SWS_GetModText("MeetDialog5"), SWS_GetModText("MeetDialog6") },
	sheriff = { SWS_GetModText("MeetDialog7"), SWS_GetModText("MeetDialog8") },
	default = { SWS_GetModText("HelloThere"), SWS_GetModText("HiFriend") }
}

function SWS_AddGroupSpawnPoint(basePos, farmPos, altBasePos, altFarmPos, mapName)
	if mapName == nil then mapName = SpawnMapName end
	table.insert(GroupSpawnPoints[mapName], {basePos, altBasePos})
	table.insert(FarmSpawnPoints[mapName], {farmPos, altFarmPos})
	if #GroupSpawnStates[mapName] < #GroupSpawnPoints[mapName] then
		table.insert(GroupSpawnStates[mapName], 0)
	end
	SWS_SpawnStatesChanged = true
end

function SWS_AddGangSpawnPoint(spawnPos, patrolX, patrolY, mapName)
	if mapName == nil then mapName = SpawnMapName end
	table.insert(GangSpawnPoints[mapName], {spawnPos[1], spawnPos[2], patrolX, patrolY})
	if #GangSpawnStates[mapName] < #GangSpawnPoints[mapName] then
		table.insert(GangSpawnStates[mapName], 0)
	end
end

function SWS_RemoveGroupSpawnPoints(bounds, mapName)
	local newSpawnPoints = {}
	local newFarmPoints = {}
	local newSpawnStates = {}
	
	if mapName == nil then mapName = SpawnMapName end
	
	for i=1, #GroupSpawnPoints[mapName] do
		local spawnPos1 = GroupSpawnPoints[mapName][i][1]
		local spawnPos2 = GroupSpawnPoints[mapName][i][2]
		
		if not (IsPointInBounds(spawnPos1[1], spawnPos1[2], bounds) or
		IsPointInBounds(spawnPos2[1], spawnPos2[2], bounds)) then
			table.insert(newSpawnPoints, GroupSpawnPoints[mapName][i])
			table.insert(newFarmPoints, FarmSpawnPoints[mapName][i])
			table.insert(newSpawnStates, GroupSpawnStates[mapName][i])
		end
	end
	
	if #GroupSpawnStates[mapName] > #newSpawnPoints then
		GroupSpawnStates[mapName] = newSpawnStates
	end
	
	GroupSpawnPoints[mapName] = newSpawnPoints
	FarmSpawnPoints[mapName] = newFarmPoints
end

function SWS_RemoveGangSpawnPoints(bounds, mapName)
	local newSpawnPoints = {}
	local newSpawnStates = {}
	
	if mapName == nil then mapName = SpawnMapName end
	
	for i=1, #GangSpawnPoints[mapName] do
		local spawnPos = GangSpawnPoints[mapName][i]
		
		if not IsPointInBounds(spawnPos[1], spawnPos[2], bounds) then
			table.insert(newSpawnPoints, GangSpawnPoints[mapName][i])
			table.insert(newSpawnStates, GangSpawnStates[mapName][i])
		end
	end
	
	if #GangSpawnStates[mapName] > #newSpawnPoints then
		GangSpawnStates[mapName] = newSpawnStates
	end
	
	GangSpawnPoints[mapName] = newSpawnPoints
end

function SWS_ClearGroupSpawnPoints(mapName)
	if mapName == nil then mapName = SpawnMapName end
	GroupSpawnPoints[mapName] = {}
	FarmSpawnPoints[mapName] = {}
	GroupSpawnStates[mapName] = {}
end

function SWS_ClearGangSpawnPoints(mapName)
	if mapName == nil then mapName = SpawnMapName end
	GangSpawnPoints[mapName] = {}
	GangSpawnStates[mapName] = {}
end

function SWS_GetGroupSpawnPoints(mapName)
	if mapName == nil then mapName = SpawnMapName end
	return GroupSpawnPoints[mapName]
end

function SWS_GetGangSpawnPoints(mapName)
	if mapName == nil then mapName = SpawnMapName end
	return GangSpawnPoints[mapName]
end

function SWS_CreateNewSpawnMap(mapName, groupSpawnPoints, farmSpawnPoints, gangSpawnPoints)
	if GroupSpawnPoints[mapName] then
		print("SWS: spawn points already exist for map name " .. mapName)
		return
	end
	
	if groupSpawnPoints then
		GroupSpawnPoints[mapName] = groupSpawnPoints
	else
		GroupSpawnPoints[mapName] = {}
	end	
	if farmSpawnPoints then
		FarmSpawnPoints[mapName] = farmSpawnPoints
	else
		FarmSpawnPoints[mapName] = {}
	end
	if gangSpawnPoints then
		GangSpawnPoints[mapName] = gangSpawnPoints
	else
		GangSpawnPoints[mapName] = {}
	end
	
	if not GroupSpawnStates[mapName] then
		GroupSpawnStates[mapName] = {}
		for i=1, #GroupSpawnPoints[mapName] do
			table.insert(GroupSpawnStates[mapName], 0)
		end
	end
	
	if not GangSpawnStates[mapName] then
		GangSpawnStates[mapName] = {}
		for i=1, #GangSpawnStates[mapName] do
			table.insert(GangSpawnStates[mapName], 0)
		end
	end
end

function SWS_SelectSpawnMap(mapName)
	if not GroupSpawnPoints[mapName] then
		print("SWS: no spawn map named " .. mapName)
		return
	end
	
	SpawnMapName = mapName
end

function SWS_GetSpawnMapName()
	return SpawnMapName
end

function SWS_SaveModVars()
	if SWS_LiteralVarsChanged then
		local varList = {}
		varList.survivorLastContacted = survivorLastContacted
		varList.survivorLastZKills = survivorLastZKills
		varList.survivorSearchTimer = survivorSearchTimer
		varList.survivorKnockTimer = survivorKnockTimer
		varList.survivorRequestTimer = survivorRequestTimer
		varList.radioResponseTimer = radioResponseTimer
		varList.radioResponseType = radioResponseType
		varList.radioResponseGroupID = radioResponseGroupID
		varList.radioResponseSurvivorID = radioResponseSurvivorID
		varList.radioRequestSurvivorID = radioRequestSurvivorID
		
		if survivorTargetSquare then
			varList.survivorTargetX = survivorTargetSquare:getX()
			varList.survivorTargetY = survivorTargetSquare:getY()
			varList.survivorTargetZ = survivorTargetSquare:getZ()
		end
		
		SWS_SaveTable(varList, "SWS_LiteralVars.txt")
		SWS_LiteralVarsChanged = false
	end
	
	if SWS_SpawnStatesChanged then
		local spawnStates = { Groups=GroupSpawnStates, Gangs=GangSpawnStates }
		SWS_SaveTable(spawnStates, "SWS_SpawnStates.txt")
		SWS_SpawnStatesChanged = false
	end
	
	if SWS_ContGroupsChanged then
		SWS_SaveTable(contactedGroups, "SWS_ContactedGroups.txt")
		SWS_ContGroupsChanged = false
	end
	
	if SWS_SurvivorShopsChanged then
		SWS_SaveTable(survivorShopList, "SWS_SurvivorShops.txt")
		SWS_SurvivorShopsChanged = false
	end
end

function SWS_LoadModVars()
	if SWS_DoesFileExist("SWS_LiteralVars.txt") then
	
		local varList = SWS_LoadTable("SWS_LiteralVars.txt")
		survivorLastContacted = varList.survivorLastContacted
		survivorLastZKills = varList.survivorLastZKills
		survivorSearchTimer = varList.survivorSearchTimer
		survivorKnockTimer = varList.survivorKnockTimer
		survivorRequestTimer = varList.survivorRequestTimer
		radioResponseTimer = varList.radioResponseTimer
		radioResponseType = varList.radioResponseType
		radioResponseGroupID = varList.radioResponseGroupID
		radioResponseSurvivorID = varList.radioResponseSurvivorID
		radioRequestSurvivorID = varList.radioRequestSurvivorID
		
		if varList.survivorTargetX and getCell() then
			survivorTargetSquare = getCell():getGridSquare(varList.survivorTargetX, varList.survivorTargetY, varList.survivorTargetZ)
		end
	end
	
	if SWS_DoesFileExist("SWS_SpawnStates.txt") then
		local spawnStates = SWS_LoadTable("SWS_SpawnStates.txt")
		GroupSpawnStates = spawnStates.Groups
		GangSpawnStates = spawnStates.Gangs
	end
	
	if SWS_DoesFileExist("SWS_ContactedGroups.txt") then
		contactedGroups = SWS_LoadTable("SWS_ContactedGroups.txt")
	end
	
	if SWS_DoesFileExist("SWS_SurvivorShops.txt") then
		survivorShopList = SWS_LoadTable("SWS_SurvivorShops.txt")
	end
end

function SWS_SetRepeatFunc(c, a, f)
	for i=1, #minuteRepeatFuncs do
		if minuteRepeatFuncs[i] == nil then
			minuteRepeatFuncs[i] = {count=c, args=a, func=f}
			return
		end
	end
	table.insert(minuteRepeatFuncs, {count=c, args=a, func=f})
end

function SWS_RoundFloat(x)
	return x>=0 and math.floor(x+0.5) or math.ceil(x-0.5)
end

function SWS_SplitString(inputstr, sep)
	local t = {}
	if sep == nil then sep = "%s" end
	for str in string.gmatch(inputstr, "([^"..sep.."]+)") do
		table.insert(t, str)
	end
	return t
end

function SWS_ContainerItemCount(inventory, itemID)
	if not inventory then return 0 end
	local result = 0
	local invItem = inventory:getItemFromTypeRecurse(itemID)
	if not invItem then return 0 end
	if invItem:IsDrainable() then
		local invItems = inventory:getItems()
		for i=0, invItems:size()-1 do
			invItem = invItems:get(i)
			if invItem:getFullType() == itemID then
				if invItem:IsDrainable() then
					result = result + invItem:getRemainingUses()
				end
			elseif invItem:IsInventoryContainer() then
				result = result + SWS_ContainerItemCount(invItem:getItemContainer(), itemID)
			end
		end
	else
		result = inventory:getItemCountRecurse(itemID)
	end
	return result
end

function SWS_PlayerItemCount(player, itemID)
	if not player then return 0 end
	return SWS_ContainerItemCount(player:getInventory(), itemID)
end

function SWS_PlayerRemoveItems(player, itemID, quantity)
	local playerInv = player:getInventory()
	if not playerInv then return false end
	local invItem = playerInv:getItemFromTypeRecurse(itemID)
	if not invItem then return false end
	local remQuant = quantity
	if invItem:IsDrainable() then
		local remUses = invItem:getRemainingUses()
		if remUses > remQuant then
			local usedDelta = invItem:getUseDelta() * remQuant
			invItem:setUsedDelta(invItem:getUsedDelta() - usedDelta)
		else
			while true do
				invItem:setUsedDelta(0.0)
				invItem:Use(true)
				remQuant = remQuant - remUses
				if remQuant <= 0 then break end
				invItem = playerInv:getItemFromTypeRecurse(itemID)
				if not (invItem and invItem:IsDrainable()) then break end
				remUses = invItem:getRemainingUses()
				if remUses > remQuant then
					local usedDelta = invItem:getUseDelta() * remQuant
					invItem:setUsedDelta(invItem:getUsedDelta() - usedDelta)
					break
				end
			end
		end
	else
		for r=1, quantity do
			playerInv:removeItemWithIDRecurse(invItem:getID())
			invItem = playerInv:getItemFromTypeRecurse(itemID)
			if not invItem then break end
		end
	end
	return true
end

function SWS_RemoveShopStock(shopInv, itemName, quant)
	for i=1, #shopInv do
		if shopInv[i].Name == itemName then
			shopInv[i].Stock = math.max(shopInv[i].Stock-quant, 0)
			break
		end
	end
end

function SWS_AddNewShopStock(shopInv, newInv)
	local invSize = #shopInv
	for n=1, #newInv do
		local invIndex = 0
		for i=1, invSize do
			if newInv[n].Name == shopInv[i].Name then
				invIndex = i
				break
			end
		end
		if invIndex > 0 then
			shopInv[invIndex].Stock = math.min(shopInv[invIndex].Stock+newInv[n].Stock, newInv[n].MaxStock)
		else
			table.insert(shopInv, newInv[n])
		end
	end
end

function SWS_SimRandomShoppers(shopInv)
	for i=1, #shopInv do
		if shopInv[i].Stock > 0 then
			shopInv[i].Stock = shopInv[i].Stock - ZombRand(shopInv[i].Stock+1)
		end
	end
end

function SWS_GenNewShopStock(stockType)
	local stockItems = {}
	for i=1, #SWS_shopItems[stockType] do
		local shopItem = SWS_shopItems[stockType][i]
		table.insert(stockItems, {
			Name = getItemNameFromFullType(shopItem.ItemID),
			BaseID = shopItem.ItemID,
			Price = shopItem.Price,
			Stock = ZombRand(shopItem.MaxStock+1),
			MaxStock = shopItem.MaxStock
		})
	end
	return stockItems
end

function SWS_AddShopToList(shopName, stockType)
	for i=1, #survivorShopList do
		if survivorShopList[i] == nil then
			survivorShopList[i] = {Name=shopName, Type=stockType}
			return
		end
	end
	table.insert(survivorShopList, {Name=shopName, Type=stockType})
	SWS_SurvivorShopsChanged = true
end

function SWS_GetRealItemPrice(itemPrice)
	return math.max(1, SWS_RoundFloat(itemPrice-(itemPrice*survivorShopDiscount)))
end

function SWS_UpdateShopStock(shopInv, stockType)
	local newStock = SWS_GenNewShopStock(stockType)
	SWS_AddNewShopStock(shopInv, newStock)
	SWS_SimRandomShoppers(shopInv)
end

function SWS_PurchaseShopStock(invItem, quant)
	local mainPlayer = getSpecificPlayer(0)
	local totalCost = SWS_GetRealItemPrice(invItem.Price) * quant
	if invItem.Stock < quant then
		if invItem.Stock < 1 then
			return SWS_GetModText("OutOfStock")
		else
			return SWS_GetModText("NotEnoughStock")
		end
	elseif SWS_PlayerItemCount(mainPlayer, "Base.Money") < totalCost then
		return SWS_GetModText("InsufficientFunds")
	else
		mainPlayer:getInventory():AddItems(invItem.BaseID, quant)
		SWS_PlayerRemoveItems(mainPlayer, "Base.Money", totalCost)
		invItem.Stock = invItem.Stock - quant
		return ""
	end
end

function SWS_GenShopInvText(shopInv, invIndex)
	local invText = ""
	for i=1, #shopInv do
		if shopInv[i].Stock > 0 then
			if i == invIndex then invText = invText .. "> " end
			invText = invText .. shopInv[i].Name .. " ($" .. SWS_GetRealItemPrice(shopInv[i].Price) .. ")\n"
		end
	end
	return invText
end

function SWS_GenShopItemText(invItem)
	return SWS_GetModText("Item")..": "..invItem.Name.."\n\n"..SWS_GetModText("Stock")..": "..
		invItem.Stock.."\n\n"..SWS_GetModText("Price")..": $"..SWS_GetRealItemPrice(invItem.Price)
end

function SWS_GenMedExamText(glassCount, bulletCount, woundCount, infectCount, antibioReq, splintsReq, bandagesReq, stitchesReq, medCost)
	local result = SWS_GetModText("LetsSeeHere")
	if glassCount > 0 then
		local glassName = SWS_GetModText("GlassShard")
		if glassCount > 1 then glassName = SWS_GetModText("GlassShards") end
		result = result .. glassCount .. " " .. glassName .. SWS_GetModText("LodgedInYou")
	end
	if bulletCount > 0 then
		local bulletName = SWS_GetModText("Bullet")
		if bulletCount > 1 then bulletName = SWS_GetModText("Bullets") end
		result = result .. bulletCount .. " " .. bulletName .. SWS_GetModText("EmbeddedInYou")
	end
	if woundCount > 0 then
		local woundName = SWS_GetModText("DeepWound")
		if woundCount > 1 then woundName = SWS_GetModText("DeepWounds") end
		result = result .. woundCount .. " " .. woundName .. ", "
	end
	if infectCount > 0 then
		local infectName = SWS_GetModText("InfectedWound")
		if infectCount > 1 then infectName = SWS_GetModText("InfectedWounds") end
		result = result .. infectCount .. " " .. infectName .. ", "
	end
	if splintsReq > 0 then
		local splintName = SWS_GetModText("FracturedBone")
		if splintsReq > 1 then splintName = SWS_GetModText("FracturedBones") end
		result = result .. splintsReq .. " " .. splintName .. ", "
	end
	if result == SWS_GetModText("LetsSeeHere") then
		result = result .. SWS_GetModText("SomeMinorInjuries") .. "\n\n"
	else
		result = result .. SWS_GetModText("ItLooksPrettyBad") .. "\n\n"
	end
	local treatText = SWS_GetModText("TreatmentRequires")
	if bandagesReq == 1 then
		treatText = treatText .. " " .. SWS_GetModText("ABandage")
	elseif bandagesReq > 1 then
		treatText = treatText .. " " .. bandagesReq .. " " .. SWS_GetModText("Bandages")
	end
	if splintsReq == 1 then
		if bandagesReq > 0 then
			treatText = treatText .. SWS_GetModText("And") .. SWS_GetModText("ASplint")
		else
			treatText = treatText .. " " .. SWS_GetModText("ASplint")
		end
	elseif splintsReq > 1 then
		if bandagesReq > 0 then
			if stitchesReq > 0 or antibioReq > 0 then
				treatText = treatText .. ", " .. splintsReq .. " " .. SWS_GetModText("Splints")
			else
				treatText = treatText .. SWS_GetModText("And") .. splintsReq .. " " .. SWS_GetModText("Splints")
			end
		else
			treatText = treatText .. " " .. splintsReq .. " " .. SWS_GetModText("Splints")
		end
	end
	if stitchesReq > 0 then
		if treatText == SWS_GetModText("TreatmentRequires") then
			treatText = treatText .. " " .. SWS_GetModText("SomeStitches")
		elseif antibioReq > 0 then
			treatText = treatText .. ", " .. SWS_GetModText("SomeStitches") .. ","
		else
			treatText = treatText .. SWS_GetModText("And") .. SWS_GetModText("SomeStitches")
		end
	end
	if antibioReq > 0 then
		if treatText == SWS_GetModText("TreatmentRequires") then
			treatText = treatText .. " " .. SWS_GetModText("SomeAntibiotics")
		else
			treatText = treatText .. SWS_GetModText("And") .. SWS_GetModText("SomeAntibiotics")
		end
	end
	if treatText == SWS_GetModText("TreatmentRequires") then
		result = result .. SWS_GetModText("TreatmentWillCost") .. medCost
	else
		result = result .. treatText .. SWS_GetModText("WhichWillCost") .. medCost
	end
	return result
end

function SWS_AddContactedGroup(newGroupID, spawnPoint, spawnFunc, spawnFuncArgs)
	table.insert(contactedGroups, {
		groupID=newGroupID, leaderID=-1, traderID=0, doctorID=0, sheriffID=0, findQuest=-1,
		leaderQuest=-1, traderQuest=-1, doctorQuest=-1, sheriffQuest=-1, spawnQuest=-1, spawnAttempts=0, 
		spawnPoint={spawnPoint.X,spawnPoint.Y}, spawnData={spawnPoint.AreaIndex,spawnPoint.VariIndex},
		isSpawned=false, isFound=false, spawnFunc=spawnFunc, spawnFuncArgs=spawnFuncArgs
	})
	GroupSpawnStates[SpawnMapName][spawnPoint.AreaIndex] = spawnPoint.VariIndex
	SWS_ContGroupsChanged = true
	SWS_SpawnStatesChanged = true
	return contactedGroups[#contactedGroups]
end

function SWS_GetContactedGroup(groupID)
	for i=1, #contactedGroups do
		if contactedGroups[i] and contactedGroups[i].groupID == groupID then
			return contactedGroups[i]
		end
	end
	SWS_ContGroupsChanged = true
end

function SWS_ContactedGroups()
	return contactedGroups
end

function SWS_HasMedicSkills(player)
	return player:getPerkLevel(Perks.FromString("First Aid")) > 1
end

function SWS_HasFarmingSkills(player)
	return player:getPerkLevel(Perks.FromString("Farming")) > 1
end

function SWS_HasShootingSkills(player)
	return player:getPerkLevel(Perks.FromString("Firearm")) > 1
end

function SWS_IncreaseSkillLevel(player, skill, levels, limit)
	local jobPerk = Perks.FromString(skill)
	for l=1, levels do
		if tostring(jobPerk) ~= "MAX" and player:getPerkLevel(jobPerk) < limit then
			player:LevelPerk(jobPerk)
		end
	end
end

function SWS_RemoveZombiesInArea(args)
	local zRefs = {}
	local cellZombies = getCell():getZombieList()
	for i=0, cellZombies:size()-1 do
		local z = cellZombies:get(i)
		if z and getDistanceBetweenPoints(args[1], args[2], z:getX(), z:getY()) <= args[3] then
			local zSquare = z:getCurrentSquare()
			if zSquare and not zSquare:IsOnScreen() then
				table.insert(zRefs, z)
			end
		end
	end
	for i=1, #zRefs do
		zRefs[i]:removeFromWorld()
	end
end

function SWS_RemoveZombiesAroundSquare(square)
	if not square then return end
	local myCell = getCell()
	local nextX = square:getX() + 1
	local nextY = square:getY() + 1
	local nextSquare
	
	local z = square:getZombie()
	if z and not square:IsOnScreen() then
		z:removeFromWorld()
	end
	
	for l=1, 4 do
		for i=1, 2 do
			nextSquare = myCell:getGridSquare(nextX,nextY,0)
			if nextSquare then
				z = nextSquare:getZombie()
				if z and not nextSquare:IsOnScreen() then
					z:removeFromWorld()
				end
			end
			if l == 1 then
				nextX = nextX - 1
			elseif l == 2 then
				nextY = nextY - 1
			elseif l == 3 then
				nextX = nextX + 1
			elseif l == 4 then
				nextY = nextY + 1
			end
		end
	end
end

function ClosestFreeAdjacentSquare(square, x, y)
	local bestDist = getDistanceBetweenPoints(x, y, square:getX(), square:getY())
	local bestSquare = square
	local myCell = getCell()
	local nextX = square:getX() + 1
	local nextY = square:getY() + 1
	local squareZ = square:getZ()
	local nextSquare
	
	for l=1, 4 do
		for i=1, 2 do
			nextSquare = myCell:getGridSquare(nextX,nextY,squareZ)
			if nextSquare and nextSquare:isSolidFloor() and not (nextSquare:isSolid() or square:isBlockedTo(nextSquare)) then
				local dist = getDistanceBetweenPoints(x, y, nextSquare:getX(), nextSquare:getY())
				if dist < bestDist then
					bestDist = dist
					bestSquare = nextSquare
				end
			end
			if l == 1 then
				nextX = nextX - 1
			elseif l == 2 then
				nextY = nextY - 1
			elseif l == 3 then
				nextX = nextX + 1
			elseif l == 4 then
				nextY = nextY + 1
			end
		end
	end
	
	return bestSquare
end

function FindFreeAdjacentSquare(x, y, z)
	local myCell = getCell()
	local nextX = x + 1
	local nextY = y + 1
	local nextSquare
	
	for l=1, 4 do
		for i=1, 2 do
			nextSquare = myCell:getGridSquare(nextX,nextY,z)
			if nextSquare and nextSquare:isSolidFloor() and not nextSquare:isSolid() then
				return nextSquare
			end
			if l == 1 then
				nextX = nextX - 1
			elseif l == 2 then
				nextY = nextY - 1
			elseif l == 3 then
				nextX = nextX + 1
			elseif l == 4 then
				nextY = nextY + 1
			end
		end
	end
	
	return false
end

function IsPointInBounds(x, y, bounds)
	if bounds then
		if (x >= bounds[1]) and (x <= bounds[2]) and (y >= bounds[3]) and (y <= bounds[4]) then
			return true
		else 
			return false
		end
	end
	return false
end

function IsPointInAnyBase(x, y)
	for i=0, SSGM:getCount() do
		local group = SSGM:Get(i)
		if group and group:getBounds() then
			if IsPointInBounds(x, y, group:getBounds()) then
				return true
			end
		end
	end
	return false
end

function IsObjectBurntFloor(sqObject)
	if not sqObject then return false end
	if sqObject:getObjectName() == "IsoObject" and sqObject:getTextureName() == "floors_burnt_01_0" then
		return true
	end
	return false
end

function IsSquareInBurntBuilding(square)
	local shifts = {
		{0, -1}, {1, 0}, {1, 1}, {1, -1},
		{0, 1}, {-1, 0}, {-1, 1}, {-1, -1}
	}
	
	local myCell = getCell()
	local origX = square:getX()
	local origY = square:getY()
	local sqObjects = square:getObjects()
	local x, y
	
	if sqObjects and sqObjects:size() > 0 then
		if IsObjectBurntFloor(sqObjects:get(0)) then return true end
	end
	
	for i=1, #shifts do
		x = origX + shifts[i][1]
		y = origY + shifts[i][2]
		square = myCell:getGridSquare(x,y,0)
		if square then
			sqObjects = square:getObjects()
		else
			sqObjects = nil
		end
		if sqObjects and sqObjects:size() > 0 then
			if IsObjectBurntFloor(sqObjects:get(0)) then return true end
		end
	end
	
	return false
end

function IsSquareOkForBase(square, myGroup)
	if square:isOutside() then return false end
	if ((not myGroup:getBounds()) or not myGroup:IsInBounds(square)) and not square:IsOnScreen() then
		groupBase = square:getBuilding()
		return (groupBase and groupBase:getRoomsNumber() > 1 and not groupBase:isToxic())
	end
	return false
end

function IsSquareOkForSpawn(square, myGroup)
	if ((not myGroup:getBounds()) or not myGroup:IsInBounds(square)) and not square:IsOnScreen() then 
		return (square:isSolidFloor() and not square:isSolid())
	end
	return false
end

function IsSquareFloorAndFree(square)
	return (square:isSolidFloor() and not square:isSolid())
end

function IsSquareOutsideAndFree(square)
	return (square:isOutside() and IsSquareFloorAndFree(square))
end

function IsInstanceOfRadio(item)
	if item and item ~= nil and instanceof(item, "Radio") then
		return true
	end
	return false
end

function IsWorkingTwoWayRadio(radioData)
	if radioData:getIsTwoWay() and radioData:getIsTurnedOn() and radioData:getPower() > 0 then
		return true
	end
	return false
end

function GetEquipedRadioFromEitherHand(player)
	local equipedItem = player:getPrimaryHandItem()--getEquipedRadio()
	if not IsInstanceOfRadio(equipedItem) then
		equipedItem = player:getSecondaryHandItem()
		if not IsInstanceOfRadio(equipedItem) then return nil end
	end
	return equipedItem
end

function ForceEquipWalkieTalkie(player, tuneToChannel)
	local equipedRadio = player:getEquipedRadio()
	if (not equipedRadio) or (equipedRadio == nil) or (not equipedRadio:getDeviceData():getIsTwoWay()) then

		local ssInvItems = player:getInventory():getItems()
		local radioInvIndex = -1
		for i=0, ssInvItems:size()-1 do
			for _, radioName in ipairs(npcWalkieTalkies) do
				if ssInvItems:get(i):getFullType() == radioName then
					radioInvIndex = i
					break
				end
			end
			if radioInvIndex >= 0 then break end
		end

		if radioInvIndex < 0 then
			local radioName = npcWalkieTalkies[ZombRand(4)+1]
			player:getInventory():AddItem(radioName)
			equipedRadio = player:getInventory():getItemFromType(radioName)
			print("SWS: Added " .. radioName .. " to survivors inventory")
		else
			equipedRadio = ssInvItems:get(radioInvIndex)
			print("SWS: Survivor already has walkie talkie in inventory")
		end

		player:setSecondaryHandItem(equipedRadio)
	end

	if tuneToChannel then
		equipedRadio:getDeviceData():setIsTurnedOn(true)
		equipedRadio:getDeviceData():setMicIsMuted(false)
		equipedRadio:getDeviceData():setChannel(tuneToChannel)
	end
	
	return equipedRadio
end

function GetIsoObjectItemName(properties)
	local groupname	= properties:Is("GroupName") and properties:Val("GroupName") or nil
	return (groupname and (groupname .. " ") or "") .. (properties:Is("CustomName") and properties:Val("CustomName") or "None")
end

function RadioFrequencyManagerUI:addChannelPreset(name, frequency)
    local channelElement = self:getRadioChannelElement()
    if (channelElement == nil) then
        return
    end
    local rwmChannelSubpanel = channelElement.subpanel

    -- Select channel preset if it already exists instead of creating a new preset
    for idx, _ in ipairs(rwmChannelSubpanel.comboBox.options) do
        local f = rwmChannelSubpanel.presets:get(idx - 1):getFrequency()
        if f == frequency then
            rwmChannelSubpanel.comboBox.selected = idx
            return
        end
    end

    -- Create new preset
    local freq = frequency / 1000
    rwmChannelSubpanel:doAddPresetButton()
    rwmChannelSubpanel.editPresetPanel.setValues(rwmChannelSubpanel.editPresetPanel, name, freq, freq, freq, 1, 0)
    rwmChannelSubpanel.editPresetPanel.doSaveButton(rwmChannelSubpanel.editPresetPanel)
end

function SWS_CreateNewMoneyBand(player, amount)
	local usedDelta = amount * 0.001
	SWS_PlayerRemoveItems(player, "Base.Money", amount)
	moneyBand = player:getInventory():AddItem("Base.SWSMoneyBand")
	moneyBand:setUsedDelta(usedDelta)
	moneyBand:setCustomWeight(true)
	moneyBand:setActualWeight(usedDelta)
	moneyBand:getModData().moneyCount = amount
	return moneyBand
end

function SWS_RandomSurvivorName(isFemale)
	if isFemale then
		return getRandomName("GirlNames")
	else
		return getRandomName("BoyNames")
	end		
end

function SWS_RandomRaiderTitle()
	return SWS_raiderTitles[ZombRand(#SWS_raiderTitles)+1]
end

function SWS_RandomRewardDialog()
	return SWS_rewardTexts[ZombRand(#SWS_rewardTexts)+1]
end

function SWS_RandomLeaveDialog()
	return SWS_leaveTexts[ZombRand(#SWS_leaveTexts)+1]
end

function SWS_RandomGreetDialog()
	return SWS_greetTexts[ZombRand(#SWS_greetTexts)+1]
end

function SWS_RandomMeetDialog(role)
	local meetTexts = SWS_meetTexts[role]
	if not meetTexts then meetTexts = SWS_meetTexts.default end
	return meetTexts[ZombRand(#meetTexts)+1]
end

function SWS_RandomWeapon(weapType)
	if weapType == "RangeWeapons" then
		return getWeapon(RangeWeapons[ZombRand(#RangeWeapons)+1])
	else
		return getWeapon(MeleWeapons[ZombRand(#MeleWeapons)+1])
	end
end

function SWS_GetPresetClothes(preset)
	local suits = SWS_outfitPresets[preset]
	if suits == nil then
		suits = SWS_outfitPresets["Preset_Default"];
	end
	return suits[ZombRand(#suits)+1]
end

function SWS_RandomOffscreenSquare(playerSq)
	local minX, minY, diffX, diffY	
	local randInt = ZombRand(4)
	
	if randInt == 0 then
		minX = playerSq:getX() - 60
		minY = playerSq:getY() - 60
		diffX = 31; diffY = 121
	elseif randInt == 1 then
		minX = playerSq:getX() + 30
		minY = playerSq:getY() - 60
		diffX = 31; diffY = 121
	elseif randInt == 2 then
		minX = playerSq:getX() - 60
		minY = playerSq:getY() - 60
		diffX = 121; diffY = 31
	else
		minX = playerSq:getX() - 60
		minY = playerSq:getY() + 30
		diffX = 121; diffY = 31
	end

	return getCell():getGridSquare(minX+ZombRand(diffX), minY+ZombRand(diffY), 0)
end

function SWS_RandomOffscreenSurvivor()
	local results = {}
	for i=1, SSM:forMax() do
		local SS = SSM:Get(i)
		if SS and SS:isInCell() and not SS:isOnScreen() then
			table.insert(results, SS)
		end
	end
	if #results > 0 then
		return results[ZombRand(#results)+1]
	end
	return false
end

function SWS_GetNearbyRaiders()
	local results = {}
	for i=1, SSM:forMax() do
		local SS = SSM:Get(i)
		if SS and SS:isInCell() and SS:isHostile() and SS.player:getModData().isRobber then
			table.insert(results, SS)
		end
	end
	return results
end

function SWS_GetGroupSpawnPoint(allowSpawned, max_range)
	local validSpawnAreas = GroupSpawnPoints[SpawnMapName]
	local spawnAreaIndex = ZombRand(#validSpawnAreas)+1
	local isSpawned = false
	
	if GroupSpawnStates[SpawnMapName][spawnAreaIndex] > 0 then isSpawned = true end
	
	if allowSpawned or not isSpawned then
	
		local spawnAreaVari = ZombRand(2)+1
		local spawnPoint = validSpawnAreas[spawnAreaIndex][spawnAreaVari]
		local dist = getDistanceBetweenPoints(spawnPoint[1], spawnPoint[2], getSpecificPlayer(0):getX(), getSpecificPlayer(0):getY())

		if dist < 200 or dist > max_range or IsPointInBounds(spawnPoint[1], spawnPoint[2], SSM:Get(0):getGroup():getBounds()) then
			return false
		end
		
		return { X=spawnPoint[1], Y=spawnPoint[2], AreaIndex=spawnAreaIndex, VariIndex=spawnAreaVari, Spawned=isSpawned }
	end
	
	print("SWS: group already spawned in area " .. spawnAreaIndex)
	return false
end

function SWS_SpawnSurvivorGroup(groupData)

	local myGroup = SSM:Get(0):getGroup()
	local myCell = getCell()
	local baseSquare, farmXY
	local buildingDef, groupBase
	local outX, outY
	local x, y, randInt
	local success = false
	local outSquare = nil
	
	if groupData then

		if groupData.spawnPoint then
			x = groupData.spawnPoint[1]
			y = groupData.spawnPoint[2]
		else
			print("SWS: invalid spawn point for survivor group")
			return false
		end

		for i=1,4 do
			baseSquare = myCell:getGridSquare(x,y,0)
			if baseSquare and IsSquareOkForBase(baseSquare, myGroup) then
				if groupData.spawnAttempts == 0 and IsSquareInBurntBuilding(baseSquare) then break end
				print("SWS: found group spawn point at " .. x .. "," .. y)
				success = true
				break
			end
			print("SWS: searching for valid group spawn point ...")
			x = x + ZombRand(5)-2
			y = y + ZombRand(5)-2
		end
		
		if not success then
			if groupData.spawnAttempts > 0 then return false end
			if groupData.spawnData[2] == 1 then
				groupData.spawnData[2] = 2
			else
				groupData.spawnData[2] = 1
			end
			groupData.spawnPoint = GroupSpawnPoints[SpawnMapName][groupData.spawnData[1]][groupData.spawnData[2]]
			return nil
		end
		
		farmXY = FarmSpawnPoints[SpawnMapName][groupData.spawnData[1]][groupData.spawnData[2]]
	else
		print("SWS: attempting to spawn group in nearby area")
		local playerSq = getSpecificPlayer(0):getCurrentSquare()
		
		for i=1,5 do	
			baseSquare = SWS_RandomOffscreenSquare(playerSq)	
			if baseSquare and IsSquareOkForBase(baseSquare, myGroup) then
				x = baseSquare:getX()
				y = baseSquare:getY()
				success = true
				break
			end
		end
	end
	
	if success then
		print("SWS: scanning for square outside building")
	
		if IsPointInAnyBase(x, y) then return false end
		groupBase = baseSquare:getBuilding()
		buildingDef = groupBase:getDef()
		if not buildingDef then return false end
		if buildingDef:isAlarmed() then buildingDef:setAlarmed(false) end
		
		for i=1, 4 do
			if i == 1 then
				outX = buildingDef:getX() - (ZombRand(4)+2)
				outY = y
			elseif i == 2 then
				outX = buildingDef:getX2() + (ZombRand(4)+2)
				outY = y
			elseif i == 3 then
				outX = x
				outY = buildingDef:getY() - (ZombRand(4)+2)
			else
				outX = x
				outY = buildingDef:getY2() + (ZombRand(4)+2)
			end
			outSquare = myCell:getGridSquare(outX,outY,0)
			if outSquare and IsSquareOutsideAndFree(outSquare) then
				break
			end
		end
	else
		print("SWS: failed to find valid base square")
		return false
	end

	local groupSize = 0
	local newGroup = nil
	local spawnSquare = nil
	local hostileGroup = false
	local hasOutGuard = false
	local hasSheriff = false
	local hasJunkman = false
	local hasDoctor = false
	local hasTrader = false
	local hasWorker = false
	local hasFarmer = false
	local skipCheck = false
	local questJobNum = 0
	local questJobs = { SS_Jobs.Trader, SS_Jobs.Doctor, SS_Jobs.Sheriff }
	local questJobPerks = { {"Maintenance","Foraging"}, {"First Aid","Fitness"}, {"Aiming","Reloading"} }

	local hoursSurvived = math.floor(getGameTime():getWorldAgeHours())
	local FinalChanceToBeHostile = ChanceToBeHostileNPC + math.floor(hoursSurvived/48)
	if (FinalChanceToBeHostile > MaxChanceToBeHostileNPC) then FinalChanceToBeHostile = MaxChanceToBeHostileNPC end
	
	local farmingBounds = {}
	
	local baseBounds = {
		baseSquare:getX() - 30, baseSquare:getX() + 30,
		baseSquare:getY() - 30, baseSquare:getY() + 30, 0
	}
	
	local forageBounds = {
		baseBounds[1] - 20, baseBounds[2] + 20,
		baseBounds[3] - 20, baseBounds[4] + 20
	}

	if groupData then
		groupSize = 4 + ZombRand(4)
		questJobNum = 3
		skipCheck = true
		hasTrader = true; hasDoctor = true; hasSheriff = true
		farmingBounds = {
			farmXY[1] - 3, farmXY[1] + 3,
			farmXY[2] - 2, farmXY[2] + 2
		}
	else
		if AltSpawnGroupSize > 1 then
			groupSize = ZombRand(1, AltSpawnGroupSize)
		else groupSize = 1 end
		if ZombRand(100) < FinalChanceToBeHostile then hostileGroup = true end
		randInt = ZombRand(4)
		if randInt == 0 then
			randInt = ZombRand(3)+1
			farmingBounds = {
				buildingDef:getX() - (6+randInt), buildingDef:getX() - randInt,
				buildingDef:getY(), buildingDef:getY2()
			}
		elseif randInt == 1 then
			randInt = ZombRand(3)+1
			farmingBounds = {
				buildingDef:getX2() + (6+randInt), buildingDef:getX2() + randInt,
				buildingDef:getY(), buildingDef:getY2()
			}
		elseif randInt == 2 then
			randInt = ZombRand(3)+1
			farmingBounds = {
				buildingDef:getX(), buildingDef:getX2(),
				buildingDef:getY() - (6+randInt), buildingDef:getY() - randInt
			}
		else
			randInt = ZombRand(3)+1
			farmingBounds = {
				buildingDef:getX(), buildingDef:getX2(),
				buildingDef:getY2() + (6+randInt), buildingDef:getY2() + randInt
			}
		end
	end

	for i=1, groupSize do
	
		if groupData and (groupSize == 1 or i == 1) then
			spawnSquare = baseSquare
		else
			spawnSquare = groupBase:getRandomRoom():getRandomFreeSquare()
		end

		if not spawnSquare then spawnSquare = baseSquare end

		local newSS = SSM:spawnSurvivor(nil, spawnSquare, skipCheck)
		if not newSS then return false end
		local newNPC = newSS:Get()
		local npcName = SWS_RandomSurvivorName(newNPC:isFemale())	
		local clothesPreset = nil

		newSS:giveRandomWeapon(hoursSurvived)
		newSS:setBaseBuilding(groupBase)
		newSS:setHostile(hostileGroup)
		newNPC:getModData().isRobber = false
		if groupData then newNPC:getModData().NoParty = true end

		if groupSize == 1 then
			--newSS:setName("Survivor "..npcName)
			newSS:getTaskManager():AddToTop(WanderInAreaTask:new(newSS, baseBounds))
			newSS:setAIMode("Random Solo")
			print("SWS: alt spawning solo survivor")
		elseif i == 1 then
			if hostileGroup then
				newSS:setName(SWS_GetModText("GangLeader").." "..npcName)
				clothesPreset = "Preset_Gangster"
			else
				newSS:setName(SWS_GetModText(SS_Jobs.Leader).." "..npcName)
				clothesPreset = "Preset_Leader"
			end
			if groupData then
				newGroup = SSGM:Get(groupData.groupID)
				groupData.leaderID = newSS:getID()
			else
				newGroup = SSGM:newGroup()
			end
			newGroup:setBounds(baseBounds)
			newGroup:setGroupArea("FarmingArea", farmingBounds[1],farmingBounds[2],farmingBounds[3],farmingBounds[4],0)
			newGroup:setGroupArea("ForageArea", forageBounds[1],forageBounds[2],forageBounds[3],forageBounds[4],0)
			newGroup:setGroupArea("ChopTreeArea", forageBounds[1],forageBounds[2],forageBounds[3],forageBounds[4],0)
			newGroup:addMember(newSS, SS_Jobs.Leader)
			newSS:getTaskManager():AddToTop(WanderInBaseTask:new(newSS))
			print("SWS: alt spawning group leader")
		else
			local jobTitle, jobPerks
			if questJobNum > 0 then
				jobTitle = questJobs[questJobNum]
				jobPerks = questJobPerks[questJobNum]
				questJobNum = questJobNum - 1
				for p=1, #jobPerks do
					SWS_IncreaseSkillLevel(newNPC, jobPerks[p], 4+ZombRand(4), 9)
				end
			else
				local newGroupJobs = { SS_Jobs.Guard }
				if not hasSheriff then table.insert(newGroupJobs, SS_Jobs.Sheriff) end
				if not hasJunkman then table.insert(newGroupJobs, SS_Jobs.Junkman) end
				if not hasDoctor then table.insert(newGroupJobs, SS_Jobs.Doctor) end
				if not hasWorker then table.insert(newGroupJobs, SS_Jobs.Worker) end
				if not hasFarmer then table.insert(newGroupJobs, SS_Jobs.Farmer) end
				if not hasTrader then table.insert(newGroupJobs, SS_Jobs.Trader) end
				jobTitle = newGroupJobs[ZombRand(#newGroupJobs)+1]
			end

			if jobTitle == SS_Jobs.Doctor and not SWS_HasMedicSkills(newNPC) then
				SWS_IncreaseSkillLevel(newNPC, "First Aid", 4+ZombRand(4), 9)
			elseif jobTitle == SS_Jobs.Farmer and not SWS_HasFarmingSkills(newNPC) then
				SWS_IncreaseSkillLevel(newNPC, "Farming", 4+ZombRand(4), 9)
			elseif jobTitle == SS_Jobs.Sheriff and not SWS_HasShootingSkills(newNPC) then
				SWS_IncreaseSkillLevel(newNPC, "Firearm", 4+ZombRand(4), 9)
			end

			if hostileGroup then
				newSS:setName(SWS_RandomRaiderTitle().." "..npcName)
			else
				newSS:setName(SWS_GetModText(jobTitle).." "..npcName)
			end

			newGroup:addMember(newSS, jobTitle)

			if jobTitle == SS_Jobs.Guard then
				clothesPreset = "Preset_Guard"
				if not newSS:hasWeapon() then
					newSS:giveWeapon(MeleWeapons[ZombRand(#MeleWeapons)+1], true)
				end
				if outSquare and not hasOutGuard then
					newSS:getTaskManager():AddToTop(GuardTask:new(newSS, outSquare))
					hasOutGuard = true
				else
					newSS:getTaskManager():AddToTop(GuardTask:new(newSS, spawnSquare))
				end
			elseif jobTitle == SS_Jobs.Sheriff then
				clothesPreset = "Preset_Police"
				if not newSS:hasGun() then
					newSS:giveWeapon(getWeapon(RangeWeapons[ZombRand(#RangeWeapons)+1]), true)
				end
				if outSquare then
					newSS:getTaskManager():AddToTop(PatrolTask:new(newSS, spawnSquare, outSquare))
				elseif spawnSquare ~= baseSquare then
					newSS:getTaskManager():AddToTop(PatrolTask:new(newSS, spawnSquare, baseSquare))
				else
					newSS:getTaskManager():AddToTop(GuardTask:new(newSS, spawnSquare))
				end
				if groupData then groupData.sheriffID = newSS:getID() end
				hasSheriff = true
			elseif jobTitle == SS_Jobs.Trader then
				clothesPreset = "Preset_Trader"
				newSS:getTaskManager():AddToTop(WanderInBaseTask:new(newSS))
				if groupData then groupData.traderID = newSS:getID() end
				hasTrader = true
			elseif jobTitle == SS_Jobs.Doctor then
				clothesPreset = "Preset_Doctor"
				newSS:getTaskManager():AddToTop(DoctorTask:new(newSS))
				if groupData then groupData.doctorID = newSS:getID() end
				hasDoctor = true
			elseif jobTitle == SS_Jobs.Junkman then
				newSS:getTaskManager():AddToTop(ForageTask:new(newSS))
				hasJunkman = true
			elseif jobTitle == SS_Jobs.Worker then
				clothesPreset = "Preset_Worker"
				newSS:getTaskManager():AddToTop(BarricadeBuildingTask:new(newSS))
				hasWorker = true
			elseif jobTitle == SS_Jobs.Farmer then
				clothesPreset = "Preset_Farmer"
				newSS:getTaskManager():AddToTop(FarmingTask:new(newSS))
				hasFarmer = true
			end
			print("SWS: alt spawning group "..jobTitle)
		end

		if not newSS:hasWeapon() then
			local combatLvl = newNPC:getPerkLevel(Perks.FromString("Combat"))
			local firearmLvl = newNPC:getPerkLevel(Perks.FromString("Firearm"))
			if combatLvl > 1 and ZombRand(combatLvl) > 0 then
				newSS:giveWeapon(MeleWeapons[ZombRand(#MeleWeapons)+1], true)
			elseif firearmLvl > 1 and ZombRand(firearmLvl) > 0 then
				newSS:giveWeapon(getWeapon(RangeWeapons[ZombRand(#RangeWeapons)+1]), true)
			end
		end

		newSS:giveRandomFood()
		if clothesPreset then
			newSS:wearSuit(SWS_GetPresetClothes(clothesPreset))
		--else getRandomSurvivorSuit(newSS)
		end
	end

	SSQM:AddTrigger({TriggerName="ClearZombiesAroundGroup"..tostring(#contactedGroups), Enabled=true, TriggerOnlyOnce=true, 
		ConditionType="DistanceToSquare", SquareX=baseSquare:getX(), SquareY=baseSquare:getY(), Distance=60,
		ResultActions={{ActionType="CustomFunc", Arg1=baseSquare:getX(), Arg2=baseSquare:getY(), Arg3=30, FuncName="SWS_RemoveZombiesInArea"}}
	})
	
	return true
end

function SWS_SpawnSearchingRaiders(groupSize, targetX, targetY)
	
	local myCell = getCell()
	local myGroup = SSM:Get(0):getGroup()	
	if myGroup == nil then return false end
	
	local x, y
	local spawnSquares = {}
	local range = 50
	local drange = range*2
	
	for i=1,10 do
		local spawnLocation = ZombRand(4)
		if spawnLocation == 0 then
			x = targetX + (ZombRand(drange) - range)
			y = targetY - range
		elseif spawnLocation == 1 then
			x = targetX + range
			y = targetY + (ZombRand(drange) - range)
		elseif spawnLocation == 2 then
			x = targetX + (ZombRand(drange) - range)
			y = targetY + range
		elseif spawnLocation == 3 then
			x = targetX - range
			y = targetY + (ZombRand(drange) - range)
		end
	
		local spawnSquare = myCell:getGridSquare(x,y,0)
		
		if spawnSquare and spawnSquare:isOutside() and IsSquareOkForSpawn(spawnSquare, myGroup) then
			table.insert(spawnSquares, spawnSquare)
			break
		end		
	end	
	
	if #spawnSquares > 0 then
		
		local shifts = {
			{0, -1}, {1, 0}, {1, 1}, {1, -1},
			{0, 1}, {-1, 0}, {-1, 1}, {-1, -1}
		}
		
		for i=1, #shifts do
			if #spawnSquares == groupSize then break end
			local spawnSquare = myCell:getGridSquare(x+shifts[i][1],y+shifts[i][2],0)
			if spawnSquare and spawnSquare:isOutside() and IsSquareOkForSpawn(spawnSquare, myGroup) then
				table.insert(spawnSquares, spawnSquare)
			end
		end
		
		local hoursSurvived = math.floor(getGameTime():getWorldAgeHours())
		local targetSquare = myCell:getGridSquare(targetX, targetY, 0)
		local RaiderGroup = SSGM:newGroup()
		
		if not targetSquare then return end
		
		if getSpecificPlayer(0):isAsleep() then 
			getSpecificPlayer(0):Say(getDialogue("IGotABadFeeling"))
			getSpecificPlayer(0):forceAwake()
		else
			getSpecificPlayer(0):Say(getDialogue("WhatWasThatSound"));
		end
		
		for i=1, groupSize do
			local raider = SuperSurvivorRandomSpawn(spawnSquares[(i % #spawnSquares) + 1])
			if i == 1 then RaiderGroup:addMember(raider,"Leader")
			else RaiderGroup:addMember(raider,"Member") end
			
			raider:setHostile(true)
			raider.player:getModData().isRobber = true
			raider:setName(SWS_GetModText("Raider")..SWS_RandomSurvivorName(raider:Get():isFemale()))
			
			if (raider:hasWeapon() == false) then raider:giveRandomWeapon(hoursSurvived) end
			raider:giveRandomFood()
			raider:wearSuit(SWS_GetPresetClothes("Preset_Gangster"))
			
			local trackTask = RaiderTrackPlayerTask:new(raider, targetSquare)
			trackTask:setOnFound(function(SS)
				SS:getTaskManager():AddToTop(PursueTask:new(SS, getSpecificPlayer(0)))
			end, raider)
			raider:getTaskManager():AddToTop(trackTask)
		end
		--RaiderGroup:AllSpokeTo()
	end
end

function SWS_RecruitContactedSS(npcID)
	if npcID == nil then npcID = radioResponseSurvivorID end
	SSQM:RemoveTriggersWithName("SurvivorContactTriggers_" .. npcID)
	local SS = SSM:Get(npcID)
	if SS then SS:recruitSurvivor() end
	radioResponseSurvivorID = 0
	SWS_LiteralVarsChanged = true
end

function SWS_RejectContactedSS(npcID)
	if npcID == nil then npcID = radioResponseSurvivorID end
	SSQM:RemoveTriggersWithName("SurvivorContactTriggers_" .. npcID)
	local SS = SSM:Get(npcID)
	if SS then SS:rejectSurvivor() end
	radioResponseSurvivorID = 0
	SWS_LiteralVarsChanged = true
end

function SWS_NearContactedSS(npcID)
	if npcID == nil then npcID = radioResponseSurvivorID end
	local SS = SSM:Get(npcID)
	if SS and not SS:isDead() then
		SS:getTaskManager():clear()
		SS:getTaskManager():AddToTop(FollowTask:new(SS, getSpecificPlayer(0)))
		SS:setAIMode("Follow")
	end
end

function SWS_NearTrainStation(npcName)
	local doorSquare = getCell():getGridSquare(11082, 9231, 0)
	local boxSquare = getCell():getGridSquare(11087, 9229, 0)
	if not boxSquare then return end
	local sqObjects = boxSquare:getObjects()
	local rewardBox = nil
	
	local rewardItems = {
		{ItemID="Base.Bag_BigHikingBag", Quant=1}, {ItemID="Radio.WalkieTalkie4", Quant=1},
		{ItemID="Base.Pistol3", Quant=1}, {ItemID="Base.Bullets44", Quant=ZombRand(5,8)},
		{ItemID="Base.44Clip", Quant=1}, {ItemID="Base.Money", Quant=ZombRand(100,150)}
	}
	
	for j=0, sqObjects:size()-1 do
		if sqObjects:get(j):getContainer() ~= nil then
			rewardBox = sqObjects:get(j):getContainer()
			for i=1, #rewardItems do
				rewardBox:AddItems(rewardItems[i].ItemID, rewardItems[i].Quant)
			end
			break
		end
	end
	
	if doorSquare and rewardBox then
		local hostageSS = SSM:GetSurvivorByName(npcName)
		local sqDoor = doorSquare:getDoor(true)
		if sqDoor then
			local keyName = "Base.Key"..ZombRand(1,6)
			rewardBox:AddItem(keyName)
			local doorKey = rewardBox:getItemFromType(keyName)
			if doorKey then
				sqDoor:setKeyId(doorSquare:getBuilding():getDef():getKeyId())
				sqDoor:setHaveKey(true)
				sqDoor:setLockedByKey(true)
				sqDoor:getProperties():Set("forceLocked", "true")
				doorKey:setKeyId(sqDoor:getKeyId())
				doorKey:setName(SWS_GetModText("TrainStationKey"))
			end
		end
		if hostageSS then
			local survGroupID = SSQM:GetGlobalData("SurvivalistGroupID")
			if survGroupID then
				local survGroup = SSGM:Get(survGroupID)
				if survGroup then survGroup:addMember(hostageSS, SS_Jobs.Worker) end
			end
		end
	end
end

function SWS_TryPayRansom(args)
	local mainPlayer = getSpecificPlayer(0)
	local npcName = args[1]
	local leaderQuest = args[2]
	
	if SWS_PlayerItemCount(mainPlayer, "Base.Money") >= 1000 then
		local rewardItems = { "Base.HuntingKnife", "Base.WoodAxe" }
		local rewardItem = rewardItems[ZombRand(#rewardItems)+1]
		SWS_PlayerRemoveItems(mainPlayer, "Base.Money", 1000)
		mainPlayer:getInventory():AddItem(rewardItem)
		
		if SSQM:TriggerEnabled("TalkWithHostageTrigger_" .. leaderQuest) then
			SSQM:AddTrigger({TriggerName="TeleportHostageTrigger", Enabled=true, TriggerOnlyOnce=true, 
				ConditionType="DistanceFromSS", Distance=20, NPCName=npcName,
				ResultActions={
					{ActionType="SetSSWantsToTalk", Value=false, NPCName=npcName},
					{ActionType="TeleportSS", NPCName=npcName, X=11581, Y=9290, Z=0}
				}
			})
		end
		
		SSQM:SetTriggerEnabled("TalkWithHostageTrigger_" .. leaderQuest, false)
		SSQM:SetTriggerEnabled("NearTrainStationTrigger_" .. leaderQuest, false)
		SSQM:RunTriggerActions("RescuedHostageTrigger_" .. leaderQuest)
		
		return SWS_GetModText("PayRansomPart1")..getItemNameFromFullType(rewardItem)..SWS_GetModText("PayRansomPart2")
	else
		return SWS_GetModText("PayRansomFail")
	end
end

function SWS_SaveSurvalistGroupID()
	local tempSS = SSM:GetSurvivorByName(SWS_GetModText("SurvivalistLeader"))
	if tempSS then SSQM:SetGlobalData("SurvivalistGroupID", tempSS:getGroupID()) end
end

function SWS_LeaderGivePlayerJob(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then return end
	
	group.leaderQuest = SSQM:BeginQuest(tempQuestInfo.Title, tempQuestInfo.Desc, group.leaderID, tempQuestInfo.Target, tempQuestInfo.Reward)
	local rewardDialog = SWS_RandomRewardDialog() .. "\n\n" .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
	local GetRewardTrigger = nil
	
	local questStage = SSQM:GetGlobalData("QuestStage_"..group.leaderID)
	if questStage == 2 then
		SSQM:SetGlobalData("SaveSurvivalistQuestStarted", true)
	end
	
	local LeaveDialogueActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.leaderID}}
	
	local RewardDialogueActions = {
		{ActionType="SSDialogueW", NPCID=group.leaderID, Value=rewardDialog, ContinueResultActions=LeaveDialogueActions, ContinueBtnText=SWS_GetModText("Thanks")},
		{ActionType="RewardPlayer", ItemType=tempQuestInfo.Reward.BaseID, ItemQuantity=tempQuestInfo.Reward.Amount, NPCID=group.leaderID},
		{ActionType="DelayActions", Actions={{ActionType="EnableTrigger", Value="TalkWithLeaderTrigger_" .. group.groupID}}, Value=1},
		{ActionType="IncGlobalData", Name="QuestStage_"..group.leaderID, Value=1},
		{ActionType="FinishQuest", QuestID=group.leaderQuest},
		{ActionType="SetGroupData", GroupID=group.groupID, Name="leaderQuest", Value=-1}
	}
	
	if tempQuestInfo.Target and tempQuestInfo.Target.BaseID then
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.leaderQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="BringToSS", TargetID=tempQuestInfo.Target.BaseID, TargetCount=tempQuestInfo.Target.Count, 
			FailActions={{ActionType="SSSpeak", Value=SWS_GetModText("DontHaveItem"), NPCID=group.leaderID}},
			NPCID=group.leaderID, ResultActions=RewardDialogueActions
		}
	else
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.leaderQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="TalkToSS", NPCID=group.leaderID, ResultActions=RewardDialogueActions
		}
	end
	
	local GotTargetActions = {
		{ActionType="SetSSWantsToTalk", Value=true, NPCID=group.leaderID},
		{ActionType="DisableTrigger", Value="TalkWithLeaderTrigger_" .. group.groupID},
		{ActionType="DisableTrigger", Value="EnterOrLeaveTrigger_" .. group.leaderQuest},
		{ActionType="DisableTrigger", Value="DiscussRansomDialogueTrigger_" .. group.leaderQuest},
		{ActionType="SetTargetCoords", QuestID=group.leaderQuest, AltX=group.spawnPoint[1], AltY=group.spawnPoint[2], AltValue=SWS_GetModText("GroupBase")},
		{ActionType="UpdateQuestDesc", QuestID=group.leaderQuest, Value=SWS_GetModText("ReturnTo") .. group.leaderName},
		{ActionType="EnableTrigger", Value="GetRewardTrigger_"..group.leaderQuest}
	}
	
	local GotTargetTrigger = {
		TriggerName="GotTargetTrigger_"..group.leaderQuest, Enabled=true, TriggerOnlyOnce=true, 
		ConditionType="GotTargetCount", QuestID=group.leaderQuest, ResultActions=GotTargetActions
	}
	
	if tempQuestInfo.Target and tempQuestInfo.Target.Range then
	
		local EnterOrLeaveTrigger = {
			TriggerName="EnterOrLeaveTrigger_" .. group.leaderQuest, Enabled=true, TriggerOnlyOnce=false, 
			ConditionType="EnterOrLeaveArea", Distance=tempQuestInfo.Target.Range,
			CenterX=tempQuestInfo.Target.X, CenterY=tempQuestInfo.Target.Y
		}
		
		SSQM:AddQuestTriggers(group.leaderQuest, { EnterOrLeaveTrigger, GotTargetTrigger, GetRewardTrigger })
		
	elseif tempQuestInfo.Preset ~= nil then
		local npcFemale = ZombRand(2)
		local npcName = SWS_GetModText("Survivalist").." "..SWS_RandomSurvivorName(npcFemale)
		local leaderName = SWS_GetModText("SurvivalistLeader")
		
		local gangPreset = {
			Name = SWS_GetModText("RattlesnakesLeader"), Weapons = "RangeWeapons", X = 11086, Y = 9235, IsFemale = false, Hostile = true,
			Perk1Name = "Aiming", Perk1Level = ZombRand(3)+1, Perk2Name = "Reloading", Perk2Level = ZombRand(3)+1,
			Orders = "Patrol", PatrolX = 0, PatrolY = 5, Guards = 3, GuardName = SWS_GetModText("RattlesnakesThug"),
			GuardWeapons = "MeleWeapons", GuardsHostile = true, Suit = "Preset_Gangster", GuardSuit = "Preset_Gangster"
		}
		
		local npcPreset = {
			Name = npcName, IsFemale = npcFemale, X = 11082, Y = 9228, Orders = "Standing Ground", Suit = "Preset_Survivalist",
			Perk1Name = "Survivalist", Perk1Level = ZombRand(2)+2, Perk2Name = "PlantScavenging", Perk2Level = ZombRand(2)+2
		}
		
		local SendHostageHomeTrigger = {
			TriggerName="SendHostageHomeTrigger_"..group.leaderQuest, Enabled=false, TriggerOnlyOnce=true,
			ConditionType="DistanceFromSS", Distance=50, NPCName=npcName,
			ResultActions={{ActionType="TeleportSS", NPCName=npcName, X=11581, Y=9290, Z=0}}
		}
		
		local RescuedHostageTrigger = {
			TriggerName="RescuedHostageTrigger_"..group.leaderQuest, Enabled=false, TriggerOnlyOnce=true, ResultActions=GotTargetActions
		}
		
		local RejectHostageActions = {
			{ActionType="RunTriggerActions", Value="RescuedHostageTrigger_"..group.leaderQuest},
			{ActionType="EnableTrigger", Value="SendHostageHomeTrigger_"..group.leaderQuest},
			{ActionType="SSNextDialogueW", NPCName=npcName, ContinueBtnText=SWS_GetModText("Goodbye"),
			Value=SWS_GetModText("NoProbSeeYou"), ContinueResultActions={}}
		}
		
		local RecruitHostageActions = {
			{ActionType="RunTriggerActions", Value="RescuedHostageTrigger_"..group.leaderQuest},
			{ActionType="SSNextDialogueW", NPCName=npcName, ContinueBtnText=SWS_GetModText("FollowMe"),
			Value=SWS_GetModText("ThanksBoss"), ContinueResultActions={}},
			{ActionType="RecruitSS", NPCName=npcName}
		}
		
		local TalkWithHostageTrigger = {
			TriggerName="TalkWithHostageTrigger_"..group.leaderQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="TalkToSS", NPCName=npcName, ResultActions={
				{ActionType="SSQuestionDialogueW", NPCName=npcName, Value=SWS_GetModText("HostageDialog"),
				YesResultActions=RecruitHostageActions, NoResultActions=RejectHostageActions, 
				YesBtnText=SWS_GetModText("Recruit"), NoBtnText=SWS_GetModText("Leave")}
			}
		}
		
		local NearTrainStationTrigger = {
			TriggerName="NearTrainStationTrigger_" .. group.leaderQuest, Enabled=false, TriggerOnlyOnce=true,
			ConditionType="DistanceToSquare", SquareX=gangPreset.X, SquareY=gangPreset.Y, Distance=60,
			ResultActions={
				{ActionType="SpawnPresetGroup", Value=gangPreset},
				{ActionType="SpawnPresetSS", Value=npcPreset},
				{ActionType="SetSSWantsToTalk", Value=true, NPCName=npcName},
				{ActionType="EnableTrigger", Value="TalkWithHostageTrigger_"..group.leaderQuest},
				{ActionType="CustomFunc", Arg1=npcName, FuncName="SWS_NearTrainStation"}
			}
		}
		
		local TryPayRansomActions = {
			{ActionType="SSNextDialogueW", NPCName=leaderName, 
			ContinueBtnText=SWS_GetModText("Goodbye"), ContinueResultActions={},
			Arg1=npcName, Arg2=group.leaderQuest, DataFunc="SWS_TryPayRansom"}
		}

		local DiscussRansomDialogueActions = {
			{ActionType="SSQuestionDialogueW", NPCName=leaderName, Value=SWS_GetModText("DiscussRansomDialog"),
			YesResultActions=TryPayRansomActions, NoResultActions={}, YesBtnText=SWS_GetModText("Pay").." (1000)", NoBtnText=SWS_GetModText("Goodbye")}
		}
		
		local DiscussRansomNextDialogueActions = {
			{ActionType="SSNextDialogueW", NPCName=leaderName, Value=SWS_GetModText("DiscussRansomDialog"), isYesOrNoQuestion=true,
			YesResultActions=TryPayRansomActions, NoResultActions={}, YesBtnText=SWS_GetModText("Pay").." (1000)", NoBtnText=SWS_GetModText("Goodbye")}
		}
		
		local DiscussRansomDialogueTrigger = {
			TriggerName="DiscussRansomDialogueTrigger_" .. group.leaderQuest, Enabled=false, TriggerOnlyOnce=false,
			ConditionType="TalkToSS", NPCName=leaderName, ResultActions=DiscussRansomDialogueActions
		}
		
		local SurvivalistLeaderDialogueActions = {
			{ActionType="SSQuestionDialogueW", NPCName=leaderName, Value=group.leaderName..SWS_GetModText("SurvLeaderDialog1")..npcName..SWS_GetModText("SurvLeaderDialog2"), 
			YesBtnText=SWS_GetModText("OK"), NoBtnText=SWS_GetModText("DiscussRansom"), NoResultActions=DiscussRansomNextDialogueActions, YesResultActions={}},
			{ActionType="SetSSWantsToTalk", Value=false, NPCName=leaderName},
			{ActionType="SetTargetNPC", QuestID=group.leaderQuest, Name=npcName},
			{ActionType="SetTargetCoords", QuestID=group.leaderQuest, X=npcPreset.X, Y=npcPreset.Y, Value=SWS_GetModText("TrainStation")},
			{ActionType="UpdateQuestDesc", QuestID=group.leaderQuest, Value=SWS_GetModText("RescueOrPay")..leaderName},
			{ActionType="EnableTrigger", Value="DiscussRansomDialogueTrigger_" .. group.leaderQuest},
			{ActionType="EnableTrigger", Value="NearTrainStationTrigger_" .. group.leaderQuest},
			{ActionType="CustomFunc", FuncName="SWS_SaveSurvalistGroupID"}
		}

		local TalkWithSurvivalistLeaderTrigger = {
			TriggerName="TalkWithSurvivalistLeaderTrigger_"..group.leaderQuest, Enabled=true, TriggerOnlyOnce=true, 
			ConditionType="TalkToSS", NPCName=leaderName, ResultActions=SurvivalistLeaderDialogueActions
		}
		
		local NearSurvivalistGroupTrigger = {
			TriggerName="NearSurvivalistGroupTrigger_" .. group.leaderQuest, Enabled=true, TriggerOnlyOnce=true, ConditionType="DistanceToSquare",
			SquareX=tempQuestInfo.Target.X, SquareY=tempQuestInfo.Target.Y, Distance=60,
			ResultActions={
				{ActionType="SpawnPresetGroup", Value=tempQuestInfo.Preset},
				{ActionType="SetSSWantsToTalk", Value=true, NPCName=leaderName}
			}
		}
		
		SSQM:AddQuestTriggers(group.leaderQuest, {
			NearSurvivalistGroupTrigger, TalkWithSurvivalistLeaderTrigger, DiscussRansomDialogueTrigger,
			NearTrainStationTrigger, TalkWithHostageTrigger, RescuedHostageTrigger, SendHostageHomeTrigger, GetRewardTrigger
		})
		
		tempQuestInfo.Preset = nil
	else
		SSQM:AddQuestTriggers(group.leaderQuest, { GotTargetTrigger, GetRewardTrigger })
	end
	
	SWS_ContGroupsChanged = true
end

function SWS_LeaderJobDialog(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then
		tempDialogInfo.Dialog = SWS_GetModText("DontHaveWork")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {}
		return tempDialogInfo
	end
	
	tempDialogInfo.YesBtnText = SWS_GetModText("Accept")
	tempDialogInfo.NoBtnText = SWS_GetModText("Goodbye")
	tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
	
	if group.leaderQuest > 0 then
		tempDialogInfo.Dialog = SWS_GetModText("FinishYourTask")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", NPCID=group.leaderID}}
	else
		local questStage = SSQM:GetGlobalData("QuestStage_"..group.leaderID, 0)
		local questData = SSQM:GetGlobalData("QuestData_"..group.leaderID)
		
		if questData and questData.Stage == questStage then
			tempQuestInfo.Target = questData.Target
			tempQuestInfo.Reward = questData.Reward
			tempQuestInfo.Title = questData.Title
			tempQuestInfo.Desc = questData.Desc
			tempDialogInfo.Dialog = questData.Dialog
		else
			if questStage == 1 then
			
				local targetItems = {
					{ Name=SWS_GetModText("Composter"), Object="IsoCompost" },
					{ Name=SWS_GetModText("WoodenCrate"), Object="Wooden Crate" }
				}
				
				local targetItem = targetItems[ZombRand(#targetItems)+1]
				tempQuestInfo.Target = { Name=targetItem.Name, ObjectName=targetItem.Object, MapTitle=SWS_GetModText("GroupBase"), Method="build", Count=1, X=group.spawnPoint[1], Y=group.spawnPoint[2], Range=25 }
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = 250 }
				tempQuestInfo.Title = SWS_GetModText("TheHandyman")
				tempQuestInfo.Desc = SWS_GetModText("BuildA") ..targetItem.Name.. SWS_GetModText("NearGroupBase") .. group.leaderName
				tempDialogInfo.Dialog = SWS_GetModText("JobReqWoodExp") .. SWS_GetModText("BuildA") ..targetItem.Name.. " "..SWS_GetModText("NearOurBase").."\n\n"
				tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
				
			elseif questStage == 2 and not SSQM:GetGlobalData("SaveSurvivalistQuestStarted") then
			
				tempQuestInfo.Preset = {
					Name = SWS_GetModText("SurvivalistLeader"), IsFemale = ZombRand(2),
					Perk1Name = "Survivalist", Perk1Level = 4, Perk2Name = "PlantScavenging", Perk2Level = 3,
					X = 11588, Y = 9300, BaseX = 11581, BaseY = 9290, Weapons = "MeleWeapons", NoParty = true,
					Guards = 4, GuardsHostile = false, GuardOrders = "Forage,Explore,Guard,Chop Wood", 
					GuardName = SWS_GetModText("Survivalist"), GuardSuit = "Preset_Survivalist", Suit = "Preset_Survivalist"
				}
				
				tempQuestInfo.Target = { Name = SWS_GetModText("SurvivalistLeader"), MapTitle = SWS_GetModText("SurvivalistGroup"), X = 11588, Y = 9300 }
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = 1500 }
				tempQuestInfo.Title = SWS_GetModText("SavingTheSurvivalist")
				tempQuestInfo.Desc = SWS_GetModText("SpeakToThe") .. SWS_GetModText("SurvivalistLeader") .. SWS_GetModText("AtCoordsOnMap")
				tempDialogInfo.Dialog = SWS_GetModText("GotRadioReport").."\n\n"
				tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
			else
				local targetItems = nil
				local targetItem = nil
				local findCount = 0
				local rewardAmount = 0
				
				if questStage == 0 then
					targetItems = {
						{ Name=SWS_GetModText("WhiteLightBulb"), Plural=SWS_GetModText("WhiteLightBulbP"), ItemID="Base.LightBulb" },
						{ Name=SWS_GetModText("ScrapElectronics"), Plural=SWS_GetModText("ScrapElectronicsP"), ItemID="Base.ElectronicsScrap" },
						{ Name=SWS_GetModText("ElectricWire"), Plural=SWS_GetModText("ElectricWireP"), ItemID="Radio.ElectricWire" }
					}
					findCount = ZombRand(3)+4
					rewardAmount = findCount * 10
				else
					targetItems = {
						{ Name=SWS_GetModText("Amplifier"), Plural=SWS_GetModText("AmplifierP"), ItemID="Base.Amplifier" },
						{ Name=SWS_GetModText("RadioReceiver"), Plural=SWS_GetModText("RadioReceiverP"), ItemID="Radio.RadioReceiver" },
						{ Name=SWS_GetModText("RadioTransmitter"), Plural=SWS_GetModText("RadioTransmitterP"), ItemID="Radio.RadioTransmitter" }
					}
					findCount = ZombRand(3)+questStage
					rewardAmount = findCount * 50
				end
				
				targetItem = targetItems[ZombRand(#targetItems)+1]
				tempQuestInfo.Target = { Name=targetItem.Name, Plural=targetItem.Plural, BaseID=targetItem.ItemID, Method="find", Count=findCount }
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
				tempQuestInfo.Title = SWS_GetModText("TechScavenger")
				tempQuestInfo.Desc = SWS_GetModText("Find") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("AndBringThemTo") .. group.leaderName
				tempDialogInfo.Dialog = SWS_GetModText("NeedPartsToRepair") .. SWS_GetModText("Bring") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("ToMe").."\n\n"
				tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
			end
			
			questData = { Stage=questStage, Target=tempQuestInfo.Target, Reward=tempQuestInfo.Reward, Title=tempQuestInfo.Title, Desc=tempQuestInfo.Desc, Dialog=tempDialogInfo.Dialog }
			SSQM:SetGlobalData("QuestData_"..group.leaderID, questData)
		end
	
		local AcceptJobDialogueActions = {
			{ActionType="SSSpeak", Value=SWS_GetModText("GoodLuckOutThere"), NPCID=group.leaderID},
			{ActionType="CustomFunc", Arg1=group.groupID, FuncName="SWS_LeaderGivePlayerJob"}
		}
		
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesActions = AcceptJobDialogueActions
		tempDialogInfo.NoActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.leaderID}}
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", NPCID=group.leaderID}}
	end
	
	return tempDialogInfo
end

function SWS_NearOtherGroup(groupIDs, spawnFail)
	local group = SWS_GetContactedGroup(groupIDs[1])
	local otherGroup = SWS_GetContactedGroup(groupIDs[2])
	if not (group and otherGroup) then return end
	
	local targetSS = nil
	local targetID = otherGroup.traderID
	local targetNPC = "Trader"
	
	if not spawnFail then
		targetSS = SSM:Get(otherGroup.traderID)
		if (not targetSS) or targetSS:isDead() then
			for i=1, 3 do
				if i == 1 then
					targetSS = SSM:Get(otherGroup.leaderID)
					targetID = otherGroup.leaderID
					targetNPC = "Leader"
				elseif i == 2 then
					targetSS = SSM:Get(otherGroup.sheriffID)
					targetID = otherGroup.sheriffID
					targetNPC = "Sheriff"
				else
					targetSS = SSM:Get(otherGroup.doctorID)
					targetID = otherGroup.doctorID
					targetNPC = "Doctor"
				end
				if targetSS and not targetSS:isDead() then
					SSQM:UpdateQuestDesc(group.traderQuest, SWS_GetModText("TraderMissing")..SWS_GetModText(targetNPC)..SWS_GetModText("Instead"))
					break
				end
				targetSS = nil
			end
		end
	end
	
	if not targetSS then
		local ReturnPackageTrigger = {
			TriggerName="ReturnPackageTrigger_"..group.traderQuest, Enabled=true, TriggerOnlyOnce=true, 
			ConditionType="BringToSS", NPCID=group.traderID, TargetID="Base.SWSPackage", TargetCount=1, 
			FailActions={{ActionType="SSSpeak", Value=SWS_GetModText("DontHavePackage"), NPCID=group.traderID}},
			ResultActions={{ActionType="RunTriggerActions", Value="GetRewardTrigger_"..group.traderQuest}}
		}
		SSQM:SetTargetCoords(group.traderQuest, nil, nil, group.spawnPoint, SWS_GetModText("GroupBase"))
		SSQM:UpdateQuestDesc(group.traderQuest, SWS_GetModText("GroupMissing") .. group.traderName)
		SSQM:SetTriggerEnabled("TalkWithTraderTrigger_" .. group.groupID, false)
		SSQM:AddQuestTrigger(group.traderQuest, ReturnPackageTrigger)
		return
	end
	
	SSQM:SetTriggerEnabled("MeetWith"..targetNPC.."Trigger_" .. otherGroup.groupID, false)
	SSQM:SetTriggerEnabled("TalkWith"..targetNPC.."Trigger_" .. otherGroup.groupID, false)
	SSQM:SetTargetCoords(group.traderQuest, nil, nil, otherGroup.spawnPoint, SWS_GetModText("GroupBase"))
	SSQM:SetTargetNPC(group.traderQuest, targetSS:getName(), targetID)
	SSQM:PerformTriggerActions({{ActionType="SetSSWantsToTalk", Value=true, NPCID=otherGroup.traderID}}, "nearGroupFunc")
	
	local DeliverPackageActions = {
		{ActionType="SSDialogueW", NPCID=targetID, Value=SWS_GetModText("ThanksForPackage"),
		ContinueResultActions={}, ContinueBtnText=SWS_GetModText("Goodbye")},
		{ActionType="SetSSWantsToTalk", Value=true, NPCID=group.traderID},
		{ActionType="DisableTrigger", Value="TalkWithTraderTrigger_" .. group.groupID},
		{ActionType="EnableTrigger", Value="TalkWith"..targetNPC.."Trigger_" .. otherGroup.groupID},
		{ActionType="EnableTrigger", Value="GetRewardTrigger_" .. group.traderQuest},
		{ActionType="SetTargetCoords", QuestID=group.traderQuest, AltX=group.spawnPoint[1], AltY=group.spawnPoint[2], AltValue=group.traderName},
		{ActionType="SetTargetNPC", QuestID=group.traderQuest, Name=group.traderName, NPCID=group.traderID},
		{ActionType="UpdateQuestDesc", QuestID=group.traderQuest, Value=SWS_GetModText("ReturnTo") .. group.traderName}
	}
	
	local DeliverPackageTrigger = {
		TriggerName="DeliverPackageTrigger_"..group.traderQuest, Enabled=true, TriggerOnlyOnce=true, 
		ConditionType="BringToSS", NPCID=targetID, TargetID="Base.SWSPackage", TargetCount=1, 
		FailActions={{ActionType="SSSpeak", Value=SWS_GetModText("DontHavePackage"), NPCID=otherGroup.traderID},
		{ActionType="SetSSWantsToTalk", Value=true, NPCID=otherGroup.traderID}}, ResultActions=DeliverPackageActions
	}
	
	SSQM:AddQuestTrigger(group.traderQuest, DeliverPackageTrigger)
end

function SWS_OnClickBuyButton(quant)
	local errMsg = SWS_PurchaseShopStock(tempDialogInfo.InvItem, 1)
	myDialogueWindow:setText(SWS_GenShopItemText(tempDialogInfo.InvItem).."\n\n"..errMsg)
end

function SWS_SelectShopItem(npcID)
	tempDialogInfo.Dialog = SWS_GenShopItemText(tempDialogInfo.InvItem)
	tempDialogInfo.IYONQ = true
	tempDialogInfo.YesBtnText = SWS_GetModText("Buy").." 1"
	tempDialogInfo.ContinueBtnText = SWS_GetModText("Buy").." 5"
	tempDialogInfo.NoBtnText = SWS_GetModText("Back")
	
	tempDialogInfo.YesActions = {{ActionType="CustomFunc", DialogAction=true, Arg1=1, FuncName="SWS_OnClickBuyButton"}}
	tempDialogInfo.ContinueActions = {{ActionType="CustomFunc", DialogAction=true, Arg1=5, FuncName="SWS_OnClickBuyButton"}}
	tempDialogInfo.NoActions = {{ActionType="SSPrevDialogueW", DialogueLevel=3, NPCID=npcID}}
	
	return tempDialogInfo
end

function SWS_NextShopItem()
	local origShopIndex = tempDialogInfo.InvIndex
	tempDialogInfo.InvIndex = tempDialogInfo.InvIndex + 1
	if tempDialogInfo.InvIndex > #tempDialogInfo.ShopInv then tempDialogInfo.InvIndex = 1 end
	while tempDialogInfo.ShopInv[tempDialogInfo.InvIndex].Stock < 1 do
		tempDialogInfo.InvIndex = tempDialogInfo.InvIndex + 1
		if tempDialogInfo.InvIndex > #tempDialogInfo.ShopInv then tempDialogInfo.InvIndex = 1 end
		if tempDialogInfo.InvIndex == origShopIndex then break end
	end
	tempDialogInfo.InvItem = tempDialogInfo.ShopInv[tempDialogInfo.InvIndex]
	myDialogueWindow:setText(SWS_GetModText("HeresMyStock") .. "\n\n" ..
							SWS_GenShopInvText(tempDialogInfo.ShopInv, tempDialogInfo.InvIndex))
end

function SWS_TraderNextShopCat()
	local catDialog = SWS_GetModText("TraderShopDialog") .. "\n\n"
	tempDialogInfo.CatIndex = tempDialogInfo.CatIndex + 1
	if tempDialogInfo.CatIndex > #traderShopCats then tempDialogInfo.CatIndex = 1 end
	for i=1, #traderShopCats do
		if i == tempDialogInfo.CatIndex then catDialog = catDialog .. "> " end
		catDialog = catDialog .. traderShopCats[i] .. "\n"
	end
	myDialogueWindow:setText(catDialog)
end

function SWS_TraderShopCatDialog()
	local catDialog = SWS_GetModText("TraderShopDialog") .. "\n\n> "
	for i=1, #traderShopCats do catDialog = catDialog .. traderShopCats[i] .. "\n" end
	tempDialogInfo.CatIndex = 1
	return catDialog
end

function SWS_TraderShopDialog(traderID)
	local invIndex = 0
	local shopCat = traderShopCats[tempDialogInfo.CatIndex]
	local shopInv = SSQM:GetGlobalData("TraderShopInv_"..shopCat..traderID)
	
	if not shopInv then
		shopInv = {}
		SWS_UpdateShopStock(shopInv, shopCat)
		SWS_AddShopToList("TraderShopInv_"..shopCat..traderID, shopCat)
		SSQM:SetGlobalData("TraderShopInv_"..shopCat..traderID, shopInv)
	end
	
	for i=1, #shopInv do
		if shopInv[i].Stock > 0 then
			invIndex = i
			break
		end
	end
	
	if invIndex > 0 then
		local traderSS = SSM:Get(traderID)
		if traderSS then
			survivorShopDiscount = math.min((traderSS:getRelationshipWP()-1.0) * 0.05, 1.0)
		else survivorShopDiscount = 0 end
		
		local SelectItemActions = {
			{ActionType="SSNextDialogueW", DialogueLevel=4, NPCID=traderID, IsDynamic=true, Arg1=traderID, DataFunc="SWS_SelectShopItem"}
		}
		
		local NextItemActions = {
			{ActionType="CustomFunc", DialogAction=true, FuncName="SWS_NextShopItem"}
		}
		
		tempDialogInfo.InvIndex = invIndex
		tempDialogInfo.ShopInv = shopInv
		tempDialogInfo.InvItem = shopInv[invIndex]
		tempDialogInfo.Dialog = SWS_GetModText("HeresMyStock") .. "\n\n" .. SWS_GenShopInvText(shopInv, invIndex)
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesBtnText = SWS_GetModText("Select")
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Next")
		tempDialogInfo.NoBtnText = SWS_GetModText("Back")
		tempDialogInfo.YesActions = SelectItemActions
		tempDialogInfo.ContinueActions = NextItemActions
		tempDialogInfo.NoActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=traderID}}
	else
		tempDialogInfo.Dialog = SWS_GetModText("NothingForSale")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=traderID}}
	end
	
	return tempDialogInfo
end

function SWS_TraderGivePlayerJob(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then return end
	
	group.traderQuest = SSQM:BeginQuest(tempQuestInfo.Title, tempQuestInfo.Desc, group.traderID, tempQuestInfo.Target, tempQuestInfo.Reward)
	local rewardDialog = SWS_RandomRewardDialog() .. "\n\n" .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
	local GetRewardTrigger = nil
	
	local LeaveDialogueActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.traderID}}
	
	local RewardDialogueActions = {
		{ActionType="SSDialogueW", NPCID=group.traderID, Value=rewardDialog, ContinueResultActions=LeaveDialogueActions, ContinueBtnText=SWS_GetModText("Thanks")},
		{ActionType="RewardPlayer", ItemType=tempQuestInfo.Reward.BaseID, ItemQuantity=tempQuestInfo.Reward.Amount, NPCID=group.traderID},
		{ActionType="DelayActions", Actions={{ActionType="EnableTrigger", Value="TalkWithTraderTrigger_" .. group.groupID}}, Value=1},
		{ActionType="IncGlobalData", Name="QuestStage_"..group.traderID, Value=1},
		{ActionType="FinishQuest", QuestID=group.traderQuest},
		{ActionType="SetGroupData", GroupID=group.groupID, Name="traderQuest", Value=-1}
	}
	
	if tempQuestInfo.Target and tempQuestInfo.Target.BaseID then
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.traderQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="BringToSS", TargetID=tempQuestInfo.Target.BaseID, TargetCount=tempQuestInfo.Target.Count*tempQuestInfo.Target.Uses, 
			FailActions={{ActionType="SSSpeak", Value=SWS_GetModText("DontHaveItem"), NPCID=group.traderID}},
			NPCID=group.traderID, ResultActions=RewardDialogueActions
		}
	else
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.traderQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="TalkToSS", NPCID=group.traderID, ResultActions=RewardDialogueActions
		}
	end
	
	local GotTargetActions = {
		{ActionType="SetSSWantsToTalk", Value=true, NPCID=group.traderID},
		{ActionType="DisableTrigger", Value="TalkWithTraderTrigger_" .. group.groupID},
		{ActionType="EnableTrigger", Value="GetRewardTrigger_" .. group.traderQuest},
		{ActionType="SetTargetCoords", QuestID=group.traderQuest, AltX=group.spawnPoint[1], AltY=group.spawnPoint[2], AltValue=SWS_GetModText("GroupBase")},
		{ActionType="UpdateQuestDesc", QuestID=group.traderQuest, Value=SWS_GetModText("ReturnTo") .. group.traderName}
	}
	
	if tempQuestInfo.Target and tempQuestInfo.Target.X ~= nil then
		getSpecificPlayer(0):getInventory():AddItem("Base.SWSPackage")
		if tempQuestInfo.SpawnData then
			local newGroupID = SSGM:newGroup():getID()
			local questGroup = SWS_AddContactedGroup(newGroupID, tempQuestInfo.SpawnData, "SWS_NearOtherGroup", {group.groupID,newGroupID})
			questGroup.spawnQuest = group.traderQuest
			tempQuestInfo.SpawnData = nil
		else
			local NearGroupTrigger = {
				TriggerName="NearGroupTrigger_" .. group.traderQuest, Enabled=true, TriggerOnlyOnce=true,
				ConditionType="DistanceToSquare", Distance=50, SquareX=tempQuestInfo.Target.X, SquareY=tempQuestInfo.Target.Y, 
				ResultActions={{ActionType="CustomFunc", Arg1=group.groupID, Arg2=tempQuestInfo.Target.GroupID, FuncName="SWS_NearOtherGroup"}}
			}
			SSQM:AddQuestTrigger(group.traderQuest, NearGroupTrigger)
		end
		SSQM:AddQuestTrigger(group.traderQuest, GetRewardTrigger)
	else
		local GotTargetTrigger = {
			TriggerName="GotTargetTrigger_"..group.traderQuest, Enabled=true, TriggerOnlyOnce=true, 
			ConditionType="GotTargetCount", QuestID=group.traderQuest, ResultActions=GotTargetActions
		}
		SSQM:AddQuestTriggers(group.traderQuest, { GotTargetTrigger, GetRewardTrigger })
	end
	
	SWS_ContGroupsChanged = true
end

function SWS_TraderJobDialog(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then
		tempDialogInfo.Dialog = SWS_GetModText("DontHaveWork")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {}
		return tempDialogInfo
	end
	
	tempDialogInfo.YesBtnText = SWS_GetModText("Accept")
	tempDialogInfo.NoBtnText = SWS_GetModText("Goodbye")
	tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
	
	if group.traderQuest > 0 then
		tempDialogInfo.Dialog = SWS_GetModText("FinishYourTask")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.traderID}}
	else
		local questStage = SSQM:GetGlobalData("QuestStage_"..group.traderID, 0)
		local questData = SSQM:GetGlobalData("QuestData_"..group.traderID)
		
		if questData and questData.Stage == questStage then
			tempQuestInfo.Target = questData.Target
			tempQuestInfo.Reward = questData.Reward
			tempQuestInfo.Title = questData.Title
			tempQuestInfo.Desc = questData.Desc
			tempDialogInfo.Dialog = questData.Dialog
		else
			if questStage == 1 or (questStage > 1 and ZombRand(3) == 0) then
				local targetGroup = false
				local spawnPoint = SWS_GetGroupSpawnPoint(true, 99999)
				
				for i=1, 9 do
					if spawnPoint and spawnPoint.AreaIndex ~= group.spawnData[1] then break end
					spawnPoint = SWS_GetGroupSpawnPoint(true, 99999)
				end
				
				if spawnPoint and spawnPoint.Spawned then
					for i=1, #contactedGroups do
						targetGroup = contactedGroups[i].groupID
						if contactedGroups[i].spawnData[1] == spawnPoint.AreaIndex then break end
						targetGroup = false
					end
				end
				
				if targetGroup then
					tempQuestInfo.Target = {
						Name=SWS_GetModText("GroupTrader"), MapTitle=SWS_GetModText("GroupCoords"),
						X=spawnPoint.X, Y=spawnPoint.Y, GroupID=targetGroup
					}
				elseif spawnPoint and spawnPoint.AreaIndex ~= group.spawnData[1] and not spawnPoint.Spawned then
					tempQuestInfo.Target = {
						Name=SWS_GetModText("GroupTrader"), 
						MapTitle=SWS_GetModText("GroupCoords"), X=spawnPoint.X, Y=spawnPoint.Y
					}
					tempQuestInfo.SpawnData = spawnPoint
				else
					tempDialogInfo.Dialog = SWS_GetModText("DontHaveWork")
					tempDialogInfo.IYONQ = false
					tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.traderID}}
					return tempDialogInfo
				end
				
				local groupDist = getDistanceBetweenPoints(getSpecificPlayer(0):getX(), getSpecificPlayer(0):getY(), spawnPoint.X, spawnPoint.Y)
				local rewardAmount = 250 + SWS_RoundFloat(groupDist * 0.05)
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
				tempQuestInfo.Title = SWS_GetModText("GoingPostal")
				tempQuestInfo.Desc = SWS_GetModText("DeliverToCoords") .. group.traderName
				tempDialogInfo.Dialog = SWS_GetModText("NeedCourier") .. "\n\n"
			else
				local targetItems = {
					{ Name=SWS_GetModText("BottleOfPerfume"), Plural=SWS_GetModText("BottleOfPerfumeP"), ItemID="Base.Perfume", Price=40, Uses=1 },
					{ Name=SWS_GetModText("BottleOfCologne"), Plural=SWS_GetModText("BottleOfCologneP"), ItemID="Base.Cologne", Price=40, Uses=1 },
					{ Name=SWS_GetModText("BoxOfNails"), Plural=SWS_GetModText("BoxOfNailsP"), ItemID="Base.NailsBox", Price=100, Uses=1 },
					{ Name=SWS_GetModText("BoxOfScrews"), Plural=SWS_GetModText("BoxOfScrewsP"), ItemID="Base.ScrewsBox", Price=110, Uses=1 },
					{ Name=SWS_GetModText("FullBoxMatches"), Plural=SWS_GetModText("FullBoxMatchesP"), ItemID="Base.Matches", Price=40, Uses=10 },
					{ Name=SWS_GetModText("FullRollTP"), Plural=SWS_GetModText("FullRollTPP"), ItemID="Base.ToiletPaper", Price=40, Uses=32 },
					{ Name=SWS_GetModText("FullSpoolThread"), Plural=SWS_GetModText("FullSpoolThreadP"), ItemID="Base.Thread", Price=60, Uses=10 },
					{ Name=SWS_GetModText("FullRollWire"), Plural=SWS_GetModText("FullRollWireP"), ItemID="Base.Wire", Price=70, Uses=5 },
					{ Name=SWS_GetModText("FullRollTwine"), Plural=SWS_GetModText("FullRollTwineP"), ItemID="Base.Twine", Price=80, Uses=5 },
					{ Name=SWS_GetModText("FullRollTape"), Plural=SWS_GetModText("FullRollTapeP"), ItemID="Base.DuctTape", Price=110, Uses=4 },
					{ Name=SWS_GetModText("FullBottleGlue"), Plural=SWS_GetModText("FullBottleGlueP"), ItemID="Base.Glue", Price=120, Uses=5 }
				}
				
				local targetItem = targetItems[ZombRand(#targetItems)+1]
				local findCount = ZombRand(3)+1
				local rewardAmount = findCount * targetItem.Price		
				tempQuestInfo.Target = { Name=targetItem.Name, Plural=targetItem.Plural, BaseID=targetItem.ItemID, Method="find", Count=findCount, Uses=targetItem.Uses }
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
				tempQuestInfo.Title = SWS_GetModText("TheSupplyRun")
				
				if findCount > 1 then
					tempQuestInfo.Desc = SWS_GetModText("Find") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("AndBringThemTo") .. group.traderName
					tempDialogInfo.Dialog = SWS_GetModText("UpForSupplyRun") .. SWS_GetModText("Find") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. 
											SWS_GetModText("AndBringThemTo")..SWS_GetModText("Me").."\n\n"
				else
					tempQuestInfo.Desc = SWS_GetModText("FindA") ..targetItem.Name.. SWS_GetModText("AndBringItTo") .. group.traderName
					tempDialogInfo.Dialog = SWS_GetModText("UpForSupplyRun") .. SWS_GetModText("FindA") ..targetItem.Name.. SWS_GetModText("AndBringItTo")..SWS_GetModText("Me").."\n\n"
				end
			end
			
			tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
			questData = { Stage=questStage, Target=tempQuestInfo.Target, Reward=tempQuestInfo.Reward, Title=tempQuestInfo.Title, Desc=tempQuestInfo.Desc, Dialog=tempDialogInfo.Dialog }
			SSQM:SetGlobalData("QuestData_"..group.traderID, questData)
		end
	
		local AcceptJobDialogueActions = {
			{ActionType="SSSpeak", Value=SWS_GetModText("GoodLuckOutThere"), NPCID=group.traderID},
			{ActionType="CustomFunc", Arg1=group.groupID, FuncName="SWS_TraderGivePlayerJob"}
		}
		
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesActions = AcceptJobDialogueActions
		tempDialogInfo.NoActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.traderID}}
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.traderID}}
	end
	
	return tempDialogInfo
end

function SWS_DoctorShopDialog(doctorID)	
	local invIndex = 0
	local shopInv = SSQM:GetGlobalData("DoctorShopInv_"..doctorID)
	
	if not shopInv then
		shopInv = {}
		SWS_UpdateShopStock(shopInv, "Medical")
		SWS_AddShopToList("DoctorShopInv_"..doctorID, "Medical")
		SSQM:SetGlobalData("DoctorShopInv_"..doctorID, shopInv)
	end
	
	for i=1, #shopInv do
		if shopInv[i].Stock > 0 then
			invIndex = i
			break
		end
	end
	
	if invIndex > 0 then
		local doctorSS = SSM:Get(doctorID)
		if doctorSS then
			survivorShopDiscount = math.min((doctorSS:getRelationshipWP()-1.0) * 0.05, 1.0)
		else survivorShopDiscount = 0 end
	
		local SelectItemActions = {
			{ActionType="SSNextDialogueW", DialogueLevel=4, NPCID=doctorID, IsDynamic=true, Arg1=doctorID, DataFunc="SWS_SelectShopItem"}
		}
		
		local NextItemActions = {
			{ActionType="CustomFunc", DialogAction=true, FuncName="SWS_NextShopItem"}
		}
		
		tempDialogInfo.InvIndex = invIndex
		tempDialogInfo.ShopInv = shopInv
		tempDialogInfo.InvItem = shopInv[invIndex]
		tempDialogInfo.Dialog = SWS_GetModText("HeresMyStock").."\n\n" .. SWS_GenShopInvText(shopInv, invIndex)
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesBtnText = SWS_GetModText("Select")
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Next")
		tempDialogInfo.NoBtnText = SWS_GetModText("Back")
		tempDialogInfo.YesActions = SelectItemActions
		tempDialogInfo.ContinueActions = NextItemActions
		tempDialogInfo.NoActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=doctorID}}
	else
		tempDialogInfo.Dialog = SWS_GetModText("NothingForSale")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=doctorID}}
	end
	
	return tempDialogInfo
end

function SWS_DoctorHealPlayer(doctorID)
	local docSS = SSM:Get(doctorID)
	if not docSS then return end
	local mainPlayer = getSpecificPlayer(0)
	
	if SWS_PlayerItemCount(mainPlayer, "Base.Money") < tempDialogInfo.MedCost then
		docSS:Speak(SWS_GetModText("NotEnoughMoney"))
		return
	end
	
	local newTask = DoctorTask:new(docSS)
	newTask:setPatient(mainPlayer)
	docSS:getTaskManager():clear()
	docSS:getTaskManager():AddToTop(newTask)
	docSS:Speak(SWS_GetModText("HoldStillForMe"))
	
	SWS_PlayerRemoveItems(mainPlayer, "Base.Money", tempDialogInfo.MedCost)
	
	if tempDialogInfo.AbReq > 0 then
		mainPlayer:getInventory():AddItem("Base.Antibiotics")
		local ab = mainPlayer:getInventory():getItemFromType("Base.Antibiotics")
		ISTimedActionQueue.add(ISEatFoodAction:new(mainPlayer, ab, 1.0))
		--ISTimedActionQueue.add(ISTakePillAction:new(mainPlayer, ab, 165))
	end
end
		
function SWS_DoctorHealDialog(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then
		tempDialogInfo.Dialog = SWS_GetModText("SorryCantHelp")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {}
		return tempDialogInfo
	end
	
	local mainPlayer = getSpecificPlayer(0)
	local bodyparts = mainPlayer:getBodyDamage():getBodyParts()
	local glassCount = 0
	local bulletCount = 0
	local infectCount = 0
	local woundCount = 0
	local splintsReq = 0
	local bandagesReq = 0
	local stitchesReq = 0
	local antibioReq = 0
	
	for i=0, bodyparts:size()-1 do
		local bodypart = bodyparts:get(i)
		local needsBandage = false
		local needsStitches = false
		if DoctorNeedsGlassRemoval(bodypart) then
			glassCount = glassCount + 1; needsBandage = true; needsStitches = true
		end
		if DoctorNeedsBulletRemoval(bodypart) then
			bulletCount = bulletCount + 1; needsBandage = true; needsStitches = true
		end
		if DoctorNeedsWoundDisinfect(bodypart) then
			infectCount = infectCount + 1; needsBandage = true
		end
		if DoctorNeedsSplint(bodypart) then	
			splintsReq = splintsReq + 1
		end
		if DoctorNeedsAntibiotics(bodypart, mainPlayer) then
			antibioReq = 1
		end
		if DoctorNeedsStiches(bodypart) then
			woundCount = woundCount + 1; needsBandage = true; needsStitches = true
		elseif DoctorNeedsBandage(bodypart) then
			needsBandage = true
		end
		if needsBandage then bandagesReq = bandagesReq + 1 end
		if needsStitches then stitchesReq = stitchesReq + 1 end
	end
	
	if bandagesReq > 0 or splintsReq > 0 or antibioReq > 0 then
		tempDialogInfo.AbReq = antibioReq
		tempDialogInfo.MedCost = (splintsReq * 90) + (bandagesReq * 30) + (stitchesReq * 40) + (antibioReq * 100) + ((infectCount+glassCount+bulletCount) * 10)
		tempDialogInfo.Dialog = SWS_GenMedExamText(glassCount, bulletCount, woundCount, infectCount, antibioReq, splintsReq, bandagesReq, stitchesReq, tempDialogInfo.MedCost)
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesBtnText = SWS_GetModText("Pay") .. " ("..tempDialogInfo.MedCost..")"
		tempDialogInfo.NoBtnText = SWS_GetModText("Back")
		tempDialogInfo.YesActions = {{ActionType="CustomFunc", Arg1=group.doctorID, FuncName="SWS_DoctorHealPlayer"}}
		tempDialogInfo.NoActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=group.doctorID}}
		tempDialogInfo.ContinueActions = nil
	else
		tempDialogInfo.Dialog = SWS_GetModText("NoMedicalProb")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=group.doctorID}}
	end
	
	return tempDialogInfo
end

function SWS_DoctorGivePlayerJob(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then return end
	
	group.doctorQuest = SSQM:BeginQuest(tempQuestInfo.Title, tempQuestInfo.Desc, group.doctorID, tempQuestInfo.Target, tempQuestInfo.Reward)
	local rewardDialog = SWS_RandomRewardDialog() .. "\n\n" .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
	local GetRewardTrigger = nil
	
	local LeaveDialogueActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.doctorID}}
	
	local RewardDialogueActions = {
		{ActionType="SSDialogueW", NPCID=group.doctorID, Value=rewardDialog, ContinueResultActions=LeaveDialogueActions, ContinueBtnText=SWS_GetModText("Thanks")},
		{ActionType="RewardPlayer", ItemType=tempQuestInfo.Reward.BaseID, ItemQuantity=tempQuestInfo.Reward.Amount, NPCID=group.doctorID},
		{ActionType="DelayActions", Actions={{ActionType="EnableTrigger", Value="TalkWithDoctorTrigger_" .. group.groupID}}, Value=1},
		{ActionType="FinishQuest", QuestID=group.doctorQuest},
		{ActionType="SetGroupData", GroupID=group.groupID, Name="doctorQuest", Value=-1},
		{ActionType="SetGlobalData", Name="QuestData_"..group.doctorID, Value=false}
	}
	
	if tempQuestInfo.Target and tempQuestInfo.Target.BaseID then
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.doctorQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="BringToSS", TargetID=tempQuestInfo.Target.BaseID, TargetCount=tempQuestInfo.Target.Count, 
			FailActions={{ActionType="SSSpeak", Value=SWS_GetModText("DontHaveItem"), NPCID=group.doctorID}},
			NPCID=group.doctorID, ResultActions=RewardDialogueActions
		}
	else
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.doctorQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="TalkToSS", NPCID=group.doctorID, ResultActions=RewardDialogueActions
		}
	end
	
	local GotTargetActions = {
		{ActionType="SetSSWantsToTalk", Value=true, NPCID=group.doctorID},
		{ActionType="DisableTrigger", Value="TalkWithDoctorTrigger_" .. group.groupID},
		{ActionType="EnableTrigger", Value="GetRewardTrigger_"..group.doctorQuest},
		{ActionType="SetTargetCoords", QuestID=group.doctorQuest, AltX=group.spawnPoint[1], AltY=group.spawnPoint[2], AltValue=SWS_GetModText("GroupBase")},
		{ActionType="UpdateQuestDesc", QuestID=group.doctorQuest, Value=SWS_GetModText("ReturnTo") .. group.doctorName}
	}
	
	local GotTargetTrigger = {
		TriggerName="GotTargetTrigger_"..group.doctorQuest, Enabled=true, TriggerOnlyOnce=true, 
		ConditionType="GotTargetCount", QuestID=group.doctorQuest, ResultActions=GotTargetActions
	}
	
	SSQM:AddQuestTriggers(group.doctorQuest, { GotTargetTrigger, GetRewardTrigger })
	SWS_ContGroupsChanged = true
end

function SWS_DoctorJobDialog(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then
		tempDialogInfo.Dialog = SWS_GetModText("DontHaveWork")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {}
		return tempDialogInfo
	end
	
	tempDialogInfo.YesBtnText = SWS_GetModText("Accept")
	tempDialogInfo.NoBtnText = SWS_GetModText("Goodbye")
	tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
	
	if group.doctorQuest > 0 then
		tempDialogInfo.Dialog = SWS_GetModText("FinishYourTask")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.doctorID}}
	else
		local questData = SSQM:GetGlobalData("QuestData_"..group.doctorID)
		
		if questData then
			tempQuestInfo.Target = questData.Target
			tempQuestInfo.Reward = questData.Reward
			tempQuestInfo.Title = questData.Title
			tempQuestInfo.Desc = questData.Desc
			tempDialogInfo.Dialog = questData.Dialog
		else
			local targetItems = {
				{ Name=SWS_GetModText("Bandage"), Plural=SWS_GetModText("BandageP"), ItemID="Base.Bandage", Mult=1 },
				{ Name=SWS_GetModText("CottonBall"), Plural=SWS_GetModText("CottonBallP"), ItemID="Base.CottonBalls", Mult=1 },
				{ Name=SWS_GetModText("PainkillerPill"), Plural=SWS_GetModText("PainkillerPillP"), ItemID="Base.Pills", Mult=2 },
				{ Name=SWS_GetModText("VitaminPill"), Plural=SWS_GetModText("VitaminPillP"), ItemID="Base.PillsVitamins", Mult=2 },
				{ Name=SWS_GetModText("BetaBlockerPill"), Plural=SWS_GetModText("BetaBlockerPillP"), ItemID="Base.PillsBeta", Mult=2 },
				{ Name=SWS_GetModText("SleepingTablet"), Plural=SWS_GetModText("SleepingTabletP"), ItemID="Base.PillsSleepingTablets", Mult=2 }
			}
			
			local targetItem = targetItems[ZombRand(#targetItems)+1]
			local findCount = (ZombRand(3)+2) * targetItem.Mult
			local rewardAmount = findCount * (50 / targetItem.Mult)
			
			tempQuestInfo.Target = { Name=targetItem.Name, Plural=targetItem.Plural, BaseID=targetItem.ItemID, Method="find", Count=findCount }
			tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
			tempQuestInfo.Title = SWS_GetModText("StockForTheDoc")
			tempQuestInfo.Desc = SWS_GetModText("Find") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("AndBringThemTo") .. group.doctorName
			tempDialogInfo.Dialog = SWS_GetModText("LookingForMeds")..SWS_GetModText("Bring") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("ToMe").."\n\n"
			tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
			
			questData = { Target=tempQuestInfo.Target, Reward=tempQuestInfo.Reward, Title=tempQuestInfo.Title, Desc=tempQuestInfo.Desc, Dialog=tempDialogInfo.Dialog }
			SSQM:SetGlobalData("QuestData_"..group.doctorID, questData)
		end
	
		local AcceptJobDialogueActions = {
			{ActionType="SSSpeak", Value=SWS_GetModText("GoodLuckOutThere"), NPCID=group.doctorID},
			{ActionType="CustomFunc", Arg1=group.groupID, FuncName="SWS_DoctorGivePlayerJob"}
		}
		
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesActions = AcceptJobDialogueActions
		tempDialogInfo.NoActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.doctorID}}
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.doctorID}}
	end
	
	return tempDialogInfo
end

function SWS_SheriffSelectShopCat(catIndex)
	tempDialogInfo.CatIndex = catIndex
end

function SWS_SheriffShopDialog(sheriffID)
	local invIndex = 0
	local shopCat = sheriffShopCats[tempDialogInfo.CatIndex]
	local shopInv = SSQM:GetGlobalData("SheriffShopInv_"..shopCat..sheriffID)
	
	if not shopInv then
		shopInv = {}
		SWS_UpdateShopStock(shopInv, shopCat)
		SWS_AddShopToList("SheriffShopInv_"..shopCat..sheriffID, shopCat)
		SSQM:SetGlobalData("SheriffShopInv_"..shopCat..sheriffID, shopInv)
	end
	
	for i=1, #shopInv do
		if shopInv[i].Stock > 0 then
			invIndex = i
			break
		end
	end
	
	if invIndex > 0 then
		local sheriffSS = SSM:Get(sheriffID)
		if sheriffSS then
			survivorShopDiscount = math.min((sheriffSS:getRelationshipWP()-1.0) * 0.05, 1.0)
		else survivorShopDiscount = 0 end
	
		local SelectItemActions = {
			{ActionType="SSNextDialogueW", DialogueLevel=4, NPCID=sheriffID, IsDynamic=true, Arg1=sheriffID, DataFunc="SWS_SelectShopItem"}
		}
		
		local NextItemActions = {
			{ActionType="CustomFunc", DialogAction=true, FuncName="SWS_NextShopItem"}
		}
		
		tempDialogInfo.InvIndex = invIndex
		tempDialogInfo.ShopInv = shopInv
		tempDialogInfo.InvItem = shopInv[invIndex]
		tempDialogInfo.Dialog = SWS_GetModText("HeresMyStock").."\n\n" .. SWS_GenShopInvText(shopInv, invIndex)
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesBtnText = SWS_GetModText("Select")
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Next")
		tempDialogInfo.NoBtnText = SWS_GetModText("Back")
		tempDialogInfo.YesActions = SelectItemActions
		tempDialogInfo.ContinueActions = NextItemActions
		tempDialogInfo.NoActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=sheriffID}}
	else
		tempDialogInfo.Dialog = SWS_GetModText("NothingForSale")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=2, NPCID=sheriffID}}
	end
	
	return tempDialogInfo
end

function SWS_SheriffGivePlayerJob(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then return end
	
	group.sheriffQuest = SSQM:BeginQuest(tempQuestInfo.Title, tempQuestInfo.Desc, group.sheriffID, tempQuestInfo.Target, tempQuestInfo.Reward)
	local rewardDialog = SWS_RandomRewardDialog() .. "\n\n" .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
	local GetRewardTrigger = nil
	
	local LeaveDialogueActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.sheriffID}}
	
	local RewardDialogueActions = {
		{ActionType="SSDialogueW", NPCID=group.sheriffID, Value=rewardDialog, ContinueResultActions=LeaveDialogueActions, ContinueBtnText=SWS_GetModText("Thanks")},
		{ActionType="RewardPlayer", ItemType=tempQuestInfo.Reward.BaseID, ItemQuantity=tempQuestInfo.Reward.Amount, NPCID=group.sheriffID},
		{ActionType="DelayActions", Actions={{ActionType="EnableTrigger", Value="TalkWithSheriffTrigger_" .. group.groupID}}, Value=1},
		{ActionType="IncGlobalData", Name="QuestStage_"..group.sheriffID, Value=1},
		{ActionType="FinishQuest", QuestID=group.sheriffQuest},
		{ActionType="SetGroupData", GroupID=group.groupID, Name="sheriffQuest", Value=-1}
	}
	
	if tempQuestInfo.Target and tempQuestInfo.Target.BaseID then
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.sheriffQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="BringToSS", TargetID=tempQuestInfo.Target.BaseID, TargetCount=tempQuestInfo.Target.Count, 
			FailActions={{ActionType="SSSpeak", Value=SWS_GetModText("DontHaveItem"), NPCID=group.sheriffID}},
			NPCID=group.sheriffID, ResultActions=RewardDialogueActions
		}
	else
		GetRewardTrigger = {
			TriggerName="GetRewardTrigger_"..group.sheriffQuest, Enabled=false, TriggerOnlyOnce=true, 
			ConditionType="TalkToSS", NPCID=group.sheriffID, ResultActions=RewardDialogueActions
		}
	end
	
	local GotTargetActions = {
		{ActionType="SetSSWantsToTalk", Value=true, NPCID=group.sheriffID},
		{ActionType="DisableTrigger", Value="TalkWithSheriffTrigger_" .. group.groupID},
		{ActionType="EnableTrigger", Value="GetRewardTrigger_"..group.sheriffQuest},
		{ActionType="SetTargetCoords", QuestID=group.sheriffQuest, AltX=group.spawnPoint[1], AltY=group.spawnPoint[2], AltValue=SWS_GetModText("GroupBase")},
		{ActionType="UpdateQuestDesc", QuestID=group.sheriffQuest, Value=SWS_GetModText("ReturnTo") .. group.sheriffName}
	}
	
	local GotTargetTrigger = {
		TriggerName="GotTargetTrigger_"..group.sheriffQuest, Enabled=true, TriggerOnlyOnce=true, 
		ConditionType="GotTargetCount", QuestID=group.sheriffQuest, ResultActions=GotTargetActions
	}
	
	if tempQuestInfo.Preset ~= nil then
		local NearTargetTrigger = {
			TriggerName="NearTargetTrigger_" .. group.sheriffQuest, Enabled=true, TriggerOnlyOnce=true, ConditionType="DistanceToSquare",
			SquareX=tempQuestInfo.Target.X, SquareY=tempQuestInfo.Target.Y, Distance=60,
			ResultActions={
				{ActionType="SpawnPresetGroup", Value=tempQuestInfo.Preset},
				{ActionType="SetTargetCoords", QuestID=group.sheriffQuest, AltX=tempQuestInfo.Target.X, AltY=tempQuestInfo.Target.Y, AltValue=tempQuestInfo.Target.Name},
				{ActionType="SetTargetNPC", QuestID=group.sheriffQuest, Name=tempQuestInfo.Target.Name, MarkMap=true}
			}
		}
		SSQM:AddQuestTriggers(group.sheriffQuest, { GotTargetTrigger, NearTargetTrigger, GetRewardTrigger })
		tempQuestInfo.Preset = nil
	else
		SSQM:AddQuestTriggers(group.sheriffQuest, { GotTargetTrigger, GetRewardTrigger })
	end
	
	SWS_ContGroupsChanged = true
end

function SWS_SheriffJobDialog(groupID)
	local group = SWS_GetContactedGroup(groupID)
	if not group then
		tempDialogInfo.Dialog = SWS_GetModText("DontHaveWork")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {}
		return tempDialogInfo
	end
	
	tempDialogInfo.YesBtnText = SWS_GetModText("Accept")
	tempDialogInfo.NoBtnText = SWS_GetModText("Goodbye")
	tempDialogInfo.ContinueBtnText = SWS_GetModText("Back")
	
	if group.sheriffQuest > 0 then
		tempDialogInfo.Dialog = SWS_GetModText("FinishYourTask")
		tempDialogInfo.IYONQ = false
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.sheriffID}}
	else
		local questStage = SSQM:GetGlobalData("QuestStage_"..group.sheriffID, 0)
		local questData = SSQM:GetGlobalData("QuestData_"..group.sheriffID)
		
		if questData and questData.Stage == questStage then
			tempQuestInfo.Target = questData.Target
			tempQuestInfo.Reward = questData.Reward
			tempQuestInfo.Title = questData.Title
			tempQuestInfo.Desc = questData.Desc
			tempDialogInfo.Dialog = questData.Dialog
		else
			if questStage == 1 or (questStage > 2 and ZombRand(2) == 0) then
			
				local targetItems = {
					{ Name=SWS_GetModText("Round9mm"), Plural=SWS_GetModText("Round9mmP"), ItemID="Base.Bullets9mm" },
					{ Name=SWS_GetModText("Round308"), Plural=SWS_GetModText("Round308P"), ItemID="Base.308Bullets" },
					{ Name=SWS_GetModText("Round45Auto"), Plural=SWS_GetModText("Round45AutoP"), ItemID="Base.Bullets45" },
					{ Name=SWS_GetModText("ShotgunShell"), Plural=SWS_GetModText("ShotgunShellP"), ItemID="Base.ShotgunShells" }
				}
				
				local targetItem = targetItems[ZombRand(#targetItems)+1]
				local findCount = ZombRand(3)+3+questStage
				local rewardAmount = findCount * 50
				tempQuestInfo.Target = { Name=targetItem.Name, Plural=targetItem.Plural, BaseID=targetItem.ItemID, Method="find", Count=findCount }
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
				tempQuestInfo.Title = SWS_GetModText("LockedAndLoaded")
				tempQuestInfo.Desc = SWS_GetModText("Find") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("AndBringThemTo") .. group.sheriffName
				tempDialogInfo.Dialog = SWS_GetModText("NeedAmmoForGun") .. SWS_GetModText("Bring") .. tempQuestInfo.Target.Count .. " " ..targetItem.Plural.. SWS_GetModText("ToMe").."\n\n"
				tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
				
			elseif questStage == 2 then
			
				local rewardAmount = 1000
				local leaderFemale = ZombRand(2)
				local leaderName = SWS_GetModText("GangLeader") .." ".. SWS_RandomSurvivorName(leaderFemale)
				local mainPlayer = getSpecificPlayer(0)
				local gangCoords = 0
				local minDist = 999999
				
				for i=1, #GangSpawnPoints[SpawnMapName] do
					local gangDist = getDistanceBetweenPoints(mainPlayer:getX(), mainPlayer:getY(), GangSpawnPoints[SpawnMapName][i][1], GangSpawnPoints[SpawnMapName][i][2])
					if gangDist < minDist and GangSpawnStates[SpawnMapName][i] == 0 then
						minDist = gangDist
						gangCoords = i
					end
				end
				
				if gangCoords == 0 then
					gangCoords = GangSpawnPoints[SpawnMapName][ZombRand(#GangSpawnPoints[SpawnMapName])+1]
				else
					GangSpawnStates[SpawnMapName][gangCoords] = 1
					gangCoords = GangSpawnPoints[SpawnMapName][gangCoords]
					SWS_SpawnStatesChanged = true
				end
				
				tempQuestInfo.Preset = {
					Name = leaderName, Weapons = "RangeWeapons", Suit = "Preset_Gangster", GuardSuit = "Preset_Gangster", Hostile = true,
					Perk1Name = "Aiming", Perk1Level = ZombRand(3)+1, Perk2Name = "Reloading", Perk2Level = ZombRand(3)+1,
					X = gangCoords[1], Y = gangCoords[2], Orders = "Patrol", PatrolX = gangCoords[3], PatrolY = gangCoords[4],
					IsFemale = leaderFemale, Guards = ZombRand(3)+2, GuardName = SWS_GetModText("GangMember"), GuardWeapons = "MeleWeapons"
				}
				
				tempQuestInfo.Target = { Name = leaderName, MapTitle = SWS_GetModText("GangCoords"), Method = "kill", Count = 1, X = gangCoords[1], Y = gangCoords[2] }
				rewardAmount = rewardAmount + (tempQuestInfo.Preset.Perk1Level * 100) + (tempQuestInfo.Preset.Perk2Level * 100) + (tempQuestInfo.Preset.Guards * 100)
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
				tempQuestInfo.Title = SWS_GetModText("WastelandJustice")
				tempQuestInfo.Desc = SWS_GetModText("KillGangLeader") .. group.sheriffName
				tempDialogInfo.Dialog = SWS_GetModText("GotWordOfGang") .. SWS_GetModText("KillGangLeader") .. SWS_GetModText("Me") .. "\n\n"
				tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
			else
				local killCount = ZombRand(3)+4+questStage
				local rewardAmount = killCount * 10
				tempQuestInfo.Target = { Name = SWS_GetModText("Zombie"), Plural=SWS_GetModText("Zombies"), Method = "kill", Count = killCount }
				tempQuestInfo.Reward = { Name = SWS_GetModText("Money"), BaseID = "Base.Money", Amount = rewardAmount }
				tempQuestInfo.Title = SWS_GetModText("ZombieSlayer")
				tempQuestInfo.Desc = SWS_GetModText("Kill") .. tempQuestInfo.Target.Count .. SWS_GetModText("ZombiesAndReport") .. group.sheriffName
				tempDialogInfo.Dialog = SWS_GetModText("WhatYouMadeOf") .. SWS_GetModText("Kill") .. tempQuestInfo.Target.Count .. SWS_GetModText("ZombiesAndReport") .. SWS_GetModText("Me").."\n\n"
				tempDialogInfo.Dialog = tempDialogInfo.Dialog .. SWS_GetModText("RewardColon") .. tempQuestInfo.Reward.Amount .. SWS_GetModText("TimesSymbol") .. tempQuestInfo.Reward.Name
			end
			
			questData = { Stage=questStage, Target=tempQuestInfo.Target, Reward=tempQuestInfo.Reward, Title=tempQuestInfo.Title, Desc=tempQuestInfo.Desc, Dialog=tempDialogInfo.Dialog }
			SSQM:SetGlobalData("QuestData_"..group.sheriffID, questData)
		end
	
		local AcceptJobDialogueActions = {
			{ActionType="SSSpeak", Value=SWS_GetModText("GoodLuckOutThere"), NPCID=group.sheriffID},
			{ActionType="CustomFunc", Arg1=group.groupID, FuncName="SWS_SheriffGivePlayerJob"}
		}
		
		tempDialogInfo.IYONQ = true
		tempDialogInfo.YesActions = AcceptJobDialogueActions
		tempDialogInfo.NoActions = {{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=group.sheriffID}}
		tempDialogInfo.ContinueActions = {{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=group.sheriffID}}
	end
	
	return tempDialogInfo
end

local function SetLeaderTriggers(groupData)

	local leaderID = groupData.leaderID
	local SS = SSM:Get(leaderID)
	if not SS then return end
	groupData.leaderName = SS:getName()
	--SS:setRelationshipWP(1.0)
	
	local LeaveDialogueActions = {
		{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=leaderID}
	}
	
	local TradeDialogueActions = {
		{ActionType="SSNextDialogueW", NPCID=leaderID, Value=SWS_GetModText("LeaderShopDialog"),
		isYesOrNoQuestion=true, YesBtnText=SWS_GetModText("Back"), NoBtnText=SWS_GetModText("Goodbye"), YesResultActions={{ActionType="SSPrevDialogueW", NPCID=leaderID}}, NoResultActions=LeaveDialogueActions}
	}
	
	local WorkDialogueActions = {
		{ActionType="SSNextDialogueW", NPCID=leaderID, IsDynamic=true, Arg1=groupData.groupID, DataFunc="SWS_LeaderJobDialog"}
	}
	
	local LeaderDialogueActions = {
		{ActionType="SSQuestionDialogueW", NPCID=leaderID, DataFunc="SWS_RandomGreetDialog",
		YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeDialogueActions, 
		YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"), ContinueBtnText=SWS_GetModText("Trade")}
	}
	
	local TalkWithLeaderTrigger = {
		TriggerName="TalkWithLeaderTrigger_" .. groupData.groupID, Enabled=false, TriggerOnlyOnce=false, ConditionType="TalkToSS", NPCID=leaderID, ResultActions=LeaderDialogueActions
	}
	
	local MeetWithLeaderTrigger = {
		TriggerName="MeetWithLeaderTrigger_" .. groupData.groupID, Enabled=true, TriggerOnlyOnce=true, ConditionType="TalkToSS", NPCID=leaderID, 
		ResultActions={{ActionType="SetSSWantsToTalk", Value=false, NPCID=leaderID},
		{ActionType="SSQuestionDialogueW", NPCID=leaderID, Value=SWS_RandomMeetDialog("leader"), YesResultActions=WorkDialogueActions, 
		NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeDialogueActions, 
		YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"), ContinueBtnText=SWS_GetModText("Trade")},
		{ActionType="DisableTrigger", Value="LeaderSetupTrigger_" .. groupData.groupID},
		{ActionType="EnableTrigger", Value="TalkWithLeaderTrigger_" .. groupData.groupID},
		{ActionType="FinishQuest", QuestID=groupData.findQuest},
		{ActionType="SetGroupData", GroupID=groupData.groupID, Name="findQuest", Value=-1},
		{ActionType="SetGroupData", GroupID=groupData.groupID, Name="isFound", Value=true}}
	}
	
	local LeaderSetupTrigger = {
		TriggerName="LeaderSetupTrigger_" .. groupData.groupID, Enabled=true, TriggerOnlyOnce=true, ConditionType="DistanceFromSS", Distance=20, NPCID=leaderID, 
		ResultActions={{ActionType="SetSSWantsToTalk", Value=true, NPCID=leaderID}}
	}
	
	if groupData.findQuest > 0 then
		SSQM:AddQuestTriggers(groupData.findQuest, { LeaderSetupTrigger, MeetWithLeaderTrigger })
	else
		MeetWithLeaderTrigger = {
			TriggerName="MeetWithLeaderTrigger_" .. groupData.groupID, Enabled=true, TriggerOnlyOnce=true, ConditionType="TalkToSS", NPCID=leaderID, 
			ResultActions={{ActionType="SSQuestionDialogueW", NPCID=leaderID, Value=SWS_RandomMeetDialog("leader"), YesResultActions=WorkDialogueActions, 
			NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeDialogueActions, YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"), ContinueBtnText=SWS_GetModText("Trade")},
			{ActionType="EnableTrigger", Value="TalkWithLeaderTrigger_" .. groupData.groupID}}
		}
		SSQM:AddTrigger(MeetWithLeaderTrigger)
	end
	
	SSQM:AddTrigger(TalkWithLeaderTrigger)
end

local function SetTraderTriggers(groupData)

	local traderID = groupData.traderID
	local SS = SSM:Get(traderID)
	if not SS then return end
	groupData.traderName = SS:getName()
	SS:setRelationshipWP(1.0)
	
	local LeaveDialogueActions = {
		{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=traderID}
	}
	
	local TradeDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=3, NPCID=traderID, IsDynamic=true, Arg1=traderID, DataFunc="SWS_TraderShopDialog"}
	}
	
	local NextCatActions = {
		{ActionType="CustomFunc", DialogAction=true, FuncName="SWS_TraderNextShopCat"}
	}
	
	local TradeCatDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=2, NPCID=traderID, YesBtnText=SWS_GetModText("Select"), ContinueBtnText=SWS_GetModText("Next"), NoBtnText=SWS_GetModText("Back"), isYesOrNoQuestion=true,
		YesResultActions=TradeDialogueActions, ContinueResultActions=NextCatActions, NoResultActions={{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=traderID}},
		DataFunc="SWS_TraderShopCatDialog"}
	}
	
	local WorkDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=2, NPCID=traderID, IsDynamic=true, Arg1=groupData.groupID, DataFunc="SWS_TraderJobDialog"}
	}
	
	local TraderDialogueActions = {
		{ActionType="SSQuestionDialogueW", DialogueLevel=1, NPCID=traderID, DataFunc="SWS_RandomGreetDialog",
		YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeCatDialogueActions,
		YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"), ContinueBtnText=SWS_GetModText("Trade")}
	}
	
	local TalkWithTraderTrigger = {
		TriggerName="TalkWithTraderTrigger_" .. groupData.groupID, Enabled=false, TriggerOnlyOnce=false, ConditionType="TalkToSS", NPCID=traderID, ResultActions=TraderDialogueActions
	}
	
	local MeetWithTraderTrigger = {
		TriggerName="MeetWithTraderTrigger_" .. groupData.groupID, Enabled=true, TriggerOnlyOnce=true, ConditionType="TalkToSS", NPCID=traderID, 
		ResultActions={{ActionType="SSQuestionDialogueW", DialogueLevel=1, NPCID=traderID, Value=SWS_RandomMeetDialog("trader"), YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"),
		ContinueBtnText=SWS_GetModText("Trade"), YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeCatDialogueActions},
		{ActionType="EnableTrigger", Value="TalkWithTraderTrigger_" .. groupData.groupID}}
	}
	
	SSQM:AddTriggers({ TalkWithTraderTrigger, MeetWithTraderTrigger })
end

local function SetDoctorTriggers(groupData)

	local doctorID = groupData.doctorID
	local SS = SSM:Get(doctorID)
	if not SS then return end
	groupData.doctorName = SS:getName()
	SS:setRelationshipWP(1.0)
	
	local LeaveDialogueActions = {
		{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=doctorID}
	}
	
	local HealDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=3, NPCID=doctorID, IsDynamic=true, Arg1=groupData.groupID, DataFunc="SWS_DoctorHealDialog"}
	}
	
	local TradeDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=3, NPCID=doctorID, IsDynamic=true, Arg1=doctorID, DataFunc="SWS_DoctorShopDialog"}
	}
	
	local ServicesDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=2, NPCID=doctorID, Value=SWS_GetModText("DoctorServDialog"), isYesOrNoQuestion=true,
		YesResultActions=HealDialogueActions, NoResultActions={{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=doctorID}}, 
		ContinueResultActions=TradeDialogueActions, YesBtnText=SWS_GetModText("Healing"), NoBtnText=SWS_GetModText("Back"), ContinueBtnText=SWS_GetModText("Trade")}
	}
	
	local WorkDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=2, NPCID=doctorID, IsDynamic=true, Arg1=groupData.groupID, DataFunc="SWS_DoctorJobDialog"}
	}
	
	local DoctorDialogueActions = {
		{ActionType="SSQuestionDialogueW", DialogueLevel=1, NPCID=doctorID, DataFunc="SWS_RandomGreetDialog",
		YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=ServicesDialogueActions,
		YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"), ContinueBtnText=SWS_GetModText("Services")}
	}
	
	local TalkWithDoctorTrigger = {
		TriggerName="TalkWithDoctorTrigger_" .. groupData.groupID, Enabled=false, TriggerOnlyOnce=false, ConditionType="TalkToSS", NPCID=doctorID, ResultActions=DoctorDialogueActions
	}
	
	local MeetWithDoctorTrigger = {
		TriggerName="MeetWithDoctorTrigger_" .. groupData.groupID, Enabled=true, TriggerOnlyOnce=true, ConditionType="TalkToSS", NPCID=doctorID, 
		ResultActions={{ActionType="SSQuestionDialogueW", DialogueLevel=1, NPCID=doctorID, Value=SWS_RandomMeetDialog("doctor"), YesBtnText=SWS_GetModText("Work"), NoBtnText=SWS_GetModText("Goodbye"),
		ContinueBtnText=SWS_GetModText("Services"), YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=ServicesDialogueActions},
		{ActionType="EnableTrigger", Value="TalkWithDoctorTrigger_" .. groupData.groupID}}
	}
	
	SSQM:AddTriggers({ TalkWithDoctorTrigger, MeetWithDoctorTrigger })
end

local function SetSheriffTriggers(groupData)

	local sheriffID = groupData.sheriffID
	local SS = SSM:Get(sheriffID)
	if not SS then return end
	groupData.sheriffName = SS:getName()
	SS:setRelationshipWP(1.0)
	
	local LeaveDialogueActions = {
		{ActionType="SSSpeak", DataFunc="SWS_RandomLeaveDialog", NPCID=sheriffID}
	}
	
	local TradeDialogueAction = {ActionType="SSNextDialogueW", DialogueLevel=3, NPCID=sheriffID, IsDynamic=true, Arg1=groupData.sheriffID, DataFunc="SWS_SheriffShopDialog"}
	
	local TradeCatDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=2, NPCID=sheriffID, Value=SWS_GetModText("GotGunsAndAmmo"), isYesOrNoQuestion=true,
		YesBtnText=SWS_GetModText("Guns"), ContinueBtnText=SWS_GetModText("Ammo"), NoBtnText=SWS_GetModText("Back"), NoResultActions={{ActionType="SSPrevDialogueW", DialogueLevel=1, NPCID=sheriffID}},
		YesResultActions={{ActionType="CustomFunc", Arg1=1, FuncName="SWS_SheriffSelectShopCat"}, TradeDialogueAction},
		ContinueResultActions={{ActionType="CustomFunc", Arg1=2, FuncName="SWS_SheriffSelectShopCat"}, TradeDialogueAction}}
	}
	
	local WorkDialogueActions = {
		{ActionType="SSNextDialogueW", DialogueLevel=2, NPCID=sheriffID, IsDynamic=true, Arg1=groupData.groupID, DataFunc="SWS_SheriffJobDialog"}
	}
	
	local SheriffDialogueActions = {
		{ActionType="SSQuestionDialogueW", DialogueLevel=1, NPCID=sheriffID, DataFunc="SWS_RandomGreetDialog",
		YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeCatDialogueActions,
		YesBtnText=SWS_GetModText("Work"), ContinueBtnText=SWS_GetModText("Trade"), NoBtnText=SWS_GetModText("Goodbye")}
	}
	
	local TalkWithSheriffTrigger = {
		TriggerName="TalkWithSheriffTrigger_" .. groupData.groupID, Enabled=false, TriggerOnlyOnce=false, ConditionType="TalkToSS", NPCID=sheriffID, ResultActions=SheriffDialogueActions
	}
	
	local MeetWithSheriffTrigger = {
		TriggerName="MeetWithSheriffTrigger_" .. groupData.groupID, Enabled=true, TriggerOnlyOnce=true, ConditionType="TalkToSS", NPCID=sheriffID, 
		ResultActions={{ActionType="SSQuestionDialogueW", DialogueLevel=1, NPCID=sheriffID, Value=SWS_RandomMeetDialog("sheriff"),
		YesResultActions=WorkDialogueActions, NoResultActions=LeaveDialogueActions, ContinueResultActions=TradeCatDialogueActions,
		YesBtnText=SWS_GetModText("Work"), ContinueBtnText=SWS_GetModText("Trade"), NoBtnText=SWS_GetModText("Goodbye")},
		{ActionType="EnableTrigger", Value="TalkWithSheriffTrigger_" .. groupData.groupID}}
	}
	
	SSQM:AddTriggers({ TalkWithSheriffTrigger, MeetWithSheriffTrigger })
end

local function SetGroupQuestTriggers(groupData)
	
	if groupData.groupID < 0 then
		print("SWS: bad group data passed to SetGroupQuestTriggers()")
		return false
	end
	
	if groupData.findQuest > 0 then
		SSQM:SetQuestGiver(groupData.findQuest, groupData.leaderID)
		SSQM:SetTargetCoords(groupData.findQuest, nil, nil, groupData.spawnPoint, SWS_GetModText("GroupBase"))
	end
	
	SSQM:ShowMessage(SWS_GetModText("GroupIsNearby"))
	
	SetLeaderTriggers(groupData)
	SetTraderTriggers(groupData)
	SetDoctorTriggers(groupData)
	SetSheriffTriggers(groupData)
end

local function GroupResponse()
	local group = contactedGroups[#contactedGroups]
	if group.groupID == radioResponseGroupID then
	
		local respondText = SWS_GetModText("GroupResponse1") .. group.spawnPoint[1] .. SWS_GetModText("CommaLongitude") .. group.spawnPoint[2]
		local randIntVal = ZombRand(3)
		if randIntVal == 1 then
			respondText = SWS_GetModText("GroupResponse2") .. group.spawnPoint[1] .. SWS_GetModText("CommaLongitude") .. group.spawnPoint[2]
		elseif randIntVal == 2 then
			respondText = SWS_GetModText("GroupResponse3") .. group.spawnPoint[1] .. SWS_GetModText("CommaLongitude") .. group.spawnPoint[2]
		end

		if radioLastUsedByPlayer then radioLastUsedByPlayer:Say(respondText) end
		
		group.findQuest = SSQM:BeginQuest(SWS_GetModText("TheLastSurvivors"), SWS_GetModText("FindGroupOnMap"))
		SSQM:SetTargetCoords(group.findQuest, group.spawnPoint, SWS_GetModText("GroupCoords"))
		SWS_ContGroupsChanged = true
	end
	
	radioResponseGroupID = 0
end

local function SurvivorResponse()
	local SS = SSM:Get(radioResponseSurvivorID)
	if (not SS) or SS:isDead() then
		radioResponseSurvivorID = 0
		return false
	end

	local respondText = SWS_GetModText("PlayerResponse1a") .. SS:getName() .. SWS_GetModText("PlayerResponse1b")
	local thanksText = SWS_GetModText("SurvivorThanks1")
	local rejectText = SWS_GetModText("SurvivorReject1")
	local greetText = SWS_GetModText("SurvivorGreet1")
	local randIntVal = ZombRand(3)
	
	if randIntVal == 1 then
		respondText = SWS_GetModText("PlayerResponse2a") .. SS:getName() .. SWS_GetModText("PlayerResponse2b")
		thanksText = SWS_GetModText("SurvivorThanks2")
		rejectText = SWS_GetModText("SurvivorReject2")
		greetText = SWS_GetModText("SurvivorGreet2")
	elseif randIntVal == 2 then
		respondText = SWS_GetModText("PlayerResponse3a") .. SS:getName() .. SWS_GetModText("PlayerResponse3b")
		thanksText = SWS_GetModText("SurvivorThanks3")
		rejectText = SWS_GetModText("SurvivorReject3")
		greetText = SWS_GetModText("SurvivorGreet3")
	end

	local equipedRadio = ForceEquipWalkieTalkie(SS:Get(), survivorChannelInt)
	local radioRange = equipedRadio:getDeviceData():getTransmitRange()
	local distance = getDistanceBetween(SS, getSpecificPlayer(0))
	
	if (distance <= radioRange) then
		print("SWS: Survivor transmitting radio signal at range " .. radioRange)
		SS:Get():Say(respondText)
		SS:Get():setLastSpokenLine(respondText)
		survivorLastZKills = SS:Get():getZombieKills()
		SSQM:ShowMessage(SWS_GetModText("SurvivorComing"), true)
	else
		print("SWS: Survivor failed to respond to player")
		return false
	end

	SS:getTaskManager():clear()
	SS:getTaskManager():AddToTop(GoCheckItOutTask:new(SS, survivorTargetSquare))

	local RecruitSurvivorActions = {
		{ActionType="SSSpeak", Value=thanksText, NPCID=radioResponseSurvivorID}, 
		{ActionType="CustomFunc", Arg1=radioResponseSurvivorID, FuncName="SWS_RecruitContactedSS"},
		{ActionType="SetSSWantsToTalk", Value=false, NPCID=radioResponseSurvivorID}
	}
	
	local RejectSurvivorActions = {
		{ActionType="SSSpeak", Value=rejectText, NPCID=radioResponseSurvivorID}, 
		{ActionType="CustomFunc", Arg1=radioResponseSurvivorID, FuncName="SWS_RejectContactedSS"},
		{ActionType="SetSSWantsToTalk", Value=false, NPCID=radioResponseSurvivorID}
	}
	
	local SurvivorAsksToJoin = {
		{ActionType="SSQuestionDialogueW", NPCID=radioResponseSurvivorID, Value=greetText .. "\n\n" .. SWS_GetModText("CanIJoinGroup"),
		YesResultActions=RecruitSurvivorActions, NoResultActions=RejectSurvivorActions}
	}
	
	local SurvivorFoundTrigger = {
		TriggerName="SurvivorFoundTrigger_" .. radioResponseSurvivorID, Name="SurvivorContactTriggers_" .. radioResponseSurvivorID, 
		Enabled=true, TriggerOnlyOnce=true, ConditionType="DistanceToSS", Distance=2, NPCID=radioResponseSurvivorID, ResultActions=SurvivorAsksToJoin
	}
	
	local SurvivorTalkTrigger = {
		TriggerName="SurvivorTalkTrigger_" .. radioResponseSurvivorID, Name="SurvivorContactTriggers_" .. radioResponseSurvivorID,
		Enabled=true, TriggerOnlyOnce=false, ConditionType="TalkToSS", NPCID=radioResponseSurvivorID, ResultActions=SurvivorAsksToJoin
	}
	
	local SurvivorNearbyTrigger = {
		TriggerName="SurvivorNearbyTrigger_" .. radioResponseSurvivorID, Name="SurvivorContactTriggers_" .. radioResponseSurvivorID,
		Enabled=true, TriggerOnlyOnce=true, ConditionType="DistanceToSS", Distance=20, NPCID=radioResponseSurvivorID, 
		ResultActions={{ActionType="SetSSWantsToTalk", Value=true, NPCID=radioResponseSurvivorID}, 
		{ActionType="CustomFunc", Arg1=radioResponseSurvivorID, FuncName="SWS_NearContactedSS"}}
	}

	SSQM:AddTrigger(SurvivorNearbyTrigger)
	SSQM:AddTrigger(SurvivorFoundTrigger)
	SSQM:AddTrigger(SurvivorTalkTrigger)
end

local function ReplyToNearbySurvivors(radio_range)
	print("SWS: Player transmitting radio signal at range " .. radio_range)
	local mainPlayer = getSpecificPlayer(0)
	survivorTargetSquare = mainPlayer:getCurrentSquare()
	local latitude = math.floor(survivorTargetSquare:getX())
	local longitude = math.floor(survivorTargetSquare:getY())
	
	local replyText = SWS_GetModText("PlayerReply1") .. latitude .. SWS_GetModText("CommaLongitude") .. longitude
	local randIntVal = ZombRand(3)
	if randIntVal == 1 then
		replyText = SWS_GetModText("PlayerReply2") .. latitude .. SWS_GetModText("CommaLongitude") .. longitude
	elseif randIntVal == 2 then
		replyText = SWS_GetModText("PlayerReply3") .. latitude .. SWS_GetModText("CommaLongitude") .. longitude
	end

	mainPlayer:Say(replyText)
	mainPlayer:setLastSpokenLine(replyText)

	radioResponseType = 0
	survivorSearchTimer = 0
	survivorRequestTimer = 0
	radioResponseTimer = ZombRand(2) + 2
	radioResponseSurvivorID = radioRequestSurvivorID
	survivorLastContacted = radioResponseSurvivorID
	SWS_LiteralVarsChanged = true
end

local function ContactNearbySurvivors(radio_range)
	print("SWS: Player transmitting radio signal at range " .. radio_range)
	local mainPlayer = getSpecificPlayer(0)
	local myGroup = SSM:Get(0):getGroup()
	survivorTargetSquare = mainPlayer:getCurrentSquare()
	local latitude = math.floor(survivorTargetSquare:getX())
	local longitude = math.floor(survivorTargetSquare:getY())
	local daysPassed = math.floor(getGameTime():getDaysSurvived())
	
	local calloutText = SWS_GetModText("PlayerCallout1") .. latitude .. SWS_GetModText("CommaLongitude") .. longitude
	local randIntVal = ZombRand(3)
	if randIntVal == 1 then
		calloutText = SWS_GetModText("PlayerCallout2") .. latitude .. SWS_GetModText("CommaLongitude") .. longitude
	elseif randIntVal == 2 then
		calloutText = SWS_GetModText("PlayerCallout3") .. latitude .. SWS_GetModText("CommaLongitude") .. longitude
	end

	mainPlayer:Say(calloutText)
	mainPlayer:setLastSpokenLine(calloutText)
	
	if ZombRand(15) == 0 and not radioAttractedRaiders then
		print("SWS: sending raiders to player coordinates")
		local nearbyRaiders = SWS_GetNearbyRaiders()
		if #nearbyRaiders > 0 then
			for i=1, #nearbyRaiders do
				local trackTask = RaiderTrackPlayerTask:new(nearbyRaiders[i], survivorTargetSquare)
				trackTask:setOnFound(function(SS)
					SS:getTaskManager():AddToTop(PursueTask:new(SS, getSpecificPlayer(0)))
				end, nearbyRaiders[i])
				nearbyRaiders[i]:getTaskManager():AddToTop(trackTask)
			end
		else
			radioAttractedRaiders = true
			SWS_SetRepeatFunc(15+ZombRand(5), {mainPlayer:getX(),mainPlayer:getY()}, function(this)
				if this.count == 0 then
					SWS_SpawnSearchingRaiders(ZombRand(4)+1, this.args[1], this.args[2])
					radioAttractedRaiders = false
					return true
				end
				return false
			end)
		end
	end
	
	for i=1, SSM:forMax() do
		if survivorLastContacted ~= i then
			local SS = SSM:Get(i)
			if SS and SS:isInCell() and SS:isRecruitable() and not (SS:isOnScreen() or SS:isEnemy(mainPlayer) or myGroup:isMember(SS)) then
				local distance = getDistanceBetween(SS, mainPlayer)
				if distance <= radio_range then
					local randMax = 10
					local friendliness = SS:getRelationshipWP()
					if SS:isHungry() or SS:isThirsty() then randMax = 8 end
					if SS:isVHungry() or SS:isVThirsty() then randMax = 6 end
					if SS:isStarving() or SS:isDyingOfThirst() then randMax = 4 end
					randMax = randMax - math.floor(friendliness+0.5)
					if friendliness > 0.0 and (randMax <= 1 or ZombRand(randMax) == 0) then
						radioResponseSurvivorID = i
						survivorLastContacted = i
						break
					end
				end
			end
		end
	end
	
	if radioResponseSurvivorID == -1 and ZombRand(daysPassed+2) == 0 and
	SWS_CellSpawnCount(survivorTargetSquare) < SWS_NPC_CELL_SPAWN_MAX+2 then
		print("SWS: no nearby survivors, spawning new npc")
		local spawnSquare = SWS_RandomOffscreenSquare(survivorTargetSquare)
		if spawnSquare and myGroup and spawnSquare:isOutside() and IsSquareOkForSpawn(spawnSquare, myGroup) then
			local SS = SuperSurvivorRandomSpawn(spawnSquare, true)
			SS:setHostile(false)
			radioResponseSurvivorID = SS:getID()
			survivorLastContacted = SS:getID()
		end
	end

	radioResponseType = 0
	survivorSearchTimer = 0
	radioResponseTimer = ZombRand(2) + 2
	SWS_LiteralVarsChanged = true
end

local function ContactSurvivorGroups(radio_range)
	print("SWS: Player transmitting radio signal at range " .. radio_range)
	local mainPlayer = getSpecificPlayer(0)
	
	local calloutText = SWS_GetModText("GroupCallout1")
	local randIntVal = ZombRand(3)
	if randIntVal == 1 then
		calloutText = SWS_GetModText("GroupCallout2")
	elseif randIntVal == 2 then
		calloutText = SWS_GetModText("GroupCallout3")
	end

	mainPlayer:Say(calloutText)
	mainPlayer:setLastSpokenLine(calloutText)
	
	local spawnPoint = SWS_GetGroupSpawnPoint(false, radio_range)
	
	if spawnPoint and ZombRand(#contactedGroups + 2) == 0 then
		print("SWS: selected spawn point for group")
		radioResponseGroupID = SSGM:newGroup():getID()
		SWS_AddContactedGroup(radioResponseGroupID, spawnPoint)
	end

	radioResponseType = 1
	radioResponseTimer = ZombRand(2) + 2
	SWS_LiteralVarsChanged = true
end

local function ReplyToNearbySurvivorsClickHandle(radioItem)
	local radioData = radioItem:getDeviceData()
	if IsWorkingTwoWayRadio(radioData) then
		RadioFrequencyManagerUI:addChannelPreset("Shortwave Survivors", survivorChannelInt)
		radioData:setMicIsMuted(false)
		radioData:setChannel(survivorChannelInt)
		radioResponseSurvivorID = -1
		ReplyToNearbySurvivors(radioData:getTransmitRange())
		radioLastUsedByPlayer = radioItem
	end
end

local function ContactNearbySurvivorsClickHandle(radioItem)
	local radioData = radioItem:getDeviceData()
	if IsWorkingTwoWayRadio(radioData) then
		RadioFrequencyManagerUI:addChannelPreset("Shortwave Survivors", survivorChannelInt)
		radioData:setMicIsMuted(false)
		radioData:setChannel(survivorChannelInt)
		radioResponseSurvivorID = -1
		ContactNearbySurvivors(radioData:getTransmitRange())
		radioLastUsedByPlayer = radioItem
	end
end

local function ContactSurvivorGroupClickHandle(radioItem)
	local radioData = radioItem:getDeviceData()
	if IsWorkingTwoWayRadio(radioData) then
		RadioFrequencyManagerUI:addChannelPreset("Shortwave Survivors", survivorChannelInt)
		radioData:setMicIsMuted(false)
		radioData:setChannel(survivorChannelInt)
		radioResponseGroupID = -1
		ContactSurvivorGroups(radioData:getTransmitRange())
		radioLastUsedByPlayer = radioItem
	end
end

local function KnockOnDoorClickHandle(SS)
	local mainPlayer = getSpecificPlayer(0)
	mainPlayer:Say(SWS_GetModText("AnyoneInside"))
	if SS then
		SS:getTaskManager():AddToTop(ListenTask:new(SS,mainPlayer,false))
	end
end

local function RemoveFromMoneyBandClickHandle(moneyBand, moneyCount, amount)
	local newMoneyCount = moneyCount - amount
	moneyBand:setUsedDelta(newMoneyCount * 0.001)
	getSpecificPlayer(0):getInventory():AddItems("Base.Money", amount)
	if newMoneyCount <= 0 then
		moneyBand:Use(true)
	else
		moneyBand:setActualWeight(moneyBand:getUsedDelta())
		moneyBand:getModData().moneyCount = newMoneyCount
	end
end

local function AddToMoneyBandClickHandle(amount)
	local mainPlayer = getSpecificPlayer(0)
	local playerInv = mainPlayer:getInventory()
	local moneyBand = playerInv:getItemFromType("Base.SWSMoneyBand")
	if not moneyBand then
		moneyBand = SWS_CreateNewMoneyBand(mainPlayer, amount)
	else
		if moneyBand:getModData().moneyCount >= 1000 then
			local invItems = playerInv:getItems()
			moneyBand = nil
			for i=0, invItems:size()-1 do
				invItem = invItems:get(i)
				if invItem:getFullType() == "Base.SWSMoneyBand" and invItem:getModData().moneyCount < 1000 then
					moneyBand = invItem
					break
				end
			end
		end
		if not moneyBand then
			SWS_CreateNewMoneyBand(mainPlayer, amount)
			return
		end
		local moneyCount = moneyBand:getModData().moneyCount
		local moneySpace = 1000 - moneyCount
		if amount > moneySpace then
			moneyBand:setUsedDelta(1.0)
			moneyBand:getModData().moneyCount = 1000
			SWS_CreateNewMoneyBand(mainPlayer, amount-moneySpace)
			SWS_PlayerRemoveItems(mainPlayer, "Base.Money", moneySpace)
		else
			moneyBand:setUsedDelta((moneyCount+amount) * 0.001)
			moneyBand:getModData().moneyCount = moneyCount + amount
			SWS_PlayerRemoveItems(mainPlayer, "Base.Money", amount)
		end
		moneyBand:setActualWeight(moneyBand:getUsedDelta())
	end
end

local function ModifyInventoryContextMenu(playerIndex, context, items)
	if playerIndex ~= 0 then return end
	local mainPlayer = getSpecificPlayer(0)
	local equipedRadio = GetEquipedRadioFromEitherHand(mainPlayer)
	local items = ISInventoryPane.getActualItems(items)
	local moneyCount = 0
	for _, item in ipairs(items) do
		if item:getFullType() == "Base.Money" then
			if item:getContainer() == mainPlayer:getInventory() then
				moneyCount = moneyCount + 1
			end
		elseif item:getFullType() == "Base.SWSMoneyBand" then
			--NOTE: using getModData() because the used delta value
			-- doesn't seem to get saved/loaded with enough precision
			if item:getModData().moneyCount ~= nil then
				moneyCount = item:getModData().moneyCount
			else
				moneyCount = SWS_RoundFloat(item:getUsedDelta() * 1000)
			end
			if moneyCount > 100 then
				context:addOption(SWS_GetModText("MB_Remove100"), mainPlayer, function()
					RemoveFromMoneyBandClickHandle(item, moneyCount, 100)
				end)
			end
			if moneyCount > 10 then
				context:addOption(SWS_GetModText("MB_Remove10"), mainPlayer, function()
					RemoveFromMoneyBandClickHandle(item, moneyCount, 10)
				end)
			end
			if moneyCount > 0 then
				context:addOption(SWS_GetModText("MB_RemoveAll"), mainPlayer, function()
					RemoveFromMoneyBandClickHandle(item, moneyCount, moneyCount)
				end)
			end
			return
		elseif radioResponseSurvivorID == 0 and equipedRadio and equipedRadio:getID() == item:getID() then
			local radioData = equipedRadio:getDeviceData()
			if IsWorkingTwoWayRadio(radioData) then
				if survivorRequestTimer == 0 then
					context:addOption(SWS_GetModText("ContactNearby"), mainPlayer, function()
						ContactNearbySurvivorsClickHandle(equipedRadio)
					end)
				elseif survivorLastContacted ~= radioRequestSurvivorID then
					context:addOption(SWS_GetModText("RespondNearby"), mainPlayer, function()
						ReplyToNearbySurvivorsClickHandle(equipedRadio)
					end)
				end
				return
			end
		end
	end
	if moneyCount > 1000 then
		context:addOption(SWS_GetModText("MB_Add1000"), mainPlayer, function()
			AddToMoneyBandClickHandle(1000)
		end)
	end
	if moneyCount > 100 then
		context:addOption(SWS_GetModText("MB_Add100"), mainPlayer, function()
			AddToMoneyBandClickHandle(100)
		end)
	end
	if moneyCount > 0 and moneyCount <= 1000 then
		context:addOption(SWS_GetModText("MB_AddAll"), mainPlayer, function()
			AddToMoneyBandClickHandle(moneyCount)
		end)
	end
end

local function ModifyWorldObjectContextMenu(playerIndex, context, worldObjects, test)
	if test and ISWorldObjectContextMenu.Test then return true end
	if playerIndex ~= 0 then return end
	local mainPlayer = getSpecificPlayer(0)
	for _, item in ipairs(worldObjects) do
		if instanceof(item, "IsoRadio") and item:getZ() == mainPlayer:getZ() then
			--local itemProps = item:getProperties()
			--local itemName = GetIsoObjectItemName(itemProps)
			local radioData = item:getDeviceData()
			if radioResponseTimer == 0 and IsWorkingTwoWayRadio(radioData) then
				if radioResponseSurvivorID == 0 then
					local optionText = SWS_GetModText("ContactNearby")
					local contextClickHandleFunc = ContactNearbySurvivorsClickHandle
					if survivorRequestTimer > 0 and survivorLastContacted ~= radioRequestSurvivorID then
						optionText = SWS_GetModText("RespondNearby")
						contextClickHandleFunc = ReplyToNearbySurvivorsClickHandle
					end
					context:addOption(optionText, nil, function()
						local micDist = getDistanceBetweenPoints(item:getX(), item:getY(), mainPlayer:getX(), mainPlayer:getY())
						if micDist <= radioData:getMicRange() then
							contextClickHandleFunc(item)
						else
							local square = item:getSquare()
							if square:isSolid() or not square:isSolidFloor() then
								square = ClosestFreeAdjacentSquare(square, mainPlayer:getX(), mainPlayer:getY())
							end
							if not mainPlayer:getPathFindBehavior2():isTargetLocation(square:getX(),square:getY(),square:getZ()) then
								local walkTask = ISWalkToTimedAction:new(mainPlayer, square)
								walkTask:setOnComplete(contextClickHandleFunc, item)
								ISTimedActionQueue.add(walkTask)
							end
						end
					end, item, nil)
				end
				if radioResponseGroupID == 0 and not radioData:getIsPortable() then
					context:addOption(SWS_GetModText("ContactGroups"), nil, function()
						local micDist = getDistanceBetweenPoints(item:getX(), item:getY(), mainPlayer:getX(), mainPlayer:getY())
						if micDist <= radioData:getMicRange() then
							ContactSurvivorGroupClickHandle(item)
						else
							local square = item:getSquare()
							if square:isSolid() or not square:isSolidFloor() then
								square = ClosestFreeAdjacentSquare(square, mainPlayer:getX(), mainPlayer:getY())
							end
							if not mainPlayer:getPathFindBehavior2():isTargetLocation(square:getX(),square:getY(),square:getZ()) then
								local walkTask = ISWalkToTimedAction:new(mainPlayer, square)
								walkTask:setOnComplete(ContactSurvivorGroupClickHandle, item)
								ISTimedActionQueue.add(walkTask)
							end
						end
					end, item, nil)
				end
				return
			end
		elseif instanceof(item, "IsoDoor") and item:getZ() == mainPlayer:getZ() then
			if item:isLocked() and not item:IsOpen() then
				local square = item:getOtherSideOfDoor(mainPlayer)
				if (not square:isOutside()) and square:getBuilding() then
					local building = square:getBuilding()
					for i=1, #contactedGroups do
						local group = contactedGroups[i]
						if group and group.leaderID > 0 then
							local SS = SSM:Get(group.leaderID)
							if SS and SS:getBaseBuilding() == building then
								context:addOption(SWS_GetModText("KnockOnDoor"), nil, function()
									if getDistanceBetweenPoints(item:getX(), item:getY(), mainPlayer:getX(), mainPlayer:getY()) > 1.5 then
										square = ClosestFreeAdjacentSquare(item:getSquare(), mainPlayer:getX(), mainPlayer:getY())
										local walkTask = ISWalkToTimedAction:new(mainPlayer, square)
										walkTask:setOnComplete(KnockOnDoorClickHandle, SS)
										ISTimedActionQueue.add(walkTask)
									else
										KnockOnDoorClickHandle(SS)
									end
								end, item, nil)
								return
							end
						end
					end
				end
			end
		end
	end
end

local function DoSurvivorRadioCall(SS, callText)
	if callText then
		ForceEquipWalkieTalkie(SS:Get(), survivorChannelInt)
		SS:Get():Say(callText)
		SS:Get():setLastSpokenLine(callText)
	end
end

local function SurvivorRadioUpdates(SS)
	local callText = nil
	if SS:Get():getZombieKills() > survivorLastZKills then
		survivorLastZKills = SS:Get():getZombieKills()
		SWS_LiteralVarsChanged = true
		if ZombRand(2) == 0 then
			callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate1")
		else
			callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate2")
		end
	elseif ZombRand(2) == 0 then
		local zcount = SS:Get():getSurroundingAttackingZombies()
		if zcount == 1 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate3")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate4")
			end
		elseif zcount > 0 and zcount < 4 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate5")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate6")
			end
		elseif zcount >= 4 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate7")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate8")
			end
		end
	elseif ZombRand(5) == 0 then
		local dayHour = getGameTime():getHour()
		local climate = getClimateManager()
		if climate:isRaining() or climate:isSnowing() then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate9")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate10")
			end
		elseif climate:getFogIntensity() >= 0.4 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate11")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate12")
			end
		elseif climate:getFogIntensity() >= 0.1 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate13")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate14")
			end
		else
			if dayHour > 5 and dayHour < 21 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate15")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioUpdate16")
			end
		end
	end
	return callText
end

local function SurvivorRadioProgress(SS)
	local callText = nil
	if not survivorTargetSquare then return nil end
	if survivorSearchTimer == 240 then -- 4 in-game hours
		if getDistanceBetweenPoints(SS:getX(), SS:getY(), survivorTargetSquare:getX(), survivorTargetSquare:getY()) > 40 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress1")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress2")
			end
		else
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress3")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress4")
			end
		end
	elseif survivorSearchTimer == 480 then -- 8 in-game hours
		if getDistanceBetweenPoints(SS:getX(), SS:getY(), survivorTargetSquare:getX(), survivorTargetSquare:getY()) > 40 then
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress5")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress6")
			end
		else
			if ZombRand(2) == 0 then
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress7")
			else
				callText = SS:getName() ..": ".. SWS_GetModText("RadioProgress8")
			end
		end
	end
	return callText
end

local function SurvivorRadioChatter(SS)
	local randInt = ZombRand(1, 11)
	if SS:isHostile() then
		if randInt < 3 then
			return SWS_GetModText("RadioChatter1")
		elseif randInt < 5 then
			return SWS_GetModText("RadioChatter2")
		elseif randInt < 7 then
			return SWS_GetModText("RadioChatter3")
		elseif randInt < 9 then
			return SWS_GetModText("RadioChatter4")
		else
			return SWS_GetModText("RadioChatter5")
		end
	else
		if randInt == 1 then
			return SWS_GetModText("RadioChatter6")
		elseif randInt == 2 then
			return SWS_GetModText("RadioChatter7")
		elseif randInt == 3 then
			return SWS_GetModText("RadioChatter8")
		elseif randInt == 4 then
			return SWS_GetModText("RadioChatter9")
		elseif randInt == 5 then
			return SWS_GetModText("RadioChatter10")
		elseif randInt == 6 then
			return SWS_GetModText("RadioChatter11")
		elseif randInt == 7 then
			return SWS_GetModText("RadioChatter12")
		elseif randInt == 8 then
			return SWS_GetModText("RadioChatter13")
		elseif randInt == 9 then
			return SWS_GetModText("RadioChatter14")
		else
			return SWS_GetModText("RadioChatter15")
		end
	end
end

local function SurvivorNotFound()
	SSQM:RemoveTriggersWithName("SurvivorContactTriggers_" .. radioResponseSurvivorID)
	SSQM:ShowMessage(SWS_GetModText("SurvivorLost"), true)
	survivorSearchTimer = 0
	radioResponseSurvivorID = 0
end

local function SWS_MinUpdate()
	local player = getSpecificPlayer(0)
	if radioResponseTimer > 0 then
		radioResponseTimer = radioResponseTimer - 1
		if radioResponseTimer <= 0 then
			if radioResponseSurvivorID > 0 and radioResponseType == 0 then
				SurvivorResponse()
			elseif radioResponseGroupID > 0 and radioResponseType == 1 then
				GroupResponse()
			else
				print("SWS: No nearby survivors picked up the transmission")
				radioResponseSurvivorID = 0
				radioResponseGroupID = 0
			end
			radioResponseTimer = 0
		end
		SWS_LiteralVarsChanged = true
	elseif radioResponseSurvivorID > 0 then
		local SS = SSM:Get(radioResponseSurvivorID)
		survivorSearchTimer = survivorSearchTimer + 1
		if survivorSearchTimer < 720 then
			if SS then
				if SS:isDead() then
					SSQM:RemoveTriggersWithName("SurvivorContactTriggers_" .. radioResponseSurvivorID)
					SSQM:ShowMessage(SS:getName() .. SWS_GetModText("DiedTrying"), true)
					survivorSearchTimer = 0
					radioResponseSurvivorID = 0
				elseif survivorKnockTimer > 0 then
					survivorKnockTimer = survivorKnockTimer - 1
				elseif survivorSearchTimer%13 == 0 then
					if getDistanceBetween(SS, player) <= 20 then
						local callText = nil
						if SS:NPC_IFOD_LockedOutsidePlayerBuilding() then
							survivorKnockTimer = 120
							SSQM:ShowMessage(SS:getName() .. SWS_GetModText("LockedOutMsg"), true)
							if ZombRand(2) == 0 then
								callText = SS:getName() ..": ".. SWS_GetModText("LockedOut1")
							else
								callText = SS:getName() ..": ".. SWS_GetModText("LockedOut2")
							end
						elseif survivorTargetSquare then
							if getDistanceBetweenPoints(SS:getX(), SS:getY(), survivorTargetSquare:getX(), survivorTargetSquare:getY()) < 5 then
								survivorKnockTimer = 240
								if SS:isOnScreen() then
									SSQM:ShowMessage(SS:getName() .. SWS_GetModText("GoMeetMsg1"), true)
								else
									SSQM:ShowMessage(SS:getName() .. SWS_GetModText("GoMeetMsg2"), true)
								end
							end
						end
						DoSurvivorRadioCall(SS, callText)
					end
				else
					local callText = SurvivorRadioProgress(SS)
					if callText == nil and survivorSearchTimer%17 == 0 then
						callText = SurvivorRadioUpdates(SS)
					end
					if callText ~= nil and not SS:isOnScreen() then
						DoSurvivorRadioCall(SS, callText)
					end
				end
			end
		elseif survivorSearchTimer == 720 then -- 12 in-game hours
			if SS and SS:isOnScreen() then
				SSQM:ShowMessage(SS:getName() .. SWS_GetModText("GoMeetMsg1"), true)
				survivorKnockTimer = 240
			else
				SurvivorNotFound()
			end
		elseif survivorKnockTimer > 0 then
			survivorKnockTimer = survivorKnockTimer - 1
		else
			SurvivorNotFound()
		end
		SWS_LiteralVarsChanged = true
	elseif survivorRequestTimer > 0 then
		survivorRequestTimer = survivorRequestTimer - 1
		SWS_LiteralVarsChanged = true
	end
	
	for i=1, #contactedGroups do
		local groupData = contactedGroups[i]
		if groupData.groupID > 0 then
			if (not groupData.isSpawned) and getCell():getGridSquare(groupData.spawnPoint[1], groupData.spawnPoint[2], 0) then
				local spawnResult = SWS_SpawnSurvivorGroup(groupData)
				if spawnResult then
					groupData.isSpawned = true
					SetGroupQuestTriggers(groupData)
					if groupData.spawnFunc then
						local spawnFunc = SSQM:GetCustomFunc(groupData.spawnFunc)
						if spawnFunc then spawnFunc(groupData.spawnFuncArgs) end
					end
				elseif spawnResult == nil and groupData.spawnAttempts == 0 then
					if groupData.findQuest > 0 then
						SSQM:SetTargetCoords(groupData.findQuest, groupData.spawnPoint, SWS_GetModText("GroupCoords"))
					elseif groupData.spawnQuest > 0 then
						SSQM:SetTargetCoords(groupData.spawnQuest, groupData.spawnPoint, SWS_GetModText("GroupCoords"))
					end
					groupData.spawnAttempts = groupData.spawnAttempts + 1
					SSQM:ShowMessage(SWS_GetModText("GotNewCoords"))
				else
					print("SWS: failed to spawn survivor group")
					groupData.groupID = -1
					if groupData.findQuest > 0 then
						SSQM:FailQuest(groupData.findQuest, SWS_GetModText("GroupVanished"))
					end
					if groupData.spawnFunc then
						local spawnFunc = SSQM:GetCustomFunc(groupData.spawnFunc)
						if spawnFunc then spawnFunc(groupData.spawnFuncArgs, true) end
					end
				end
				SWS_ContGroupsChanged = true
			end
		end
	end
	
	for i=1, #minuteRepeatFuncs do
		if minuteRepeatFuncs[i] and minuteRepeatFuncs[i].count > 0 then
			local stopFunc = false
			minuteRepeatFuncs[i].count = minuteRepeatFuncs[i].count - 1
			stopFunc = minuteRepeatFuncs[i].func(minuteRepeatFuncs[i])
			if stopFunc or minuteRepeatFuncs[i].count == 0 then
				minuteRepeatFuncs[i] = nil
			end
		end
	end
end

local function SWS_TenMinUpdate()
	local player = getSpecificPlayer(0)
	if survivorRequestTimer == 0 and ZombRand(4) == 0 then
		local SS = SWS_RandomOffscreenSurvivor()
		local playerRadio = GetEquipedRadioFromEitherHand(player)
		if SS and playerRadio then
			local radioData = playerRadio:getDeviceData()
			if IsWorkingTwoWayRadio(radioData) and radioData:getChannel() == survivorChannelInt then
				local callText = nil
				if ZombRand(4) == 0 then
					if SS:isHostile() then
						--TODO: raider trying to lure player
					elseif SS:isRecruitable() then
						if ZombRand(2) == 0 then
							callText = SWS_GetModText("SurvivorCall1")
						else
							callText = SWS_GetModText("SurvivorCall2")
						end
						survivorRequestTimer = 10
						radioRequestSurvivorID = SS:getID()
						SWS_LiteralVarsChanged = true
					end
				else
					callText = SurvivorRadioChatter(SS)
				end
				DoSurvivorRadioCall(SS, callText)
			end
		end
	end
end

local function SWS_DayUpdate()
	if (getGameTime():getDay() % 2) == 0 then
		for i=1, #survivorShopList do
			local shopInv = SSQM:GetGlobalData(survivorShopList[i].Name)
			if shopInv then
				SWS_UpdateShopStock(shopInv, survivorShopList[i].Type)
			end
		end
	end
end

local function TileBuildingCheck(this)
	local reqBuildObjects = SSQM:GetRequiredObjects()
	if #reqBuildObjects <= 0 then return false end
	local square = getCell():getGridSquare(this.args[1], this.args[2], this.args[3])
	if not square then return false end
	local sqObjects = square:getObjects()
	for i=0, sqObjects:size()-1 do
		local obj = sqObjects:get(i)
		local objName = obj:getName()
		if not objName then
			objName = obj:getObjectName()
		end
		if objName then
			for o=1, #reqBuildObjects do
				if objName == reqBuildObjects[o] then
					SSQM:UpdateObjectsBuilt(objName, this.args[1], this.args[2])
					return true
				end
			end
		end
	end
	return false
end

local function OnDoTileBuilding(x, y, z)
	local reqBuildObjects = SSQM:GetRequiredObjects()
	if #reqBuildObjects <= 0 then return end
	SWS_SetRepeatFunc(9, {x,y,z}, TileBuildingCheck)
end

Events.OnDoTileBuilding2.Add(function(chunk, render, x, y, z, square)
	if render then
		return
	else
		print("SWS: OnDoTileBuilding2 triggered")
		OnDoTileBuilding(x, y, z)
	end
end)

Events.OnDoTileBuilding3.Add(function(chunk, render, x, y, z)
	if render then
		return
	else
		print("SWS: OnDoTileBuilding3 triggered")
		OnDoTileBuilding(x, y, z)
	end
end)

Events.OnNewGame.Add(function(player, square)
	SuperSurvivorSetOption("SpawnRate", 5)
	SuperSurvivorSetOption("NoPreSetSpawn", true)
end)

Events.OnSave.Add(function()
	if SWS_GameLoaded and SSQM then
		SWS_LiteralVarsChanged = true
		SWS_ContGroupsChanged = true
		SWS_SurvivorShopsChanged = true
		SWS_SpawnStatesChanged = true
		SSQM_QuestTriggersChanged = true
		SSQM_ActiveQuestsChanged = true
		SSQM_FailedQuestsChanged = true
		SSQM_CompleteQuestsChanged = true
		SSQM_MiscMessagesChanged = true
		SSQM_ActionQueueChanged = true
		SSQM_QuestDataChanged = true
		SSQM_NPCCellKeysChanged = true
		SSQM_NPCCellCountsChanged = true
		SSQM_NPCTWTTChanged = true
		SWS_SaveModVars()
		SSQM:SaveToFile()
	end
end)

Events.OnLoad.Add(function()
	SWS_LoadModVars()
	SSQM:LoadFromFile()
	if radioResponseSurvivorID == -1 and (survivorSearchTimer == 0 or survivorSearchTimer > 960) then
		print("SWS: fixing bad radioResponseSurvivorID")
		radioResponseSurvivorID = 0
	end
	for i=1, SSM:forMax() do
		local SS = SSM:Get(i)
		if SS then
			SSQM:CheckNPCWantsToTalk(SS:getID())
		end
	end
	SSQM:UpdateQuestInfoWindow()
	SWS_GameLoaded = true
end)

Events.OnGameBoot.Add(function()
	SSQM:SetCustomFunc("SWS_RecruitContactedSS", SWS_RecruitContactedSS)
	SSQM:SetCustomFunc("SWS_RejectContactedSS", SWS_RejectContactedSS)
	SSQM:SetCustomFunc("SWS_NearContactedSS", SWS_NearContactedSS)
	SSQM:SetCustomFunc("SWS_LeaderGivePlayerJob", SWS_LeaderGivePlayerJob)
	SSQM:SetCustomFunc("SWS_LeaderJobDialog", SWS_LeaderJobDialog)
	SSQM:SetCustomFunc("SWS_TraderGivePlayerJob", SWS_TraderGivePlayerJob)
	SSQM:SetCustomFunc("SWS_TraderJobDialog", SWS_TraderJobDialog)
	SSQM:SetCustomFunc("SWS_TraderNextShopCat", SWS_TraderNextShopCat)
	SSQM:SetCustomFunc("SWS_TraderShopCatDialog", SWS_TraderShopCatDialog)
	SSQM:SetCustomFunc("SWS_TraderShopDialog", SWS_TraderShopDialog)
	SSQM:SetCustomFunc("SWS_DoctorGivePlayerJob", SWS_DoctorGivePlayerJob)
	SSQM:SetCustomFunc("SWS_DoctorJobDialog", SWS_DoctorJobDialog)
	SSQM:SetCustomFunc("SWS_DoctorShopDialog", SWS_DoctorShopDialog)
	SSQM:SetCustomFunc("SWS_DoctorHealPlayer", SWS_DoctorHealPlayer)
	SSQM:SetCustomFunc("SWS_DoctorHealDialog", SWS_DoctorHealDialog)
	SSQM:SetCustomFunc("SWS_SheriffGivePlayerJob", SWS_SheriffGivePlayerJob)
	SSQM:SetCustomFunc("SWS_SheriffJobDialog", SWS_SheriffJobDialog)
	SSQM:SetCustomFunc("SWS_SheriffSelectShopCat", SWS_SheriffSelectShopCat)
	SSQM:SetCustomFunc("SWS_SheriffShopDialog", SWS_SheriffShopDialog)
	SSQM:SetCustomFunc("SWS_NearOtherGroup", SWS_NearOtherGroup)
	SSQM:SetCustomFunc("SWS_NearTrainStation", SWS_NearTrainStation)
	SSQM:SetCustomFunc("SWS_RandomGreetDialog", SWS_RandomGreetDialog)
	SSQM:SetCustomFunc("SWS_RandomLeaveDialog", SWS_RandomLeaveDialog)
	SSQM:SetCustomFunc("SWS_RandomMeetDialog", SWS_RandomMeetDialog)
	SSQM:SetCustomFunc("SWS_RandomRewardDialog", SWS_RandomRewardDialog)
	SSQM:SetCustomFunc("SWS_RandomRaiderTitle", SWS_RandomRaiderTitle)
	SSQM:SetCustomFunc("SWS_RandomSurvivorName", SWS_RandomSurvivorName)
	SSQM:SetCustomFunc("SWS_SaveSurvalistGroupID", SWS_SaveSurvalistGroupID)
	SSQM:SetCustomFunc("SWS_TryPayRansom", SWS_TryPayRansom)
	SSQM:SetCustomFunc("SWS_OnClickBuyButton", SWS_OnClickBuyButton)
	SSQM:SetCustomFunc("SWS_SelectShopItem", SWS_SelectShopItem)
	SSQM:SetCustomFunc("SWS_NextShopItem", SWS_NextShopItem)
	SSQM:SetCustomFunc("SWS_RemoveZombiesInArea", SWS_RemoveZombiesInArea)
end)

Events.OnFillInventoryObjectContextMenu.Add(ModifyInventoryContextMenu)
Events.OnFillWorldObjectContextMenu.Add(ModifyWorldObjectContextMenu)
Events.EveryOneMinute.Add(SWS_MinUpdate)
Events.EveryTenMinutes.Add(SWS_TenMinUpdate)
Events.EveryDays.Add(SWS_DayUpdate)