RaiderTrackPlayerTask = {}
RaiderTrackPlayerTask.__index = RaiderTrackPlayerTask

function RaiderTrackPlayerTask:new(superSurvivor, spot)

	local o = {}
	setmetatable(o, self)
	self.__index = self
		
	o.parent = superSurvivor
	o.Name = "Check out spot"
	o.Spot = spot
	o.SeenSpot = false
	o.FoundPlayer = false
	o.Ticks = 0
	o.Complete = false
	
	return o

end

function RaiderTrackPlayerTask:isComplete()
	if self.Complete then
		if self.FoundPlayer and self.onFoundFunc then
			self.onFoundFunc(self.onFoundArgs)
		end
	end
	return self.Complete
end

function RaiderTrackPlayerTask:setOnFound(func, args)
    self.onFoundFunc = func
    self.onFoundArgs = args
end

function RaiderTrackPlayerTask:isValid()
	if not self.parent or self.Spot == nil then return false 
	else return true end
end

function RaiderTrackPlayerTask:update()
	
	if not self:isValid() then 
		self.Complete = true
		return false
	end
	
	if self.parent.player:CanSee(getSpecificPlayer(0)) then
		self.FoundPlayer = true
		self.Complete = true
	elseif self.parent:isInAction() == false then
		
		local distance = getDistanceBetween(self.parent:Get(), self.Spot)
			
		if distance <= 2.0 then
			self.parent:setRunning(false)
			self.parent:Speak(getDialogue("WhereHeGo"))
			self.Complete = true
		else
			self.parent:WalkToPoint(self.Spot:getX(),self.Spot:getY(),self.Spot:getZ())
			self.parent:setRunning(true)
		end
	
		self.Ticks = self.Ticks + 1
		if self.Ticks > 15 then self.Complete = true end
	end

end
