local modid = "ShortwaveSurvivors"

local function getFileFullPath(fileName)
	return getWorld():getWorld()..getFileSeparator()..fileName
end

local function formatString(str)
    local result, count = string.gsub(str, "\n", "\\n")
    result, count = string.gsub(result, "\r", "\\r")
    result, count = string.gsub(result, '"', '\\"')
    return '"'..result..'"'
end

local function encodeTable(val, key, depth)
    depth = depth or 0
	local varType = type(val)
    local tmp = string.rep(" ", depth)
	
    if key then
		if type(key) == "number" then
			tmp = tmp .. "[" .. key .. "] = "
		else
			tmp = tmp .. key .. " = "
		end
	end

    if varType == "table" then
        tmp = tmp .. "{\n"
        for k, v in pairs(val) do
            tmp = tmp .. encodeTable(v, k, depth + 1) .. ",\n"
        end
        tmp = tmp .. string.rep(" ", depth) .. "}"
    elseif varType == "number" then
        tmp = tmp .. tostring(val)
    elseif varType == "string" then
        tmp = tmp .. formatString(val)
    elseif varType == "boolean" then
        tmp = tmp .. (val and "true" or "false")
    else--if varType == "nil" then
        tmp = tmp .. "nil"
    end

    return tmp
end

local function decodeTable(txt)
	local f = loadstring("return "..txt)
	if f ~= nil then
		return f()
	else
		return {}
	end
end
 
function SWS_SaveTable(t, name)
	local fileWriterObj = getModFileWriter(modid, getFileFullPath(name), true, false)
	fileWriterObj:write(encodeTable(t))
	fileWriterObj:close()
end

function SWS_LoadTable(name)
	local fileReaderObj = getModFileReader(modid, getFileFullPath(name), true)
	local text = ""
	local line = fileReaderObj:readLine()
	while line ~= nil do
		text = text .. line
		line = fileReaderObj:readLine()
	end
	fileReaderObj:close()
	if text and text ~= "" then
		return decodeTable(text)
	end
	return {}
end

function SWS_DoesFileExist(name)
	local fileTable = {}
	local readFile = getModFileReader(modid, getFileFullPath(name), false)
	if readFile then 
		return true
	else 
		return false 
	end
end

function SWS_GetModText(text)
	return getText("IGUI_SWS_" .. text)
end