
WaterWorld = WaterWorld or {}
WaterWorld.Verbose = false
WaterWorld.RemoveErosion = false
WaterWorld.RemoveOtherTiles = false

local lcl = {}
lcl.igs_base = __classmetatables[IsoGridSquare.class].__index
lcl.igs_getX             = lcl.igs_base.getX
lcl.igs_getY             = lcl.igs_base.getY
lcl.igs_getZ             = lcl.igs_base.getZ
lcl.igs_getFloor         = lcl.igs_base.getFloor
lcl.igs_addFloor         = lcl.igs_base.addFloor
lcl.igs_disableErosion   = lcl.igs_base.disableErosion
lcl.igs_RemoveTileObject = lcl.igs_base.RemoveTileObject
lcl.igs_isOutside        = lcl.igs_base.isOutside
lcl.igs_getObjects        = lcl.igs_base.getObjects

lcl.io_base = __classmetatables[IsoObject.class].__index
lcl.io_getProperties     = lcl.io_base.getProperties
lcl.io_getObjectName     = lcl.io_base.getObjectName


lcl.pc_base = __classmetatables[PropertyContainer.class].__index
lcl.pc_Is     = lcl.pc_base.Is
lcl.pc_Val    = lcl.pc_base.Val

lcl.PZArrayList_base        = __classmetatables[PZArrayList.class].__index
lcl.PZArrayList_size        = lcl.PZArrayList_base.size
lcl.PZArrayList_get         = lcl.PZArrayList_base.get

function lcl.getCoordLimit(daysSinceStart, endWaterWorldDay, initCoord, endCoord)
    if daysSinceStart >= endWaterWorldDay then
        return endCoord
    else
        return initCoord + (endCoord-initCoord) * daysSinceStart / endWaterWorldDay
    end
end

function WaterWorld.OnZombieUpdate(zombie)
    --it zombie is stuck on water, then move it on "shore"?
    if zombie:isLocal() then
        local square = zombie:getCurrentSquare()
        if square then
            local previousFloor = lcl.igs_getFloor(square)
            if previousFloor then
                local prevFloorProps = lcl.io_getProperties(previousFloor)
                if prevFloorProps and lcl.pc_Is(prevFloorProps,IsoFlagType.water) then
                    
                    local daysSinceStart = lcl.gameTime:getWorldAgeHours() / 24.0
                    local sbv = SandboxVars.WaterWorld
                    local destPos = {x=lcl.igs_getX(square),y=lcl.igs_getY(square),z=lcl.igs_getZ(square)}
                    local moveSources = {false,false,false,false}
                    if sbv.FromSouth then
                        local limit = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromSouth, sbv.MapSouthestPoint, sbv.SouthWaterLimit)
                        if destPos.y >= limit then
                            destPos.y = limit-1
                            moveSources[1] = true
                        end
                    end
                    if sbv.FromWest then
                        local limit = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromWest , sbv.MapWestestPoint , sbv.WestWaterLimit)
                        if destPos.x <= limit then
                            destPos.x = limit+1
                            moveSources[2] = true
                        end
                    end
                    if sbv.FromNorth then
                        local limit = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromNorth, sbv.MapNorthestPoint, sbv.NorthWaterLimit)
                        if destPos.y <= limit then
                            destPos.y = limit+1
                            moveSources[3] = true
                        end
                    end
                    if sbv.FromEast then
                        local limit = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromEast , sbv.MapEastestPoint , sbv.EastWaterLimit)
                        if destPos.x >= limit then
                            destPos.x = limit-1
                            moveSources[4] = true
                        end
                    end
                    
                    local moveEWReq = moveSources[2] ~= moveSources[4]
                    local moveSNReq = moveSources[1] ~= moveSources[3]
                    local moveEWForbid = moveSources[2] and moveSources[4]
                    local moveSNForbid = moveSources[1] and moveSources[3]
                    if moveEWReq and not moveSNForbid or moveSNReq and not moveEWForbid then
                        WaterWorld.teleport(zombie,destPos)
                    end
                end
            end
        end
    end
end

local telOnTick = {}
function WaterWorld.teleport(character,destPos)
    if not character then return end
    if not destPos or not destPos.x or not destPos.y or not destPos.z then return end
    --handle start / end offset on square ?
    local offsetX = character:getX()-character:getCurrentSquare():getX()
    local offsetY = character:getY()-character:getCurrentSquare():getY()
    local offsetZ = character:getZ()-character:getCurrentSquare():getZ()
    if WaterWorld.Verbose then print ('WaterWorld teleport to '..offsetX..' '..offsetY..' '..sq2str(destPos)..' '..sq2str(destPos)..' '..sq2str(character:getSquare())..' '..sq2str(character:getCurrentSquare())) end
    if WaterWorld.Verbose then print ('WaterWorld teleport from '..offsetX..' '..offsetY..' '..sq2str({x=character:getX(),y=character:getY(),z=character:getZ()})) end
    character:setX (destPos.x+offsetX)
    character:setY (destPos.y+offsetY)
    character:setZ (destPos.z+offsetZ)
    character:setLx(destPos.x+offsetX)
    character:setLy(destPos.y+offsetY)
    character:setLz(destPos.z+offsetZ)
end



function WaterWorld.onSandboxOptionsReady()
    if SandboxVars.WaterWorld.TeleportZombies then
        Events.OnZombieUpdate.Add(WaterWorld.OnZombieUpdate)
    end
end

Events.OnInitGlobalModData.Add(WaterWorld.onSandboxOptionsReady)
Events.OnGameTimeLoaded.Add(function() lcl.gameTime = getGameTime() end)
