WaterWorld = WaterWorld or {}


local lcl = {}
lcl.igs_base = __classmetatables[IsoGridSquare.class].__index
lcl.igs_getX             = lcl.igs_base.getX
lcl.igs_getY             = lcl.igs_base.getY
lcl.igs_getZ             = lcl.igs_base.getZ
lcl.igs_getFloor         = lcl.igs_base.getFloor
lcl.igs_addFloor         = lcl.igs_base.addFloor
lcl.igs_disableErosion   = lcl.igs_base.disableErosion
lcl.igs_RemoveTileObject = lcl.igs_base.RemoveTileObject
lcl.igs_isOutside        = lcl.igs_base.isOutside
lcl.igs_getObjects        = lcl.igs_base.getObjects

lcl.io_base = __classmetatables[IsoObject.class].__index
lcl.io_getProperties     = lcl.io_base.getProperties
lcl.io_getObjectName     = lcl.io_base.getObjectName


lcl.pc_base = __classmetatables[PropertyContainer.class].__index
lcl.pc_Is     = lcl.pc_base.Is
lcl.pc_Val    = lcl.pc_base.Val

lcl.PZArrayList_base        = __classmetatables[PZArrayList.class].__index
lcl.PZArrayList_size        = lcl.PZArrayList_base.size
lcl.PZArrayList_get         = lcl.PZArrayList_base.get

function lcl.getCoordLimit(daysSinceStart, endWaterWorldDay, initCoord, endCoord)
    if daysSinceStart >= endWaterWorldDay then
        return endCoord
    else
        return initCoord + (endCoord-initCoord) * daysSinceStart / endWaterWorldDay
    end
end

function WaterWorld.onLoadGridsquare(square)
    --decide if must be flooded. try hard to reduce time spent here because it is called A LOT.
    local mustBeWaterWorlded = false
    local daysSinceStart = lcl.gameTime:getWorldAgeHours() / 24.0
    local sbv = SandboxVars.WaterWorld
    if square
  and ((sbv.FromSouth and lcl.igs_getY(square) >= lcl.getCoordLimit(daysSinceStart, sbv.DaysFromSouth, sbv.MapSouthestPoint, sbv.SouthWaterLimit)) or
       (sbv.FromWest  and lcl.igs_getX(square) <= lcl.getCoordLimit(daysSinceStart, sbv.DaysFromWest , sbv.MapWestestPoint , sbv.WestWaterLimit )) or
       (sbv.FromNorth and lcl.igs_getY(square) <= lcl.getCoordLimit(daysSinceStart, sbv.DaysFromNorth, sbv.MapNorthestPoint, sbv.NorthWaterLimit)) or
       (sbv.FromEast  and lcl.igs_getX(square) >= lcl.getCoordLimit(daysSinceStart, sbv.DaysFromEast , sbv.MapEastestPoint , sbv.EastWaterLimit )))
      and lcl.igs_getZ(square) == 0 
      and (sbv.InsideBuilding or lcl.igs_isOutside(square)) then--TODO moving limit, applying inside?
        local previousFloor = lcl.igs_getFloor(square)
        if previousFloor then
            local prevFloorProps = lcl.io_getProperties(previousFloor)
            if prevFloorProps and not lcl.pc_Is(prevFloorProps,IsoFlagType.water) then
                mustBeWaterWorlded = lcl.pc_Is(prevFloorProps,IsoFlagType.diamondFloor)--do not override player built floor (those are not diamondFloor.. but I have not tested everything so it could break things up. if you know better contact me)
            end
        end
    end

    if mustBeWaterWorlded then--if it must be do it, but please fast !
        if WaterWorld.Verbose then print('Square ',square:getX(),' ',square:getY(),' ',square:getZ(),' ',square:getPlayerBuiltFloor(),' ',daysSinceStart) end

        local newObj = lcl.igs_addFloor(square,"blends_natural_02_0");--replace square with water
        
        if WaterWorld.RemoveErosion then--disable erosion
            lcl.igs_disableErosion(square)
            local args = { x = lcl.igs_getX(square), y = lcl.igs_getY(square), z = lcl.igs_getZ(square) }
            sendClientCommand('erosion', 'disableForSquare', args)
        end
        
        if WaterWorld.RemoveOtherTiles then--remove tiles that should disappear with the flow
            -- maybe just store coordinate to remove stuff one square per cycle later.
            local objects = lcl.igs_getObjects(square)
            if objects then
                for i=0,lcl.PZArrayList_size(objects)-1 do
                    local isoObject = lcl.PZArrayList_get(objects,i)
                    if isoObject then
                        local props = lcl.io_getProperties(isoObject)
                        if (lcl.pc_Is(props,IsoFlagType.solidfloor) and not lcl.pc_Is(props,IsoFlagType.water)) --remove non water floors
                          or lcl.io_getObjectName(isoObject) == 'Grass' or lcl.pc_Val(props,'CustomName') == 'Trash' then--cut grass / clean trash
                            if WaterWorld.Verbose then print('Remove Object ',i,' ',isoObject:getObjectName(),' ',isoObject:getTextureName(),' Water=',props:Is(IsoFlagType.water),' Floor=',props:Is(IsoFlagType.solidfloor),' Trans=',props:Is(IsoFlagType.solidtrans)) end
                            lcl.igs_RemoveTileObject(square,isoObject)
                            i = i - 1
                        else
                            if WaterWorld.Verbose then print('Keep Object ',i,' ',isoObject:getObjectName(),' ',isoObject:getTextureName(),' Water=',props:Is(IsoFlagType.water),' Floor=',props:Is(IsoFlagType.solidfloor),' Trans=',props:Is(IsoFlagType.solidtrans)) end
                        end
                    end
                end
            end
        end
    end
end

if not isClient() then
    Events.LoadGridsquare.Add(WaterWorld.onLoadGridsquare)
end

Events.OnGameTimeLoaded.Add(function()
    lcl.gameTime = getGameTime()
end)
