
WaterWorld = WaterWorld or {}

local lcl = {}
lcl.igs_base = __classmetatables[IsoGridSquare.class].__index
lcl.igs_getX             = lcl.igs_base.getX
lcl.igs_getY             = lcl.igs_base.getY
lcl.igs_getZ             = lcl.igs_base.getZ
lcl.igs_getFloor         = lcl.igs_base.getFloor
lcl.igs_addFloor         = lcl.igs_base.addFloor
lcl.igs_disableErosion   = lcl.igs_base.disableErosion
lcl.igs_RemoveTileObject = lcl.igs_base.RemoveTileObject
lcl.igs_isOutside        = lcl.igs_base.isOutside
lcl.igs_getObjects        = lcl.igs_base.getObjects

lcl.io_base = __classmetatables[IsoObject.class].__index
lcl.io_getProperties     = lcl.io_base.getProperties
lcl.io_getObjectName     = lcl.io_base.getObjectName


lcl.pc_base = __classmetatables[PropertyContainer.class].__index
lcl.pc_Is     = lcl.pc_base.Is
lcl.pc_Val    = lcl.pc_base.Val

lcl.PZArrayList_base        = __classmetatables[PZArrayList.class].__index
lcl.PZArrayList_size        = lcl.PZArrayList_base.size
lcl.PZArrayList_get         = lcl.PZArrayList_base.get

lcl.lastSouth = nil
lcl.lastWest  = nil
lcl.lastNorth = nil
lcl.lastEast  = nil

function lcl.getCoordLimit(daysSinceStart, endWaterWorldDay, initCoord, endCoord)
    if daysSinceStart >= endWaterWorldDay then
        return endCoord
    else
        return initCoord + (endCoord-initCoord) * daysSinceStart / endWaterWorldDay
    end
end

--currently only valid for solo ?
function WaterWorld.floodSquare(square)
    local mustBeWaterWorlded = false
    local sbv = SandboxVars.WaterWorld
    if square
      and lcl.igs_getZ(square) == 0 
      and (sbv.InsideBuilding or lcl.igs_isOutside(square)) then--TODO moving limit, applying inside?
        local previousFloor = lcl.igs_getFloor(square)
        if previousFloor then
            local prevFloorProps = lcl.io_getProperties(previousFloor)
            if prevFloorProps and not lcl.pc_Is(prevFloorProps,IsoFlagType.water) then
                mustBeWaterWorlded = lcl.pc_Is(prevFloorProps,IsoFlagType.diamondFloor)--do not override player built floor (those are not diamondFloor.. but I have not tested everything so it could break things up. if you know better contact me)
            end
        end
    end
    if mustBeWaterWorlded then
        if WaterWorld.Verbose then print('Square ',square:getX(),' ',square:getY(),' ',square:getZ(),' ',square:getPlayerBuiltFloor(),' ',daysSinceStart) end
        local newObj = lcl.igs_addFloor(square,"blends_natural_02_0");--replace square with water
        
        if WaterWorld.RemoveErosion then--disable erosion
            lcl.igs_disableErosion(square)
            local args = { x = lcl.igs_getX(square), y = lcl.igs_getY(square), z = lcl.igs_getZ(square) }
            sendClientCommand('erosion', 'disableForSquare', args)
        end
        
        if WaterWorld.RemoveOtherTiles then--remove tiles that should disappear with the flow
            -- maybe just store coordinate to remove stuff one square per cycle later.
            local objects = lcl.igs_getObjects(square)
            if objects then
                for i=0,lcl.PZArrayList_size(objects)-1 do
                    local isoObject = lcl.PZArrayList_get(objects,i)
                    if isoObject then
                        local props = lcl.io_getProperties(isoObject)
                        if (lcl.pc_Is(props,IsoFlagType.solidfloor) and not lcl.pc_Is(props,IsoFlagType.water)) --remove non water floors
                          or lcl.io_getObjectName(isoObject) == 'Grass' or lcl.pc_Val(props,'CustomName') == 'Trash' then--cut grass / clean trash
                            if WaterWorld.Verbose then print('Remove Object ',i,' ',isoObject:getObjectName(),' ',isoObject:getTextureName(),' Water=',props:Is(IsoFlagType.water),' Floor=',props:Is(IsoFlagType.solidfloor),' Trans=',props:Is(IsoFlagType.solidtrans)) end
                            lcl.igs_RemoveTileObject(square,isoObject)
                            i = i - 1
                        else
                            if WaterWorld.Verbose then print('Keep Object ',i,' ',isoObject:getObjectName(),' ',isoObject:getTextureName(),' Water=',props:Is(IsoFlagType.water),' Floor=',props:Is(IsoFlagType.solidfloor),' Trans=',props:Is(IsoFlagType.solidtrans)) end
                        end
                    end
                end
            end
        end
    end
end

function lcl.floodSouth(x,y,z)
    local sq = getCell():getGridSquare(x,y,z)
    if sq then
        WaterWorld.floodSquare(sq)
        lcl.floodSouth(x,y+1,z)
    end
end
function lcl.floodWest(x,y,z)
    local sq = getCell():getGridSquare(x,y,z)
    if sq then
        WaterWorld.floodSquare(sq)
        lcl.floodWest(x-1,y,z)
    end
end
function lcl.floodNorth(x,y,z)
    local sq = getCell():getGridSquare(x,y,z)
    if sq then
        WaterWorld.floodSquare(sq)
        lcl.floodNorth(x,y-1,z)
    end
end
function lcl.floodEast(x,y,z)
    local sq = getCell():getGridSquare(x,y,z)
    if sq then
        WaterWorld.floodSquare(sq)
        lcl.floodEast(x+1,y,z)
    end
end

function WaterWorld.OnPlayerUpdate(isoPlayer)
    if not isoPlayer then return end--some reuse from elsewhere with missing parameter
    local currentSquare = isoPlayer:getSquare()
    if not currentSquare then return end--during a teleport
    
    local sbv = SandboxVars.WaterWorld
    local cell = getCell()
    local px = lcl.igs_getX(currentSquare)
    local py = lcl.igs_getY(currentSquare)
    local daysSinceStart = lcl.gameTime:getWorldAgeHours() / 24.0
    
    
    if sbv.FromSouth then
        local southEdge = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromSouth, sbv.MapSouthestPoint, sbv.SouthWaterLimit)
        if southEdge ~= lcl.lastSouth then
            lcl.lastSouth = southEdge
            lcl.floodEast(px+1,southEdge,0)
            lcl.floodWest(px,southEdge,0)
        end
    end
    if sbv.FromWest then
        local westEdge = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromWest , sbv.MapWestestPoint , sbv.WestWaterLimit)
        if westEdge ~= lcl.lastWest then
            lcl.lastWest = westEdge
            lcl.floodSouth(westEdge,py+1,0)
            lcl.floodNorth(westEdge,py,0)
        end
    end
    if sbv.FromNorth then
        local northEdge = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromNorth, sbv.MapNorthestPoint, sbv.NorthWaterLimit)
        if northEdge ~= lcl.lastNorth then
            lcl.lastNorth = northEdge
            lcl.floodEast(px+1,northEdge,0)
            lcl.floodWest(px,northEdge,0)
        end
    end
    if sbv.FromEast then
        local eastEdge = lcl.getCoordLimit(daysSinceStart, sbv.DaysFromEast , sbv.MapEastestPoint , sbv.EastWaterLimit)
        if eastEdge ~= lcl.lastEast then
            lcl.lastEast = eastEdge
            lcl.floodSouth(eastEdge,py+1,0)
            lcl.floodNorth(eastEdge,py,0)
        end
    end
end

Events.OnPlayerUpdate.Add(WaterWorld.OnPlayerUpdate)
Events.OnGameTimeLoaded.Add(function() lcl.gameTime = getGameTime() end)
