require "DAMN_Parts";
require "DAMN_Spawns";

--***********************************************************
--**                   KI5 / bikinihorst                   **
--***********************************************************

DAMN.Parts:processConfigV2("CVPI92", {
	["BumperFrontR"] = {
		partId = "CVPI92BumperFront",
		itemToModel = {
			["Base.92fordCVPIBumperFront0"] = "FrontBumper0",
			["Base.92fordCVPIBumperFront1"] = "FrontBumper1",
			["Base.92fordCVPIBumperFront2"] = "FrontBumper2",
            ["Base.92fordCVPIBumperFront3"] = "FrontBumper3",
		},
		allowedForRandom = {
            "Base.92fordCVPIBumperFront0"
        },
		default = "trve_random",
		noPartChance = 5,
	},
	["BumperFront"] = {
		partId = "CVPI92BumperFront",
		itemToModel = {
			["Base.92fordCVPIBumperFront1"] = "FrontBumper1",
			["Base.92fordCVPIBumperFront0"] = "FrontBumper0",
			["Base.92fordCVPIBumperFront2"] = "FrontBumper2",
            ["Base.92fordCVPIBumperFront3"] = "FrontBumper3",
		},
		default = "random",
	},
	["BumperRear"] = {
		partId = "CVPI92BumperRear",
		itemToModel = {
			["Base.92fordCVPIBumperRear0"] = "BumperRear0",
		},
		default = "first",
	},
	["WindshieldArmor"] = {
		partId = "CVPI92WindshieldArmor",
		itemToModel = {
			["Base.fordCVPIWindshieldArmor"] = "CVPI92winda0",
		},
	},
	["WindshieldRearArmor"] = {
		partId = "CVPI92WindshieldRearArmor",
		itemToModel = {
			["Base.fordCVPIWindshieldRearArmor"] = "CVPI92windra",
		},
	},
	["WindowFrontLeftArmor"] = {
		partId = "CVPI92WindowFrontLeftArmor",
		itemToModel = {
			["Base.fordCVPIFrontWindowArmor"] = "CVPI92leftdoora",
		},
	},
	["WindowFrontRightArmor"] = {
		partId = "CVPI92WindowFrontRightArmor",
		itemToModel = {
			["Base.fordCVPIFrontWindowArmor"] = "CVPI92rightdoora",
		},
	},
	["WindowRearLeftArmor"] = {
		partId = "CVPI92WindowRearLeftArmor",
		itemToModel = {
			["Base.fordCVPIRearWindowArmor"] = "CVPI92leftdoorra",
		},
	},
	["WindowRearRightArmor"] = {
		partId = "CVPI92WindowRearRightArmor",
		itemToModel = {
			["Base.fordCVPIRearWindowArmor"] = "CVPI92rightdoorra",
		},
	},
	["SpareTire"] = {
		partId = "CVPI92SpareTire",
		itemToModel = {
			["Base.fordCVPITire"] = "SpareTire",
		},
		default = "trve_random",
		noPartChance = 33,
	},
});


function CVPI92.ContainerAccess.Gunrack(vehicle, part, chr)
	if chr:getVehicle() == vehicle then
		local seat = vehicle:getSeat(chr)
		return seat == 1 or seat == 0;
	elseif chr:getVehicle() then
		return false
	else
		if not vehicle:isInArea(part:getArea(), chr) then return false end
		local doorPart = vehicle:getPartById("DoorFrontRight")
		if doorPart and doorPart:getDoor() and not doorPart:getDoor():isOpen() then
			return false
		end
		return true
	end
end