require "DAMN_Parts";
require "DAMN_Spawns";

--***********************************************************
--**                   KI5 / bikinihorst                   **
--***********************************************************

DAMN.Parts:processConfigV2("PWR", {
	["FrontBumper"] = {
		partId = "PWRFrontBumper",
		itemToModel = {
			["Base.49powerWagonBumper0"] = "FrontBumper0",
			["Base.49powerWagonBullbar1"] = "FrontBullbar1",
			["Base.49powerWagonBullbar2"] = "FrontBullbar2",
		},
		default = "first",
	},
	["FrontBumperPA"] = {
		partId = "PWRFrontBumper",
		itemToModel = {
			["Base.49powerWagonBullbar2"] = "FrontBullbar2",
			["Base.49powerWagonBumper0"] = "FrontBumper0",
			["Base.49powerWagonBullbar1"] = "FrontBullbar1",
		},
		default = "first",
	},
	["FrontBumperPD"] = {
		partId = "PWRFrontBumper",
		itemToModel = {
			["Base.49powerWagonBullbar1"] = "FrontBullbar1",
			["Base.49powerWagonBullbar2"] = "FrontBullbar2",
			["Base.49powerWagonBumper0"] = "FrontBumper0",
		},
		default = "first",
	},
	["WindshieldArmor"] = {
		partId = "PWRWindshieldArmor",
		itemToModel = {
			["Base.49powerWagonWindshieldArmor"] = "PWRwinda",
		},
	},
	["WindshieldRearArmor"] = {
		partId = "PWRWindshieldRearArmor",
		itemToModel = {
			["Base.49powerWagonWindshieldRearArmor"] = "PWRwindra",
		},
	},
	["FrontLeftArmor"] = {
		partId = "PWRFrontLeftArmor",
		itemToModel = {
			["Base.49powerWagonFrontDoorArmor"] = "PWRfla",
		},
	},
	["FrontRightArmor"] = {
		partId = "PWRFrontRightArmor",
		itemToModel = {
			["Base.49powerWagonFrontDoorArmor"] = "PWRfra",
		},
	},
	["RearLeftArmor"] = {
		partId = "PWRRearLeftArmor",
		itemToModel = {
			["Base.49powerWagonRearDoorArmor"] = "PWRrla",
		},
	},
	["RearRightArmor"] = {
		partId = "PWRRearRightArmor",
		itemToModel = {
			["Base.49powerWagonRearDoorArmor"] = "PWRrra",
		},
	},
	["FenderFrontLeft"] = {
		partId = "FenderFrontLeft",
		itemToModel = {
			["Base.49powerWagonFrontFender"] = "fenderFL",
			["Base.49powerWagonFrontFenderMakeshift"] = "fenderapocFL",
		},
		default = "first",
	},
	["FenderFrontRight"] = {
		partId = "FenderFrontRight",
		itemToModel = {
			["Base.49powerWagonFrontFender"] = "fenderFR",
			["Base.49powerWagonFrontFenderMakeshift"] = "fenderapocFR",
		},
		default = "first",
	},
	["FenderRearLeft"] = {
		partId = "FenderRearLeft",
		itemToModel = {
			["Base.49powerWagonRearFender"] = "fenderRL",
			["Base.49powerWagonRearFenderMakeshift"] = "fenderapocRL",
		},
		default = "first",
	},
	["FenderRearRight"] = {
		partId = "FenderRearRight",
		itemToModel = {
			["Base.49powerWagonRearFender"] = "fenderRR",
			["Base.49powerWagonRearFenderMakeshift"] = "fenderapocRR",
		},
		default = "first",
	},
	["Sideskirts"] = {
		partId = "PWRSideskirts",
		itemToModel = {
			["Base.49powerWagonSideskirts0"] = "skirts0",
			["Base.49powerWagonSideskirts1"] = "skirts1",
		},
		default = "first",
	},
	["SideskirtsPA"] = {
		partId = "PWRSideskirts",
		itemToModel = {
			["Base.49powerWagonSideskirts1"] = "skirts1",
			["Base.49powerWagonSideskirts0"] = "skirts0",
		},
		default = "first",
	},
	["FenderFrontLeftPA"] = {
		partId = "FenderFrontLeft",
		itemToModel = {
			["Base.49powerWagonFrontFenderMakeshift"] = "fenderapocFL",
			["Base.49powerWagonFrontFender"] = "fenderFL",
		},
		default = "first",
	},
	["FenderFrontRightPA"] = {
		partId = "FenderFrontRight",
		itemToModel = {
			["Base.49powerWagonFrontFenderMakeshift"] = "fenderapocFL",
			["Base.49powerWagonFrontFender"] = "fenderFL",
		},
		default = "first",
	},
	["FenderRearLeftPA"] = {
		partId = "FenderRearLeft",
		itemToModel = {
			["Base.49powerWagonRearFenderMakeshift"] = "fenderapocRL",
			["Base.49powerWagonRearFender"] = "fenderRL",
		},
		default = "first",
	},
	["FenderRearRightPA"] = {
		partId = "FenderRearRight",
		itemToModel = {
			["Base.49powerWagonRearFenderMakeshift"] = "fenderapocRL",
			["Base.49powerWagonRearFender"] = "fenderRL",
		},
		default = "first",
	},
	["SpareTire"] = {
		partId = "PWRSpare",
		itemToModel = {
			["Base.49powerWagonTire"] = "PWRspare0",
		},
		default = "trve_random",
		noPartChance = 15,
	},
	["SpareTirePA"] = {
		partId = "PWRSpare",
		itemToModel = {
			["Base.49powerWagonApocalypseTire"] = "PWRspare1",
		},
		default = "trve_random",
		noPartChance = 15,
	},
});

DAMN.Spawns:add("Base.49powerWagonPA", 8283, 12242, {
    direction = IsoDirections.W, 
    chance = 81,
    sandboxVar = "AllowPowerChadSpawns",
});

DAMN.Spawns:add("Base.49powerWagonPA", 8503, 8555, {
    direction = IsoDirections.W, 
    chance = 80,
    sandboxVar = "AllowPowerChadSpawns",
});

DAMN.Spawns:add("Base.49powerWagonPA", 4222, 6308, {
    direction = IsoDirections.N, 
    chance = 84,
    sandboxVar = "AllowPowerChadSpawns",
});

DAMN.Spawns:add("Base.49powerWagonPA", 14172, 5938, {
    direction = IsoDirections.N, 
    chance = 79,
    sandboxVar = "AllowPowerChadSpawns",
});

DAMN.Spawns:add("Base.49powerWagonPA", 11581, 9923, {
    direction = IsoDirections.N, 
    chance = 85,
    sandboxVar = "AllowPowerChadSpawns",
});

function PWR.ContainerAccess.Trunk(vehicle, part, chr)
	if chr:getVehicle() == vehicle then
		local seat = vehicle:getSeat(chr)
		return seat == 4;
	elseif chr:getVehicle() then
		return false
	else
		if not vehicle:isInArea(part:getArea(), chr) then return false end
		local doorPart = vehicle:getPartById("TrunkDoor")
		if doorPart and doorPart:getDoor() and not doorPart:getDoor():isOpen() then
			return false
		end
		return true
	end
end