require "DAMN_Armor_Shared";

--***********************************************************
--**                   KI5 / bikinihorst                   **
--***********************************************************
--v2.0.0

PWR = PWR or {};

function PWR.activeArmor(player, vehicle)
   
    	--

			for partId, armorPartId in pairs({
				["Windshield"] = "DAMNWindshieldArmor",
				["WindshieldRear"] = "DAMNWindshieldRearArmor",
			}) do
				local part = vehicle:getPartById(partId);
				local protection = vehicle:getPartById(armorPartId);
				if protection and protection:getInventoryItem() and part and part:getModData()
				then
					local partCond = tonumber(part:getModData().saveCond);
					if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
						local cond = protection:getCondition() - ZombRand(4);
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
			end

		-- 

			local protection = vehicle:getPartById("DAMNBumperFront")
			local inventoryItem = protection:getInventoryItem();
			local part = vehicle:getPartById("EngineDoor")
				if part and protection and part:getInventoryItem() and inventoryItem and part:getModData()
				then 
					if inventoryItem and inventoryItem:getFullType() ~= "Base.49powerWagonBumper0" then
						local partCond = tonumber(part:getModData().saveCond)
						if protection:getCondition() > 0 and partCond
						then
							if part:getCondition() < partCond
							then
								DAMN.Armor:setPartCondition(part, partCond);
								local cond = protection:getCondition() - (ZombRandBetween(0,100) <= 35 and ZombRandBetween(0,3) or 0);
								DAMN.Armor:setPartCondition(protection, cond);
							end
						end
				elseif inventoryItem and inventoryItem:getFullType() == "Base.49powerWagonBumper0" then
						local partCond = tonumber(part:getModData().saveCond)
						if protection:getCondition() > 0 and partCond
						then
							if part:getCondition() < partCond
							then
								DAMN.Armor:setPartCondition(part, partCond);
								local cond = protection:getCondition() - ZombRandBetween(0,4);
								DAMN.Armor:setPartCondition(protection, cond);
							end
						end
					end
				else
					local protection = vehicle:getPartById("DAMNBumperFront")
					local inventoryItem = protection:getInventoryItem();
					local part = vehicle:getPartById("Engine")
						if protection and inventoryItem and part and part:getModData()
						then
								local partCond = tonumber(part:getModData().saveCond)
								if protection:getCondition() > 0 and partCond
								then
									if part:getCondition() < partCond
									then
										DAMN.Armor:setPartCondition(part, partCond);
										local cond = protection:getCondition() - ZombRandBetween(1,3);
										DAMN.Armor:setPartCondition(protection, cond);
									end
								end
						end
				end

		--

			for partId, armorPartId in pairs({
				["WindowFrontLeft"] = "DAMNFrontLeftArmor",
				["WindowFrontRight"] = "DAMNFrontRightArmor",
				["WindowRearLeft"] = "DAMNRearLeftArmor",
				["WindowRearRight"] = "DAMNRearRightArmor",
			}) do
				local part = vehicle:getPartById(partId);
				local protection = vehicle:getPartById(armorPartId);
				if protection and protection:getInventoryItem() and part and part:getModData()
				then
					local partCond = tonumber(part:getModData().saveCond);
					if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
                        local cond = protection:getCondition() - ZombRandBetween(0,2);
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
			end

		--

			for partId, armorPartId in pairs({
				["HeadlightLeft"] = "DAMNBumperFront",
				["HeadlightRight"] = "DAMNBumperFront",
			}) do
				local part = vehicle:getPartById(partId);
				local protection = vehicle:getPartById(armorPartId);
				local inventoryItem = protection:getInventoryItem();
				if inventoryItem and inventoryItem:getFullType() ~= "Base.49powerWagonBumper0" then
					if protection and protection:getInventoryItem() and part and part:getModData()
					then
						local partCond = tonumber(part:getModData().saveCond);
						if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
						then
							DAMN.Armor:setPartCondition(part, partCond);
						end
					end
				end
			end

		--

		for partId, armorPartId in pairs({
				["TireFrontLeft"] = "FenderFrontLeft",
				["TireFrontRight"] = "FenderFrontRight",
				["TireRearLeft"] = "FenderRearLeft",
				["TireRearRight"] = "FenderRearRight",
			}) do
				local part = vehicle:getPartById(partId);
				local protection = vehicle:getPartById(armorPartId);
				if protection and protection:getInventoryItem() and part and part:getModData()
				then
					local partCond = tonumber(part:getModData().saveCond);
					if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
						local cond = protection:getCondition() - 1;
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
			end

		--

		for i, freezeState in ipairs ({"DAMNSpareTire"})
				do
					if vehicle:getPartById(freezeState) then
						local part = vehicle:getPartById(freezeState)
						local freezeCond = tonumber(part:getModData().saveCond)
					    	if freezeCond and part:getCondition() < freezeCond then
					    		DAMN.Armor:setPartCondition(part, freezeCond);
							end
					end
			end


		--

			for i, nodisplay in ipairs ({"TruckBed", "FakeDoor", "FakeWindow"})
				do
					if vehicle:getPartById(nodisplay) then
						local part = vehicle:getPartById(nodisplay)
						local nodisplay = 100;
					    	if part:getCondition() < nodisplay then
					    		DAMN.Armor:setPartCondition(part, nodisplay);
							end
					end
			end

		--

end

DAMN.Armor:add("Base.49powerWagon", PWR.activeArmor);
DAMN.Armor:add("Base.49powerWagonMP", PWR.activeArmor);
DAMN.Armor:add("Base.49powerWagonPA", PWR.activeArmor);
DAMN.Armor:add("Base.49powerWagonPD", PWR.activeArmor);