require "DAMN_Parts";
require "DAMN_Spawns";

--***********************************************************
--**                   KI5 / bikinihorst                   **
--***********************************************************

DAMN.Parts:processConfigV2("BR89", {
	["FrontBumper"] = {
		partId = "BR89FrontBumper",
		itemToModel = {
			["Base.89BroncoBumperFront"] = "FrontBumper",
			["Base.80sPickupBullbarFront"] = "FrontBullbar1",
			["Base.89BroncoBullbarFront"] = "FrontBullbar2",
		},
		default = "first",
	},
	["RearBumper"] = {
		partId = "BR89RearBumper",
		itemToModel = {
			["Base.89BroncoBumperRear"] = "RearBumper",
			["Base.80sPickupBullbarRear"] = "RearBullbar",
		},
		default = "first",
	},
	["WindowFrontLeftArmor"] = {
		partId = "BR89WindowFrontLeftArmor",
		itemToModel = {
			["Base.80sPickupWindowFrontArmor"] = "BR89leftwina",
		},
	},
	["WindowFrontRightArmor"] = {
		partId = "BR89WindowFrontRightArmor",
		itemToModel = {
			["Base.80sPickupWindowFrontArmor"] = "BR89rightwina",
		},
	},
	["WindowRearLeftArmor"] = {
		partId = "BR89WindowRearLeftArmor",
		itemToModel = {
			["Base.80sPickupWindowRearArmor"] = "BR89leftrearwina",
		},
	},
	["WindowRearRightArmor"] = {
		partId = "BR89WindowRearRightArmor",
		itemToModel = {
			["Base.80sPickupWindowRearArmor"] = "BR89rightrearwina",
		},
	},
	["WindshieldArmor"] = {
		partId = "BR89WindshieldArmor",
		itemToModel = {
			["Base.80sPickupWindshieldArmor"] = "BR89winda",
		},
	},
	["SpareTire"] = {
		partId = "BR89SpareTireRoof",
		itemToModel = {
			["Base.80sOffroadTireA"] = "BR89Tire0",
            ["Base.76chevyKseriesTire2"] = "BR89Tire1",
            ["Base.80chevyCKseriesTire2"] = "BR89Tire2",
            ["Base.80chevyCKseriesTire1"] = "BR89Tire3",
            ["Base.90chevyCKseriesTire2"] = "BR89Tire4",
            ["Base.90chevyCKseriesTire1"] = "BR89Tire5",
		},
	},
    ["TireFrontLeft"] = {
		partId = "TireFrontLeft",
		itemToModel = {
			["Base.80sOffroadTireA"] = "BR89Tire0",
            ["Base.76chevyKseriesTire2"] = "BR89Tire1",
            ["Base.80chevyCKseriesTire2"] = "BR89Tire2",
            ["Base.80chevyCKseriesTire1"] = "BR89Tire3",
            ["Base.90chevyCKseriesTire2"] = "BR89Tire4",
            ["Base.90chevyCKseriesTire1"] = "BR89Tire5",
		},
	},
	["TireFrontRight"] = {
		partId = "TireFrontRight",
		itemToModel = {
			["Base.80sOffroadTireA"] = "BR89Tire0",
            ["Base.76chevyKseriesTire2"] = "BR89Tire1",
            ["Base.80chevyCKseriesTire2"] = "BR89Tire2",
            ["Base.80chevyCKseriesTire1"] = "BR89Tire3",
            ["Base.90chevyCKseriesTire2"] = "BR89Tire4",
            ["Base.90chevyCKseriesTire1"] = "BR89Tire5",
		},
	},
	["TireRearLeft"] = {
		partId = "TireRearLeft",
		itemToModel = {
			["Base.80sOffroadTireA"] = "BR89Tire0",
            ["Base.76chevyKseriesTire2"] = "BR89Tire1",
            ["Base.80chevyCKseriesTire2"] = "BR89Tire2",
            ["Base.80chevyCKseriesTire1"] = "BR89Tire3",
            ["Base.90chevyCKseriesTire2"] = "BR89Tire4",
            ["Base.90chevyCKseriesTire1"] = "BR89Tire5",
		},
	},
	["TireRearRight"] = {
		partId = "TireRearRight",
		itemToModel = {
			["Base.80sOffroadTireA"] = "BR89Tire0",
            ["Base.76chevyKseriesTire2"] = "BR89Tire1",
            ["Base.80chevyCKseriesTire2"] = "BR89Tire2",
            ["Base.80chevyCKseriesTire1"] = "BR89Tire3",
            ["Base.90chevyCKseriesTire2"] = "BR89Tire4",
            ["Base.90chevyCKseriesTire1"] = "BR89Tire5",
		},
	},
});

function BR89.ContainerAccess.Trunk(vehicle, part, chr)
	if chr:getVehicle() == vehicle then
		local seat = vehicle:getSeat(chr)
		return seat == 3 or seat == 2 or seat == 1 or seat == 0;
	elseif chr:getVehicle() then
		return false
	else
		if not vehicle:isInArea(part:getArea(), chr) then return false end
		local doorPart = vehicle:getPartById("TrunkDoor")
		if doorPart and doorPart:getDoor() and not doorPart:getDoor():isOpen() then
			return false
		end
		return true
	end
end

function BR89.ContainerAccess.Roofrack(vehicle, part, chr)
	if chr:getVehicle() then return false end
	if not vehicle:isInArea(part:getArea(), chr) then return false end
	return true
end