require "DAMN_Armor_Shared";

--***********************************************************
--**                   KI5 / bikinihorst                   **
--***********************************************************
--v2.0.0

BR89 = BR89 or {};

function BR89.activeArmor(player, vehicle)
   
	--

	for partId, armorPartId in pairs({
		["Windshield"] = "BR89WindshieldArmor",
		["WindshieldRear"] = "BR89Rollbar",
		}) do
		local part = vehicle:getPartById(partId);
		local protection = vehicle:getPartById(armorPartId);
		if protection and protection:getInventoryItem() and part and part:getModData()
		then
			local partCond = tonumber(part:getModData().saveCond);
			if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
			then
				DAMN.Armor:setPartCondition(part, partCond);
				local cond = protection:getCondition() - ZombRand(4);
				DAMN.Armor:setPartCondition(protection, cond);
			end
		end
	end

-- 

	local protection = vehicle:getPartById("BR89FrontBumper")
	local inventoryItem = protection:getInventoryItem();
	local part = vehicle:getPartById("EngineDoor")
		if part and protection and part:getInventoryItem() and inventoryItem and part:getModData()
		then 
			if inventoryItem:getFullType() ~= "Base.89BroncoBumperFront" then
				local partCond = tonumber(part:getModData().saveCond)
				if protection:getCondition() > 0 and partCond
				then
					if part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
						local cond = protection:getCondition() - (ZombRandBetween(0,100) <= 35 and ZombRandBetween(0,3) or 0);
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
		elseif inventoryItem:getFullType() == "Base.89BroncoBumperFront" then
				local partCond = tonumber(part:getModData().saveCond)
				if protection:getCondition() > 0 and partCond
				then
					if part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
						local cond = protection:getCondition() - ZombRandBetween(0,15);
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
			end
		else
			local protection = vehicle:getPartById("BR89FrontBumper")
			local inventoryItem = protection:getInventoryItem();
			local part = vehicle:getPartById("Engine")
				if protection and inventoryItem and part and part:getModData()
				then
					if inventoryItem:getFullType() ~= "Base.89BroncoBumperFront" then
						local partCond = tonumber(part:getModData().saveCond)
						if protection:getCondition() > 0 and partCond
						then
							if part:getCondition() < partCond
							then
								DAMN.Armor:setPartCondition(part, partCond);
								local cond = protection:getCondition() - ZombRandBetween(1,3);
								DAMN.Armor:setPartCondition(protection, cond);
							end
						end
					end
				end
		end

-- 

	local protection = vehicle:getPartById("BR89RearBumper")
	local inventoryItem = protection:getInventoryItem();
	local part = vehicle:getPartById("TrunkDoor")
		if part and protection and part:getInventoryItem() and inventoryItem and part:getModData()
		then 
			if inventoryItem:getFullType() ~= "Base.89BroncoBumperRear" then
				local partCond = tonumber(part:getModData().saveCond)
				if protection:getCondition() > 0 and partCond
				then
					if part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
						local cond = protection:getCondition() - (ZombRandBetween(0,100) <= 45 and ZombRandBetween(0,3) or 0);
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
		elseif inventoryItem:getFullType() == "Base.89BroncoBumperRear" then
				local partCond = tonumber(part:getModData().saveCond)
				if protection:getCondition() > 0 and partCond
				then
					if part:getCondition() < partCond
					then
						DAMN.Armor:setPartCondition(part, partCond);
						local cond = protection:getCondition() - ZombRandBetween(0,15);
						DAMN.Armor:setPartCondition(protection, cond);
					end
				end
			end
		end

--

	for partId, armorPartId in pairs({
		["WindowFrontLeft"] = "BR89WindowFrontLeftArmor",
		["WindowFrontRight"] = "BR89WindowFrontRightArmor",
		["WindowRearLeft"] = "BR89WindowRearLeftArmor",
		["WindowRearRight"] = "BR89WindowRearRightArmor",
	}) do
		local part = vehicle:getPartById(partId);
		local protection = vehicle:getPartById(armorPartId);
		if protection and protection:getInventoryItem() and part and part:getModData()
		then
			local partCond = tonumber(part:getModData().saveCond);
			if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
			then
				DAMN.Armor:setPartCondition(part, partCond);
                local cond = protection:getCondition() - ZombRandBetween(0,2);
				DAMN.Armor:setPartCondition(protection, cond);
			end
		end
	end

--

	for partId, armorPartId in pairs({
		["HeadlightLeft"] = "BR89FrontBumper",
		["HeadlightRight"] = "BR89FrontBumper",
		["HeadlightRearLeft"] = "BR89RearBumper",
		["HeadlightRearRight"] = "BR89RearBumper",
	}) do
		local part = vehicle:getPartById(partId);
		local protection = vehicle:getPartById(armorPartId);
		if protection and protection:getInventoryItem() and part and part:getModData()
		then
			local partCond = tonumber(part:getModData().saveCond);
			if protection:getCondition() > 0 and partCond and part:getCondition() < partCond
			then
				DAMN.Armor:setPartCondition(part, partCond);
			end
		end
	end

--

for i, freezeState in ipairs ({"BR89SpareTireRear", "BR89SpareTireRoof", "BR89BedCover", "BR89Roofrack"})
		do
			if vehicle:getPartById(freezeState) then
				local part = vehicle:getPartById(freezeState)
				local freezeCond = tonumber(part:getModData().saveCond)
					if freezeCond and part:getCondition() < freezeCond then
						DAMN.Armor:setPartCondition(part, freezeCond);
					end
			end
	end

--

	for i, nodisplay in ipairs ({"TruckBed"})
		do
			if vehicle:getPartById(nodisplay) then
				local part = vehicle:getPartById(nodisplay)
				local nodisplay = 100;
					if part:getCondition() < nodisplay then
						DAMN.Armor:setPartCondition(part, nodisplay);
					end
			end
	end

--

end

DAMN.Armor:add("Base.89fordBronco", BR89.activeArmor);
DAMN.Armor:add("Base.89fordBroncoPD", BR89.activeArmor);
DAMN.Armor:add("Base.89fordBroncoRanger", BR89.activeArmor);