require 'Items/ProceduralDistributions'
require 'Items/Distributions'

--- Tags: PompsItems. & PompsItems_MyLittlePony.
--- Thanks to ZippySqrl for fixin' this distribution file!
---------------------- LITERATURE & MISC ----------------------

print("-----------PonyMLPItemDistribution----------")
local ponyPlushPattern = {
	{ location = "SewingKit", 			distribution = SuburbsDistributions, 				weight = 0.42 },
	{ location = "CrateRandomJunk", 	distribution = ProceduralDistributions["list"], 	weight = 0.26 },
	{ location = "CrateTailoring", 		distribution = ProceduralDistributions["list"],  	weight = 0.5 },
	{ location = "SewingStoreTools", 	distribution = ProceduralDistributions["list"], 	weight = 0.46 }
}

local ponyMagazines = {
	-- Note: These use SandboxVars for dynamic spawn rates
	{ location = "BookstoreMisc", 										weight = 1.5 },
	{ location = "CrateMagazines", 										weight = 2.0 },
	{ location = "LibraryBooks", 										weight = 2.6 },
	{ location = "LivingRoomShelf", 									weight = 0.35 },
	{ location = "LivingRoomShelfNoTapes", 								weight = 0.35 },
	{ location = "LivingRoomSideTable", 								weight = 0.28 },
	{ location = "LivingRoomSideTableNoRemote", 						weight = 0.24 },
	{ location = "MagazineRackMixed", 									weight = 1.2 },
	{ location = "PostOfficeMagazines", 								weight = 2.6 },
	{ location = "ShelfGeneric", 										weight = 0.16 },
	{ location = "CafeShelfBooks", 										weight = 0.3 },
	{ location = "ComicStoreMagazines", 								weight = 2.8 },
	{ location = "ComicStoreCounter", 									weight = 1.5 },
	{ location = "ComicStoreShelfComics", 								weight = 1.0 },
	{ location = "RecRoomShelf", 										weight = 0.2 },
	{ location = "SafehouseBookShelf", 									weight = 0.2 },
	{ location = "DresserGeneric", 										weight = 0.15 },
	{ location = "postbox", distribution = SuburbsDistributions["all"], weight = 0.25 }
}

-- List of all pony magazine types
local magazineTypes = {
	"PIOCMagazine",
	"PICanonMagazine",
	"PICanonUniquesMagazine",
	"PISonaOutfitsMagazine",
	"PICanonOutfitsMagazine",
	"PISnowpityMagazine"
}

local falloutEquestria = {
	{ location = "PlankStashMagazine", 		weight = 0.1 },
	{ location = "PlankStashMisc", 			weight = 0.05 },
	{ location = "PlankStashMoney", 		weight = 0.05 },
	{ location = "Antiques", 				weight = 0.02 },
	{ location = "LivingRoomShelfNoTapes", 	weight = 0.03 },
	{ location = "LivingRoomShelf", 		weight = 0.01 },
	{ location = "LockerArmyBedroom", 		weight = 0.02 }
}

local function insertPonyItems(distributionTable, itemPrefix)
	for _, data in ipairs(distributionTable) do
		-- Check if the 'distribution' field exists
		if data.distribution then
			if data.distribution[data.location] then
				local list = data.distribution[data.location].items
				table.insert(list, "PompsItems." .. itemPrefix)
				table.insert(list, data.weight * SandboxVars.PompsItems.LiteratureSpawnRate)
			else
				print("Warning: No items list found for location " .. data.location)
			end
		else
			if ProceduralDistributions["list"][data.location] then
				local list = ProceduralDistributions["list"][data.location].items
				table.insert(list, "PompsItems." .. itemPrefix)
				table.insert(list, data.weight * SandboxVars.PompsItems.LiteratureSpawnRate)
			else
				print("Warning: No items list found for location " .. data.location)
			end
		end
	end
end

-- Insert Pony Plush Pattern
insertPonyItems(ponyPlushPattern, "PIPonyPattern")

-- Insert Pony Magazines for each type
for _, magazineType in ipairs(magazineTypes) do
	for _, data in ipairs(ponyMagazines) do
		if data.distribution then
			if data.distribution[data.location] then
				local list = data.distribution[data.location].items
				table.insert(list, "PompsItems." .. magazineType)
				table.insert(list, data.weight * SandboxVars.PompsItems.LiteratureSpawnRate)
			else
				print("Warning: No items list found for location " .. data.location)
			end
		else
			--if the table lacked a distribution list, then default to this one
			if ProceduralDistributions["list"][data.location] then
				local list = ProceduralDistributions["list"][data.location].items
				table.insert(list, "PompsItems." .. magazineType)
				table.insert(list, data.weight * SandboxVars.PompsItems.LiteratureSpawnRate)
			else
				print("Warning: No items list found for location " .. data.location)
			end
		end
	end
end

-- Insert Fallout Equestria items
insertPonyItems(falloutEquestria, "PIBlackBookFOE")

