local PonyList = require("PI_PonyList")

-- local chanceOfSpawn = 1 -- testing 0.05 normal
local chanceOfSpawn = 0.05

--- Objects 
local function getRandomScene()
    local randomItems = ArrayList.new()
    randomItems:add({type = "Base.EmptyJar", x=-0.2, y=0.2})
	randomItems:add({type = "Base.JarLid", x=-0.4, y=0.3})
    randomItems:add({type = "Base.Tissue", x=-0.5, y=0.4})
    return randomItems
end

--- Spawns the Pony
local function spawnRandomPonyOnSquare(square, offsetX, offsetY, height, rotation)
    if not instanceof(square, "IsoGridSquare") then return; end
    if not offsetX then offsetX = 0 end
    if not offsetY then offsetY = 0 end
    if not height then height = 0 end
    if not rotation then rotation = 0 end
    local rand = ZombRand(PonyList:size())
    local item = square:AddWorldInventoryItem("Base." .. PonyList:get(rand), offsetX + 0.00001, offsetY + 0.00001, height)
    if rotation ~= 0 then item:setWorldZRotation(rotation) end
    return item
end

--- Spawns the Scene Objects
local function spawnRandomItemsOnSquare(square, offsetX, offsetY, height)
    local randomItems = getRandomScene()
    if not instanceof(square, "IsoGridSquare") then return; end
    if not offsetX then offsetX = 0 end
    if not offsetY then offsetY = 0 end
    if not height then height = 0 end
    for i=0, randomItems:size()-1 do
        local item = randomItems:get(i)
        square:AddWorldInventoryItem(item.type, item.x + offsetX + 0.00001, item.y + offsetY + 0.00001, height)
    end
end

local function isSquareBed(square)
    if not instanceof(square, "IsoGridSquare") then return; end
    local squareProps = square:getProperties()
    return squareProps:has(IsoFlagType.bed)
end

local function isObjectGoodBed(object)
    if not instanceof(object, "IsoObject") then return; end
    local objectProps = object:getProperties()
    local bedType = objectProps:get("BedType")
    return bedType == "goodBed"
end

local function shouldSpawn()
    local chance = ZombRandFloat(0, 1)
    -- print("Chance of scene spawn ", chance .. "/" .. chanceOfSpawn)
    return chance <= chanceOfSpawn 
end

local function distributePoniesOnBeds(room)
    if not room then return; end

    local bedSquares = ArrayList.new()

    local squares = room:getSquares();
    for s=0, squares:size()-1 do
        local square = squares:get(s);
        if isSquareBed(square) then
            local objects = square:getObjects();
            for o=0, objects:size()-1 do
                local object = objects:get(o);
                if isObjectGoodBed(object) then
                    bedSquares:add({square=square, object=object})
                end
            end
        end
    end

    -- Got a double bed
    if bedSquares and bedSquares:size() == 4 then
        local targetSquare = nil
        for b=0, bedSquares:size()-1 do
            local bed = bedSquares:get(b)
            if bed and shouldSpawn() then
                local sprite = bed.object:getSprite()
                local spriteGrid = sprite:getSpriteGrid()
                if spriteGrid and spriteGrid:getSpriteGridPosX(sprite) == 1 and spriteGrid:getSpriteGridPosY(sprite) == 1 then
                    spawnRandomPonyOnSquare(bed.square, 0, 0, 0.33, 322)
                    spawnRandomItemsOnSquare(bed.square, 0, 0, 0.33)
                    print("Pony Jar event spawned. Please save her from her fate.")
                end
            end
        end
    end
end
Events.OnInitGlobalModData.Add(function()
    if (SandboxVars.PompsItems.PonyJars) then
        Events.OnSeeNewRoom.Add(distributePoniesOnBeds)
    end
end)