---Returns a numerically indexed table that is the combination of the two input tables.
---@param a table
---@param b table
---@return table
local function MergeTables(a, b)
    if not a then return b elseif not b then return a end
    local result = {}
    for _,v in pairs(a) do
        table.insert(result, v)
    end
    for _,v in pairs(b) do
        table.insert(result, v)
    end
    return result
end

local Ponies = {}

Ponies.mane6Ponies = {'PompsItems_MyLittlePony.FluttershyPlushie', 'PompsItems_MyLittlePony.RarityPlushie', 'PompsItems_MyLittlePony.ApplejackPlushieHat', 'PompsItems_MyLittlePony.RainbowDashPlushie',
'PompsItems_MyLittlePony.TwilightSparklePlushie', 'PompsItems_MyLittlePony.PinkiePiePlushie'}

Ponies.gen4Ponies = {'PompsItems_MyLittlePony.CelestiaPlushie', 'PompsItems_MyLittlePony.LunaPlushie', 'PompsItems_MyLittlePony.CadancePlushie',
'PompsItems_MyLittlePony.ChrysalisPlushie', 'PompsItems_MyLittlePony.NightmareMoonPlushie', 'PompsItems_MyLittlePony.PIDiscordPlushie', 'PompsItems_MyLittlePony.KingSombraPlushie', 'PompsItems_MyLittlePony.ScootalooPlushie', 'PompsItems_MyLittlePony.SweetiePlushie', 'PompsItems_MyLittlePony.ApplebloomPlushie',
'PompsItems_MyLittlePony.PIBabsSeedPlushie', 'PompsItems_MyLittlePony.PIDaybreakerPlushie', 'PompsItems_MyLittlePony.PITempestShadowPlushie',
'PompsItems_MyLittlePony.PompsItems_MyLittlePony.ShiningArmorPlushie', 'PompsItems_MyLittlePony.SpitfirePlushie', 'PompsItems_MyLittlePony.CheerileePlushie', 'PompsItems_MyLittlePony.BigMacPlushie',
'PompsItems_MyLittlePony.SongbirdPlushie', 'PompsItems_MyLittlePony.ZecoraPlushie', 'PompsItems_MyLittlePony.TrixiePlushie', 'PompsItems_MyLittlePony.GrannySmithPlushie', 'PompsItems_MyLittlePony.BraeburnPlushieComplete',
'PompsItems_MyLittlePony.StarlightGlimmerPlushie', 'PompsItems_MyLittlePony.SunsetShimmerPlushie', 'PompsItems_MyLittlePony.SpikePlushie', 'PompsItems_MyLittlePony.AutumnBlazePlushie', 'PompsItems_MyLittlePony.MoondancerPlushie',
'PompsItems_MyLittlePony.PIKerfuffleCompletePlushie', 'PompsItems_MyLittlePony.PISunburstPlushieComplete', 'PompsItems_MyLittlePony.PIMaudPiePlushie', 'PompsItems_MyLittlePony.PICheeseSandwichPlushie',
'PompsItems_MyLittlePony.DerpyHoovesPlushie', 'PompsItems_MyLittlePony.OctaviaPlushie', 'PompsItems_MyLittlePony.VinylScratchPlushie', 'PompsItems_MyLittlePony.HoovesPlushie', 'PompsItems_MyLittlePony.LyraPlushie',
'PompsItems_MyLittlePony.BonbonPlushie', 'PompsItems_MyLittlePony.SoarinPlushie', 'PompsItems_MyLittlePony.PompsItems_MyLittlePony.CaramelApplePlushie', 'PompsItems_MyLittlePony.WoonaPlushie', 'PompsItems_MyLittlePony.CocoPommelPlushie',
'PompsItems_MyLittlePony.NurseRedheartPlushie', 'PompsItems_MyLittlePony.LotusBlossomPlushie', 'PompsItems_MyLittlePony.AloePlushie', 'PompsItems_MyLittlePony.MinuettePlushie', 'PompsItems_MyLittlePony.LightningDustPlushie',
'PompsItems_MyLittlePony.ThunderlanePlushie', 'PompsItems_MyLittlePony.DoubleDiamondPlushie', 'PompsItems_MyLittlePony.PIRavenInkwellPlushie', 'PompsItems_MyLittlePony.PIDaringDoPlushie', 'PompsItems_MyLittlePony.PICarrotTopPlushie', 'PompsItems_MyLittlePony.PIRivetPlushie', 'PompsItems_MyLittlePony.PICozyGlowPlushie', 'PompsItems_MyLittlePony.PIRainbowshinePlushie', 'PompsItems_MyLittlePony.PIOrangeBoxPlushie', 'PompsItems_MyLittlePony.PIBerryPunchPlushie', 'PompsItems_MyLittlePony.PIBottlecapPlushie'}

Ponies.g5Ponies = {'PompsItems_MyLittlePony.HitchPlushie', 'PompsItems_MyLittlePony.SproutPlushie', 'PompsItems_MyLittlePony.ZippPlushie', 'PompsItems_MyLittlePony.SunnyPlushie', 'PompsItems_MyLittlePony.IzzyPlushie', 'PompsItems_MyLittlePony.PippPetalsPlushie',
'PompsItems_MyLittlePony.PIG5MistyPlushie'}

Ponies.classicPonies = {'PompsItems_MyLittlePony.FizzyPlushie'}

Ponies.ocs = {'PompsItems_MyLittlePony.KorDustPlushie', 'PompsItems_MyLittlePony.StormySkiesPlushie', 'PompsItems_MyLittlePony.PICoPipPlushie', 'PompsItems_MyLittlePony.PITruenoPlushie', 'PompsItems_MyLittlePony.PICOSaturnPlushie', 'PompsItems_MyLittlePony.PIXenraxPlushie', 'PompsItems_MyLittlePony.LilyPlushie', 'PompsItems_MyLittlePony.FlikPlushie', 'PompsItems_MyLittlePony.PICryptoPlushie', 'PompsItems_MyLittlePony.NarzissaFumePlushie', 'PompsItems_MyLittlePony.JellybeanChangelingPlushie', 'PompsItems_MyLittlePony.PIZoobobPlushie',
'PompsItems_MyLittlePony.AleutianAvalanchePlushie', 'PompsItems_MyLittlePony.CobaltFlamePlushie',
'PompsItems_MyLittlePony.SofiePlushie', 'PompsItems_MyLittlePony.PILightSpeedPlushie', 'PompsItems_MyLittlePony.PIHarmonicPlushie',
'PompsItems_MyLittlePony.LightyPlushie', 'PompsItems_MyLittlePony.PIMaddyPlushie', 'PompsItems_MyLittlePony.CosmosPlushie', 'PompsItems_MyLittlePony.SunlightPlushie', 'PompsItems_MyLittlePony.BastlerPlushie', 'PompsItems_MyLittlePony.NuximuPlushie', 'PompsItems_MyLittlePony.SlatePlushie', 'PompsItems_MyLittlePony.CrimPlushie',
'PompsItems_MyLittlePony.MagicCurePlushie', 'PompsItems_MyLittlePony.SignPonyPlushie', 'PompsItems_MyLittlePony.NurseHaywickPlushie', 'PompsItems_MyLittlePony.CaraMelodyPlushie', 'PompsItems_MyLittlePony.JulianaPlushie', 'PompsItems_MyLittlePony.DenimRosePlushie', 'PompsItems_MyLittlePony.TitanGuardPlushie',
'PompsItems_MyLittlePony.MidnightSapphirePlushie', 'PompsItems_MyLittlePony.PICherriPlushie', 'PompsItems_MyLittlePony.PIKarmPlushie', 'PompsItems_MyLittlePony.PIGreylinePlushie', 'PompsItems_MyLittlePony.PIMaxwellPlushie', 'PompsItems_MyLittlePony.PIKootyPlushie', 'PompsItems_MyLittlePony.PISnowPearlPlushie',
'PompsItems_MyLittlePony.PISkylarPalettePlushie', 'PompsItems_MyLittlePony.PISadnessTearPlushie', 'PompsItems_MyLittlePony.PISheepoPlushie', 'PompsItems_MyLittlePony.PITomatoPastePlushie','PompsItems_MyLittlePony.PIAuroraFangPlushie',
'PompsItems_MyLittlePony.PIGentleHeartPlushie', 'PompsItems_MyLittlePony.PICharmingDazzPlushie', 'PompsItems_MyLittlePony.PIResonantCrystalPlushie', 'PompsItems_MyLittlePony.PIIvoryReedPlushie', 'PompsItems_MyLittlePony.PIMisterMannPlushie', 'PompsItems_MyLittlePony.PICzariePlushie',
'PompsItems_MyLittlePony.LuckyPlushie', 'PompsItems_MyLittlePony.SlidingBoltPlushie', 'PompsItems_MyLittlePony.GrapefruitPlushie', 'PompsItems_MyLittlePony.ScarletPlushie', 'PompsItems_MyLittlePony.SoulHarmonyPlushie', 'PompsItems_MyLittlePony.BakerPlushie',
'PompsItems_MyLittlePony.BlueSkiesPlushie', 'PompsItems_MyLittlePony.FeatherBloomPlushie', 'PompsItems_MyLittlePony.ZenithPlushie', 'PompsItems_MyLittlePony.SaladDressingPlushie', 'PompsItems_MyLittlePony.StormyCloudPlushie', 'PompsItems_MyLittlePony.PegamationPlushie',
'PompsItems_MyLittlePony.MarshPlushie', 'PompsItems_MyLittlePony.PIMistyBreezePlushie', 'PompsItems_MyLittlePony.PIToffeeScotchPlushie', 'PompsItems_MyLittlePony.PINightShadePlushie', 'PompsItems_MyLittlePony.PIGryphXanderPlushie',
'PompsItems_MyLittlePony.PIDogePlushie', 'PompsItems_MyLittlePony.PIFlurryPlushie', 'PompsItems_MyLittlePony.PISlingringPlushie', 'PompsItems_MyLittlePony.PICynicalSunsetPlushie', 'PompsItems_MyLittlePony.PILambdaPlushie', 'PompsItems_MyLittlePony.PITwistedCyclonePlushie',
'PompsItems_MyLittlePony.PIPeepPlushie', 'PompsItems_MyLittlePony.PILightningWingPlushie', 'PompsItems_MyLittlePony.PISunnyDayPlushie', 'PompsItems_MyLittlePony.PIGallantValorPlushie', 'PompsItems_MyLittlePony.PIGagePlushie', 'PompsItems_MyLittlePony.PIPlaylistPlushie',
'PompsItems_MyLittlePony.PompPlushie', 'PompsItems_MyLittlePony.PastelPlushie', 'PompsItems_MyLittlePony.TechnoColtPlushie', 'PompsItems_MyLittlePony.RubyStarPlushie', 'PompsItems_MyLittlePony.DesertWindsPlushie',
'PompsItems_MyLittlePony.NukiPlushie', 'PompsItems_MyLittlePony.PIDesireePlushie', 'PompsItems_MyLittlePony.PIMixtapePlushie', 'PompsItems_MyLittlePony.PIScribblesPlushie', 'PompsItems_MyLittlePony.PIEurekaPlushie', 'PompsItems_MyLittlePony.PISandDollarPlushie',
'PompsItems_MyLittlePony.PIBornilaPlushie', 'PompsItems_MyLittlePony.PIFoxGuyPlushie', 'PompsItems_MyLittlePony.PIFilaBrightsparkPlushie',
'PompsItems_MyLittlePony.JubileePlushie', 'PompsItems_MyLittlePony.MoonbowPlushie', 'PompsItems_MyLittlePony.CelestialAegisPlushie', 'PompsItems_MyLittlePony.NeonBurstPlushie', 'PompsItems_MyLittlePony.CrystalBatPlushie',
'PompsItems_MyLittlePony.PINightTerrorPlushie', 'PompsItems_MyLittlePony.PIFirestarterPlushie', 'PompsItems_MyLittlePony.PIQuantumMelodyPlushie', 'PompsItems_MyLittlePony.PIBloodMoonPlushie',
'PompsItems_MyLittlePony.PISnowflakePlushie', 'PompsItems_MyLittlePony.PIMangoDuskPlushie', 'PompsItems_MyLittlePony.PIPacificMelodyPlushie', 'PompsItems_MyLittlePony.PIAaaTheBatPlushie', 'PompsItems_MyLittlePony.OpalSnakePlushie', 'PompsItems_MyLittlePony.CosmosSnekPlushie',
'PompsItems_MyLittlePony.PIAnarchyPlushie', 'PompsItems_MyLittlePony.PINynIndigoPlushie', 'PompsItems_MyLittlePony.PISpiralDelightPlushie', 'PompsItems_MyLittlePony.MetalTrombonePlushie', 'PompsItems_MyLittlePony.DiaSunshinePlushie',
'PompsItems_MyLittlePony.ScratchCatPlushie', 'PompsItems_MyLittlePony.PIPatchworkPlushie', 'PompsItems_MyLittlePony.PICursedAffectionPlushie', 'PompsItems_MyLittlePony.PICheorryNightshadePlushie', 'PompsItems_MyLittlePony.PIHBLoonaPlushie', 'PompsItems_MyLittlePony.PIBizarreSongPlushie', 'PompsItems_MyLittlePony.PISugarMorningPlushie', 'PompsItems_MyLittlePony.PICyanNovaPlushie', 'PompsItems_MyLittlePony.PIBlitzStreakPlushie', 'PompsItems_MyLittlePony.PIAltusBastionPlushie', 'PompsItems_MyLittlePony.PIVelvetSilverwingPlushie', 'PompsItems_MyLittlePony.PITwitchyLivePlushie', 'PompsItems_MyLittlePony.PIShadowBeatzPlushie', 'PompsItems_MyLittlePony.PIShatteredHeartPlushie', 'PompsItems_MyLittlePony.PIFenrisEbonyglowPlushie', 'PompsItems_MyLittlePony.PIVesperPlushie', 'PompsItems_MyLittlePony.PIIcyBreezePlushie', 'PompsItems_MyLittlePony.PIPonkPlushie', 'PompsItems_MyLittlePony.PIOddPlushie', 'PompsItems_MyLittlePony.PICelicaGearsPlushie', 'PompsItems_MyLittlePony.PIPossumPonePlushie', 'PompsItems_MyLittlePony.PINumberNinePlushie', 'PompsItems_MyLittlePony.PIMidnightLancerPlushie', 'PompsItems_MyLittlePony.PIBlueMendingPlushie', 'PompsItems_MyLittlePony.PIKaroaPlushie', 'PompsItems_MyLittlePony.PIPenSketchyPlushie', 'PompsItems_MyLittlePony.PISlashingPricesPlushie', 'PompsItems_MyLittlePony.PIFableRatPlushie', 'PompsItems_MyLittlePony.PIPetriPlushie', 'PompsItems_MyLittlePony.PICinnyPlushie', 'PompsItems_MyLittlePony.PIClydePlushie', 'PompsItems_MyLittlePony.PINoteworthyPlushie', 'PompsItems_MyLittlePony.PIOvercastSofthoofPlushie', 'PompsItems_MyLittlePony.PIWhipperSnapperPlushie', 'PompsItems_MyLittlePony.PIBrandfurdStalkPlushie', 'PompsItems_MyLittlePony.PISearingSkiesPlushie', 'PompsItems_MyLittlePony.PIMidnightShinePlushie', 'PompsItems_MyLittlePony.PIRangerDashPlushie', 'PompsItems_MyLittlePony.PICJPlushie', 'PompsItems_MyLittlePony.PIDoodleDooPlushie', 'PompsItems_MyLittlePony.PIBuffonSmashPlushie', 'PompsItems_MyLittlePony.PIBurntBrickPlushie', 'PompsItems_MyLittlePony.PICupcakePlushie', 'PompsItems_MyLittlePony.PIVanessaPlushie', 'PompsItems_MyLittlePony.PIFatalFixPlushie', 'PompsItems_MyLittlePony.PIBattyBlissPlushie', 'PompsItems_MyLittlePony.PIDonutDaydreamPlushie', 'PompsItems_MyLittlePony.PIAnthydeChrysPlushie', 'PompsItems_MyLittlePony.PIPrimrosePlushie', 'PompsItems_MyLittlePony.PIHeavenShockPlushie', 'PompsItems_MyLittlePony.PIIrisPlushie', 'PompsItems_MyLittlePony.PIFieryLightningPlushie', 'PompsItems_MyLittlePony.PIBlazeAmberjackPlushie', 'PompsItems_MyLittlePony.PIDamlanilPlushie', 'PompsItems_MyLittlePony.PIElysiumPlushie', 'PompsItems_MyLittlePony.PISiegfriedPlushie', 'PompsItems_MyLittlePony.PIBloonaBlazesPlushie', 'PompsItems_MyLittlePony.PITenebrousGrimoirePlushie', 'PompsItems_MyLittlePony.PICogsFixmorePlushie', 'PompsItems_MyLittlePony.PIGlacialNeigePlushie', 'PompsItems_MyLittlePony.PIPommPlushie', 'PompsItems_MyLittlePony.PIGoosePlushie', 'PompsItems_MyLittlePony.PICardinalFluxPlushie', 'PompsItems_MyLittlePony.PIPhillipDriverPlushie', 'PompsItems_MyLittlePony.PIPhantomLightPlushie', 'PompsItems_MyLittlePony.PIClankPlushie', 'PompsItems_MyLittlePony.PIVelvetDreamPlushie', 'PompsItems_MyLittlePony.PINeedleStarPlushie', 'PompsItems_MyLittlePony.PIEnergyWavePlushie', 'PompsItems_MyLittlePony.PIPaintHeartPlushie', 'PompsItems_MyLittlePony.PIWhiskeyWispPlushie', 'PompsItems_MyLittlePony.PICubePonyPlushie', 'PompsItems_MyLittlePony.PITollyPlushie', 'PompsItems_MyLittlePony.PIWhirlwindPlushie', 'PompsItems_MyLittlePony.PISilverPlushie', 'PompsItems_MyLittlePony.PIAubreyGlowPlushie', 'PompsItems_MyLittlePony.PIArwenPlushie', 'PompsItems_MyLittlePony.PIMorningBulletPlushie', 'PompsItems_MyLittlePony.PIWhimsyTailPlushie', 'PompsItems_MyLittlePony.PIMidnightBlitzPlushie', 'PompsItems_MyLittlePony.PIAmberDawnPlushie', 'PompsItems_MyLittlePony.PIToothyHorizonPlushie', 'PompsItems_MyLittlePony.PIPyraxisPlushie', 'PompsItems_MyLittlePony.PIRecordStereoPlushie', 'PompsItems_MyLittlePony.PISmarePlushie', 'PompsItems_MyLittlePony.PIWenniPlushie', 'PompsItems_MyLittlePony.PIKraftPlushie', 'PompsItems_MyLittlePony.PIDesiredPlushie', 'PompsItems_MyLittlePony.PIWinterSpiritPlushie', 'PompsItems_MyLittlePony.PIShadowtaskPlushie', 'PompsItems_MyLittlePony.PIKyePlushie', 'PompsItems_MyLittlePony.PIAlissaPlushie', 'PompsItems_MyLittlePony.PIArnyPlushie', 'PompsItems_MyLittlePony.PIEverlastingStationsPlushie', 'PompsItems_MyLittlePony.PIMangoFoalixPlushie', 'PompsItems_MyLittlePony.PIDreamsiclePlushie', 'PompsItems_MyLittlePony.PIBananaBreadPlushie'}

Ponies.falloutequestria = {'PompsItems_MyLittlePony.LittlepipPlushie', 'PompsItems_MyLittlePony.VelvetRemedyPlushie', 'PompsItems_MyLittlePony.BlackjackPlushie', 'PompsItems_MyLittlePony.PIFOEBooPlushie', 'PompsItems_MyLittlePony.CalamityPlushie', 'PompsItems_MyLittlePony.P21Plushie', 'PompsItems_MyLittlePony.MorningGloryPlushie'}

Ponies.cons = {'PompsItems_MyLittlePony.BitRatePlushie', 'PompsItems_MyLittlePony.PIMorningMimosaCompletePlushie', 'PompsItems_MyLittlePony.PIFairFlyerPlushie',  'PompsItems_MyLittlePony.PIMatineePlushie', 'PompsItems_MyLittlePony.PISoireePlushie', 'PompsItems_MyLittlePony.PIFallenOaklyPlushie', 'PompsItems_MyLittlePony.PIHarmonicTunePlushie','PompsItems_MyLittlePony.PIHarmonyStarPlushie', 'PompsItems_MyLittlePony.PIBlueBonnetPlushie', 'PompsItems_MyLittlePony.PIArmaredilloPlushie', 'PompsItems_MyLittlePony.PIWahWahPlushie'}

Ponies.fnaf = {'PompsItems_MyLittlePony.PIPonifiedManglePlushie', 'PompsItems_MyLittlePony.PIPonifiedGlamrockChicaPlushie', 'PompsItems_MyLittlePony.PIPonifiedFoxyPlushie', 'PompsItems_MyLittlePony.PIPonifiedChicaPlushie',
'PompsItems_MyLittlePony.PIPonifiedMontyPlushie', 'PompsItems_MyLittlePony.PIPonifiedBonniePlushie', 'PompsItems_MyLittlePony.PIPonifiedRoxyPlushie', 'PompsItems_MyLittlePony.PIPonifiedLolbitPlushie'}

Ponies.spaceponyos = {'PompsItems_MyLittlePony.PIApogeePlushie', 'PompsItems_MyLittlePony.PIJetStreamPlushie', 'PompsItems_MyLittlePony.PIDeltaVeePlushie'}

Ponies.empyrean = {'PompsItems_MyLittlePony.PIVeenSundownNewPlushie', 'PompsItems_MyLittlePony.PIDalemPlushie', 'PompsItems_MyLittlePony.PIAegisSundownPlushie', 'PompsItems_MyLittlePony.PISkianorInfernumPlushie', 'PompsItems_MyLittlePony.PIVolaraStandingPlushie', 'PompsItems_MyLittlePony.PIBEANPlushie', 'PompsItems_MyLittlePony.PIRadiumGearsPlushie', 'PompsItems_MyLittlePony.PIPODPlushie', 'PompsItems_MyLittlePony.PIVurenSundownPlushie',  'PompsItems_MyLittlePony.PIAalstPlushie', 'PompsItems_MyLittlePony.PICaelusHaimaPlushie', 'PompsItems_MyLittlePony.PIRyakarArracalPlushie', 'PompsItems_MyLittlePony.PIStormStrykerPlushie', 'PompsItems_MyLittlePony.PINightstalkerPlushie', 'PompsItems_MyLittlePony.PIDarkSkyPlushie'}

Ponies.neet = {'PompsItems_MyLittlePony.FloorBoredPlushie', 'PompsItems_MyLittlePony.PIDotMatrixPlushie', 'PompsItems_MyLittlePony.PITakuPlushie', 'PompsItems_MyLittlePony.PIGoldieMopsPlushie', 'PompsItems_MyLittlePony.PIDoomyGloomPlushie'}

Ponies.popular = {'PompsItems_MyLittlePony.AnonfillyPlushie', 'PompsItems_MyLittlePony.SpotlightSplashPlushie', 'PompsItems_MyLittlePony.CloudyCanvasPlushie',
'PompsItems_MyLittlePony.SlendermanePlushie', 'PompsItems_MyLittlePony.PIStoneyPonyPlushie', 'PompsItems_MyLittlePony.PIMarkerPonyPlushie', 'PompsItems_MyLittlePony.PISnowdropPlushie', 'PompsItems_MyLittlePony.PICreamHeartPlushie', 'PompsItems_MyLittlePony.PINightStitchPlushie', 'PompsItems_MyLittlePony.PIWheelyBopperPlushie', 'PompsItems_MyLittlePony.PIFausticornPlushie', 'PompsItems_MyLittlePony.PILoafTrixiePlushie', 'PompsItems_MyLittlePony.PIVerityPlushie', 'PompsItems_MyLittlePony.PITwilitStarskyPlushie', 'PompsItems_MyLittlePony.PILittleLeaguePlushie', 'PompsItems_MyLittlePony.PIMilkyWayPlushie', 'PompsItems_MyLittlePony.PIFlawlessSparklemoonPlushie', 'PompsItems_MyLittlePony.PITracyCagePlushie', 'PompsItems_MyLittlePony.PIDyxFillyPlushie', 'PompsItems_MyLittlePony.PIDyxPlushie', 'PompsItems_MyLittlePony.PINyxFillyPlushie', 'PompsItems_MyLittlePony.PINyxPlushie', 'PompsItems_MyLittlePony.PINHNBFillyPlushie', 'PompsItems_MyLittlePony.PIMLPOLFillyPlushie'}

Ponies.albionSpawnlist = {'PompsItems_MyLittlePony.FluttershyPlushie', 'PompsItems_MyLittlePony.RarityPlushie', 'PompsItems_MyLittlePony.ApplejackPlushieHat', 'PompsItems_MyLittlePony.RainbowDashPlushie', 'PompsItems_MyLittlePony.DerpyHoovesPlushie',
'PompsItems_MyLittlePony.TwilightSparklePlushie', 'PompsItems_MyLittlePony.PinkiePiePlushie', 'PompsItems_MyLittlePony.CelestiaPlushie', 'PompsItems_MyLittlePony.LunaPlushie', 'PompsItems_MyLittlePony.CadancePlushie', 'PompsItems_MyLittlePony.ChrysalisPlushie', 'PompsItems_MyLittlePony.SpitfirePlushie',
'PompsItems_MyLittlePony.OctaviaPlushie', 'PompsItems_MyLittlePony.VinylScratchPlushie', 'PompsItems_MyLittlePony.HoovesPlushie', 'PompsItems_MyLittlePony.CheerileePlushie', 'PompsItems_MyLittlePony.LyraPlushie', 'PompsItems_MyLittlePony.BonbonPlushie', 'PompsItems_MyLittlePony.SongbirdPlushie',
'PompsItems_MyLittlePony.ZecoraPlushie', 'PompsItems_MyLittlePony.TrixieLulamoonPlushie', 'PompsItems_MyLittlePony.GrannySmithPlushie', 'PompsItems_MyLittlePony.NightmareMoonPlushie', 'PompsItems_MyLittlePony.StarlightGlimmerPlushie', 'PompsItems_MyLittlePony.SunsetShimmerPlushie',
'PompsItems_MyLittlePony.SunnyPlushie', 'PompsItems_MyLittlePony.PippPetalsPlushie', 'PompsItems_MyLittlePony.IzzyPlushie', 'PompsItems_MyLittlePony.ScootalooPlushie', 'PompsItems_MyLittlePony.SweetiePlushie', 'PompsItems_MyLittlePony.ApplebloomPlushie', 'PompsItems_MyLittlePony.CocoPommelPlushie', 'PompsItems_MyLittlePony.NurseRedheartPlushie',
'PompsItems_MyLittlePony.LotusBlossomPlushie', 'PompsItems_MyLittlePony.AloePlushie', 'PompsItems_MyLittlePony.MinuettePlushie', 'PompsItems_MyLittlePony.LightningDustPlushie', 'PompsItems_MyLittlePony.AutumnBlazePlushie', 'PompsItems_MyLittlePony.MoondancerPlushie', 'PompsItems_MyLittlePony.PIDaybreakerPlushie',
'PompsItems_MyLittlePony.PIKerfuffleCompletePlushie', 'PompsItems_MyLittlePony.PIDaringDoPlushie', 'PompsItems_MyLittlePony.PITempestShadowPlushie', 'PompsItems_MyLittlePony.PIMaudPiePlushie'}

function Ponies.getAllPonies()
    return MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(MergeTables(Ponies.mane6Ponies, Ponies.gen4Ponies), Ponies.g5Ponies), Ponies.classicPonies), Ponies.ocs), Ponies.falloutequestria), Ponies.cons), Ponies.fnaf), Ponies.spaceponyos), Ponies.empyrean), Ponies.neet), Ponies.popular)
end

return Ponies