require "recipecode"

Recipe = Recipe or {}
Recipe.GetItemTypes = Recipe.GetItemTypes or {}
Recipe.OnCanPerform = Recipe.OnCanPerform or {}
Recipe.OnCreate = Recipe.OnCreate or {}
Recipe.OnGiveXP = Recipe.OnGiveXP or {}
Recipe.OnTest = Recipe.OnTest or {}

local function openFood(food, count, items, player)
  local age = items:get(0):getAge()
  print("Age: "..tostring(age))
  local inv = player:getInventory()
  for i=0,count do
    local item = InventoryItemFactory.CreateItem(food)
    item:setAge(age)
    inv:addItem(item)
  end
end

local trashRecipes = {'Open Package of Whizzy Suckers', 'Open Wafflez Waffles', 'Open Frozen Mozzarrela Sticks',
'Open Marley Fried Chicken', 'Open Pomps', 'Open Box of Root Beers',
'Open Box of Dinosaur Nuggets', 'Open Package of Vanilla Sandwich Cookies', 'Open Package of Chocolate Sandwich Cookies',
'Open Packaged Chocolate Cross', 'Open Packaged Chocolate Rabbit', 'Open Packet of Utah Wafers', 'Open Packet of Wasabi Wafers',
'Open Pack of Buckeyes', 'Open Box of Fig Bars', 'Open Ham & Cheddar Snackable', 'Open Pepperoni & Mozzarella Snackable',
'Open Ham & Swiss Snackable', 'Open Turkey & Cheddar Snackable', 'Open Bologna & American Snackable',
'Open Ham & American Snackable', 'Open Cheese Pizza Snackable', 'Open Pepperoni Pizza Snackable',
'Open Chicken Pizza Snackable', 'Open Package of Rocky Mountain Oysters', 'Open Box of Fruit Barrels',
'Open Package of Freeze Pops', 'Open Box of Honey Buns', 'Open Pomps Big Cup', 'Open Bag of Powdered Mini Donuts',
'Open Bag of Chocolate Mini Donuts', 'Open Bag of Strawberry Mini Donuts', 'Open Bag of Glazed Mini Donuts',
'Open Box of Fruit Spillers', 'Open Box of Ice Cream Sandwiches', 'Open Packaged Pepperoni Pizza', 'Open Packaged Cheese Pizza',
'Open Packaged Supreme Pizza', 'Open Packaged Meat Lovers Pizza', 'Open Box of Lug Root Beer'}
Events.OnInitGlobalModData.Add(function()
    if not SandboxVars.PompsItems.Littering then return end
    for i = 1, #trashRecipes do
        local recipe = ScriptManager.instance:getRecipe(trashRecipes[i])
        if recipe then
            recipe:setRemoveResultItem(true)
        end
    end
end)

-- Food of the Stale and Rotten Variety
local function addItemsWithAge(container, type, count, age)
    local items = {}
    for i = 1, count do
        table.insert(items, container:AddItem(type))
    end
    for i = 1, count do
        items[i]:setAge(age)
    end
end

	--Pomps
function Recipe.OnCreate.OpenPomps(items, result, player)
    player:getInventory():AddItems("PompsItems.PBCup", 2);
end

	--Wafflez Box
function Recipe.OnCreate.OpenWafflez(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.FrozenWafflez', 6, originalAge)
end

	--Moxx Sticks Box
function Recipe.OnCreate.OpenMoxxBox(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.MoxxStick', 12, originalAge)
end

	--KFC Box
function Recipe.OnCreate.OpenKFC(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'Base.ChickenFried', 6, originalAge)
end

	--Root Beer Box
function Recipe.OnCreate.OpenRootBeerBox(items, result, player)
    player:getInventory():AddItems("PompsItems.PIRootBeer", 12);
end

	--Dino Nug Box
function Recipe.OnCreate.OpenDinoNugBox(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.DinoNug1', 6, originalAge)
	addItemsWithAge(inventory, 'PompsItems.DinoNug2', 6, originalAge)
	addItemsWithAge(inventory, 'PompsItems.DinoNug3', 6, originalAge)
end

	--Vanilla Oreos
function Recipe.OnCreate.OpenVanillaSandwichCookies(items, result, player)
    player:getInventory():AddItems("PompsItems.POreoVanilla", 20);
end

	--Chocolate Oreos
function Recipe.OnCreate.OpenChocolateSandwichCookies(items, result, player)
    player:getInventory():AddItems("PompsItems.POreo", 20);
end

	--Chocolate Cross
function Recipe.OnCreate.OpenChocolateCrossBox(items, result, player)
    player:getInventory():AddItem("PompsItems.ChocolateCross");
end

	--Chocolate Rabbit
function Recipe.OnCreate.OpenChocolateRabbitBox(items, result, player)
    player:getInventory():AddItem("PompsItems.ChocolateRabbit");
end

	--Utah Wafers
function Recipe.OnCreate.OpenUtahWafers(items, result, player)
    player:getInventory():AddItems("PompsItems.UtahWafers", 2);
end

	--Wasabi Wafers
function Recipe.OnCreate.OpenWasabiWafers(items, result, player)
    player:getInventory():AddItems("PompsItems.WasabiWafers", 2);
end

	--Buckeyes
function Recipe.OnCreate.OpenBuckeyes(items, result, player)
    player:getInventory():AddItems("PompsItems.Buckeyes", 8);
end

	--Fig Bar Box
function Recipe.OnCreate.OpenFigBarBox(items, result, player)
    player:getInventory():AddItems("PompsItems.PIFigBar", 8);
end

	--Medium Snackable Ham and Cheddar
function Recipe.OnCreate.OpenMedSnackableHamCheddar(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIRitz', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIHam', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PICheddar', 5, originalAge)
    player:getInventory():AddItems("PompsItems.POreoVanilla", 2);
end

	--Medium Snackable Pepperoni and Mozzarella
function Recipe.OnCreate.OpenMedSnackablePepperoniMox(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIRitz', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIPepperoni', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIMozzarella', 5, originalAge)
end

	--Medium Snackable Ham and Swiss
function Recipe.OnCreate.OpenMedSnackableHamSwiss(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIRitz', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIHam', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PISwissCheese', 5, originalAge)
end

	--Medium Snackable Turkey and Cheddar
function Recipe.OnCreate.OpenMedSnackableTurkeyCheddar(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIRitz', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PITurkey', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PICheddar', 5, originalAge)
end

	--Medium Snackable Bologna and American
function Recipe.OnCreate.OpenMedSnackableBologna(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIRitz', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIBologna', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIAmerican', 5, originalAge)
    player:getInventory():AddItems("Base.CookieChocolateChip", 2);
end

	--Medium Snackable Ham and American
function Recipe.OnCreate.OpenMedSnackableHamAmerican(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIRitz', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIHam', 5, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIAmerican', 5, originalAge)
    player:getInventory():AddItems("PompsItems.POreo", 2);
end

	--Medium Snackable Cheese Pizza
function Recipe.OnCreate.OpenMedSnackableCheesePizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIPizzaMarinara', 1, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PISnackCheese', 3, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIPizzaBlank', 3, originalAge)
end

	--Medium Snackable Pepperoni Pizza
function Recipe.OnCreate.OpenMedSnackablePepperoniPizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIPizzaMarinara', 1, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PISnackCheese', 3, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIPepperoni', 3, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIPizzaBlank', 3, originalAge)
end

	--Medium Snackable Chicken Pizza
function Recipe.OnCreate.OpenMedSnackableChickenPizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIPizzaMarinara', 1, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PISnackCheese', 3, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PISnackNuggs', 3, originalAge)
	addItemsWithAge(inventory, 'PompsItems.PIPizzaBlank', 3, originalAge)
end

	--Empty RM Oyster Package
function Recipe.OnCreate.OpenRMOysters(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIOyster', 8, originalAge)
end

	--Fruit Barrel Box
function Recipe.OnCreate.OpenFruitBarrelBox(items, result, player)
    player:getInventory():AddItems("PompsItems.PIBRBarrel", 10);
    player:getInventory():AddItems("PompsItems.PIGreenBarrel", 10);
    player:getInventory():AddItems("PompsItems.PIPurpleBarrel", 10);
    player:getInventory():AddItems("PompsItems.PIRedBarrel", 10);
end

	--Whizzy Suckers
function Recipe.OnCreate.OpenWhizzySuckers(items, result, player)
    player:getInventory():AddItems("PompsItems.PIRingPopBlue", 1);
    player:getInventory():AddItems("PompsItems.PIRingPopRed", 1);
    player:getInventory():AddItems("PompsItems.PIRingPopPurple", 1);
    player:getInventory():AddItems("PompsItems.PIRingPopGreen", 1);
    player:getInventory():AddItems("PompsItems.PIRingPopFancy", 1);
	if SandboxVars.PompsItems.Littering then
        player:getInventory():Remove("PompsItems.PIWhizzyPopsEmpty")
    end
end

	--Freeze Pops
function Recipe.OnCreate.OpenFreezePops(items, result, player)
    player:getInventory():AddItems("PompsItems.PIFreezePopPurple", 4);
    player:getInventory():AddItems("PompsItems.PIFreezePopOrange", 4);
    player:getInventory():AddItems("PompsItems.PIFreezePopBlue", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopWhite", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopYellow", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopGreen", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopNougat", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopPink", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopRed", 4);
	player:getInventory():AddItems("PompsItems.PIFreezePopMango", 4);
end

	--Honey Bun Box
function Recipe.OnCreate.OpenHoneyBunBox(items, result, player)
    player:getInventory():AddItems("PompsItems.PIHoneyBun", 6);
end

	--Powder Donut Bag
function Recipe.OnCreate.OpenPowderDonutBag(items, result, player)
    player:getInventory():AddItems("PompsItems.PIPowderDonut", 20);
end

	--Choc Donut Bag
function Recipe.OnCreate.OpenChocDonutBag(items, result, player)
    player:getInventory():AddItems("PompsItems.PIChocDonut", 20);
end

	--SW Donut Bag
function Recipe.OnCreate.OpenSWDonutBag(items, result, player)
    player:getInventory():AddItems("PompsItems.PISWDonut", 20);
end

	--Glaze Donut Bag
function Recipe.OnCreate.OpenGlazeDonutBag(items, result, player)
    player:getInventory():AddItems("PompsItems.PIGlazeDonut", 20);
end

	--PompsBig
function Recipe.OnCreate.OpenPompsBig(items, result, player)
    player:getInventory():AddItems("PompsItems.PBCupBig", 2);
end

	--Fruit Spillers
function Recipe.OnCreate.OpenFruitSpillers(items, result, player)
    player:getInventory():AddItems("PompsItems.PIFruitSpillers", 6);
end

	--Ice Cream Sandwiches
function Recipe.OnCreate.OpenIceCreamSandwiches(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIIceCreamSandwich', 12, originalAge)
end

	--Frozen Pepperoni Pizza
function Recipe.OnCreate.OpenPepperoniPizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIFrozenPizzaPepperoni', 1, originalAge)
end

	--Frozen Cheese Pizza
function Recipe.OnCreate.OpenCheesePizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIFrozenPizzaCheese', 1, originalAge)
end

	--Frozen Supreme Pizza
function Recipe.OnCreate.OpenSupremePizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIFrozenPizzaSupreme', 1, originalAge)
end

	--Frozen Meat Pizza
function Recipe.OnCreate.OpenMeatPizza(items, result, player)
	local inventory = player:getInventory()
	local originalAge = items:get(0):getAge()
	addItemsWithAge(inventory, 'PompsItems.PIFrozenPizzaMeat', 1, originalAge)
end

	--Classic Mac & Cheese Packet
function Recipe.OnCreate.PIOpenClassicMacCheese(items, result, player)
    player:getInventory():AddItem("PompsItems.CheetosPacket");
end

	--Lug Root Beer Box
function Recipe.OnCreate.OpenLugRootBeerBox(items, result, player)
    player:getInventory():AddItems("PompsItems.LugRootBeer", 12);
end

--NON FOOD STUFF

	--Tailoring XP
function Recipe.OnGiveXP.TailoringXP(recipe, ingredients, result, player)
    player:getXp():AddXP(Perks.Tailoring, 15);
end

	--Tailoring 5 XP
function Recipe.OnGiveXP.Tailoring5XP(recipe, ingredients, result, player)
    player:getXp():AddXP(Perks.Tailoring, 5);
end

	--Tailoring 7 XP
function Recipe.OnGiveXP.Tailoring7XP(recipe, ingredients, result, player)
    player:getXp():AddXP(Perks.Tailoring, 7);
end

	--Snowpity List
function Recipe.GetItemTypes.Snowpity(scriptItems)
    scriptItems:addAll(getScriptManager():getItemsTag("Snowpity"))
end

	--Smolpity
function Recipe.OnCreate.Snowpity(sources, result, character, item, isPrimaryHandItem, isSecondaryHandItem, player)
	result:setUsedDelta(result:getUseDelta());
end

	--Mare Parts
function Recipe.OnCreate.DisassembleMare(items, result, player)
    player:getInventory():AddItems("Base.RippedSheets", 3);
    player:getInventory():AddItems("Base.CottonBalls", 2);
end

	--Applejack Hat
function Recipe.OnCreate.RemoveHatfromApplejack(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.ApplejackHat");
end

	--Vinyl Glasses
function Recipe.OnCreate.RemoveGlassesfromVinylScratch(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.VinylGlasses");
end

	--Trixie Outfit
function Recipe.OnCreate.RemoveOutfitfromTrixie(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.TrixieOutfit");
end

	--Bit Rate Headset
function Recipe.OnCreate.RemoveHeadsetfromBitRate(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.BitRateHeadset");
end

	--Braeburn Hat
function Recipe.OnCreate.RemoveHatfromBraeburn(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.BraeburnHat");
end

	--Calamity Hat
function Recipe.OnCreate.RemoveHatfromCalamity(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.CalamityHat");
end

	--P-21 Saddlebags
function Recipe.OnCreate.RemoveBagsfromP21(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.P21PlushieAccessory");
end

	--Midnight Sapphire Hoodie
function Recipe.OnCreate.RemoveHoodiefromMidnightSapphire(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.MidnightSapphirePlushieAccessory");
end

	--Desiree Saddlebags
function Recipe.OnCreate.RemoveSaddlebagsfromDesiree(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIDesireePlushieAccessory");
end

	--Maxwell Book Bags
function Recipe.OnCreate.RemoveBookBagsfromMaxwell(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMaxwellAccessory");
end

	--Skylar Palette Hoodie
function Recipe.OnCreate.RemoveHoodiefromSkylarPalette(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PISkylarPalettePlushieHoodie");
end

	--Toffee Scotch Jacket
function Recipe.OnCreate.RemoveJacketFromToffeeScotch(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIToffeeScotchJacket");
end

	--Gryph Xander Outfit
function Recipe.OnCreate.RemoveOutfitFromGryphXander(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIGryphXanderClothes");
end

	--Mango Dusk Armor
function Recipe.OnCreate.RemoveArmorFromMangoDusk(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMangoDuskAccessory");
end

	--Spiral de Light Vest
function Recipe.OnCreate.RemoveVestFromSpiralDelight(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PISpiralDelightVest");
end

	--Aurora Fang Hoodie
function Recipe.OnCreate.RemoveHoodieFromAuroraFang(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIAuroraFangAccessory");
end

	--Ryakar Arracal Armor
function Recipe.OnCreate.RemoveArmorFromRyakarArracal(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRyakarArracalArmor");
end

	--Sunny Day Gala Dress
function Recipe.OnCreate.RemoveDressFromSunnyDay(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PISunnyDayPlushieDress");
end

	--Harmonic Duster
function Recipe.OnCreate.RemoveDusterFromHarmonic(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIHarmonicaAccessory");
end

	--Marker Pony Cape
function Recipe.OnCreate.RemoveCapeFromMarkerPony(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMarkerPonyAccessory");
end

	--Gage Battledress
function Recipe.OnCreate.RemoveBDUFromGage(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIGageAccessory");
end

	--Charming Dazz Hoodie
function Recipe.OnCreate.RemoveHoodieFromCharmingDazz(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PICharmingDazzAccessory");
end

	--Kerfuffle Vest
function Recipe.OnCreate.RemoveVestFromKerfuffle(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIKerfuffleAccessory");
end

	--Fila Brightspark Outfit
function Recipe.OnCreate.RemoveOutfitFromFilaBrightspark(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFilaBrightsparkAccessory");
end

	--Storm Stryker Outfit
function Recipe.OnCreate.RemoveOutfitFromStormStryker(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIStormStrykerAccessory");
end

	--Resonant Crystal Outfit
function Recipe.OnCreate.RemoveOutfitFromResonantCrystal(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIResonantCrystalAccessory");
end

	--Misty Breeze Outfit
function Recipe.OnCreate.RemoveOutfitFromMistyBreeze(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMistyBreezeAccessory");
end

	--Lampwick Outfit
function Recipe.OnCreate.RemoveOutfitFromLampwick(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMisterMannAccessory");
end

	--Sunburst Outfit
function Recipe.OnCreate.RemoveOutfitFromSunburst(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PISunburstAccessory");
end

	--Raven Inkwell Outfit
function Recipe.OnCreate.RemoveOutfitFromRavenInkwell(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRavenInkwellAccessory");
end

	--Titan Guard Outfit
function Recipe.OnCreate.RemoveOutfitFromTitanGuard(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PITitanGuardAccessory");
end

	--Rarity Gala Outfit
function Recipe.OnCreate.RemoveGalaDressFromRarity(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRarityGalaDress");
end

	--Fluttershy Gala Outfit
function Recipe.OnCreate.RemoveGalaDressFromFluttershy(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFluttershyGalaDress");
end

	--Rainbow Dash Gala Outfit
function Recipe.OnCreate.RemoveGalaDressFromRainbowDash(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRainbowDashGalaAccessory");
end

	--Pinkie Pie Gala Outfit
function Recipe.OnCreate.RemoveGalaDressFromPinkiePie(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIPinkiePieGalaDressAccessory");
end

	--Pinkie Pie Burlesque Outfit
function Recipe.OnCreate.RemoveBurlesqueDressFromPinkiePie(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIPinkiePieBurlesqueDress");
end

	--Applejack Hat
function Recipe.OnCreate.RemoveHatFromApplejack(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.ApplejackHat");
end

	--Applejack Gala Outfit
function Recipe.OnCreate.RemoveGalaDressFromApplejack(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIApplejackGalaAccessory");
end

	--Twilight Sparkle Gala Outfit
function Recipe.OnCreate.RemoveGalaDressFromTwilightSparkle(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PITwilightSparkleGalaDress");
end

	--Veen Sundown Armor
function Recipe.OnCreate.RemoveArmorFromVeenSundown(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIVeenSundownArmor");
end

	--Veen Sundown Scarf
function Recipe.OnCreate.RemoveScarfFromVeenSundown(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIVeenSundownScarfAccessory");
end

	--Bizarre Song Cape
function Recipe.OnCreate.RemoveCapeFromBizarreSong(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBizarreSongCape");
end

	--Cyan Nova Uniform
function Recipe.OnCreate.RemoveUniformFromCyanNova(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PICyanNovaAccessory");
end

	--Velvet Silverwing Hat
function Recipe.OnCreate.RemoveHatFromVelvetSilverwing(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIVelvetSilverwingAccessory");
end

	--Twitchy Live Hoodie
function Recipe.OnCreate.RemoveHoodieFromTwitchyLive(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PITwitchyLiveAccessory");
end

	--Shattered Heart Outfit
function Recipe.OnCreate.RemoveOutfitFromShatteredHeart(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIShatteredHeartAccessory");
end

	--Fenris Ebonyglow Outfit
function Recipe.OnCreate.RemoveOutfitFromFenrisEbonyglow(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFenrisEbonyglowAccessory");
end

	--Number Nine Outfit
function Recipe.OnCreate.RemoveOutfitFromNumberNine(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PINumberNinePlushieAccessory");
end

	--Midnight Lancer Outfit
function Recipe.OnCreate.RemoveOutfitFromMidnightLancer(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMidnightLancerPlushieAccessory");
end

	--Midnight Lancer Maid
function Recipe.OnCreate.RemoveMaidOutfitFromMidnightLancer(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMaidAccessory");
end

	--Midnight Lancer Cheerleader
function Recipe.OnCreate.RemoveCheerOutfitFromMidnightLancer(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMidnightLancerCheerleaderAccessory");
end

	--Blue Mending Outfit
function Recipe.OnCreate.RemoveOutfitFromBlueMending(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBlueMendingAccessory");
end

	--Shining Armor Outfit
function Recipe.OnCreate.RemoveOutfitFromShiningArmor(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIShiningArmorAccessory");
end

	--Slashing Prices Outfit
function Recipe.OnCreate.RemoveOutfitFromSlashingPrices(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PISlashingPricesAccessory");
end

	--Morning Mimosa Outfit
function Recipe.OnCreate.RemoveOutfitFromMorningMimosa(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMorningMimosaAccessory");
end

	--Fair Flyer Outfit
function Recipe.OnCreate.RemoveOutfitFromFairFlyer(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFairFlyerAccessory");
end

	--Vuren Sundown Radiant Outfit
function Recipe.OnCreate.RemoveRadiantFromVurenSundown(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIVurenSundownRadiantAccessory");
end

	--Altus Bastion Outfit
function Recipe.OnCreate.RemoveOutfitFromAltusBastion(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIAltusBastionAccessory");
end

	--Radium Gears Outfit
function Recipe.OnCreate.RemoveOutfitFromRadiumGears(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRadiumGearsAccessory");
end

	--Fable Rat Outfit
function Recipe.OnCreate.RemoveOutfitFromFableRat(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFableRatPlushieAccessory");
end

	--Cinny Outfit
function Recipe.OnCreate.RemoveOutfitFromCinny(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PICinnyAccessory");
end

	--Clyde Outfit
function Recipe.OnCreate.RemoveOutfitFromClyde(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIClydeAccessory");
end

	--Harmonic Tune Outfit
function Recipe.OnCreate.RemoveOutfitFromHarmonicTune(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIHarmonicTuneHC25Accessory");
end

	--Harmony Star Hat
function Recipe.OnCreate.RemoveHatFromHarmonyStar(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIHarmonyStarAccessory");
end

	--Harmony Star Dress
function Recipe.OnCreate.RemoveDressFromHarmonyStar(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIHarmonyStarHC25Accessory");
end

	--Brandfurd Outfit
function Recipe.OnCreate.RemoveOutfitFromBrandfurd(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBrandfurdStalkAccessory");
end

	--Wanda Bee Outfit
function Recipe.OnCreate.RemoveWandaBeeFromFilly(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBeeFillyAccessory");
end

	--Rainbowshine Outfit
function Recipe.OnCreate.RemoveJacketFromRainbowshine(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRainbowshineAccessory");
end

	--Ranger Dash Outfit
function Recipe.OnCreate.RemoveJacketFromRangerDash(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRangerDashAccessory");
end

	--CJ Outfit
function Recipe.OnCreate.PIRemoveCJ(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PICJPlushieAccessory");
end







	--Burnt Brick Outfit
function Recipe.OnCreate.PIRemoveBurntBrick(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBurntBrickAccessory");
end

	--Fatal Fix Outfit
function Recipe.OnCreate.PIRemoveFatalFix(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFatalFixAccessory");
end

	--Blue Bonnet Outfit
function Recipe.OnCreate.PIRemoveBlueBonnet(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBlueBonnetAccessory");
end

	--Donut Daydream Outfit
function Recipe.OnCreate.PIRemoveDonutDaydream(items, result, player)
    player:getInventory():AddItem("Base.DoughnutFrosted");
end

	--Anthyde Chrys Outfit
function Recipe.OnCreate.PIRemoveAnthydeChrys(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIAnthydeChrysAccessory");
end

	--Anon Filly Scarf
function Recipe.OnCreate.PIRemoveFillyScarf(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIAnonFillyScarf");
end

	--Armaredillo Outfit
function Recipe.OnCreate.PIRemoveArmaredillo(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIArmaredilloAccessory");
end

	--Bloona Blazes Outfit
function Recipe.OnCreate.PIRemoveBloonaBlazes(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBloonaBlazesAccessory");
end

	--Tenebrous Outfit
function Recipe.OnCreate.PIRemoveTenebrous(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PITenebrousGrimoireAccessory");
end

	--Glacial Neige Outfit
function Recipe.OnCreate.PIRemoveGlacialNeige(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIGlacialNeigeAccessory");
end

	--Phillip Driver Outfit
function Recipe.OnCreate.PIRemovePhillipDriver(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIPhillipDriverAccessory");
end

	--Clank Gearheart Outfit
function Recipe.OnCreate.PIRemoveClankGearheart(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIClankPlushieAccessory");
end

	--Whiskey Wisp Outfit
function Recipe.OnCreate.PIRemoveWhiskeyWisp(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIWhiskeyWispPlushieAccessory");
end

	--Whirlwind Outfit
function Recipe.OnCreate.PIRemoveWhirlwind(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIBlackParadeAccessory");
end

	--Trixie Outfit Outfit
function Recipe.OnCreate.PIRemoveTrixieCape(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.TrixieOutfit");
end

	--Trixie GP Outfit
function Recipe.OnCreate.PIRemoveTrixieGP(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PITrixieOutfitMLR");
end

	--Silver Hat Outfit
function Recipe.OnCreate.PIRemoveSilverHat(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PISilverAccessory");
end

	--Arwen Outfit
function Recipe.OnCreate.PIRemoveArwen(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIArwenAccessory");
end

	--Little League Outfit
function Recipe.OnCreate.PIRemoveLittleLeague(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PILittleLeagueAccessory");
end

	--Whimsy Tail Outfit
function Recipe.OnCreate.PIRemoveWhimsyTail(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIWhimsyTailAccessory");
end

	--Trixie Hoodie Outfit
function Recipe.OnCreate.PIRemoveTrixieHoodie(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PITrixieBabysitterAccessory");
end

	--Midnight Blitz Outfit
function Recipe.OnCreate.PIRemoveMidnightBlitz(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMaidAccessory");
end

	--Pyraxis Outfit
function Recipe.OnCreate.PIRemovePyraxis(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIPyraxisPlushieAccessory");
end

	--Record Stereo Outfit
function Recipe.OnCreate.PIRemoveRecordStereo(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIRecordStereoAccessory");
end

	--Milky Way Outfit
function Recipe.OnCreate.PIRemoveMilkyWay(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIMilkyWayAccessory");
end

	--Whinny Outfit
function Recipe.OnCreate.PIRemoveWhinny(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIWenniPlushieAccessory");
end

	--Desired Outfit
function Recipe.OnCreate.PIRemoveDesired(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIDesiredPlushieAccessory");
end

	--Winter Spirit Outfit
function Recipe.OnCreate.PIRemoveWinterSpirit(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIWinterSpiritAccessory");
end

	--Shadowtask Outfit
function Recipe.OnCreate.PIRemoveShadowtask(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIShadowtaskPlushieAccessory");
end

	--Flawless Sparklemoon Outfit
function Recipe.OnCreate.PIRemoveFlawlessSparklemoon(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIFlawlessSparklemoonAccessory");
end

	--Arny Outfit
function Recipe.OnCreate.PIRemoveArny(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIArnyPlushieAccessory");
end

	--Goldie Mops Outfit
function Recipe.OnCreate.PIRemoveGoldieMops(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIGoldieMopsAccessory");
end

	--Dyx Getup Outfit
function Recipe.OnCreate.PIRemoveDyxGetup(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIDyxAccessory");
end

	--Filly Scout Outfit
function Recipe.OnCreate.PIRemoveFillyScout(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIDyxFillyScoutAccessory");
end

	--Doomy Gloom Outfit
function Recipe.OnCreate.PIRemoveDoomyGloom(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PIDoomyGloomAccessory");
end

	--Nyx Outfit
function Recipe.OnCreate.PIRemoveNyx(items, result, player)
    player:getInventory():AddItem("PompsItems_MyLittlePony.PINyxAccessory");
end