local Ponies = require 'PI_PonyVariations'

Ponies.wantedPonies = {}

---Replaces an item in a container with a random item from the item list.
---@param container ItemContainer
local function replaceDummies(container)
    local dummies = container:getAllType('PompsItems_MyLittlePony.PIDummyPony') -- dummy item type
    for i = 0, dummies:size()-1 do
        container:Remove(dummies:get(i))
        local itemChoice = ZombRand(#Ponies.wantedPonies)+1
        local item = container:AddItem(Ponies.wantedPonies[itemChoice])
        container:addItemOnServer(item)
    end
end

-- for items in containers
local function onFillContainer(_roomName, _containerType, container)
    replaceDummies(container)
end

table.insert(ProceduralDistributions["list"]["GigamartToys"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["GigamartToys"].items, 11.32 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["WardrobeChild"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["WardrobeChild"].items, 8.64 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["WardrobeMan"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["WardrobeMan"].items, 0.28 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["WardrobeWoman"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["WardrobeWoman"].items, 0.3 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["DaycareCounter"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["DaycareCounter"].items, 1.66 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["DaycareShelves"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["DaycareShelves"].items, 1.66 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["CrateToys"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["CrateToys"].items, 12.64 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["WardrobeWomanClassy"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["WardrobeWomanClassy"].items, 0.2 * SandboxVars.PompsItems.PonySpawnRate)
table.insert(ProceduralDistributions["list"]["WardrobeManClassy"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(ProceduralDistributions["list"]["WardrobeManClassy"].items, 0.2 * SandboxVars.PompsItems.PonySpawnRate)

Events.OnFillContainer.Add(onFillContainer)

-- for items found on zombies
local function onRefreshInventoryWindowContainers(inventoryPage)
    if not inventoryPage.inventory or not instanceof(inventoryPage.inventory:getParent(), "IsoDeadBody") then return end
    replaceDummies(inventoryPage.inventory)
end

table.insert(SuburbsDistributions["all"]["inventorymale"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(SuburbsDistributions["all"]["inventorymale"].items, 1.8 * SandboxVars.PompsItems.PonyZombieSpawnRate)
table.insert(SuburbsDistributions["all"]["inventoryfemale"].items, "PompsItems_MyLittlePony.PIDummyPony")
table.insert(SuburbsDistributions["all"]["inventoryfemale"].items, 1.8 * SandboxVars.PompsItems.PonyZombieSpawnRate)

Events.OnRefreshInventoryWindowContainers.Add(onRefreshInventoryWindowContainers)

---Returns a numerically indexed table that is the combination of the two input tables.
---@param a table
---@param b table
---@return table
local function MergeTables(a, b)
    if not a then return b elseif not b then return a end
    local result = {}
    for _,v in pairs(a) do
        table.insert(result, v)
    end
    for _,v in pairs(b) do
        table.insert(result, v)
    end
    return result
end

function Ponies.createSpawnList()
    if SandboxVars.PompsItems.AlbionSpawnlist then
        return Ponies.albionSpawnlist
    end
 
   
    local wantedPonies
    if SandboxVars.PompsItems.WantMane6Ponies then
        wantedPonies = Ponies.mane6Ponies
    end

    if SandboxVars.PompsItems.WantG4Ponies then
        wantedPonies = Ponies.gen4Ponies
    end

    if SandboxVars.PompsItems.WantG5Ponies then
        wantedPonies = MergeTables(wantedPonies, Ponies.g5Ponies)
    end

    if SandboxVars.PompsItems.WantClassicPonies then
        wantedPonies = MergeTables(wantedPonies, Ponies.classicPonies)
    end

    if SandboxVars.PompsItems.WantOCs then
        wantedPonies = MergeTables(wantedPonies, Ponies.ocs)
    end
	
    if SandboxVars.PompsItems.WantFoE then
        wantedPonies = MergeTables(wantedPonies, Ponies.falloutequestria)
    end
	
    if SandboxVars.PompsItems.WantCons then
        wantedPonies = MergeTables(wantedPonies, Ponies.cons)
    end

    if SandboxVars.PompsItems.WantMLPFNAF then
        wantedPonies = MergeTables(wantedPonies, Ponies.fnaf)
    end

    if SandboxVars.PompsItems.WantSpacePonyos then
        wantedPonies = MergeTables(wantedPonies, Ponies.spaceponyos)
    end
	
    if SandboxVars.PompsItems.WantEmpyreanPones then
        wantedPonies = MergeTables(wantedPonies, Ponies.empyrean)
    end

    if SandboxVars.PompsItems.WantNeetPones then
        wantedPonies = MergeTables(wantedPonies, Ponies.neet)
    end

    if SandboxVars.PompsItems.WantPopularPones then
        wantedPonies = MergeTables(wantedPonies, Ponies.popular)
    end

    return wantedPonies
end

Events.OnInitGlobalModData.Add(function()
    Ponies.wantedPonies = Ponies.createSpawnList()
end)

return Ponies